use std::io;
use std::cmp::Ordering;
use rand::Rng;

pub struct Guess {
    value: i32,
}

impl Guess {
    pub fn new(value: i32) -> Guess {
        if value < 1 || value > 100 {
            panic!("Значение догадки должно быть между 1 и 100, вы ввели {}.", value);
        }
        Guess {
            value
        }
    }
    
    pub fn value(&self) -> i32 {
        self.value
    }
}


fn main() {
    println!("Угадайте число!");

    println!("Пожалуйста, введите свою догададку.");

    let secret_number = rand::thread_rng().gen_range(1, 101);

    loop { 
        println!("Пожалуйста, введите свою догадку");

        let mut guess = String::new();

        io::stdin().read_line(&mut guess)
            .expect("Не получилось прочитать строку");

        let guess: u32 = match guess.trim().parse(){
            Ok(num) => num,
            Err(_) => continue,
        };

        if guess < 1 || guess > 100 {
            println!("Секретное число будет между 1 и 100.");
            continue;
        }
            
        println!("Вы загадали: {}", guess);

        match guess.cmp(&secret_number){
            Ordering::Less => println!("Слишком малое число"),
            Ordering::Greater => println!("Слишком большое число!"),
            Ordering::Equal => {
                println!("Вы выиграли");
                break;
            }
        }

    }

}
