use std::io;
use std::cmp::Ordering;
use rand::Rng;

fn main() {
    println!("Guess the number!");

    // thread_rng(): 乱数生成器を返す
    // gen_range(): 2つの引数を取り、それらの間の乱数を生成。範囲は下限値を含み、上限値は含まない
    let secret_number = rand::thread_rng().gen_range(1, 101);

    // println!("The secret number is :{}", secret_number);

    loop {
        println!("Please input your guess.");

        let mut guess = String::new();
    
        io::stdin()
            .read_line(&mut guess)
            .expect("Failed to read line"); // unwrap()がpanic!を呼びだすと標準のエラーメッセージが表示されるが、expect()を呼ぶと、エラーメッセージに情報を追加できる。OkならOkの値を返す。
    
        let guess: u32 = match guess.trim().parse() {
            Ok(num) => num,
            Err(_) => continue,
        };
    
        println!("You guessed: {}", guess);
    
        match guess.cmp(&secret_number) {
            Ordering::Less => println!("Too small!"),
            Ordering::Greater => println!("Too big!"),
            Ordering::Equal => {
                println!("You win!");
                break;
            }
        }
    }
}
