# Gtk Comfy

Gtk Comfy is an effort to improve GTK builder files. Whilst the separation between code and interface is a good one, but the implementation is poor. XML is tricky and obtuse:

```xml
<?xml version="1.0" encoding="UTF-8"?>
<interface>
  <object class="GtkApplicationWindow" id="window">
    <property name="title">My GTK App</property>
    <child>
      <object class="GtkButton" id="button">
        <property name="label">Press me!</property>
        <property name="margin-top">12</property>
        <property name="margin-bottom">12</property>
        <property name="margin-start">12</property>
        <property name="margin-end">12</property>  
      </object>
    </child>
  </object>
</interface>
```

So with GTK Comfy you can instead use any serde compatable format, as shown in the example below:

```yaml
# The root interface
interface:
    # The class of the object (reserverd keyword)
    class: GtkApplicationWindow

    # The id of the widget (reserved keyword)
    id: window

    # The title property. See that properties are automatically infered
    title: My Gtk App

    # The children
    children:
    -
        class: GtkButton
        id: Button
        label: Press me!
        margin-start: "12"
        margin-top: "12"
        margin-bottom: "12"
        margin-end: "12"
```

Gtk Comfy provides many convinience features, such as:

 * Inferred properties, if it does not recognise a variable it will infer it as a property (see the `title` in the above example.)
 * Child types, if a widget is given the `child_type` property than you can set the child type (I can’t remember when you need this but you do.)
 * Pango Attributes. For labels (and suchlike) you can use `attributes` to provide a map of attributes (example below.)
 * Style classes, provided in a `style` array.

An example of attributes:

```yaml
class: GtkLabel
label: "This is a red label"
attributes:
    foreground: '#FF0000'
```

An example of styles:

```yaml
class: GtkBox
orientation: "horizontal"
style:
    - linked
children:
# ...
```
