// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::Accessible;
use crate::AccessibleRole;
use crate::Adjustment;
use crate::Align;
use crate::Buildable;
use crate::ConstraintTarget;
use crate::DeleteType;
use crate::InputHints;
use crate::InputPurpose;
use crate::Justification;
use crate::LayoutManager;
use crate::MovementStep;
use crate::Overflow;
use crate::ScrollStep;
use crate::Scrollable;
use crate::ScrollablePolicy;
use crate::TextBuffer;
use crate::TextChildAnchor;
use crate::TextExtendSelection;
use crate::TextIter;
use crate::TextMark;
use crate::TextWindowType;
use crate::Widget;
use crate::WrapMode;
use glib::object::Cast;
use glib::object::IsA;
use glib::object::ObjectExt;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "GtkTextView")]
    pub struct TextView(Object<ffi::GtkTextView, ffi::GtkTextViewClass>) @extends Widget, @implements Accessible, Buildable, ConstraintTarget, Scrollable;

    match fn {
        type_ => || ffi::gtk_text_view_get_type(),
    }
}

impl TextView {
    #[doc(alias = "gtk_text_view_new")]
    pub fn new() -> TextView {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(ffi::gtk_text_view_new()).unsafe_cast() }
    }

    #[doc(alias = "gtk_text_view_new_with_buffer")]
    #[doc(alias = "new_with_buffer")]
    pub fn with_buffer<P: IsA<TextBuffer>>(buffer: &P) -> TextView {
        skip_assert_initialized!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_text_view_new_with_buffer(
                buffer.as_ref().to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`TextView`] objects.
    ///
    /// This method returns an instance of [`TextViewBuilder`] which can be used to create [`TextView`] objects.
    pub fn builder() -> TextViewBuilder {
        TextViewBuilder::default()
    }
}

impl Default for TextView {
    fn default() -> Self {
        Self::new()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`TextView`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
pub struct TextViewBuilder {
    accepts_tab: Option<bool>,
    bottom_margin: Option<i32>,
    buffer: Option<TextBuffer>,
    cursor_visible: Option<bool>,
    editable: Option<bool>,
    extra_menu: Option<gio::MenuModel>,
    im_module: Option<String>,
    indent: Option<i32>,
    input_hints: Option<InputHints>,
    input_purpose: Option<InputPurpose>,
    justification: Option<Justification>,
    left_margin: Option<i32>,
    monospace: Option<bool>,
    overwrite: Option<bool>,
    pixels_above_lines: Option<i32>,
    pixels_below_lines: Option<i32>,
    pixels_inside_wrap: Option<i32>,
    right_margin: Option<i32>,
    tabs: Option<pango::TabArray>,
    top_margin: Option<i32>,
    wrap_mode: Option<WrapMode>,
    can_focus: Option<bool>,
    can_target: Option<bool>,
    css_classes: Option<Vec<String>>,
    css_name: Option<String>,
    cursor: Option<gdk::Cursor>,
    focus_on_click: Option<bool>,
    focusable: Option<bool>,
    halign: Option<Align>,
    has_tooltip: Option<bool>,
    height_request: Option<i32>,
    hexpand: Option<bool>,
    hexpand_set: Option<bool>,
    layout_manager: Option<LayoutManager>,
    margin_bottom: Option<i32>,
    margin_end: Option<i32>,
    margin_start: Option<i32>,
    margin_top: Option<i32>,
    name: Option<String>,
    opacity: Option<f64>,
    overflow: Option<Overflow>,
    receives_default: Option<bool>,
    sensitive: Option<bool>,
    tooltip_markup: Option<String>,
    tooltip_text: Option<String>,
    valign: Option<Align>,
    vexpand: Option<bool>,
    vexpand_set: Option<bool>,
    visible: Option<bool>,
    width_request: Option<i32>,
    accessible_role: Option<AccessibleRole>,
    hadjustment: Option<Adjustment>,
    hscroll_policy: Option<ScrollablePolicy>,
    vadjustment: Option<Adjustment>,
    vscroll_policy: Option<ScrollablePolicy>,
}

impl TextViewBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`TextViewBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`TextView`].
    pub fn build(self) -> TextView {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref accepts_tab) = self.accepts_tab {
            properties.push(("accepts-tab", accepts_tab));
        }
        if let Some(ref bottom_margin) = self.bottom_margin {
            properties.push(("bottom-margin", bottom_margin));
        }
        if let Some(ref buffer) = self.buffer {
            properties.push(("buffer", buffer));
        }
        if let Some(ref cursor_visible) = self.cursor_visible {
            properties.push(("cursor-visible", cursor_visible));
        }
        if let Some(ref editable) = self.editable {
            properties.push(("editable", editable));
        }
        if let Some(ref extra_menu) = self.extra_menu {
            properties.push(("extra-menu", extra_menu));
        }
        if let Some(ref im_module) = self.im_module {
            properties.push(("im-module", im_module));
        }
        if let Some(ref indent) = self.indent {
            properties.push(("indent", indent));
        }
        if let Some(ref input_hints) = self.input_hints {
            properties.push(("input-hints", input_hints));
        }
        if let Some(ref input_purpose) = self.input_purpose {
            properties.push(("input-purpose", input_purpose));
        }
        if let Some(ref justification) = self.justification {
            properties.push(("justification", justification));
        }
        if let Some(ref left_margin) = self.left_margin {
            properties.push(("left-margin", left_margin));
        }
        if let Some(ref monospace) = self.monospace {
            properties.push(("monospace", monospace));
        }
        if let Some(ref overwrite) = self.overwrite {
            properties.push(("overwrite", overwrite));
        }
        if let Some(ref pixels_above_lines) = self.pixels_above_lines {
            properties.push(("pixels-above-lines", pixels_above_lines));
        }
        if let Some(ref pixels_below_lines) = self.pixels_below_lines {
            properties.push(("pixels-below-lines", pixels_below_lines));
        }
        if let Some(ref pixels_inside_wrap) = self.pixels_inside_wrap {
            properties.push(("pixels-inside-wrap", pixels_inside_wrap));
        }
        if let Some(ref right_margin) = self.right_margin {
            properties.push(("right-margin", right_margin));
        }
        if let Some(ref tabs) = self.tabs {
            properties.push(("tabs", tabs));
        }
        if let Some(ref top_margin) = self.top_margin {
            properties.push(("top-margin", top_margin));
        }
        if let Some(ref wrap_mode) = self.wrap_mode {
            properties.push(("wrap-mode", wrap_mode));
        }
        if let Some(ref can_focus) = self.can_focus {
            properties.push(("can-focus", can_focus));
        }
        if let Some(ref can_target) = self.can_target {
            properties.push(("can-target", can_target));
        }
        if let Some(ref css_classes) = self.css_classes {
            properties.push(("css-classes", css_classes));
        }
        if let Some(ref css_name) = self.css_name {
            properties.push(("css-name", css_name));
        }
        if let Some(ref cursor) = self.cursor {
            properties.push(("cursor", cursor));
        }
        if let Some(ref focus_on_click) = self.focus_on_click {
            properties.push(("focus-on-click", focus_on_click));
        }
        if let Some(ref focusable) = self.focusable {
            properties.push(("focusable", focusable));
        }
        if let Some(ref halign) = self.halign {
            properties.push(("halign", halign));
        }
        if let Some(ref has_tooltip) = self.has_tooltip {
            properties.push(("has-tooltip", has_tooltip));
        }
        if let Some(ref height_request) = self.height_request {
            properties.push(("height-request", height_request));
        }
        if let Some(ref hexpand) = self.hexpand {
            properties.push(("hexpand", hexpand));
        }
        if let Some(ref hexpand_set) = self.hexpand_set {
            properties.push(("hexpand-set", hexpand_set));
        }
        if let Some(ref layout_manager) = self.layout_manager {
            properties.push(("layout-manager", layout_manager));
        }
        if let Some(ref margin_bottom) = self.margin_bottom {
            properties.push(("margin-bottom", margin_bottom));
        }
        if let Some(ref margin_end) = self.margin_end {
            properties.push(("margin-end", margin_end));
        }
        if let Some(ref margin_start) = self.margin_start {
            properties.push(("margin-start", margin_start));
        }
        if let Some(ref margin_top) = self.margin_top {
            properties.push(("margin-top", margin_top));
        }
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        if let Some(ref opacity) = self.opacity {
            properties.push(("opacity", opacity));
        }
        if let Some(ref overflow) = self.overflow {
            properties.push(("overflow", overflow));
        }
        if let Some(ref receives_default) = self.receives_default {
            properties.push(("receives-default", receives_default));
        }
        if let Some(ref sensitive) = self.sensitive {
            properties.push(("sensitive", sensitive));
        }
        if let Some(ref tooltip_markup) = self.tooltip_markup {
            properties.push(("tooltip-markup", tooltip_markup));
        }
        if let Some(ref tooltip_text) = self.tooltip_text {
            properties.push(("tooltip-text", tooltip_text));
        }
        if let Some(ref valign) = self.valign {
            properties.push(("valign", valign));
        }
        if let Some(ref vexpand) = self.vexpand {
            properties.push(("vexpand", vexpand));
        }
        if let Some(ref vexpand_set) = self.vexpand_set {
            properties.push(("vexpand-set", vexpand_set));
        }
        if let Some(ref visible) = self.visible {
            properties.push(("visible", visible));
        }
        if let Some(ref width_request) = self.width_request {
            properties.push(("width-request", width_request));
        }
        if let Some(ref accessible_role) = self.accessible_role {
            properties.push(("accessible-role", accessible_role));
        }
        if let Some(ref hadjustment) = self.hadjustment {
            properties.push(("hadjustment", hadjustment));
        }
        if let Some(ref hscroll_policy) = self.hscroll_policy {
            properties.push(("hscroll-policy", hscroll_policy));
        }
        if let Some(ref vadjustment) = self.vadjustment {
            properties.push(("vadjustment", vadjustment));
        }
        if let Some(ref vscroll_policy) = self.vscroll_policy {
            properties.push(("vscroll-policy", vscroll_policy));
        }
        glib::Object::new::<TextView>(&properties)
            .expect("Failed to create an instance of TextView")
    }

    pub fn accepts_tab(mut self, accepts_tab: bool) -> Self {
        self.accepts_tab = Some(accepts_tab);
        self
    }

    pub fn bottom_margin(mut self, bottom_margin: i32) -> Self {
        self.bottom_margin = Some(bottom_margin);
        self
    }

    pub fn buffer<P: IsA<TextBuffer>>(mut self, buffer: &P) -> Self {
        self.buffer = Some(buffer.clone().upcast());
        self
    }

    pub fn cursor_visible(mut self, cursor_visible: bool) -> Self {
        self.cursor_visible = Some(cursor_visible);
        self
    }

    pub fn editable(mut self, editable: bool) -> Self {
        self.editable = Some(editable);
        self
    }

    pub fn extra_menu<P: IsA<gio::MenuModel>>(mut self, extra_menu: &P) -> Self {
        self.extra_menu = Some(extra_menu.clone().upcast());
        self
    }

    pub fn im_module(mut self, im_module: &str) -> Self {
        self.im_module = Some(im_module.to_string());
        self
    }

    pub fn indent(mut self, indent: i32) -> Self {
        self.indent = Some(indent);
        self
    }

    pub fn input_hints(mut self, input_hints: InputHints) -> Self {
        self.input_hints = Some(input_hints);
        self
    }

    pub fn input_purpose(mut self, input_purpose: InputPurpose) -> Self {
        self.input_purpose = Some(input_purpose);
        self
    }

    pub fn justification(mut self, justification: Justification) -> Self {
        self.justification = Some(justification);
        self
    }

    pub fn left_margin(mut self, left_margin: i32) -> Self {
        self.left_margin = Some(left_margin);
        self
    }

    pub fn monospace(mut self, monospace: bool) -> Self {
        self.monospace = Some(monospace);
        self
    }

    pub fn overwrite(mut self, overwrite: bool) -> Self {
        self.overwrite = Some(overwrite);
        self
    }

    pub fn pixels_above_lines(mut self, pixels_above_lines: i32) -> Self {
        self.pixels_above_lines = Some(pixels_above_lines);
        self
    }

    pub fn pixels_below_lines(mut self, pixels_below_lines: i32) -> Self {
        self.pixels_below_lines = Some(pixels_below_lines);
        self
    }

    pub fn pixels_inside_wrap(mut self, pixels_inside_wrap: i32) -> Self {
        self.pixels_inside_wrap = Some(pixels_inside_wrap);
        self
    }

    pub fn right_margin(mut self, right_margin: i32) -> Self {
        self.right_margin = Some(right_margin);
        self
    }

    pub fn tabs(mut self, tabs: &pango::TabArray) -> Self {
        self.tabs = Some(tabs.clone());
        self
    }

    pub fn top_margin(mut self, top_margin: i32) -> Self {
        self.top_margin = Some(top_margin);
        self
    }

    pub fn wrap_mode(mut self, wrap_mode: WrapMode) -> Self {
        self.wrap_mode = Some(wrap_mode);
        self
    }

    pub fn can_focus(mut self, can_focus: bool) -> Self {
        self.can_focus = Some(can_focus);
        self
    }

    pub fn can_target(mut self, can_target: bool) -> Self {
        self.can_target = Some(can_target);
        self
    }

    pub fn css_classes(mut self, css_classes: Vec<String>) -> Self {
        self.css_classes = Some(css_classes);
        self
    }

    pub fn css_name(mut self, css_name: &str) -> Self {
        self.css_name = Some(css_name.to_string());
        self
    }

    pub fn cursor(mut self, cursor: &gdk::Cursor) -> Self {
        self.cursor = Some(cursor.clone());
        self
    }

    pub fn focus_on_click(mut self, focus_on_click: bool) -> Self {
        self.focus_on_click = Some(focus_on_click);
        self
    }

    pub fn focusable(mut self, focusable: bool) -> Self {
        self.focusable = Some(focusable);
        self
    }

    pub fn halign(mut self, halign: Align) -> Self {
        self.halign = Some(halign);
        self
    }

    pub fn has_tooltip(mut self, has_tooltip: bool) -> Self {
        self.has_tooltip = Some(has_tooltip);
        self
    }

    pub fn height_request(mut self, height_request: i32) -> Self {
        self.height_request = Some(height_request);
        self
    }

    pub fn hexpand(mut self, hexpand: bool) -> Self {
        self.hexpand = Some(hexpand);
        self
    }

    pub fn hexpand_set(mut self, hexpand_set: bool) -> Self {
        self.hexpand_set = Some(hexpand_set);
        self
    }

    pub fn layout_manager<P: IsA<LayoutManager>>(mut self, layout_manager: &P) -> Self {
        self.layout_manager = Some(layout_manager.clone().upcast());
        self
    }

    pub fn margin_bottom(mut self, margin_bottom: i32) -> Self {
        self.margin_bottom = Some(margin_bottom);
        self
    }

    pub fn margin_end(mut self, margin_end: i32) -> Self {
        self.margin_end = Some(margin_end);
        self
    }

    pub fn margin_start(mut self, margin_start: i32) -> Self {
        self.margin_start = Some(margin_start);
        self
    }

    pub fn margin_top(mut self, margin_top: i32) -> Self {
        self.margin_top = Some(margin_top);
        self
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }

    pub fn opacity(mut self, opacity: f64) -> Self {
        self.opacity = Some(opacity);
        self
    }

    pub fn overflow(mut self, overflow: Overflow) -> Self {
        self.overflow = Some(overflow);
        self
    }

    pub fn receives_default(mut self, receives_default: bool) -> Self {
        self.receives_default = Some(receives_default);
        self
    }

    pub fn sensitive(mut self, sensitive: bool) -> Self {
        self.sensitive = Some(sensitive);
        self
    }

    pub fn tooltip_markup(mut self, tooltip_markup: &str) -> Self {
        self.tooltip_markup = Some(tooltip_markup.to_string());
        self
    }

    pub fn tooltip_text(mut self, tooltip_text: &str) -> Self {
        self.tooltip_text = Some(tooltip_text.to_string());
        self
    }

    pub fn valign(mut self, valign: Align) -> Self {
        self.valign = Some(valign);
        self
    }

    pub fn vexpand(mut self, vexpand: bool) -> Self {
        self.vexpand = Some(vexpand);
        self
    }

    pub fn vexpand_set(mut self, vexpand_set: bool) -> Self {
        self.vexpand_set = Some(vexpand_set);
        self
    }

    pub fn visible(mut self, visible: bool) -> Self {
        self.visible = Some(visible);
        self
    }

    pub fn width_request(mut self, width_request: i32) -> Self {
        self.width_request = Some(width_request);
        self
    }

    pub fn accessible_role(mut self, accessible_role: AccessibleRole) -> Self {
        self.accessible_role = Some(accessible_role);
        self
    }

    pub fn hadjustment<P: IsA<Adjustment>>(mut self, hadjustment: &P) -> Self {
        self.hadjustment = Some(hadjustment.clone().upcast());
        self
    }

    pub fn hscroll_policy(mut self, hscroll_policy: ScrollablePolicy) -> Self {
        self.hscroll_policy = Some(hscroll_policy);
        self
    }

    pub fn vadjustment<P: IsA<Adjustment>>(mut self, vadjustment: &P) -> Self {
        self.vadjustment = Some(vadjustment.clone().upcast());
        self
    }

    pub fn vscroll_policy(mut self, vscroll_policy: ScrollablePolicy) -> Self {
        self.vscroll_policy = Some(vscroll_policy);
        self
    }
}

pub const NONE_TEXT_VIEW: Option<&TextView> = None;

pub trait TextViewExt: 'static {
    #[doc(alias = "gtk_text_view_add_child_at_anchor")]
    fn add_child_at_anchor<P: IsA<Widget>, Q: IsA<TextChildAnchor>>(&self, child: &P, anchor: &Q);

    #[doc(alias = "gtk_text_view_add_overlay")]
    fn add_overlay<P: IsA<Widget>>(&self, child: &P, xpos: i32, ypos: i32);

    #[doc(alias = "gtk_text_view_backward_display_line")]
    fn backward_display_line(&self, iter: &mut TextIter) -> bool;

    #[doc(alias = "gtk_text_view_backward_display_line_start")]
    fn backward_display_line_start(&self, iter: &mut TextIter) -> bool;

    #[doc(alias = "gtk_text_view_buffer_to_window_coords")]
    fn buffer_to_window_coords(
        &self,
        win: TextWindowType,
        buffer_x: i32,
        buffer_y: i32,
    ) -> (i32, i32);

    #[doc(alias = "gtk_text_view_forward_display_line")]
    fn forward_display_line(&self, iter: &mut TextIter) -> bool;

    #[doc(alias = "gtk_text_view_forward_display_line_end")]
    fn forward_display_line_end(&self, iter: &mut TextIter) -> bool;

    #[doc(alias = "gtk_text_view_get_accepts_tab")]
    #[doc(alias = "get_accepts_tab")]
    fn accepts_tab(&self) -> bool;

    #[doc(alias = "gtk_text_view_get_bottom_margin")]
    #[doc(alias = "get_bottom_margin")]
    fn bottom_margin(&self) -> i32;

    #[doc(alias = "gtk_text_view_get_buffer")]
    #[doc(alias = "get_buffer")]
    fn buffer(&self) -> TextBuffer;

    #[doc(alias = "gtk_text_view_get_cursor_locations")]
    #[doc(alias = "get_cursor_locations")]
    fn cursor_locations(&self, iter: Option<&TextIter>) -> (gdk::Rectangle, gdk::Rectangle);

    #[doc(alias = "gtk_text_view_get_cursor_visible")]
    #[doc(alias = "get_cursor_visible")]
    fn is_cursor_visible(&self) -> bool;

    #[doc(alias = "gtk_text_view_get_editable")]
    #[doc(alias = "get_editable")]
    fn is_editable(&self) -> bool;

    #[doc(alias = "gtk_text_view_get_extra_menu")]
    #[doc(alias = "get_extra_menu")]
    fn extra_menu(&self) -> Option<gio::MenuModel>;

    #[doc(alias = "gtk_text_view_get_gutter")]
    #[doc(alias = "get_gutter")]
    fn gutter(&self, win: TextWindowType) -> Option<Widget>;

    #[doc(alias = "gtk_text_view_get_indent")]
    #[doc(alias = "get_indent")]
    fn indent(&self) -> i32;

    #[doc(alias = "gtk_text_view_get_input_hints")]
    #[doc(alias = "get_input_hints")]
    fn input_hints(&self) -> InputHints;

    #[doc(alias = "gtk_text_view_get_input_purpose")]
    #[doc(alias = "get_input_purpose")]
    fn input_purpose(&self) -> InputPurpose;

    #[doc(alias = "gtk_text_view_get_iter_at_location")]
    #[doc(alias = "get_iter_at_location")]
    fn iter_at_location(&self, x: i32, y: i32) -> Option<TextIter>;

    #[doc(alias = "gtk_text_view_get_iter_at_position")]
    #[doc(alias = "get_iter_at_position")]
    fn iter_at_position(&self, x: i32, y: i32) -> Option<(TextIter, i32)>;

    #[doc(alias = "gtk_text_view_get_iter_location")]
    #[doc(alias = "get_iter_location")]
    fn iter_location(&self, iter: &TextIter) -> gdk::Rectangle;

    #[doc(alias = "gtk_text_view_get_justification")]
    #[doc(alias = "get_justification")]
    fn justification(&self) -> Justification;

    #[doc(alias = "gtk_text_view_get_left_margin")]
    #[doc(alias = "get_left_margin")]
    fn left_margin(&self) -> i32;

    #[doc(alias = "gtk_text_view_get_line_at_y")]
    #[doc(alias = "get_line_at_y")]
    fn line_at_y(&self, y: i32) -> (TextIter, i32);

    #[doc(alias = "gtk_text_view_get_line_yrange")]
    #[doc(alias = "get_line_yrange")]
    fn line_yrange(&self, iter: &TextIter) -> (i32, i32);

    #[doc(alias = "gtk_text_view_get_monospace")]
    #[doc(alias = "get_monospace")]
    fn is_monospace(&self) -> bool;

    #[doc(alias = "gtk_text_view_get_overwrite")]
    #[doc(alias = "get_overwrite")]
    fn overwrites(&self) -> bool;

    #[doc(alias = "gtk_text_view_get_pixels_above_lines")]
    #[doc(alias = "get_pixels_above_lines")]
    fn pixels_above_lines(&self) -> i32;

    #[doc(alias = "gtk_text_view_get_pixels_below_lines")]
    #[doc(alias = "get_pixels_below_lines")]
    fn pixels_below_lines(&self) -> i32;

    #[doc(alias = "gtk_text_view_get_pixels_inside_wrap")]
    #[doc(alias = "get_pixels_inside_wrap")]
    fn pixels_inside_wrap(&self) -> i32;

    #[doc(alias = "gtk_text_view_get_right_margin")]
    #[doc(alias = "get_right_margin")]
    fn right_margin(&self) -> i32;

    #[doc(alias = "gtk_text_view_get_tabs")]
    #[doc(alias = "get_tabs")]
    fn tabs(&self) -> Option<pango::TabArray>;

    #[doc(alias = "gtk_text_view_get_top_margin")]
    #[doc(alias = "get_top_margin")]
    fn top_margin(&self) -> i32;

    #[doc(alias = "gtk_text_view_get_visible_rect")]
    #[doc(alias = "get_visible_rect")]
    fn visible_rect(&self) -> gdk::Rectangle;

    #[doc(alias = "gtk_text_view_get_wrap_mode")]
    #[doc(alias = "get_wrap_mode")]
    fn wrap_mode(&self) -> WrapMode;

    #[doc(alias = "gtk_text_view_move_mark_onscreen")]
    fn move_mark_onscreen<P: IsA<TextMark>>(&self, mark: &P) -> bool;

    #[doc(alias = "gtk_text_view_move_overlay")]
    fn move_overlay<P: IsA<Widget>>(&self, child: &P, xpos: i32, ypos: i32);

    #[doc(alias = "gtk_text_view_move_visually")]
    fn move_visually(&self, iter: &mut TextIter, count: i32) -> bool;

    #[doc(alias = "gtk_text_view_place_cursor_onscreen")]
    fn place_cursor_onscreen(&self) -> bool;

    #[doc(alias = "gtk_text_view_remove")]
    fn remove<P: IsA<Widget>>(&self, child: &P);

    #[doc(alias = "gtk_text_view_reset_cursor_blink")]
    fn reset_cursor_blink(&self);

    #[doc(alias = "gtk_text_view_reset_im_context")]
    fn reset_im_context(&self);

    #[doc(alias = "gtk_text_view_scroll_mark_onscreen")]
    fn scroll_mark_onscreen<P: IsA<TextMark>>(&self, mark: &P);

    #[doc(alias = "gtk_text_view_scroll_to_iter")]
    fn scroll_to_iter(
        &self,
        iter: &mut TextIter,
        within_margin: f64,
        use_align: bool,
        xalign: f64,
        yalign: f64,
    ) -> bool;

    #[doc(alias = "gtk_text_view_scroll_to_mark")]
    fn scroll_to_mark<P: IsA<TextMark>>(
        &self,
        mark: &P,
        within_margin: f64,
        use_align: bool,
        xalign: f64,
        yalign: f64,
    );

    #[doc(alias = "gtk_text_view_set_accepts_tab")]
    fn set_accepts_tab(&self, accepts_tab: bool);

    #[doc(alias = "gtk_text_view_set_bottom_margin")]
    fn set_bottom_margin(&self, bottom_margin: i32);

    #[doc(alias = "gtk_text_view_set_buffer")]
    fn set_buffer<P: IsA<TextBuffer>>(&self, buffer: Option<&P>);

    #[doc(alias = "gtk_text_view_set_cursor_visible")]
    fn set_cursor_visible(&self, setting: bool);

    #[doc(alias = "gtk_text_view_set_editable")]
    fn set_editable(&self, setting: bool);

    #[doc(alias = "gtk_text_view_set_extra_menu")]
    fn set_extra_menu<P: IsA<gio::MenuModel>>(&self, model: Option<&P>);

    #[doc(alias = "gtk_text_view_set_gutter")]
    fn set_gutter<P: IsA<Widget>>(&self, win: TextWindowType, widget: Option<&P>);

    #[doc(alias = "gtk_text_view_set_indent")]
    fn set_indent(&self, indent: i32);

    #[doc(alias = "gtk_text_view_set_input_hints")]
    fn set_input_hints(&self, hints: InputHints);

    #[doc(alias = "gtk_text_view_set_input_purpose")]
    fn set_input_purpose(&self, purpose: InputPurpose);

    #[doc(alias = "gtk_text_view_set_justification")]
    fn set_justification(&self, justification: Justification);

    #[doc(alias = "gtk_text_view_set_left_margin")]
    fn set_left_margin(&self, left_margin: i32);

    #[doc(alias = "gtk_text_view_set_monospace")]
    fn set_monospace(&self, monospace: bool);

    #[doc(alias = "gtk_text_view_set_overwrite")]
    fn set_overwrite(&self, overwrite: bool);

    #[doc(alias = "gtk_text_view_set_pixels_above_lines")]
    fn set_pixels_above_lines(&self, pixels_above_lines: i32);

    #[doc(alias = "gtk_text_view_set_pixels_below_lines")]
    fn set_pixels_below_lines(&self, pixels_below_lines: i32);

    #[doc(alias = "gtk_text_view_set_pixels_inside_wrap")]
    fn set_pixels_inside_wrap(&self, pixels_inside_wrap: i32);

    #[doc(alias = "gtk_text_view_set_right_margin")]
    fn set_right_margin(&self, right_margin: i32);

    #[doc(alias = "gtk_text_view_set_tabs")]
    fn set_tabs(&self, tabs: &pango::TabArray);

    #[doc(alias = "gtk_text_view_set_top_margin")]
    fn set_top_margin(&self, top_margin: i32);

    #[doc(alias = "gtk_text_view_set_wrap_mode")]
    fn set_wrap_mode(&self, wrap_mode: WrapMode);

    #[doc(alias = "gtk_text_view_starts_display_line")]
    fn starts_display_line(&self, iter: &TextIter) -> bool;

    #[doc(alias = "gtk_text_view_window_to_buffer_coords")]
    fn window_to_buffer_coords(
        &self,
        win: TextWindowType,
        window_x: i32,
        window_y: i32,
    ) -> (i32, i32);

    #[doc(alias = "im-module")]
    fn im_module(&self) -> Option<glib::GString>;

    #[doc(alias = "im-module")]
    fn set_im_module(&self, im_module: Option<&str>);

    #[doc(alias = "backspace")]
    fn connect_backspace<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_backspace(&self);

    #[doc(alias = "copy-clipboard")]
    fn connect_copy_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_copy_clipboard(&self);

    #[doc(alias = "cut-clipboard")]
    fn connect_cut_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_cut_clipboard(&self);

    #[doc(alias = "delete-from-cursor")]
    fn connect_delete_from_cursor<F: Fn(&Self, DeleteType, i32) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn emit_delete_from_cursor(&self, type_: DeleteType, count: i32);

    #[doc(alias = "extend-selection")]
    fn connect_extend_selection<
        F: Fn(&Self, TextExtendSelection, &TextIter, &TextIter, &TextIter) -> glib::signal::Inhibit
            + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "insert-at-cursor")]
    fn connect_insert_at_cursor<F: Fn(&Self, &str) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_insert_at_cursor(&self, string: &str);

    #[doc(alias = "insert-emoji")]
    fn connect_insert_emoji<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_insert_emoji(&self);

    #[doc(alias = "move-cursor")]
    fn connect_move_cursor<F: Fn(&Self, MovementStep, i32, bool) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn emit_move_cursor(&self, step: MovementStep, count: i32, extend_selection: bool);

    #[doc(alias = "move-viewport")]
    fn connect_move_viewport<F: Fn(&Self, ScrollStep, i32) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn emit_move_viewport(&self, step: ScrollStep, count: i32);

    #[doc(alias = "paste-clipboard")]
    fn connect_paste_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_paste_clipboard(&self);

    #[doc(alias = "preedit-changed")]
    fn connect_preedit_changed<F: Fn(&Self, &str) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_preedit_changed(&self, preedit: &str);

    #[doc(alias = "select-all")]
    fn connect_select_all<F: Fn(&Self, bool) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_select_all(&self, select: bool);

    #[doc(alias = "set-anchor")]
    fn connect_set_anchor<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_set_anchor(&self);

    #[doc(alias = "toggle-cursor-visible")]
    fn connect_toggle_cursor_visible<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_toggle_cursor_visible(&self);

    #[doc(alias = "toggle-overwrite")]
    fn connect_toggle_overwrite<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_toggle_overwrite(&self);

    #[doc(alias = "accepts-tab")]
    fn connect_accepts_tab_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "bottom-margin")]
    fn connect_bottom_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "buffer")]
    fn connect_buffer_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "cursor-visible")]
    fn connect_cursor_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "editable")]
    fn connect_editable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "extra-menu")]
    fn connect_extra_menu_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "im-module")]
    fn connect_im_module_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "indent")]
    fn connect_indent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "input-hints")]
    fn connect_input_hints_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "input-purpose")]
    fn connect_input_purpose_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "justification")]
    fn connect_justification_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "left-margin")]
    fn connect_left_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "monospace")]
    fn connect_monospace_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "overwrite")]
    fn connect_overwrite_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "pixels-above-lines")]
    fn connect_pixels_above_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "pixels-below-lines")]
    fn connect_pixels_below_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "pixels-inside-wrap")]
    fn connect_pixels_inside_wrap_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "right-margin")]
    fn connect_right_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "tabs")]
    fn connect_tabs_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "top-margin")]
    fn connect_top_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "wrap-mode")]
    fn connect_wrap_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<TextView>> TextViewExt for O {
    fn add_child_at_anchor<P: IsA<Widget>, Q: IsA<TextChildAnchor>>(&self, child: &P, anchor: &Q) {
        unsafe {
            ffi::gtk_text_view_add_child_at_anchor(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
                anchor.as_ref().to_glib_none().0,
            );
        }
    }

    fn add_overlay<P: IsA<Widget>>(&self, child: &P, xpos: i32, ypos: i32) {
        unsafe {
            ffi::gtk_text_view_add_overlay(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
                xpos,
                ypos,
            );
        }
    }

    fn backward_display_line(&self, iter: &mut TextIter) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_view_backward_display_line(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
            ))
        }
    }

    fn backward_display_line_start(&self, iter: &mut TextIter) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_view_backward_display_line_start(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
            ))
        }
    }

    fn buffer_to_window_coords(
        &self,
        win: TextWindowType,
        buffer_x: i32,
        buffer_y: i32,
    ) -> (i32, i32) {
        unsafe {
            let mut window_x = mem::MaybeUninit::uninit();
            let mut window_y = mem::MaybeUninit::uninit();
            ffi::gtk_text_view_buffer_to_window_coords(
                self.as_ref().to_glib_none().0,
                win.into_glib(),
                buffer_x,
                buffer_y,
                window_x.as_mut_ptr(),
                window_y.as_mut_ptr(),
            );
            let window_x = window_x.assume_init();
            let window_y = window_y.assume_init();
            (window_x, window_y)
        }
    }

    fn forward_display_line(&self, iter: &mut TextIter) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_view_forward_display_line(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
            ))
        }
    }

    fn forward_display_line_end(&self, iter: &mut TextIter) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_view_forward_display_line_end(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
            ))
        }
    }

    fn accepts_tab(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_view_get_accepts_tab(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn bottom_margin(&self) -> i32 {
        unsafe { ffi::gtk_text_view_get_bottom_margin(self.as_ref().to_glib_none().0) }
    }

    fn buffer(&self) -> TextBuffer {
        unsafe {
            from_glib_none(ffi::gtk_text_view_get_buffer(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn cursor_locations(&self, iter: Option<&TextIter>) -> (gdk::Rectangle, gdk::Rectangle) {
        unsafe {
            let mut strong = gdk::Rectangle::uninitialized();
            let mut weak = gdk::Rectangle::uninitialized();
            ffi::gtk_text_view_get_cursor_locations(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none().0,
                strong.to_glib_none_mut().0,
                weak.to_glib_none_mut().0,
            );
            (strong, weak)
        }
    }

    fn is_cursor_visible(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_view_get_cursor_visible(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_editable(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_view_get_editable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn extra_menu(&self) -> Option<gio::MenuModel> {
        unsafe {
            from_glib_none(ffi::gtk_text_view_get_extra_menu(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn gutter(&self, win: TextWindowType) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_text_view_get_gutter(
                self.as_ref().to_glib_none().0,
                win.into_glib(),
            ))
        }
    }

    fn indent(&self) -> i32 {
        unsafe { ffi::gtk_text_view_get_indent(self.as_ref().to_glib_none().0) }
    }

    fn input_hints(&self) -> InputHints {
        unsafe {
            from_glib(ffi::gtk_text_view_get_input_hints(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn input_purpose(&self) -> InputPurpose {
        unsafe {
            from_glib(ffi::gtk_text_view_get_input_purpose(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn iter_at_location(&self, x: i32, y: i32) -> Option<TextIter> {
        unsafe {
            let mut iter = TextIter::uninitialized();
            let ret = from_glib(ffi::gtk_text_view_get_iter_at_location(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                x,
                y,
            ));
            if ret {
                Some(iter)
            } else {
                None
            }
        }
    }

    fn iter_at_position(&self, x: i32, y: i32) -> Option<(TextIter, i32)> {
        unsafe {
            let mut iter = TextIter::uninitialized();
            let mut trailing = mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gtk_text_view_get_iter_at_position(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                trailing.as_mut_ptr(),
                x,
                y,
            ));
            let trailing = trailing.assume_init();
            if ret {
                Some((iter, trailing))
            } else {
                None
            }
        }
    }

    fn iter_location(&self, iter: &TextIter) -> gdk::Rectangle {
        unsafe {
            let mut location = gdk::Rectangle::uninitialized();
            ffi::gtk_text_view_get_iter_location(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none().0,
                location.to_glib_none_mut().0,
            );
            location
        }
    }

    fn justification(&self) -> Justification {
        unsafe {
            from_glib(ffi::gtk_text_view_get_justification(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn left_margin(&self) -> i32 {
        unsafe { ffi::gtk_text_view_get_left_margin(self.as_ref().to_glib_none().0) }
    }

    fn line_at_y(&self, y: i32) -> (TextIter, i32) {
        unsafe {
            let mut target_iter = TextIter::uninitialized();
            let mut line_top = mem::MaybeUninit::uninit();
            ffi::gtk_text_view_get_line_at_y(
                self.as_ref().to_glib_none().0,
                target_iter.to_glib_none_mut().0,
                y,
                line_top.as_mut_ptr(),
            );
            let line_top = line_top.assume_init();
            (target_iter, line_top)
        }
    }

    fn line_yrange(&self, iter: &TextIter) -> (i32, i32) {
        unsafe {
            let mut y = mem::MaybeUninit::uninit();
            let mut height = mem::MaybeUninit::uninit();
            ffi::gtk_text_view_get_line_yrange(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none().0,
                y.as_mut_ptr(),
                height.as_mut_ptr(),
            );
            let y = y.assume_init();
            let height = height.assume_init();
            (y, height)
        }
    }

    fn is_monospace(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_view_get_monospace(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn overwrites(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_view_get_overwrite(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn pixels_above_lines(&self) -> i32 {
        unsafe { ffi::gtk_text_view_get_pixels_above_lines(self.as_ref().to_glib_none().0) }
    }

    fn pixels_below_lines(&self) -> i32 {
        unsafe { ffi::gtk_text_view_get_pixels_below_lines(self.as_ref().to_glib_none().0) }
    }

    fn pixels_inside_wrap(&self) -> i32 {
        unsafe { ffi::gtk_text_view_get_pixels_inside_wrap(self.as_ref().to_glib_none().0) }
    }

    fn right_margin(&self) -> i32 {
        unsafe { ffi::gtk_text_view_get_right_margin(self.as_ref().to_glib_none().0) }
    }

    fn tabs(&self) -> Option<pango::TabArray> {
        unsafe { from_glib_full(ffi::gtk_text_view_get_tabs(self.as_ref().to_glib_none().0)) }
    }

    fn top_margin(&self) -> i32 {
        unsafe { ffi::gtk_text_view_get_top_margin(self.as_ref().to_glib_none().0) }
    }

    fn visible_rect(&self) -> gdk::Rectangle {
        unsafe {
            let mut visible_rect = gdk::Rectangle::uninitialized();
            ffi::gtk_text_view_get_visible_rect(
                self.as_ref().to_glib_none().0,
                visible_rect.to_glib_none_mut().0,
            );
            visible_rect
        }
    }

    fn wrap_mode(&self) -> WrapMode {
        unsafe {
            from_glib(ffi::gtk_text_view_get_wrap_mode(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn move_mark_onscreen<P: IsA<TextMark>>(&self, mark: &P) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_view_move_mark_onscreen(
                self.as_ref().to_glib_none().0,
                mark.as_ref().to_glib_none().0,
            ))
        }
    }

    fn move_overlay<P: IsA<Widget>>(&self, child: &P, xpos: i32, ypos: i32) {
        unsafe {
            ffi::gtk_text_view_move_overlay(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
                xpos,
                ypos,
            );
        }
    }

    fn move_visually(&self, iter: &mut TextIter, count: i32) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_view_move_visually(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                count,
            ))
        }
    }

    fn place_cursor_onscreen(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_view_place_cursor_onscreen(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn remove<P: IsA<Widget>>(&self, child: &P) {
        unsafe {
            ffi::gtk_text_view_remove(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
            );
        }
    }

    fn reset_cursor_blink(&self) {
        unsafe {
            ffi::gtk_text_view_reset_cursor_blink(self.as_ref().to_glib_none().0);
        }
    }

    fn reset_im_context(&self) {
        unsafe {
            ffi::gtk_text_view_reset_im_context(self.as_ref().to_glib_none().0);
        }
    }

    fn scroll_mark_onscreen<P: IsA<TextMark>>(&self, mark: &P) {
        unsafe {
            ffi::gtk_text_view_scroll_mark_onscreen(
                self.as_ref().to_glib_none().0,
                mark.as_ref().to_glib_none().0,
            );
        }
    }

    fn scroll_to_iter(
        &self,
        iter: &mut TextIter,
        within_margin: f64,
        use_align: bool,
        xalign: f64,
        yalign: f64,
    ) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_view_scroll_to_iter(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                within_margin,
                use_align.into_glib(),
                xalign,
                yalign,
            ))
        }
    }

    fn scroll_to_mark<P: IsA<TextMark>>(
        &self,
        mark: &P,
        within_margin: f64,
        use_align: bool,
        xalign: f64,
        yalign: f64,
    ) {
        unsafe {
            ffi::gtk_text_view_scroll_to_mark(
                self.as_ref().to_glib_none().0,
                mark.as_ref().to_glib_none().0,
                within_margin,
                use_align.into_glib(),
                xalign,
                yalign,
            );
        }
    }

    fn set_accepts_tab(&self, accepts_tab: bool) {
        unsafe {
            ffi::gtk_text_view_set_accepts_tab(
                self.as_ref().to_glib_none().0,
                accepts_tab.into_glib(),
            );
        }
    }

    fn set_bottom_margin(&self, bottom_margin: i32) {
        unsafe {
            ffi::gtk_text_view_set_bottom_margin(self.as_ref().to_glib_none().0, bottom_margin);
        }
    }

    fn set_buffer<P: IsA<TextBuffer>>(&self, buffer: Option<&P>) {
        unsafe {
            ffi::gtk_text_view_set_buffer(
                self.as_ref().to_glib_none().0,
                buffer.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_cursor_visible(&self, setting: bool) {
        unsafe {
            ffi::gtk_text_view_set_cursor_visible(
                self.as_ref().to_glib_none().0,
                setting.into_glib(),
            );
        }
    }

    fn set_editable(&self, setting: bool) {
        unsafe {
            ffi::gtk_text_view_set_editable(self.as_ref().to_glib_none().0, setting.into_glib());
        }
    }

    fn set_extra_menu<P: IsA<gio::MenuModel>>(&self, model: Option<&P>) {
        unsafe {
            ffi::gtk_text_view_set_extra_menu(
                self.as_ref().to_glib_none().0,
                model.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_gutter<P: IsA<Widget>>(&self, win: TextWindowType, widget: Option<&P>) {
        unsafe {
            ffi::gtk_text_view_set_gutter(
                self.as_ref().to_glib_none().0,
                win.into_glib(),
                widget.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_indent(&self, indent: i32) {
        unsafe {
            ffi::gtk_text_view_set_indent(self.as_ref().to_glib_none().0, indent);
        }
    }

    fn set_input_hints(&self, hints: InputHints) {
        unsafe {
            ffi::gtk_text_view_set_input_hints(self.as_ref().to_glib_none().0, hints.into_glib());
        }
    }

    fn set_input_purpose(&self, purpose: InputPurpose) {
        unsafe {
            ffi::gtk_text_view_set_input_purpose(
                self.as_ref().to_glib_none().0,
                purpose.into_glib(),
            );
        }
    }

    fn set_justification(&self, justification: Justification) {
        unsafe {
            ffi::gtk_text_view_set_justification(
                self.as_ref().to_glib_none().0,
                justification.into_glib(),
            );
        }
    }

    fn set_left_margin(&self, left_margin: i32) {
        unsafe {
            ffi::gtk_text_view_set_left_margin(self.as_ref().to_glib_none().0, left_margin);
        }
    }

    fn set_monospace(&self, monospace: bool) {
        unsafe {
            ffi::gtk_text_view_set_monospace(self.as_ref().to_glib_none().0, monospace.into_glib());
        }
    }

    fn set_overwrite(&self, overwrite: bool) {
        unsafe {
            ffi::gtk_text_view_set_overwrite(self.as_ref().to_glib_none().0, overwrite.into_glib());
        }
    }

    fn set_pixels_above_lines(&self, pixels_above_lines: i32) {
        unsafe {
            ffi::gtk_text_view_set_pixels_above_lines(
                self.as_ref().to_glib_none().0,
                pixels_above_lines,
            );
        }
    }

    fn set_pixels_below_lines(&self, pixels_below_lines: i32) {
        unsafe {
            ffi::gtk_text_view_set_pixels_below_lines(
                self.as_ref().to_glib_none().0,
                pixels_below_lines,
            );
        }
    }

    fn set_pixels_inside_wrap(&self, pixels_inside_wrap: i32) {
        unsafe {
            ffi::gtk_text_view_set_pixels_inside_wrap(
                self.as_ref().to_glib_none().0,
                pixels_inside_wrap,
            );
        }
    }

    fn set_right_margin(&self, right_margin: i32) {
        unsafe {
            ffi::gtk_text_view_set_right_margin(self.as_ref().to_glib_none().0, right_margin);
        }
    }

    fn set_tabs(&self, tabs: &pango::TabArray) {
        unsafe {
            ffi::gtk_text_view_set_tabs(
                self.as_ref().to_glib_none().0,
                mut_override(tabs.to_glib_none().0),
            );
        }
    }

    fn set_top_margin(&self, top_margin: i32) {
        unsafe {
            ffi::gtk_text_view_set_top_margin(self.as_ref().to_glib_none().0, top_margin);
        }
    }

    fn set_wrap_mode(&self, wrap_mode: WrapMode) {
        unsafe {
            ffi::gtk_text_view_set_wrap_mode(self.as_ref().to_glib_none().0, wrap_mode.into_glib());
        }
    }

    fn starts_display_line(&self, iter: &TextIter) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_view_starts_display_line(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none().0,
            ))
        }
    }

    fn window_to_buffer_coords(
        &self,
        win: TextWindowType,
        window_x: i32,
        window_y: i32,
    ) -> (i32, i32) {
        unsafe {
            let mut buffer_x = mem::MaybeUninit::uninit();
            let mut buffer_y = mem::MaybeUninit::uninit();
            ffi::gtk_text_view_window_to_buffer_coords(
                self.as_ref().to_glib_none().0,
                win.into_glib(),
                window_x,
                window_y,
                buffer_x.as_mut_ptr(),
                buffer_y.as_mut_ptr(),
            );
            let buffer_x = buffer_x.assume_init();
            let buffer_y = buffer_y.assume_init();
            (buffer_x, buffer_y)
        }
    }

    fn im_module(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"im-module\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `im-module` getter")
        }
    }

    fn set_im_module(&self, im_module: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"im-module\0".as_ptr() as *const _,
                im_module.to_value().to_glib_none().0,
            );
        }
    }

    fn connect_backspace<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn backspace_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"backspace\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    backspace_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_backspace(&self) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("backspace", &[])
                .unwrap()
        };
    }

    fn connect_copy_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn copy_clipboard_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"copy-clipboard\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    copy_clipboard_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_copy_clipboard(&self) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("copy-clipboard", &[])
                .unwrap()
        };
    }

    fn connect_cut_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn cut_clipboard_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"cut-clipboard\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    cut_clipboard_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_cut_clipboard(&self) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("cut-clipboard", &[])
                .unwrap()
        };
    }

    fn connect_delete_from_cursor<F: Fn(&Self, DeleteType, i32) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn delete_from_cursor_trampoline<
            P: IsA<TextView>,
            F: Fn(&P, DeleteType, i32) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            type_: ffi::GtkDeleteType,
            count: libc::c_int,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                TextView::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(type_),
                count,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"delete-from-cursor\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    delete_from_cursor_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_delete_from_cursor(&self, type_: DeleteType, count: i32) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("delete-from-cursor", &[&type_, &count])
                .unwrap()
        };
    }

    fn connect_extend_selection<
        F: Fn(&Self, TextExtendSelection, &TextIter, &TextIter, &TextIter) -> glib::signal::Inhibit
            + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn extend_selection_trampoline<
            P: IsA<TextView>,
            F: Fn(
                    &P,
                    TextExtendSelection,
                    &TextIter,
                    &TextIter,
                    &TextIter,
                ) -> glib::signal::Inhibit
                + 'static,
        >(
            this: *mut ffi::GtkTextView,
            granularity: ffi::GtkTextExtendSelection,
            location: *mut ffi::GtkTextIter,
            start: *mut ffi::GtkTextIter,
            end: *mut ffi::GtkTextIter,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                TextView::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(granularity),
                &from_glib_borrow(location),
                &from_glib_borrow(start),
                &from_glib_borrow(end),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"extend-selection\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    extend_selection_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_insert_at_cursor<F: Fn(&Self, &str) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn insert_at_cursor_trampoline<
            P: IsA<TextView>,
            F: Fn(&P, &str) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            string: *mut libc::c_char,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                TextView::from_glib_borrow(this).unsafe_cast_ref(),
                &glib::GString::from_glib_borrow(string),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"insert-at-cursor\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    insert_at_cursor_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_insert_at_cursor(&self, string: &str) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("insert-at-cursor", &[&string])
                .unwrap()
        };
    }

    fn connect_insert_emoji<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn insert_emoji_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"insert-emoji\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    insert_emoji_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_insert_emoji(&self) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("insert-emoji", &[])
                .unwrap()
        };
    }

    fn connect_move_cursor<F: Fn(&Self, MovementStep, i32, bool) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn move_cursor_trampoline<
            P: IsA<TextView>,
            F: Fn(&P, MovementStep, i32, bool) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            step: ffi::GtkMovementStep,
            count: libc::c_int,
            extend_selection: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                TextView::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(step),
                count,
                from_glib(extend_selection),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"move-cursor\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    move_cursor_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_move_cursor(&self, step: MovementStep, count: i32, extend_selection: bool) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("move-cursor", &[&step, &count, &extend_selection])
                .unwrap()
        };
    }

    fn connect_move_viewport<F: Fn(&Self, ScrollStep, i32) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn move_viewport_trampoline<
            P: IsA<TextView>,
            F: Fn(&P, ScrollStep, i32) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            step: ffi::GtkScrollStep,
            count: libc::c_int,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                TextView::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(step),
                count,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"move-viewport\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    move_viewport_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_move_viewport(&self, step: ScrollStep, count: i32) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("move-viewport", &[&step, &count])
                .unwrap()
        };
    }

    fn connect_paste_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn paste_clipboard_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"paste-clipboard\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    paste_clipboard_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_paste_clipboard(&self) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("paste-clipboard", &[])
                .unwrap()
        };
    }

    fn connect_preedit_changed<F: Fn(&Self, &str) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn preedit_changed_trampoline<
            P: IsA<TextView>,
            F: Fn(&P, &str) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            preedit: *mut libc::c_char,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                TextView::from_glib_borrow(this).unsafe_cast_ref(),
                &glib::GString::from_glib_borrow(preedit),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"preedit-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    preedit_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_preedit_changed(&self, preedit: &str) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("preedit-changed", &[&preedit])
                .unwrap()
        };
    }

    fn connect_select_all<F: Fn(&Self, bool) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn select_all_trampoline<P: IsA<TextView>, F: Fn(&P, bool) + 'static>(
            this: *mut ffi::GtkTextView,
            select: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                TextView::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(select),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"select-all\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    select_all_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_select_all(&self, select: bool) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("select-all", &[&select])
                .unwrap()
        };
    }

    fn connect_set_anchor<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn set_anchor_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"set-anchor\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    set_anchor_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_set_anchor(&self) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("set-anchor", &[])
                .unwrap()
        };
    }

    fn connect_toggle_cursor_visible<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn toggle_cursor_visible_trampoline<
            P: IsA<TextView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"toggle-cursor-visible\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    toggle_cursor_visible_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_toggle_cursor_visible(&self) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("toggle-cursor-visible", &[])
                .unwrap()
        };
    }

    fn connect_toggle_overwrite<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn toggle_overwrite_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"toggle-overwrite\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    toggle_overwrite_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_toggle_overwrite(&self) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("toggle-overwrite", &[])
                .unwrap()
        };
    }

    fn connect_accepts_tab_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_accepts_tab_trampoline<
            P: IsA<TextView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::accepts-tab\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_accepts_tab_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_bottom_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_bottom_margin_trampoline<
            P: IsA<TextView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::bottom-margin\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_bottom_margin_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_buffer_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_buffer_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::buffer\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_buffer_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_cursor_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_cursor_visible_trampoline<
            P: IsA<TextView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::cursor-visible\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_cursor_visible_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_editable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_editable_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::editable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_editable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_extra_menu_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_extra_menu_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::extra-menu\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_extra_menu_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_im_module_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_im_module_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::im-module\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_im_module_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_indent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_indent_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::indent\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_indent_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_input_hints_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_input_hints_trampoline<
            P: IsA<TextView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::input-hints\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_input_hints_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_input_purpose_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_input_purpose_trampoline<
            P: IsA<TextView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::input-purpose\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_input_purpose_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_justification_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_justification_trampoline<
            P: IsA<TextView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::justification\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_justification_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_left_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_left_margin_trampoline<
            P: IsA<TextView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::left-margin\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_left_margin_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_monospace_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_monospace_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::monospace\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_monospace_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_overwrite_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_overwrite_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::overwrite\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_overwrite_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_pixels_above_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixels_above_lines_trampoline<
            P: IsA<TextView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pixels-above-lines\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pixels_above_lines_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_pixels_below_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixels_below_lines_trampoline<
            P: IsA<TextView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pixels-below-lines\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pixels_below_lines_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_pixels_inside_wrap_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixels_inside_wrap_trampoline<
            P: IsA<TextView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pixels-inside-wrap\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pixels_inside_wrap_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_right_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_right_margin_trampoline<
            P: IsA<TextView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::right-margin\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_right_margin_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_tabs_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tabs_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tabs\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tabs_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_top_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_top_margin_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::top-margin\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_top_margin_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_wrap_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_wrap_mode_trampoline<P: IsA<TextView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::wrap-mode\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_wrap_mode_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for TextView {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("TextView")
    }
}
