// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::Justification;
use crate::TextDirection;
use crate::WrapMode;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "GtkTextTag")]
    pub struct TextTag(Object<ffi::GtkTextTag, ffi::GtkTextTagClass>);

    match fn {
        type_ => || ffi::gtk_text_tag_get_type(),
    }
}

impl TextTag {
    #[doc(alias = "gtk_text_tag_new")]
    pub fn new(name: Option<&str>) -> TextTag {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gtk_text_tag_new(name.to_glib_none().0)) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`TextTag`] objects.
    ///
    /// This method returns an instance of [`TextTagBuilder`] which can be used to create [`TextTag`] objects.
    pub fn builder() -> TextTagBuilder {
        TextTagBuilder::default()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`TextTag`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
pub struct TextTagBuilder {
    accumulative_margin: Option<bool>,
    allow_breaks: Option<bool>,
    allow_breaks_set: Option<bool>,
    background: Option<String>,
    background_full_height: Option<bool>,
    background_full_height_set: Option<bool>,
    background_rgba: Option<gdk::RGBA>,
    background_set: Option<bool>,
    direction: Option<TextDirection>,
    editable: Option<bool>,
    editable_set: Option<bool>,
    fallback: Option<bool>,
    fallback_set: Option<bool>,
    family: Option<String>,
    family_set: Option<bool>,
    font: Option<String>,
    font_desc: Option<pango::FontDescription>,
    font_features: Option<String>,
    font_features_set: Option<bool>,
    foreground: Option<String>,
    foreground_rgba: Option<gdk::RGBA>,
    foreground_set: Option<bool>,
    indent: Option<i32>,
    indent_set: Option<bool>,
    insert_hyphens: Option<bool>,
    insert_hyphens_set: Option<bool>,
    invisible: Option<bool>,
    invisible_set: Option<bool>,
    justification: Option<Justification>,
    justification_set: Option<bool>,
    language: Option<String>,
    language_set: Option<bool>,
    left_margin: Option<i32>,
    left_margin_set: Option<bool>,
    letter_spacing: Option<i32>,
    letter_spacing_set: Option<bool>,
    name: Option<String>,
    overline: Option<pango::Overline>,
    overline_rgba: Option<gdk::RGBA>,
    overline_rgba_set: Option<bool>,
    overline_set: Option<bool>,
    paragraph_background: Option<String>,
    paragraph_background_rgba: Option<gdk::RGBA>,
    paragraph_background_set: Option<bool>,
    pixels_above_lines: Option<i32>,
    pixels_above_lines_set: Option<bool>,
    pixels_below_lines: Option<i32>,
    pixels_below_lines_set: Option<bool>,
    pixels_inside_wrap: Option<i32>,
    pixels_inside_wrap_set: Option<bool>,
    right_margin: Option<i32>,
    right_margin_set: Option<bool>,
    rise: Option<i32>,
    rise_set: Option<bool>,
    scale: Option<f64>,
    scale_set: Option<bool>,
    show_spaces: Option<pango::ShowFlags>,
    show_spaces_set: Option<bool>,
    size: Option<i32>,
    size_points: Option<f64>,
    size_set: Option<bool>,
    stretch: Option<pango::Stretch>,
    stretch_set: Option<bool>,
    strikethrough: Option<bool>,
    strikethrough_rgba: Option<gdk::RGBA>,
    strikethrough_rgba_set: Option<bool>,
    strikethrough_set: Option<bool>,
    style: Option<pango::Style>,
    style_set: Option<bool>,
    tabs: Option<pango::TabArray>,
    tabs_set: Option<bool>,
    underline: Option<pango::Underline>,
    underline_rgba: Option<gdk::RGBA>,
    underline_rgba_set: Option<bool>,
    underline_set: Option<bool>,
    variant: Option<pango::Variant>,
    variant_set: Option<bool>,
    weight: Option<i32>,
    weight_set: Option<bool>,
    wrap_mode: Option<WrapMode>,
    wrap_mode_set: Option<bool>,
}

impl TextTagBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`TextTagBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`TextTag`].
    pub fn build(self) -> TextTag {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref accumulative_margin) = self.accumulative_margin {
            properties.push(("accumulative-margin", accumulative_margin));
        }
        if let Some(ref allow_breaks) = self.allow_breaks {
            properties.push(("allow-breaks", allow_breaks));
        }
        if let Some(ref allow_breaks_set) = self.allow_breaks_set {
            properties.push(("allow-breaks-set", allow_breaks_set));
        }
        if let Some(ref background) = self.background {
            properties.push(("background", background));
        }
        if let Some(ref background_full_height) = self.background_full_height {
            properties.push(("background-full-height", background_full_height));
        }
        if let Some(ref background_full_height_set) = self.background_full_height_set {
            properties.push(("background-full-height-set", background_full_height_set));
        }
        if let Some(ref background_rgba) = self.background_rgba {
            properties.push(("background-rgba", background_rgba));
        }
        if let Some(ref background_set) = self.background_set {
            properties.push(("background-set", background_set));
        }
        if let Some(ref direction) = self.direction {
            properties.push(("direction", direction));
        }
        if let Some(ref editable) = self.editable {
            properties.push(("editable", editable));
        }
        if let Some(ref editable_set) = self.editable_set {
            properties.push(("editable-set", editable_set));
        }
        if let Some(ref fallback) = self.fallback {
            properties.push(("fallback", fallback));
        }
        if let Some(ref fallback_set) = self.fallback_set {
            properties.push(("fallback-set", fallback_set));
        }
        if let Some(ref family) = self.family {
            properties.push(("family", family));
        }
        if let Some(ref family_set) = self.family_set {
            properties.push(("family-set", family_set));
        }
        if let Some(ref font) = self.font {
            properties.push(("font", font));
        }
        if let Some(ref font_desc) = self.font_desc {
            properties.push(("font-desc", font_desc));
        }
        if let Some(ref font_features) = self.font_features {
            properties.push(("font-features", font_features));
        }
        if let Some(ref font_features_set) = self.font_features_set {
            properties.push(("font-features-set", font_features_set));
        }
        if let Some(ref foreground) = self.foreground {
            properties.push(("foreground", foreground));
        }
        if let Some(ref foreground_rgba) = self.foreground_rgba {
            properties.push(("foreground-rgba", foreground_rgba));
        }
        if let Some(ref foreground_set) = self.foreground_set {
            properties.push(("foreground-set", foreground_set));
        }
        if let Some(ref indent) = self.indent {
            properties.push(("indent", indent));
        }
        if let Some(ref indent_set) = self.indent_set {
            properties.push(("indent-set", indent_set));
        }
        if let Some(ref insert_hyphens) = self.insert_hyphens {
            properties.push(("insert-hyphens", insert_hyphens));
        }
        if let Some(ref insert_hyphens_set) = self.insert_hyphens_set {
            properties.push(("insert-hyphens-set", insert_hyphens_set));
        }
        if let Some(ref invisible) = self.invisible {
            properties.push(("invisible", invisible));
        }
        if let Some(ref invisible_set) = self.invisible_set {
            properties.push(("invisible-set", invisible_set));
        }
        if let Some(ref justification) = self.justification {
            properties.push(("justification", justification));
        }
        if let Some(ref justification_set) = self.justification_set {
            properties.push(("justification-set", justification_set));
        }
        if let Some(ref language) = self.language {
            properties.push(("language", language));
        }
        if let Some(ref language_set) = self.language_set {
            properties.push(("language-set", language_set));
        }
        if let Some(ref left_margin) = self.left_margin {
            properties.push(("left-margin", left_margin));
        }
        if let Some(ref left_margin_set) = self.left_margin_set {
            properties.push(("left-margin-set", left_margin_set));
        }
        if let Some(ref letter_spacing) = self.letter_spacing {
            properties.push(("letter-spacing", letter_spacing));
        }
        if let Some(ref letter_spacing_set) = self.letter_spacing_set {
            properties.push(("letter-spacing-set", letter_spacing_set));
        }
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        if let Some(ref overline) = self.overline {
            properties.push(("overline", overline));
        }
        if let Some(ref overline_rgba) = self.overline_rgba {
            properties.push(("overline-rgba", overline_rgba));
        }
        if let Some(ref overline_rgba_set) = self.overline_rgba_set {
            properties.push(("overline-rgba-set", overline_rgba_set));
        }
        if let Some(ref overline_set) = self.overline_set {
            properties.push(("overline-set", overline_set));
        }
        if let Some(ref paragraph_background) = self.paragraph_background {
            properties.push(("paragraph-background", paragraph_background));
        }
        if let Some(ref paragraph_background_rgba) = self.paragraph_background_rgba {
            properties.push(("paragraph-background-rgba", paragraph_background_rgba));
        }
        if let Some(ref paragraph_background_set) = self.paragraph_background_set {
            properties.push(("paragraph-background-set", paragraph_background_set));
        }
        if let Some(ref pixels_above_lines) = self.pixels_above_lines {
            properties.push(("pixels-above-lines", pixels_above_lines));
        }
        if let Some(ref pixels_above_lines_set) = self.pixels_above_lines_set {
            properties.push(("pixels-above-lines-set", pixels_above_lines_set));
        }
        if let Some(ref pixels_below_lines) = self.pixels_below_lines {
            properties.push(("pixels-below-lines", pixels_below_lines));
        }
        if let Some(ref pixels_below_lines_set) = self.pixels_below_lines_set {
            properties.push(("pixels-below-lines-set", pixels_below_lines_set));
        }
        if let Some(ref pixels_inside_wrap) = self.pixels_inside_wrap {
            properties.push(("pixels-inside-wrap", pixels_inside_wrap));
        }
        if let Some(ref pixels_inside_wrap_set) = self.pixels_inside_wrap_set {
            properties.push(("pixels-inside-wrap-set", pixels_inside_wrap_set));
        }
        if let Some(ref right_margin) = self.right_margin {
            properties.push(("right-margin", right_margin));
        }
        if let Some(ref right_margin_set) = self.right_margin_set {
            properties.push(("right-margin-set", right_margin_set));
        }
        if let Some(ref rise) = self.rise {
            properties.push(("rise", rise));
        }
        if let Some(ref rise_set) = self.rise_set {
            properties.push(("rise-set", rise_set));
        }
        if let Some(ref scale) = self.scale {
            properties.push(("scale", scale));
        }
        if let Some(ref scale_set) = self.scale_set {
            properties.push(("scale-set", scale_set));
        }
        if let Some(ref show_spaces) = self.show_spaces {
            properties.push(("show-spaces", show_spaces));
        }
        if let Some(ref show_spaces_set) = self.show_spaces_set {
            properties.push(("show-spaces-set", show_spaces_set));
        }
        if let Some(ref size) = self.size {
            properties.push(("size", size));
        }
        if let Some(ref size_points) = self.size_points {
            properties.push(("size-points", size_points));
        }
        if let Some(ref size_set) = self.size_set {
            properties.push(("size-set", size_set));
        }
        if let Some(ref stretch) = self.stretch {
            properties.push(("stretch", stretch));
        }
        if let Some(ref stretch_set) = self.stretch_set {
            properties.push(("stretch-set", stretch_set));
        }
        if let Some(ref strikethrough) = self.strikethrough {
            properties.push(("strikethrough", strikethrough));
        }
        if let Some(ref strikethrough_rgba) = self.strikethrough_rgba {
            properties.push(("strikethrough-rgba", strikethrough_rgba));
        }
        if let Some(ref strikethrough_rgba_set) = self.strikethrough_rgba_set {
            properties.push(("strikethrough-rgba-set", strikethrough_rgba_set));
        }
        if let Some(ref strikethrough_set) = self.strikethrough_set {
            properties.push(("strikethrough-set", strikethrough_set));
        }
        if let Some(ref style) = self.style {
            properties.push(("style", style));
        }
        if let Some(ref style_set) = self.style_set {
            properties.push(("style-set", style_set));
        }
        if let Some(ref tabs) = self.tabs {
            properties.push(("tabs", tabs));
        }
        if let Some(ref tabs_set) = self.tabs_set {
            properties.push(("tabs-set", tabs_set));
        }
        if let Some(ref underline) = self.underline {
            properties.push(("underline", underline));
        }
        if let Some(ref underline_rgba) = self.underline_rgba {
            properties.push(("underline-rgba", underline_rgba));
        }
        if let Some(ref underline_rgba_set) = self.underline_rgba_set {
            properties.push(("underline-rgba-set", underline_rgba_set));
        }
        if let Some(ref underline_set) = self.underline_set {
            properties.push(("underline-set", underline_set));
        }
        if let Some(ref variant) = self.variant {
            properties.push(("variant", variant));
        }
        if let Some(ref variant_set) = self.variant_set {
            properties.push(("variant-set", variant_set));
        }
        if let Some(ref weight) = self.weight {
            properties.push(("weight", weight));
        }
        if let Some(ref weight_set) = self.weight_set {
            properties.push(("weight-set", weight_set));
        }
        if let Some(ref wrap_mode) = self.wrap_mode {
            properties.push(("wrap-mode", wrap_mode));
        }
        if let Some(ref wrap_mode_set) = self.wrap_mode_set {
            properties.push(("wrap-mode-set", wrap_mode_set));
        }
        glib::Object::new::<TextTag>(&properties).expect("Failed to create an instance of TextTag")
    }

    pub fn accumulative_margin(mut self, accumulative_margin: bool) -> Self {
        self.accumulative_margin = Some(accumulative_margin);
        self
    }

    pub fn allow_breaks(mut self, allow_breaks: bool) -> Self {
        self.allow_breaks = Some(allow_breaks);
        self
    }

    pub fn allow_breaks_set(mut self, allow_breaks_set: bool) -> Self {
        self.allow_breaks_set = Some(allow_breaks_set);
        self
    }

    pub fn background(mut self, background: &str) -> Self {
        self.background = Some(background.to_string());
        self
    }

    pub fn background_full_height(mut self, background_full_height: bool) -> Self {
        self.background_full_height = Some(background_full_height);
        self
    }

    pub fn background_full_height_set(mut self, background_full_height_set: bool) -> Self {
        self.background_full_height_set = Some(background_full_height_set);
        self
    }

    pub fn background_rgba(mut self, background_rgba: &gdk::RGBA) -> Self {
        self.background_rgba = Some(background_rgba.clone());
        self
    }

    pub fn background_set(mut self, background_set: bool) -> Self {
        self.background_set = Some(background_set);
        self
    }

    pub fn direction(mut self, direction: TextDirection) -> Self {
        self.direction = Some(direction);
        self
    }

    pub fn editable(mut self, editable: bool) -> Self {
        self.editable = Some(editable);
        self
    }

    pub fn editable_set(mut self, editable_set: bool) -> Self {
        self.editable_set = Some(editable_set);
        self
    }

    pub fn fallback(mut self, fallback: bool) -> Self {
        self.fallback = Some(fallback);
        self
    }

    pub fn fallback_set(mut self, fallback_set: bool) -> Self {
        self.fallback_set = Some(fallback_set);
        self
    }

    pub fn family(mut self, family: &str) -> Self {
        self.family = Some(family.to_string());
        self
    }

    pub fn family_set(mut self, family_set: bool) -> Self {
        self.family_set = Some(family_set);
        self
    }

    pub fn font(mut self, font: &str) -> Self {
        self.font = Some(font.to_string());
        self
    }

    pub fn font_desc(mut self, font_desc: &pango::FontDescription) -> Self {
        self.font_desc = Some(font_desc.clone());
        self
    }

    pub fn font_features(mut self, font_features: &str) -> Self {
        self.font_features = Some(font_features.to_string());
        self
    }

    pub fn font_features_set(mut self, font_features_set: bool) -> Self {
        self.font_features_set = Some(font_features_set);
        self
    }

    pub fn foreground(mut self, foreground: &str) -> Self {
        self.foreground = Some(foreground.to_string());
        self
    }

    pub fn foreground_rgba(mut self, foreground_rgba: &gdk::RGBA) -> Self {
        self.foreground_rgba = Some(foreground_rgba.clone());
        self
    }

    pub fn foreground_set(mut self, foreground_set: bool) -> Self {
        self.foreground_set = Some(foreground_set);
        self
    }

    pub fn indent(mut self, indent: i32) -> Self {
        self.indent = Some(indent);
        self
    }

    pub fn indent_set(mut self, indent_set: bool) -> Self {
        self.indent_set = Some(indent_set);
        self
    }

    pub fn insert_hyphens(mut self, insert_hyphens: bool) -> Self {
        self.insert_hyphens = Some(insert_hyphens);
        self
    }

    pub fn insert_hyphens_set(mut self, insert_hyphens_set: bool) -> Self {
        self.insert_hyphens_set = Some(insert_hyphens_set);
        self
    }

    pub fn invisible(mut self, invisible: bool) -> Self {
        self.invisible = Some(invisible);
        self
    }

    pub fn invisible_set(mut self, invisible_set: bool) -> Self {
        self.invisible_set = Some(invisible_set);
        self
    }

    pub fn justification(mut self, justification: Justification) -> Self {
        self.justification = Some(justification);
        self
    }

    pub fn justification_set(mut self, justification_set: bool) -> Self {
        self.justification_set = Some(justification_set);
        self
    }

    pub fn language(mut self, language: &str) -> Self {
        self.language = Some(language.to_string());
        self
    }

    pub fn language_set(mut self, language_set: bool) -> Self {
        self.language_set = Some(language_set);
        self
    }

    pub fn left_margin(mut self, left_margin: i32) -> Self {
        self.left_margin = Some(left_margin);
        self
    }

    pub fn left_margin_set(mut self, left_margin_set: bool) -> Self {
        self.left_margin_set = Some(left_margin_set);
        self
    }

    pub fn letter_spacing(mut self, letter_spacing: i32) -> Self {
        self.letter_spacing = Some(letter_spacing);
        self
    }

    pub fn letter_spacing_set(mut self, letter_spacing_set: bool) -> Self {
        self.letter_spacing_set = Some(letter_spacing_set);
        self
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }

    pub fn overline(mut self, overline: pango::Overline) -> Self {
        self.overline = Some(overline);
        self
    }

    pub fn overline_rgba(mut self, overline_rgba: &gdk::RGBA) -> Self {
        self.overline_rgba = Some(overline_rgba.clone());
        self
    }

    pub fn overline_rgba_set(mut self, overline_rgba_set: bool) -> Self {
        self.overline_rgba_set = Some(overline_rgba_set);
        self
    }

    pub fn overline_set(mut self, overline_set: bool) -> Self {
        self.overline_set = Some(overline_set);
        self
    }

    pub fn paragraph_background(mut self, paragraph_background: &str) -> Self {
        self.paragraph_background = Some(paragraph_background.to_string());
        self
    }

    pub fn paragraph_background_rgba(mut self, paragraph_background_rgba: &gdk::RGBA) -> Self {
        self.paragraph_background_rgba = Some(paragraph_background_rgba.clone());
        self
    }

    pub fn paragraph_background_set(mut self, paragraph_background_set: bool) -> Self {
        self.paragraph_background_set = Some(paragraph_background_set);
        self
    }

    pub fn pixels_above_lines(mut self, pixels_above_lines: i32) -> Self {
        self.pixels_above_lines = Some(pixels_above_lines);
        self
    }

    pub fn pixels_above_lines_set(mut self, pixels_above_lines_set: bool) -> Self {
        self.pixels_above_lines_set = Some(pixels_above_lines_set);
        self
    }

    pub fn pixels_below_lines(mut self, pixels_below_lines: i32) -> Self {
        self.pixels_below_lines = Some(pixels_below_lines);
        self
    }

    pub fn pixels_below_lines_set(mut self, pixels_below_lines_set: bool) -> Self {
        self.pixels_below_lines_set = Some(pixels_below_lines_set);
        self
    }

    pub fn pixels_inside_wrap(mut self, pixels_inside_wrap: i32) -> Self {
        self.pixels_inside_wrap = Some(pixels_inside_wrap);
        self
    }

    pub fn pixels_inside_wrap_set(mut self, pixels_inside_wrap_set: bool) -> Self {
        self.pixels_inside_wrap_set = Some(pixels_inside_wrap_set);
        self
    }

    pub fn right_margin(mut self, right_margin: i32) -> Self {
        self.right_margin = Some(right_margin);
        self
    }

    pub fn right_margin_set(mut self, right_margin_set: bool) -> Self {
        self.right_margin_set = Some(right_margin_set);
        self
    }

    pub fn rise(mut self, rise: i32) -> Self {
        self.rise = Some(rise);
        self
    }

    pub fn rise_set(mut self, rise_set: bool) -> Self {
        self.rise_set = Some(rise_set);
        self
    }

    pub fn scale(mut self, scale: f64) -> Self {
        self.scale = Some(scale);
        self
    }

    pub fn scale_set(mut self, scale_set: bool) -> Self {
        self.scale_set = Some(scale_set);
        self
    }

    pub fn show_spaces(mut self, show_spaces: pango::ShowFlags) -> Self {
        self.show_spaces = Some(show_spaces);
        self
    }

    pub fn show_spaces_set(mut self, show_spaces_set: bool) -> Self {
        self.show_spaces_set = Some(show_spaces_set);
        self
    }

    pub fn size(mut self, size: i32) -> Self {
        self.size = Some(size);
        self
    }

    pub fn size_points(mut self, size_points: f64) -> Self {
        self.size_points = Some(size_points);
        self
    }

    pub fn size_set(mut self, size_set: bool) -> Self {
        self.size_set = Some(size_set);
        self
    }

    pub fn stretch(mut self, stretch: pango::Stretch) -> Self {
        self.stretch = Some(stretch);
        self
    }

    pub fn stretch_set(mut self, stretch_set: bool) -> Self {
        self.stretch_set = Some(stretch_set);
        self
    }

    pub fn strikethrough(mut self, strikethrough: bool) -> Self {
        self.strikethrough = Some(strikethrough);
        self
    }

    pub fn strikethrough_rgba(mut self, strikethrough_rgba: &gdk::RGBA) -> Self {
        self.strikethrough_rgba = Some(strikethrough_rgba.clone());
        self
    }

    pub fn strikethrough_rgba_set(mut self, strikethrough_rgba_set: bool) -> Self {
        self.strikethrough_rgba_set = Some(strikethrough_rgba_set);
        self
    }

    pub fn strikethrough_set(mut self, strikethrough_set: bool) -> Self {
        self.strikethrough_set = Some(strikethrough_set);
        self
    }

    pub fn style(mut self, style: pango::Style) -> Self {
        self.style = Some(style);
        self
    }

    pub fn style_set(mut self, style_set: bool) -> Self {
        self.style_set = Some(style_set);
        self
    }

    pub fn tabs(mut self, tabs: &pango::TabArray) -> Self {
        self.tabs = Some(tabs.clone());
        self
    }

    pub fn tabs_set(mut self, tabs_set: bool) -> Self {
        self.tabs_set = Some(tabs_set);
        self
    }

    pub fn underline(mut self, underline: pango::Underline) -> Self {
        self.underline = Some(underline);
        self
    }

    pub fn underline_rgba(mut self, underline_rgba: &gdk::RGBA) -> Self {
        self.underline_rgba = Some(underline_rgba.clone());
        self
    }

    pub fn underline_rgba_set(mut self, underline_rgba_set: bool) -> Self {
        self.underline_rgba_set = Some(underline_rgba_set);
        self
    }

    pub fn underline_set(mut self, underline_set: bool) -> Self {
        self.underline_set = Some(underline_set);
        self
    }

    pub fn variant(mut self, variant: pango::Variant) -> Self {
        self.variant = Some(variant);
        self
    }

    pub fn variant_set(mut self, variant_set: bool) -> Self {
        self.variant_set = Some(variant_set);
        self
    }

    pub fn weight(mut self, weight: i32) -> Self {
        self.weight = Some(weight);
        self
    }

    pub fn weight_set(mut self, weight_set: bool) -> Self {
        self.weight_set = Some(weight_set);
        self
    }

    pub fn wrap_mode(mut self, wrap_mode: WrapMode) -> Self {
        self.wrap_mode = Some(wrap_mode);
        self
    }

    pub fn wrap_mode_set(mut self, wrap_mode_set: bool) -> Self {
        self.wrap_mode_set = Some(wrap_mode_set);
        self
    }
}

pub const NONE_TEXT_TAG: Option<&TextTag> = None;

pub trait TextTagExt: 'static {
    #[doc(alias = "gtk_text_tag_changed")]
    fn changed(&self, size_changed: bool);

    #[doc(alias = "gtk_text_tag_get_priority")]
    #[doc(alias = "get_priority")]
    fn priority(&self) -> i32;

    #[doc(alias = "gtk_text_tag_set_priority")]
    fn set_priority(&self, priority: i32);

    #[doc(alias = "accumulative-margin")]
    fn is_accumulative_margin(&self) -> bool;

    #[doc(alias = "accumulative-margin")]
    fn set_accumulative_margin(&self, accumulative_margin: bool);

    #[doc(alias = "allow-breaks")]
    fn allows_breaks(&self) -> bool;

    #[doc(alias = "allow-breaks")]
    fn set_allow_breaks(&self, allow_breaks: bool);

    #[doc(alias = "allow-breaks-set")]
    fn allows_breaks_set(&self) -> bool;

    #[doc(alias = "allow-breaks-set")]
    fn set_allow_breaks_set(&self, allow_breaks_set: bool);

    fn set_background(&self, background: Option<&str>);

    #[doc(alias = "background-full-height")]
    fn is_background_full_height(&self) -> bool;

    #[doc(alias = "background-full-height")]
    fn set_background_full_height(&self, background_full_height: bool);

    #[doc(alias = "background-full-height-set")]
    fn is_background_full_height_set(&self) -> bool;

    #[doc(alias = "background-full-height-set")]
    fn set_background_full_height_set(&self, background_full_height_set: bool);

    #[doc(alias = "background-rgba")]
    fn background_rgba(&self) -> Option<gdk::RGBA>;

    #[doc(alias = "background-rgba")]
    fn set_background_rgba(&self, background_rgba: Option<&gdk::RGBA>);

    #[doc(alias = "background-set")]
    fn is_background_set(&self) -> bool;

    #[doc(alias = "background-set")]
    fn set_background_set(&self, background_set: bool);

    fn direction(&self) -> TextDirection;

    fn set_direction(&self, direction: TextDirection);

    fn is_editable(&self) -> bool;

    fn set_editable(&self, editable: bool);

    #[doc(alias = "editable-set")]
    fn is_editable_set(&self) -> bool;

    #[doc(alias = "editable-set")]
    fn set_editable_set(&self, editable_set: bool);

    fn is_fallback(&self) -> bool;

    fn set_fallback(&self, fallback: bool);

    #[doc(alias = "fallback-set")]
    fn is_fallback_set(&self) -> bool;

    #[doc(alias = "fallback-set")]
    fn set_fallback_set(&self, fallback_set: bool);

    fn family(&self) -> Option<glib::GString>;

    fn set_family(&self, family: Option<&str>);

    #[doc(alias = "family-set")]
    fn is_family_set(&self) -> bool;

    #[doc(alias = "family-set")]
    fn set_family_set(&self, family_set: bool);

    fn font(&self) -> Option<glib::GString>;

    fn set_font(&self, font: Option<&str>);

    #[doc(alias = "font-desc")]
    fn font_desc(&self) -> Option<pango::FontDescription>;

    #[doc(alias = "font-desc")]
    fn set_font_desc(&self, font_desc: Option<&pango::FontDescription>);

    #[doc(alias = "font-features")]
    fn font_features(&self) -> Option<glib::GString>;

    #[doc(alias = "font-features")]
    fn set_font_features(&self, font_features: Option<&str>);

    #[doc(alias = "font-features-set")]
    fn is_font_features_set(&self) -> bool;

    #[doc(alias = "font-features-set")]
    fn set_font_features_set(&self, font_features_set: bool);

    fn set_foreground(&self, foreground: Option<&str>);

    #[doc(alias = "foreground-rgba")]
    fn foreground_rgba(&self) -> Option<gdk::RGBA>;

    #[doc(alias = "foreground-rgba")]
    fn set_foreground_rgba(&self, foreground_rgba: Option<&gdk::RGBA>);

    #[doc(alias = "foreground-set")]
    fn is_foreground_set(&self) -> bool;

    #[doc(alias = "foreground-set")]
    fn set_foreground_set(&self, foreground_set: bool);

    fn indent(&self) -> i32;

    fn set_indent(&self, indent: i32);

    #[doc(alias = "indent-set")]
    fn is_indent_set(&self) -> bool;

    #[doc(alias = "indent-set")]
    fn set_indent_set(&self, indent_set: bool);

    #[doc(alias = "insert-hyphens")]
    fn is_insert_hyphens(&self) -> bool;

    #[doc(alias = "insert-hyphens")]
    fn set_insert_hyphens(&self, insert_hyphens: bool);

    #[doc(alias = "insert-hyphens-set")]
    fn is_insert_hyphens_set(&self) -> bool;

    #[doc(alias = "insert-hyphens-set")]
    fn set_insert_hyphens_set(&self, insert_hyphens_set: bool);

    fn is_invisible(&self) -> bool;

    fn set_invisible(&self, invisible: bool);

    #[doc(alias = "invisible-set")]
    fn is_invisible_set(&self) -> bool;

    #[doc(alias = "invisible-set")]
    fn set_invisible_set(&self, invisible_set: bool);

    fn justification(&self) -> Justification;

    fn set_justification(&self, justification: Justification);

    #[doc(alias = "justification-set")]
    fn is_justification_set(&self) -> bool;

    #[doc(alias = "justification-set")]
    fn set_justification_set(&self, justification_set: bool);

    fn language(&self) -> Option<glib::GString>;

    fn set_language(&self, language: Option<&str>);

    #[doc(alias = "language-set")]
    fn is_language_set(&self) -> bool;

    #[doc(alias = "language-set")]
    fn set_language_set(&self, language_set: bool);

    #[doc(alias = "left-margin")]
    fn left_margin(&self) -> i32;

    #[doc(alias = "left-margin")]
    fn set_left_margin(&self, left_margin: i32);

    #[doc(alias = "left-margin-set")]
    fn is_left_margin_set(&self) -> bool;

    #[doc(alias = "left-margin-set")]
    fn set_left_margin_set(&self, left_margin_set: bool);

    #[doc(alias = "letter-spacing")]
    fn letter_spacing(&self) -> i32;

    #[doc(alias = "letter-spacing")]
    fn set_letter_spacing(&self, letter_spacing: i32);

    #[doc(alias = "letter-spacing-set")]
    fn is_letter_spacing_set(&self) -> bool;

    #[doc(alias = "letter-spacing-set")]
    fn set_letter_spacing_set(&self, letter_spacing_set: bool);

    fn name(&self) -> Option<glib::GString>;

    fn overline(&self) -> pango::Overline;

    fn set_overline(&self, overline: pango::Overline);

    #[doc(alias = "overline-rgba")]
    fn overline_rgba(&self) -> Option<gdk::RGBA>;

    #[doc(alias = "overline-rgba")]
    fn set_overline_rgba(&self, overline_rgba: Option<&gdk::RGBA>);

    #[doc(alias = "overline-rgba-set")]
    fn is_overline_rgba_set(&self) -> bool;

    #[doc(alias = "overline-rgba-set")]
    fn set_overline_rgba_set(&self, overline_rgba_set: bool);

    #[doc(alias = "overline-set")]
    fn is_overline_set(&self) -> bool;

    #[doc(alias = "overline-set")]
    fn set_overline_set(&self, overline_set: bool);

    #[doc(alias = "paragraph-background")]
    fn set_paragraph_background(&self, paragraph_background: Option<&str>);

    #[doc(alias = "paragraph-background-rgba")]
    fn paragraph_background_rgba(&self) -> Option<gdk::RGBA>;

    #[doc(alias = "paragraph-background-rgba")]
    fn set_paragraph_background_rgba(&self, paragraph_background_rgba: Option<&gdk::RGBA>);

    #[doc(alias = "paragraph-background-set")]
    fn is_paragraph_background_set(&self) -> bool;

    #[doc(alias = "paragraph-background-set")]
    fn set_paragraph_background_set(&self, paragraph_background_set: bool);

    #[doc(alias = "pixels-above-lines")]
    fn pixels_above_lines(&self) -> i32;

    #[doc(alias = "pixels-above-lines")]
    fn set_pixels_above_lines(&self, pixels_above_lines: i32);

    #[doc(alias = "pixels-above-lines-set")]
    fn is_pixels_above_lines_set(&self) -> bool;

    #[doc(alias = "pixels-above-lines-set")]
    fn set_pixels_above_lines_set(&self, pixels_above_lines_set: bool);

    #[doc(alias = "pixels-below-lines")]
    fn pixels_below_lines(&self) -> i32;

    #[doc(alias = "pixels-below-lines")]
    fn set_pixels_below_lines(&self, pixels_below_lines: i32);

    #[doc(alias = "pixels-below-lines-set")]
    fn is_pixels_below_lines_set(&self) -> bool;

    #[doc(alias = "pixels-below-lines-set")]
    fn set_pixels_below_lines_set(&self, pixels_below_lines_set: bool);

    #[doc(alias = "pixels-inside-wrap")]
    fn pixels_inside_wrap(&self) -> i32;

    #[doc(alias = "pixels-inside-wrap")]
    fn set_pixels_inside_wrap(&self, pixels_inside_wrap: i32);

    #[doc(alias = "pixels-inside-wrap-set")]
    fn is_pixels_inside_wrap_set(&self) -> bool;

    #[doc(alias = "pixels-inside-wrap-set")]
    fn set_pixels_inside_wrap_set(&self, pixels_inside_wrap_set: bool);

    #[doc(alias = "right-margin")]
    fn right_margin(&self) -> i32;

    #[doc(alias = "right-margin")]
    fn set_right_margin(&self, right_margin: i32);

    #[doc(alias = "right-margin-set")]
    fn is_right_margin_set(&self) -> bool;

    #[doc(alias = "right-margin-set")]
    fn set_right_margin_set(&self, right_margin_set: bool);

    fn rise(&self) -> i32;

    fn set_rise(&self, rise: i32);

    #[doc(alias = "rise-set")]
    fn is_rise_set(&self) -> bool;

    #[doc(alias = "rise-set")]
    fn set_rise_set(&self, rise_set: bool);

    fn scale(&self) -> f64;

    fn set_scale(&self, scale: f64);

    #[doc(alias = "scale-set")]
    fn is_scale_set(&self) -> bool;

    #[doc(alias = "scale-set")]
    fn set_scale_set(&self, scale_set: bool);

    #[doc(alias = "show-spaces")]
    fn show_spaces(&self) -> pango::ShowFlags;

    #[doc(alias = "show-spaces")]
    fn set_show_spaces(&self, show_spaces: pango::ShowFlags);

    #[doc(alias = "show-spaces-set")]
    fn shows_spaces_set(&self) -> bool;

    #[doc(alias = "show-spaces-set")]
    fn set_show_spaces_set(&self, show_spaces_set: bool);

    fn size(&self) -> i32;

    fn set_size(&self, size: i32);

    #[doc(alias = "size-points")]
    fn size_points(&self) -> f64;

    #[doc(alias = "size-points")]
    fn set_size_points(&self, size_points: f64);

    #[doc(alias = "size-set")]
    fn is_size_set(&self) -> bool;

    #[doc(alias = "size-set")]
    fn set_size_set(&self, size_set: bool);

    fn stretch(&self) -> pango::Stretch;

    fn set_stretch(&self, stretch: pango::Stretch);

    #[doc(alias = "stretch-set")]
    fn is_stretch_set(&self) -> bool;

    #[doc(alias = "stretch-set")]
    fn set_stretch_set(&self, stretch_set: bool);

    fn is_strikethrough(&self) -> bool;

    fn set_strikethrough(&self, strikethrough: bool);

    #[doc(alias = "strikethrough-rgba")]
    fn strikethrough_rgba(&self) -> Option<gdk::RGBA>;

    #[doc(alias = "strikethrough-rgba")]
    fn set_strikethrough_rgba(&self, strikethrough_rgba: Option<&gdk::RGBA>);

    #[doc(alias = "strikethrough-rgba-set")]
    fn is_strikethrough_rgba_set(&self) -> bool;

    #[doc(alias = "strikethrough-rgba-set")]
    fn set_strikethrough_rgba_set(&self, strikethrough_rgba_set: bool);

    #[doc(alias = "strikethrough-set")]
    fn is_strikethrough_set(&self) -> bool;

    #[doc(alias = "strikethrough-set")]
    fn set_strikethrough_set(&self, strikethrough_set: bool);

    fn style(&self) -> pango::Style;

    fn set_style(&self, style: pango::Style);

    #[doc(alias = "style-set")]
    fn is_style_set(&self) -> bool;

    #[doc(alias = "style-set")]
    fn set_style_set(&self, style_set: bool);

    fn tabs(&self) -> Option<pango::TabArray>;

    fn set_tabs(&self, tabs: Option<&pango::TabArray>);

    #[doc(alias = "tabs-set")]
    fn is_tabs_set(&self) -> bool;

    #[doc(alias = "tabs-set")]
    fn set_tabs_set(&self, tabs_set: bool);

    fn underline(&self) -> pango::Underline;

    fn set_underline(&self, underline: pango::Underline);

    #[doc(alias = "underline-rgba")]
    fn underline_rgba(&self) -> Option<gdk::RGBA>;

    #[doc(alias = "underline-rgba")]
    fn set_underline_rgba(&self, underline_rgba: Option<&gdk::RGBA>);

    #[doc(alias = "underline-rgba-set")]
    fn is_underline_rgba_set(&self) -> bool;

    #[doc(alias = "underline-rgba-set")]
    fn set_underline_rgba_set(&self, underline_rgba_set: bool);

    #[doc(alias = "underline-set")]
    fn is_underline_set(&self) -> bool;

    #[doc(alias = "underline-set")]
    fn set_underline_set(&self, underline_set: bool);

    fn variant(&self) -> pango::Variant;

    fn set_variant(&self, variant: pango::Variant);

    #[doc(alias = "variant-set")]
    fn is_variant_set(&self) -> bool;

    #[doc(alias = "variant-set")]
    fn set_variant_set(&self, variant_set: bool);

    fn weight(&self) -> i32;

    fn set_weight(&self, weight: i32);

    #[doc(alias = "weight-set")]
    fn is_weight_set(&self) -> bool;

    #[doc(alias = "weight-set")]
    fn set_weight_set(&self, weight_set: bool);

    #[doc(alias = "wrap-mode")]
    fn wrap_mode(&self) -> WrapMode;

    #[doc(alias = "wrap-mode")]
    fn set_wrap_mode(&self, wrap_mode: WrapMode);

    #[doc(alias = "wrap-mode-set")]
    fn wraps_mode_set(&self) -> bool;

    #[doc(alias = "wrap-mode-set")]
    fn set_wrap_mode_set(&self, wrap_mode_set: bool);

    #[doc(alias = "accumulative-margin")]
    fn connect_accumulative_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "allow-breaks")]
    fn connect_allow_breaks_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "allow-breaks-set")]
    fn connect_allow_breaks_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "background")]
    fn connect_background_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "background-full-height")]
    fn connect_background_full_height_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "background-full-height-set")]
    fn connect_background_full_height_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "background-rgba")]
    fn connect_background_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "background-set")]
    fn connect_background_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "direction")]
    fn connect_direction_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "editable")]
    fn connect_editable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "editable-set")]
    fn connect_editable_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "fallback")]
    fn connect_fallback_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "fallback-set")]
    fn connect_fallback_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "family")]
    fn connect_family_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "family-set")]
    fn connect_family_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "font")]
    fn connect_font_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "font-desc")]
    fn connect_font_desc_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "font-features")]
    fn connect_font_features_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "font-features-set")]
    fn connect_font_features_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "foreground")]
    fn connect_foreground_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "foreground-rgba")]
    fn connect_foreground_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "foreground-set")]
    fn connect_foreground_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "indent")]
    fn connect_indent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "indent-set")]
    fn connect_indent_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "insert-hyphens")]
    fn connect_insert_hyphens_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "insert-hyphens-set")]
    fn connect_insert_hyphens_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "invisible")]
    fn connect_invisible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "invisible-set")]
    fn connect_invisible_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "justification")]
    fn connect_justification_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "justification-set")]
    fn connect_justification_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "language")]
    fn connect_language_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "language-set")]
    fn connect_language_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "left-margin")]
    fn connect_left_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "left-margin-set")]
    fn connect_left_margin_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "letter-spacing")]
    fn connect_letter_spacing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "letter-spacing-set")]
    fn connect_letter_spacing_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "overline")]
    fn connect_overline_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "overline-rgba")]
    fn connect_overline_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "overline-rgba-set")]
    fn connect_overline_rgba_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "overline-set")]
    fn connect_overline_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "paragraph-background")]
    fn connect_paragraph_background_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "paragraph-background-rgba")]
    fn connect_paragraph_background_rgba_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "paragraph-background-set")]
    fn connect_paragraph_background_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "pixels-above-lines")]
    fn connect_pixels_above_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "pixels-above-lines-set")]
    fn connect_pixels_above_lines_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "pixels-below-lines")]
    fn connect_pixels_below_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "pixels-below-lines-set")]
    fn connect_pixels_below_lines_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "pixels-inside-wrap")]
    fn connect_pixels_inside_wrap_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "pixels-inside-wrap-set")]
    fn connect_pixels_inside_wrap_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "right-margin")]
    fn connect_right_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "right-margin-set")]
    fn connect_right_margin_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "rise")]
    fn connect_rise_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "rise-set")]
    fn connect_rise_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "scale")]
    fn connect_scale_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "scale-set")]
    fn connect_scale_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "show-spaces")]
    fn connect_show_spaces_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "show-spaces-set")]
    fn connect_show_spaces_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "size")]
    fn connect_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "size-points")]
    fn connect_size_points_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "size-set")]
    fn connect_size_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "stretch")]
    fn connect_stretch_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "stretch-set")]
    fn connect_stretch_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "strikethrough")]
    fn connect_strikethrough_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "strikethrough-rgba")]
    fn connect_strikethrough_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "strikethrough-rgba-set")]
    fn connect_strikethrough_rgba_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "strikethrough-set")]
    fn connect_strikethrough_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "style")]
    fn connect_style_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "style-set")]
    fn connect_style_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "tabs")]
    fn connect_tabs_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "tabs-set")]
    fn connect_tabs_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "underline")]
    fn connect_underline_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "underline-rgba")]
    fn connect_underline_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "underline-rgba-set")]
    fn connect_underline_rgba_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "underline-set")]
    fn connect_underline_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "variant")]
    fn connect_variant_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "variant-set")]
    fn connect_variant_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "weight")]
    fn connect_weight_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "weight-set")]
    fn connect_weight_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "wrap-mode")]
    fn connect_wrap_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "wrap-mode-set")]
    fn connect_wrap_mode_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<TextTag>> TextTagExt for O {
    fn changed(&self, size_changed: bool) {
        unsafe {
            ffi::gtk_text_tag_changed(self.as_ref().to_glib_none().0, size_changed.into_glib());
        }
    }

    fn priority(&self) -> i32 {
        unsafe { ffi::gtk_text_tag_get_priority(self.as_ref().to_glib_none().0) }
    }

    fn set_priority(&self, priority: i32) {
        unsafe {
            ffi::gtk_text_tag_set_priority(self.as_ref().to_glib_none().0, priority);
        }
    }

    fn is_accumulative_margin(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"accumulative-margin\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `accumulative-margin` getter")
        }
    }

    fn set_accumulative_margin(&self, accumulative_margin: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"accumulative-margin\0".as_ptr() as *const _,
                accumulative_margin.to_value().to_glib_none().0,
            );
        }
    }

    fn allows_breaks(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"allow-breaks\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `allow-breaks` getter")
        }
    }

    fn set_allow_breaks(&self, allow_breaks: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"allow-breaks\0".as_ptr() as *const _,
                allow_breaks.to_value().to_glib_none().0,
            );
        }
    }

    fn allows_breaks_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"allow-breaks-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `allow-breaks-set` getter")
        }
    }

    fn set_allow_breaks_set(&self, allow_breaks_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"allow-breaks-set\0".as_ptr() as *const _,
                allow_breaks_set.to_value().to_glib_none().0,
            );
        }
    }

    fn set_background(&self, background: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"background\0".as_ptr() as *const _,
                background.to_value().to_glib_none().0,
            );
        }
    }

    fn is_background_full_height(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"background-full-height\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `background-full-height` getter")
        }
    }

    fn set_background_full_height(&self, background_full_height: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"background-full-height\0".as_ptr() as *const _,
                background_full_height.to_value().to_glib_none().0,
            );
        }
    }

    fn is_background_full_height_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"background-full-height-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `background-full-height-set` getter")
        }
    }

    fn set_background_full_height_set(&self, background_full_height_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"background-full-height-set\0".as_ptr() as *const _,
                background_full_height_set.to_value().to_glib_none().0,
            );
        }
    }

    fn background_rgba(&self) -> Option<gdk::RGBA> {
        unsafe {
            let mut value = glib::Value::from_type(<gdk::RGBA as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"background-rgba\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `background-rgba` getter")
        }
    }

    fn set_background_rgba(&self, background_rgba: Option<&gdk::RGBA>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"background-rgba\0".as_ptr() as *const _,
                background_rgba.to_value().to_glib_none().0,
            );
        }
    }

    fn is_background_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"background-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `background-set` getter")
        }
    }

    fn set_background_set(&self, background_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"background-set\0".as_ptr() as *const _,
                background_set.to_value().to_glib_none().0,
            );
        }
    }

    fn direction(&self) -> TextDirection {
        unsafe {
            let mut value = glib::Value::from_type(<TextDirection as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"direction\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `direction` getter")
        }
    }

    fn set_direction(&self, direction: TextDirection) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"direction\0".as_ptr() as *const _,
                direction.to_value().to_glib_none().0,
            );
        }
    }

    fn is_editable(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"editable\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `editable` getter")
        }
    }

    fn set_editable(&self, editable: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"editable\0".as_ptr() as *const _,
                editable.to_value().to_glib_none().0,
            );
        }
    }

    fn is_editable_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"editable-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `editable-set` getter")
        }
    }

    fn set_editable_set(&self, editable_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"editable-set\0".as_ptr() as *const _,
                editable_set.to_value().to_glib_none().0,
            );
        }
    }

    fn is_fallback(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"fallback\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `fallback` getter")
        }
    }

    fn set_fallback(&self, fallback: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"fallback\0".as_ptr() as *const _,
                fallback.to_value().to_glib_none().0,
            );
        }
    }

    fn is_fallback_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"fallback-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `fallback-set` getter")
        }
    }

    fn set_fallback_set(&self, fallback_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"fallback-set\0".as_ptr() as *const _,
                fallback_set.to_value().to_glib_none().0,
            );
        }
    }

    fn family(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"family\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `family` getter")
        }
    }

    fn set_family(&self, family: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"family\0".as_ptr() as *const _,
                family.to_value().to_glib_none().0,
            );
        }
    }

    fn is_family_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"family-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `family-set` getter")
        }
    }

    fn set_family_set(&self, family_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"family-set\0".as_ptr() as *const _,
                family_set.to_value().to_glib_none().0,
            );
        }
    }

    fn font(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"font\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `font` getter")
        }
    }

    fn set_font(&self, font: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"font\0".as_ptr() as *const _,
                font.to_value().to_glib_none().0,
            );
        }
    }

    fn font_desc(&self) -> Option<pango::FontDescription> {
        unsafe {
            let mut value =
                glib::Value::from_type(<pango::FontDescription as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"font-desc\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `font-desc` getter")
        }
    }

    fn set_font_desc(&self, font_desc: Option<&pango::FontDescription>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"font-desc\0".as_ptr() as *const _,
                font_desc.to_value().to_glib_none().0,
            );
        }
    }

    fn font_features(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"font-features\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `font-features` getter")
        }
    }

    fn set_font_features(&self, font_features: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"font-features\0".as_ptr() as *const _,
                font_features.to_value().to_glib_none().0,
            );
        }
    }

    fn is_font_features_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"font-features-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `font-features-set` getter")
        }
    }

    fn set_font_features_set(&self, font_features_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"font-features-set\0".as_ptr() as *const _,
                font_features_set.to_value().to_glib_none().0,
            );
        }
    }

    fn set_foreground(&self, foreground: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"foreground\0".as_ptr() as *const _,
                foreground.to_value().to_glib_none().0,
            );
        }
    }

    fn foreground_rgba(&self) -> Option<gdk::RGBA> {
        unsafe {
            let mut value = glib::Value::from_type(<gdk::RGBA as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"foreground-rgba\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `foreground-rgba` getter")
        }
    }

    fn set_foreground_rgba(&self, foreground_rgba: Option<&gdk::RGBA>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"foreground-rgba\0".as_ptr() as *const _,
                foreground_rgba.to_value().to_glib_none().0,
            );
        }
    }

    fn is_foreground_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"foreground-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `foreground-set` getter")
        }
    }

    fn set_foreground_set(&self, foreground_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"foreground-set\0".as_ptr() as *const _,
                foreground_set.to_value().to_glib_none().0,
            );
        }
    }

    fn indent(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"indent\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `indent` getter")
        }
    }

    fn set_indent(&self, indent: i32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"indent\0".as_ptr() as *const _,
                indent.to_value().to_glib_none().0,
            );
        }
    }

    fn is_indent_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"indent-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `indent-set` getter")
        }
    }

    fn set_indent_set(&self, indent_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"indent-set\0".as_ptr() as *const _,
                indent_set.to_value().to_glib_none().0,
            );
        }
    }

    fn is_insert_hyphens(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"insert-hyphens\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `insert-hyphens` getter")
        }
    }

    fn set_insert_hyphens(&self, insert_hyphens: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"insert-hyphens\0".as_ptr() as *const _,
                insert_hyphens.to_value().to_glib_none().0,
            );
        }
    }

    fn is_insert_hyphens_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"insert-hyphens-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `insert-hyphens-set` getter")
        }
    }

    fn set_insert_hyphens_set(&self, insert_hyphens_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"insert-hyphens-set\0".as_ptr() as *const _,
                insert_hyphens_set.to_value().to_glib_none().0,
            );
        }
    }

    fn is_invisible(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"invisible\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `invisible` getter")
        }
    }

    fn set_invisible(&self, invisible: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"invisible\0".as_ptr() as *const _,
                invisible.to_value().to_glib_none().0,
            );
        }
    }

    fn is_invisible_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"invisible-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `invisible-set` getter")
        }
    }

    fn set_invisible_set(&self, invisible_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"invisible-set\0".as_ptr() as *const _,
                invisible_set.to_value().to_glib_none().0,
            );
        }
    }

    fn justification(&self) -> Justification {
        unsafe {
            let mut value = glib::Value::from_type(<Justification as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"justification\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `justification` getter")
        }
    }

    fn set_justification(&self, justification: Justification) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"justification\0".as_ptr() as *const _,
                justification.to_value().to_glib_none().0,
            );
        }
    }

    fn is_justification_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"justification-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `justification-set` getter")
        }
    }

    fn set_justification_set(&self, justification_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"justification-set\0".as_ptr() as *const _,
                justification_set.to_value().to_glib_none().0,
            );
        }
    }

    fn language(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"language\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `language` getter")
        }
    }

    fn set_language(&self, language: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"language\0".as_ptr() as *const _,
                language.to_value().to_glib_none().0,
            );
        }
    }

    fn is_language_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"language-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `language-set` getter")
        }
    }

    fn set_language_set(&self, language_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"language-set\0".as_ptr() as *const _,
                language_set.to_value().to_glib_none().0,
            );
        }
    }

    fn left_margin(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"left-margin\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `left-margin` getter")
        }
    }

    fn set_left_margin(&self, left_margin: i32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"left-margin\0".as_ptr() as *const _,
                left_margin.to_value().to_glib_none().0,
            );
        }
    }

    fn is_left_margin_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"left-margin-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `left-margin-set` getter")
        }
    }

    fn set_left_margin_set(&self, left_margin_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"left-margin-set\0".as_ptr() as *const _,
                left_margin_set.to_value().to_glib_none().0,
            );
        }
    }

    fn letter_spacing(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"letter-spacing\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `letter-spacing` getter")
        }
    }

    fn set_letter_spacing(&self, letter_spacing: i32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"letter-spacing\0".as_ptr() as *const _,
                letter_spacing.to_value().to_glib_none().0,
            );
        }
    }

    fn is_letter_spacing_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"letter-spacing-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `letter-spacing-set` getter")
        }
    }

    fn set_letter_spacing_set(&self, letter_spacing_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"letter-spacing-set\0".as_ptr() as *const _,
                letter_spacing_set.to_value().to_glib_none().0,
            );
        }
    }

    fn name(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"name\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `name` getter")
        }
    }

    fn overline(&self) -> pango::Overline {
        unsafe {
            let mut value = glib::Value::from_type(<pango::Overline as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"overline\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `overline` getter")
        }
    }

    fn set_overline(&self, overline: pango::Overline) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"overline\0".as_ptr() as *const _,
                overline.to_value().to_glib_none().0,
            );
        }
    }

    fn overline_rgba(&self) -> Option<gdk::RGBA> {
        unsafe {
            let mut value = glib::Value::from_type(<gdk::RGBA as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"overline-rgba\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `overline-rgba` getter")
        }
    }

    fn set_overline_rgba(&self, overline_rgba: Option<&gdk::RGBA>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"overline-rgba\0".as_ptr() as *const _,
                overline_rgba.to_value().to_glib_none().0,
            );
        }
    }

    fn is_overline_rgba_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"overline-rgba-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `overline-rgba-set` getter")
        }
    }

    fn set_overline_rgba_set(&self, overline_rgba_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"overline-rgba-set\0".as_ptr() as *const _,
                overline_rgba_set.to_value().to_glib_none().0,
            );
        }
    }

    fn is_overline_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"overline-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `overline-set` getter")
        }
    }

    fn set_overline_set(&self, overline_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"overline-set\0".as_ptr() as *const _,
                overline_set.to_value().to_glib_none().0,
            );
        }
    }

    fn set_paragraph_background(&self, paragraph_background: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"paragraph-background\0".as_ptr() as *const _,
                paragraph_background.to_value().to_glib_none().0,
            );
        }
    }

    fn paragraph_background_rgba(&self) -> Option<gdk::RGBA> {
        unsafe {
            let mut value = glib::Value::from_type(<gdk::RGBA as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"paragraph-background-rgba\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `paragraph-background-rgba` getter")
        }
    }

    fn set_paragraph_background_rgba(&self, paragraph_background_rgba: Option<&gdk::RGBA>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"paragraph-background-rgba\0".as_ptr() as *const _,
                paragraph_background_rgba.to_value().to_glib_none().0,
            );
        }
    }

    fn is_paragraph_background_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"paragraph-background-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `paragraph-background-set` getter")
        }
    }

    fn set_paragraph_background_set(&self, paragraph_background_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"paragraph-background-set\0".as_ptr() as *const _,
                paragraph_background_set.to_value().to_glib_none().0,
            );
        }
    }

    fn pixels_above_lines(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"pixels-above-lines\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `pixels-above-lines` getter")
        }
    }

    fn set_pixels_above_lines(&self, pixels_above_lines: i32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"pixels-above-lines\0".as_ptr() as *const _,
                pixels_above_lines.to_value().to_glib_none().0,
            );
        }
    }

    fn is_pixels_above_lines_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"pixels-above-lines-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `pixels-above-lines-set` getter")
        }
    }

    fn set_pixels_above_lines_set(&self, pixels_above_lines_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"pixels-above-lines-set\0".as_ptr() as *const _,
                pixels_above_lines_set.to_value().to_glib_none().0,
            );
        }
    }

    fn pixels_below_lines(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"pixels-below-lines\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `pixels-below-lines` getter")
        }
    }

    fn set_pixels_below_lines(&self, pixels_below_lines: i32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"pixels-below-lines\0".as_ptr() as *const _,
                pixels_below_lines.to_value().to_glib_none().0,
            );
        }
    }

    fn is_pixels_below_lines_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"pixels-below-lines-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `pixels-below-lines-set` getter")
        }
    }

    fn set_pixels_below_lines_set(&self, pixels_below_lines_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"pixels-below-lines-set\0".as_ptr() as *const _,
                pixels_below_lines_set.to_value().to_glib_none().0,
            );
        }
    }

    fn pixels_inside_wrap(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"pixels-inside-wrap\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `pixels-inside-wrap` getter")
        }
    }

    fn set_pixels_inside_wrap(&self, pixels_inside_wrap: i32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"pixels-inside-wrap\0".as_ptr() as *const _,
                pixels_inside_wrap.to_value().to_glib_none().0,
            );
        }
    }

    fn is_pixels_inside_wrap_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"pixels-inside-wrap-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `pixels-inside-wrap-set` getter")
        }
    }

    fn set_pixels_inside_wrap_set(&self, pixels_inside_wrap_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"pixels-inside-wrap-set\0".as_ptr() as *const _,
                pixels_inside_wrap_set.to_value().to_glib_none().0,
            );
        }
    }

    fn right_margin(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"right-margin\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `right-margin` getter")
        }
    }

    fn set_right_margin(&self, right_margin: i32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"right-margin\0".as_ptr() as *const _,
                right_margin.to_value().to_glib_none().0,
            );
        }
    }

    fn is_right_margin_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"right-margin-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `right-margin-set` getter")
        }
    }

    fn set_right_margin_set(&self, right_margin_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"right-margin-set\0".as_ptr() as *const _,
                right_margin_set.to_value().to_glib_none().0,
            );
        }
    }

    fn rise(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"rise\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `rise` getter")
        }
    }

    fn set_rise(&self, rise: i32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"rise\0".as_ptr() as *const _,
                rise.to_value().to_glib_none().0,
            );
        }
    }

    fn is_rise_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"rise-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `rise-set` getter")
        }
    }

    fn set_rise_set(&self, rise_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"rise-set\0".as_ptr() as *const _,
                rise_set.to_value().to_glib_none().0,
            );
        }
    }

    fn scale(&self) -> f64 {
        unsafe {
            let mut value = glib::Value::from_type(<f64 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"scale\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `scale` getter")
        }
    }

    fn set_scale(&self, scale: f64) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"scale\0".as_ptr() as *const _,
                scale.to_value().to_glib_none().0,
            );
        }
    }

    fn is_scale_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"scale-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `scale-set` getter")
        }
    }

    fn set_scale_set(&self, scale_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"scale-set\0".as_ptr() as *const _,
                scale_set.to_value().to_glib_none().0,
            );
        }
    }

    fn show_spaces(&self) -> pango::ShowFlags {
        unsafe {
            let mut value = glib::Value::from_type(<pango::ShowFlags as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"show-spaces\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `show-spaces` getter")
        }
    }

    fn set_show_spaces(&self, show_spaces: pango::ShowFlags) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"show-spaces\0".as_ptr() as *const _,
                show_spaces.to_value().to_glib_none().0,
            );
        }
    }

    fn shows_spaces_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"show-spaces-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `show-spaces-set` getter")
        }
    }

    fn set_show_spaces_set(&self, show_spaces_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"show-spaces-set\0".as_ptr() as *const _,
                show_spaces_set.to_value().to_glib_none().0,
            );
        }
    }

    fn size(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"size\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `size` getter")
        }
    }

    fn set_size(&self, size: i32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"size\0".as_ptr() as *const _,
                size.to_value().to_glib_none().0,
            );
        }
    }

    fn size_points(&self) -> f64 {
        unsafe {
            let mut value = glib::Value::from_type(<f64 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"size-points\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `size-points` getter")
        }
    }

    fn set_size_points(&self, size_points: f64) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"size-points\0".as_ptr() as *const _,
                size_points.to_value().to_glib_none().0,
            );
        }
    }

    fn is_size_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"size-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `size-set` getter")
        }
    }

    fn set_size_set(&self, size_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"size-set\0".as_ptr() as *const _,
                size_set.to_value().to_glib_none().0,
            );
        }
    }

    fn stretch(&self) -> pango::Stretch {
        unsafe {
            let mut value = glib::Value::from_type(<pango::Stretch as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"stretch\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `stretch` getter")
        }
    }

    fn set_stretch(&self, stretch: pango::Stretch) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"stretch\0".as_ptr() as *const _,
                stretch.to_value().to_glib_none().0,
            );
        }
    }

    fn is_stretch_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"stretch-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `stretch-set` getter")
        }
    }

    fn set_stretch_set(&self, stretch_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"stretch-set\0".as_ptr() as *const _,
                stretch_set.to_value().to_glib_none().0,
            );
        }
    }

    fn is_strikethrough(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"strikethrough\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `strikethrough` getter")
        }
    }

    fn set_strikethrough(&self, strikethrough: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"strikethrough\0".as_ptr() as *const _,
                strikethrough.to_value().to_glib_none().0,
            );
        }
    }

    fn strikethrough_rgba(&self) -> Option<gdk::RGBA> {
        unsafe {
            let mut value = glib::Value::from_type(<gdk::RGBA as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"strikethrough-rgba\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `strikethrough-rgba` getter")
        }
    }

    fn set_strikethrough_rgba(&self, strikethrough_rgba: Option<&gdk::RGBA>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"strikethrough-rgba\0".as_ptr() as *const _,
                strikethrough_rgba.to_value().to_glib_none().0,
            );
        }
    }

    fn is_strikethrough_rgba_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"strikethrough-rgba-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `strikethrough-rgba-set` getter")
        }
    }

    fn set_strikethrough_rgba_set(&self, strikethrough_rgba_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"strikethrough-rgba-set\0".as_ptr() as *const _,
                strikethrough_rgba_set.to_value().to_glib_none().0,
            );
        }
    }

    fn is_strikethrough_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"strikethrough-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `strikethrough-set` getter")
        }
    }

    fn set_strikethrough_set(&self, strikethrough_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"strikethrough-set\0".as_ptr() as *const _,
                strikethrough_set.to_value().to_glib_none().0,
            );
        }
    }

    fn style(&self) -> pango::Style {
        unsafe {
            let mut value = glib::Value::from_type(<pango::Style as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"style\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `style` getter")
        }
    }

    fn set_style(&self, style: pango::Style) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"style\0".as_ptr() as *const _,
                style.to_value().to_glib_none().0,
            );
        }
    }

    fn is_style_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"style-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `style-set` getter")
        }
    }

    fn set_style_set(&self, style_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"style-set\0".as_ptr() as *const _,
                style_set.to_value().to_glib_none().0,
            );
        }
    }

    fn tabs(&self) -> Option<pango::TabArray> {
        unsafe {
            let mut value = glib::Value::from_type(<pango::TabArray as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"tabs\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `tabs` getter")
        }
    }

    fn set_tabs(&self, tabs: Option<&pango::TabArray>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"tabs\0".as_ptr() as *const _,
                tabs.to_value().to_glib_none().0,
            );
        }
    }

    fn is_tabs_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"tabs-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `tabs-set` getter")
        }
    }

    fn set_tabs_set(&self, tabs_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"tabs-set\0".as_ptr() as *const _,
                tabs_set.to_value().to_glib_none().0,
            );
        }
    }

    fn underline(&self) -> pango::Underline {
        unsafe {
            let mut value = glib::Value::from_type(<pango::Underline as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"underline\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `underline` getter")
        }
    }

    fn set_underline(&self, underline: pango::Underline) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"underline\0".as_ptr() as *const _,
                underline.to_value().to_glib_none().0,
            );
        }
    }

    fn underline_rgba(&self) -> Option<gdk::RGBA> {
        unsafe {
            let mut value = glib::Value::from_type(<gdk::RGBA as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"underline-rgba\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `underline-rgba` getter")
        }
    }

    fn set_underline_rgba(&self, underline_rgba: Option<&gdk::RGBA>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"underline-rgba\0".as_ptr() as *const _,
                underline_rgba.to_value().to_glib_none().0,
            );
        }
    }

    fn is_underline_rgba_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"underline-rgba-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `underline-rgba-set` getter")
        }
    }

    fn set_underline_rgba_set(&self, underline_rgba_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"underline-rgba-set\0".as_ptr() as *const _,
                underline_rgba_set.to_value().to_glib_none().0,
            );
        }
    }

    fn is_underline_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"underline-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `underline-set` getter")
        }
    }

    fn set_underline_set(&self, underline_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"underline-set\0".as_ptr() as *const _,
                underline_set.to_value().to_glib_none().0,
            );
        }
    }

    fn variant(&self) -> pango::Variant {
        unsafe {
            let mut value = glib::Value::from_type(<pango::Variant as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"variant\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `variant` getter")
        }
    }

    fn set_variant(&self, variant: pango::Variant) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"variant\0".as_ptr() as *const _,
                variant.to_value().to_glib_none().0,
            );
        }
    }

    fn is_variant_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"variant-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `variant-set` getter")
        }
    }

    fn set_variant_set(&self, variant_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"variant-set\0".as_ptr() as *const _,
                variant_set.to_value().to_glib_none().0,
            );
        }
    }

    fn weight(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"weight\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `weight` getter")
        }
    }

    fn set_weight(&self, weight: i32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"weight\0".as_ptr() as *const _,
                weight.to_value().to_glib_none().0,
            );
        }
    }

    fn is_weight_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"weight-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `weight-set` getter")
        }
    }

    fn set_weight_set(&self, weight_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"weight-set\0".as_ptr() as *const _,
                weight_set.to_value().to_glib_none().0,
            );
        }
    }

    fn wrap_mode(&self) -> WrapMode {
        unsafe {
            let mut value = glib::Value::from_type(<WrapMode as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"wrap-mode\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `wrap-mode` getter")
        }
    }

    fn set_wrap_mode(&self, wrap_mode: WrapMode) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"wrap-mode\0".as_ptr() as *const _,
                wrap_mode.to_value().to_glib_none().0,
            );
        }
    }

    fn wraps_mode_set(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"wrap-mode-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `wrap-mode-set` getter")
        }
    }

    fn set_wrap_mode_set(&self, wrap_mode_set: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"wrap-mode-set\0".as_ptr() as *const _,
                wrap_mode_set.to_value().to_glib_none().0,
            );
        }
    }

    fn connect_accumulative_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_accumulative_margin_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::accumulative-margin\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_accumulative_margin_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_allow_breaks_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_allow_breaks_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::allow-breaks\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_allow_breaks_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_allow_breaks_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_allow_breaks_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::allow-breaks-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_allow_breaks_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_background_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_background_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::background\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_background_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_background_full_height_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_background_full_height_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::background-full-height\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_background_full_height_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_background_full_height_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_background_full_height_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::background-full-height-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_background_full_height_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_background_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_background_rgba_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::background-rgba\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_background_rgba_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_background_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_background_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::background-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_background_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_direction_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_direction_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::direction\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_direction_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_editable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_editable_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::editable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_editable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_editable_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_editable_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::editable-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_editable_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_fallback_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_fallback_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::fallback\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_fallback_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_fallback_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_fallback_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::fallback-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_fallback_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_family_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_family_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::family\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_family_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_family_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_family_set_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::family-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_family_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_font_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_font_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::font\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_font_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_font_desc_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_font_desc_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::font-desc\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_font_desc_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_font_features_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_font_features_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::font-features\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_font_features_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_font_features_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_font_features_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::font-features-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_font_features_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_foreground_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_foreground_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::foreground\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_foreground_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_foreground_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_foreground_rgba_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::foreground-rgba\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_foreground_rgba_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_foreground_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_foreground_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::foreground-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_foreground_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_indent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_indent_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::indent\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_indent_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_indent_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_indent_set_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::indent-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_indent_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_insert_hyphens_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_insert_hyphens_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::insert-hyphens\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_insert_hyphens_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_insert_hyphens_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_insert_hyphens_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::insert-hyphens-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_insert_hyphens_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_invisible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_invisible_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::invisible\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_invisible_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_invisible_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_invisible_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::invisible-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_invisible_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_justification_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_justification_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::justification\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_justification_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_justification_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_justification_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::justification-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_justification_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_language_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_language_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::language\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_language_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_language_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_language_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::language-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_language_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_left_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_left_margin_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::left-margin\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_left_margin_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_left_margin_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_left_margin_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::left-margin-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_left_margin_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_letter_spacing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_letter_spacing_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::letter-spacing\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_letter_spacing_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_letter_spacing_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_letter_spacing_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::letter-spacing-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_letter_spacing_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_overline_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_overline_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::overline\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_overline_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_overline_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_overline_rgba_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::overline-rgba\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_overline_rgba_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_overline_rgba_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_overline_rgba_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::overline-rgba-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_overline_rgba_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_overline_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_overline_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::overline-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_overline_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_paragraph_background_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_paragraph_background_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::paragraph-background\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_paragraph_background_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_paragraph_background_rgba_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_paragraph_background_rgba_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::paragraph-background-rgba\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_paragraph_background_rgba_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_paragraph_background_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_paragraph_background_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::paragraph-background-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_paragraph_background_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_pixels_above_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixels_above_lines_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pixels-above-lines\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pixels_above_lines_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_pixels_above_lines_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixels_above_lines_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pixels-above-lines-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pixels_above_lines_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_pixels_below_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixels_below_lines_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pixels-below-lines\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pixels_below_lines_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_pixels_below_lines_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixels_below_lines_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pixels-below-lines-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pixels_below_lines_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_pixels_inside_wrap_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixels_inside_wrap_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pixels-inside-wrap\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pixels_inside_wrap_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_pixels_inside_wrap_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixels_inside_wrap_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pixels-inside-wrap-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pixels_inside_wrap_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_right_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_right_margin_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::right-margin\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_right_margin_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_right_margin_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_right_margin_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::right-margin-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_right_margin_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_rise_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_rise_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::rise\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_rise_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_rise_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_rise_set_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::rise-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_rise_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_scale_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scale_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::scale\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_scale_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_scale_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scale_set_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::scale-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_scale_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_show_spaces_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_show_spaces_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::show-spaces\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_show_spaces_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_show_spaces_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_show_spaces_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::show-spaces-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_show_spaces_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_size_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_size_points_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_size_points_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::size-points\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_size_points_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_size_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_size_set_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::size-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_size_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_stretch_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_stretch_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::stretch\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_stretch_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_stretch_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_stretch_set_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::stretch-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_stretch_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_strikethrough_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_strikethrough_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::strikethrough\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_strikethrough_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_strikethrough_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_strikethrough_rgba_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::strikethrough-rgba\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_strikethrough_rgba_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_strikethrough_rgba_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_strikethrough_rgba_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::strikethrough-rgba-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_strikethrough_rgba_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_strikethrough_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_strikethrough_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::strikethrough-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_strikethrough_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_style_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_style_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::style\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_style_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_style_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_style_set_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::style-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_style_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_tabs_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tabs_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tabs\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tabs_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_tabs_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tabs_set_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tabs-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tabs_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_underline_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_underline_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::underline\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_underline_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_underline_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_underline_rgba_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::underline-rgba\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_underline_rgba_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_underline_rgba_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_underline_rgba_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::underline-rgba-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_underline_rgba_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_underline_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_underline_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::underline-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_underline_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_variant_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_variant_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::variant\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_variant_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_variant_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_variant_set_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::variant-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_variant_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_weight_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_weight_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::weight\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_weight_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_weight_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_weight_set_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::weight-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_weight_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_wrap_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_wrap_mode_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::wrap-mode\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_wrap_mode_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_wrap_mode_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_wrap_mode_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::wrap-mode-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_wrap_mode_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for TextTag {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("TextTag")
    }
}
