// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::Accessible;
use crate::AccessibleRole;
use crate::Adjustment;
use crate::Align;
use crate::Buildable;
use crate::CellArea;
use crate::CellLayout;
use crate::CellRenderer;
use crate::ConstraintTarget;
use crate::IconViewDropPosition;
use crate::LayoutManager;
use crate::MovementStep;
use crate::Orientation;
use crate::Overflow;
use crate::Scrollable;
use crate::ScrollablePolicy;
use crate::SelectionMode;
use crate::Tooltip;
use crate::TreeIter;
use crate::TreeModel;
use crate::TreePath;
use crate::Widget;
use glib::object::Cast;
use glib::object::IsA;
use glib::object::ObjectExt;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem;
use std::mem::transmute;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "GtkIconView")]
    pub struct IconView(Object<ffi::GtkIconView>) @extends Widget, @implements Accessible, Buildable, ConstraintTarget, CellLayout, Scrollable;

    match fn {
        type_ => || ffi::gtk_icon_view_get_type(),
    }
}

impl IconView {
    #[doc(alias = "gtk_icon_view_new")]
    pub fn new() -> IconView {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(ffi::gtk_icon_view_new()).unsafe_cast() }
    }

    #[doc(alias = "gtk_icon_view_new_with_area")]
    #[doc(alias = "new_with_area")]
    pub fn with_area<P: IsA<CellArea>>(area: &P) -> IconView {
        skip_assert_initialized!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_icon_view_new_with_area(
                area.as_ref().to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }

    #[doc(alias = "gtk_icon_view_new_with_model")]
    #[doc(alias = "new_with_model")]
    pub fn with_model<P: IsA<TreeModel>>(model: &P) -> IconView {
        skip_assert_initialized!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_icon_view_new_with_model(
                model.as_ref().to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`IconView`] objects.
    ///
    /// This method returns an instance of [`IconViewBuilder`] which can be used to create [`IconView`] objects.
    pub fn builder() -> IconViewBuilder {
        IconViewBuilder::default()
    }

    #[doc(alias = "gtk_icon_view_create_drag_icon")]
    pub fn create_drag_icon(&self, path: &TreePath) -> Option<gdk::Paintable> {
        unsafe {
            from_glib_full(ffi::gtk_icon_view_create_drag_icon(
                self.to_glib_none().0,
                mut_override(path.to_glib_none().0),
            ))
        }
    }

    #[doc(alias = "gtk_icon_view_enable_model_drag_dest")]
    pub fn enable_model_drag_dest(&self, formats: &gdk::ContentFormats, actions: gdk::DragAction) {
        unsafe {
            ffi::gtk_icon_view_enable_model_drag_dest(
                self.to_glib_none().0,
                formats.to_glib_none().0,
                actions.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_icon_view_enable_model_drag_source")]
    pub fn enable_model_drag_source(
        &self,
        start_button_mask: gdk::ModifierType,
        formats: &gdk::ContentFormats,
        actions: gdk::DragAction,
    ) {
        unsafe {
            ffi::gtk_icon_view_enable_model_drag_source(
                self.to_glib_none().0,
                start_button_mask.into_glib(),
                formats.to_glib_none().0,
                actions.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_icon_view_get_activate_on_single_click")]
    #[doc(alias = "get_activate_on_single_click")]
    pub fn activates_on_single_click(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_icon_view_get_activate_on_single_click(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_icon_view_get_cell_rect")]
    #[doc(alias = "get_cell_rect")]
    pub fn cell_rect<P: IsA<CellRenderer>>(
        &self,
        path: &TreePath,
        cell: Option<&P>,
    ) -> Option<gdk::Rectangle> {
        unsafe {
            let mut rect = gdk::Rectangle::uninitialized();
            let ret = from_glib(ffi::gtk_icon_view_get_cell_rect(
                self.to_glib_none().0,
                mut_override(path.to_glib_none().0),
                cell.map(|p| p.as_ref()).to_glib_none().0,
                rect.to_glib_none_mut().0,
            ));
            if ret {
                Some(rect)
            } else {
                None
            }
        }
    }

    #[doc(alias = "gtk_icon_view_get_column_spacing")]
    #[doc(alias = "get_column_spacing")]
    pub fn column_spacing(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_column_spacing(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_icon_view_get_columns")]
    #[doc(alias = "get_columns")]
    pub fn columns(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_columns(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_icon_view_get_cursor")]
    #[doc(alias = "get_cursor")]
    pub fn cursor(&self) -> Option<(TreePath, CellRenderer)> {
        unsafe {
            let mut path = ptr::null_mut();
            let mut cell = ptr::null_mut();
            let ret = from_glib(ffi::gtk_icon_view_get_cursor(
                self.to_glib_none().0,
                &mut path,
                &mut cell,
            ));
            if ret {
                Some((from_glib_full(path), from_glib_none(cell)))
            } else {
                None
            }
        }
    }

    #[doc(alias = "gtk_icon_view_get_dest_item_at_pos")]
    #[doc(alias = "get_dest_item_at_pos")]
    pub fn dest_item_at_pos(
        &self,
        drag_x: i32,
        drag_y: i32,
    ) -> Option<(TreePath, IconViewDropPosition)> {
        unsafe {
            let mut path = ptr::null_mut();
            let mut pos = mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gtk_icon_view_get_dest_item_at_pos(
                self.to_glib_none().0,
                drag_x,
                drag_y,
                &mut path,
                pos.as_mut_ptr(),
            ));
            let pos = pos.assume_init();
            if ret {
                Some((from_glib_full(path), from_glib(pos)))
            } else {
                None
            }
        }
    }

    #[doc(alias = "gtk_icon_view_get_drag_dest_item")]
    #[doc(alias = "get_drag_dest_item")]
    pub fn drag_dest_item(&self) -> (TreePath, IconViewDropPosition) {
        unsafe {
            let mut path = ptr::null_mut();
            let mut pos = mem::MaybeUninit::uninit();
            ffi::gtk_icon_view_get_drag_dest_item(
                self.to_glib_none().0,
                &mut path,
                pos.as_mut_ptr(),
            );
            let pos = pos.assume_init();
            (from_glib_full(path), from_glib(pos))
        }
    }

    #[doc(alias = "gtk_icon_view_get_item_at_pos")]
    #[doc(alias = "get_item_at_pos")]
    pub fn item_at_pos(&self, x: i32, y: i32) -> Option<(TreePath, CellRenderer)> {
        unsafe {
            let mut path = ptr::null_mut();
            let mut cell = ptr::null_mut();
            let ret = from_glib(ffi::gtk_icon_view_get_item_at_pos(
                self.to_glib_none().0,
                x,
                y,
                &mut path,
                &mut cell,
            ));
            if ret {
                Some((from_glib_full(path), from_glib_none(cell)))
            } else {
                None
            }
        }
    }

    #[doc(alias = "gtk_icon_view_get_item_column")]
    #[doc(alias = "get_item_column")]
    pub fn item_column(&self, path: &TreePath) -> i32 {
        unsafe {
            ffi::gtk_icon_view_get_item_column(
                self.to_glib_none().0,
                mut_override(path.to_glib_none().0),
            )
        }
    }

    #[doc(alias = "gtk_icon_view_get_item_orientation")]
    #[doc(alias = "get_item_orientation")]
    pub fn item_orientation(&self) -> Orientation {
        unsafe {
            from_glib(ffi::gtk_icon_view_get_item_orientation(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_icon_view_get_item_padding")]
    #[doc(alias = "get_item_padding")]
    pub fn item_padding(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_item_padding(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_icon_view_get_item_row")]
    #[doc(alias = "get_item_row")]
    pub fn item_row(&self, path: &TreePath) -> i32 {
        unsafe {
            ffi::gtk_icon_view_get_item_row(
                self.to_glib_none().0,
                mut_override(path.to_glib_none().0),
            )
        }
    }

    #[doc(alias = "gtk_icon_view_get_item_width")]
    #[doc(alias = "get_item_width")]
    pub fn item_width(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_item_width(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_icon_view_get_margin")]
    #[doc(alias = "get_margin")]
    pub fn margin(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_margin(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_icon_view_get_markup_column")]
    #[doc(alias = "get_markup_column")]
    pub fn markup_column(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_markup_column(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_icon_view_get_model")]
    #[doc(alias = "get_model")]
    pub fn model(&self) -> Option<TreeModel> {
        unsafe { from_glib_none(ffi::gtk_icon_view_get_model(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_icon_view_get_path_at_pos")]
    #[doc(alias = "get_path_at_pos")]
    pub fn path_at_pos(&self, x: i32, y: i32) -> Option<TreePath> {
        unsafe {
            from_glib_full(ffi::gtk_icon_view_get_path_at_pos(
                self.to_glib_none().0,
                x,
                y,
            ))
        }
    }

    #[doc(alias = "gtk_icon_view_get_pixbuf_column")]
    #[doc(alias = "get_pixbuf_column")]
    pub fn pixbuf_column(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_pixbuf_column(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_icon_view_get_reorderable")]
    #[doc(alias = "get_reorderable")]
    pub fn is_reorderable(&self) -> bool {
        unsafe { from_glib(ffi::gtk_icon_view_get_reorderable(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_icon_view_get_row_spacing")]
    #[doc(alias = "get_row_spacing")]
    pub fn row_spacing(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_row_spacing(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_icon_view_get_selected_items")]
    #[doc(alias = "get_selected_items")]
    pub fn selected_items(&self) -> Vec<TreePath> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::gtk_icon_view_get_selected_items(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_icon_view_get_selection_mode")]
    #[doc(alias = "get_selection_mode")]
    pub fn selection_mode(&self) -> SelectionMode {
        unsafe { from_glib(ffi::gtk_icon_view_get_selection_mode(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_icon_view_get_spacing")]
    #[doc(alias = "get_spacing")]
    pub fn spacing(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_spacing(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_icon_view_get_text_column")]
    #[doc(alias = "get_text_column")]
    pub fn text_column(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_text_column(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_icon_view_get_tooltip_column")]
    #[doc(alias = "get_tooltip_column")]
    pub fn tooltip_column(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_tooltip_column(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_icon_view_get_tooltip_context")]
    #[doc(alias = "get_tooltip_context")]
    pub fn tooltip_context(
        &self,
        x: i32,
        y: i32,
        keyboard_tip: bool,
    ) -> Option<(TreeModel, TreePath, TreeIter)> {
        unsafe {
            let mut model = ptr::null_mut();
            let mut path = ptr::null_mut();
            let mut iter = TreeIter::uninitialized();
            let ret = from_glib(ffi::gtk_icon_view_get_tooltip_context(
                self.to_glib_none().0,
                x,
                y,
                keyboard_tip.into_glib(),
                &mut model,
                &mut path,
                iter.to_glib_none_mut().0,
            ));
            if ret {
                Some((from_glib_none(model), from_glib_full(path), iter))
            } else {
                None
            }
        }
    }

    #[doc(alias = "gtk_icon_view_get_visible_range")]
    #[doc(alias = "get_visible_range")]
    pub fn visible_range(&self) -> Option<(TreePath, TreePath)> {
        unsafe {
            let mut start_path = ptr::null_mut();
            let mut end_path = ptr::null_mut();
            let ret = from_glib(ffi::gtk_icon_view_get_visible_range(
                self.to_glib_none().0,
                &mut start_path,
                &mut end_path,
            ));
            if ret {
                Some((from_glib_full(start_path), from_glib_full(end_path)))
            } else {
                None
            }
        }
    }

    #[doc(alias = "gtk_icon_view_item_activated")]
    pub fn item_activated(&self, path: &TreePath) {
        unsafe {
            ffi::gtk_icon_view_item_activated(
                self.to_glib_none().0,
                mut_override(path.to_glib_none().0),
            );
        }
    }

    #[doc(alias = "gtk_icon_view_path_is_selected")]
    pub fn path_is_selected(&self, path: &TreePath) -> bool {
        unsafe {
            from_glib(ffi::gtk_icon_view_path_is_selected(
                self.to_glib_none().0,
                mut_override(path.to_glib_none().0),
            ))
        }
    }

    #[doc(alias = "gtk_icon_view_scroll_to_path")]
    pub fn scroll_to_path(&self, path: &TreePath, use_align: bool, row_align: f32, col_align: f32) {
        unsafe {
            ffi::gtk_icon_view_scroll_to_path(
                self.to_glib_none().0,
                mut_override(path.to_glib_none().0),
                use_align.into_glib(),
                row_align,
                col_align,
            );
        }
    }

    #[doc(alias = "gtk_icon_view_select_all")]
    pub fn select_all(&self) {
        unsafe {
            ffi::gtk_icon_view_select_all(self.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_icon_view_select_path")]
    pub fn select_path(&self, path: &TreePath) {
        unsafe {
            ffi::gtk_icon_view_select_path(
                self.to_glib_none().0,
                mut_override(path.to_glib_none().0),
            );
        }
    }

    #[doc(alias = "gtk_icon_view_selected_foreach")]
    pub fn selected_foreach<P: FnMut(&IconView, &TreePath)>(&self, func: P) {
        let func_data: P = func;
        unsafe extern "C" fn func_func<P: FnMut(&IconView, &TreePath)>(
            icon_view: *mut ffi::GtkIconView,
            path: *mut ffi::GtkTreePath,
            data: glib::ffi::gpointer,
        ) {
            let icon_view = from_glib_borrow(icon_view);
            let path = from_glib_borrow(path);
            let callback: *mut P = data as *const _ as usize as *mut P;
            (*callback)(&icon_view, &path);
        }
        let func = Some(func_func::<P> as _);
        let super_callback0: &P = &func_data;
        unsafe {
            ffi::gtk_icon_view_selected_foreach(
                self.to_glib_none().0,
                func,
                super_callback0 as *const _ as usize as *mut _,
            );
        }
    }

    #[doc(alias = "gtk_icon_view_set_activate_on_single_click")]
    pub fn set_activate_on_single_click(&self, single: bool) {
        unsafe {
            ffi::gtk_icon_view_set_activate_on_single_click(
                self.to_glib_none().0,
                single.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_icon_view_set_column_spacing")]
    pub fn set_column_spacing(&self, column_spacing: i32) {
        unsafe {
            ffi::gtk_icon_view_set_column_spacing(self.to_glib_none().0, column_spacing);
        }
    }

    #[doc(alias = "gtk_icon_view_set_columns")]
    pub fn set_columns(&self, columns: i32) {
        unsafe {
            ffi::gtk_icon_view_set_columns(self.to_glib_none().0, columns);
        }
    }

    #[doc(alias = "gtk_icon_view_set_cursor")]
    pub fn set_cursor<P: IsA<CellRenderer>>(
        &self,
        path: &TreePath,
        cell: Option<&P>,
        start_editing: bool,
    ) {
        unsafe {
            ffi::gtk_icon_view_set_cursor(
                self.to_glib_none().0,
                mut_override(path.to_glib_none().0),
                cell.map(|p| p.as_ref()).to_glib_none().0,
                start_editing.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_icon_view_set_drag_dest_item")]
    pub fn set_drag_dest_item(&self, path: Option<&TreePath>, pos: IconViewDropPosition) {
        unsafe {
            ffi::gtk_icon_view_set_drag_dest_item(
                self.to_glib_none().0,
                mut_override(path.to_glib_none().0),
                pos.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_icon_view_set_item_orientation")]
    pub fn set_item_orientation(&self, orientation: Orientation) {
        unsafe {
            ffi::gtk_icon_view_set_item_orientation(self.to_glib_none().0, orientation.into_glib());
        }
    }

    #[doc(alias = "gtk_icon_view_set_item_padding")]
    pub fn set_item_padding(&self, item_padding: i32) {
        unsafe {
            ffi::gtk_icon_view_set_item_padding(self.to_glib_none().0, item_padding);
        }
    }

    #[doc(alias = "gtk_icon_view_set_item_width")]
    pub fn set_item_width(&self, item_width: i32) {
        unsafe {
            ffi::gtk_icon_view_set_item_width(self.to_glib_none().0, item_width);
        }
    }

    #[doc(alias = "gtk_icon_view_set_margin")]
    pub fn set_margin(&self, margin: i32) {
        unsafe {
            ffi::gtk_icon_view_set_margin(self.to_glib_none().0, margin);
        }
    }

    #[doc(alias = "gtk_icon_view_set_markup_column")]
    pub fn set_markup_column(&self, column: i32) {
        unsafe {
            ffi::gtk_icon_view_set_markup_column(self.to_glib_none().0, column);
        }
    }

    #[doc(alias = "gtk_icon_view_set_model")]
    pub fn set_model<P: IsA<TreeModel>>(&self, model: Option<&P>) {
        unsafe {
            ffi::gtk_icon_view_set_model(
                self.to_glib_none().0,
                model.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_icon_view_set_pixbuf_column")]
    pub fn set_pixbuf_column(&self, column: i32) {
        unsafe {
            ffi::gtk_icon_view_set_pixbuf_column(self.to_glib_none().0, column);
        }
    }

    #[doc(alias = "gtk_icon_view_set_reorderable")]
    pub fn set_reorderable(&self, reorderable: bool) {
        unsafe {
            ffi::gtk_icon_view_set_reorderable(self.to_glib_none().0, reorderable.into_glib());
        }
    }

    #[doc(alias = "gtk_icon_view_set_row_spacing")]
    pub fn set_row_spacing(&self, row_spacing: i32) {
        unsafe {
            ffi::gtk_icon_view_set_row_spacing(self.to_glib_none().0, row_spacing);
        }
    }

    #[doc(alias = "gtk_icon_view_set_selection_mode")]
    pub fn set_selection_mode(&self, mode: SelectionMode) {
        unsafe {
            ffi::gtk_icon_view_set_selection_mode(self.to_glib_none().0, mode.into_glib());
        }
    }

    #[doc(alias = "gtk_icon_view_set_spacing")]
    pub fn set_spacing(&self, spacing: i32) {
        unsafe {
            ffi::gtk_icon_view_set_spacing(self.to_glib_none().0, spacing);
        }
    }

    #[doc(alias = "gtk_icon_view_set_text_column")]
    pub fn set_text_column(&self, column: i32) {
        unsafe {
            ffi::gtk_icon_view_set_text_column(self.to_glib_none().0, column);
        }
    }

    #[doc(alias = "gtk_icon_view_set_tooltip_cell")]
    pub fn set_tooltip_cell<P: IsA<CellRenderer>>(
        &self,
        tooltip: &Tooltip,
        path: &TreePath,
        cell: Option<&P>,
    ) {
        unsafe {
            ffi::gtk_icon_view_set_tooltip_cell(
                self.to_glib_none().0,
                tooltip.to_glib_none().0,
                mut_override(path.to_glib_none().0),
                cell.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_icon_view_set_tooltip_column")]
    pub fn set_tooltip_column(&self, column: i32) {
        unsafe {
            ffi::gtk_icon_view_set_tooltip_column(self.to_glib_none().0, column);
        }
    }

    #[doc(alias = "gtk_icon_view_set_tooltip_item")]
    pub fn set_tooltip_item(&self, tooltip: &Tooltip, path: &TreePath) {
        unsafe {
            ffi::gtk_icon_view_set_tooltip_item(
                self.to_glib_none().0,
                tooltip.to_glib_none().0,
                mut_override(path.to_glib_none().0),
            );
        }
    }

    #[doc(alias = "gtk_icon_view_unselect_all")]
    pub fn unselect_all(&self) {
        unsafe {
            ffi::gtk_icon_view_unselect_all(self.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_icon_view_unselect_path")]
    pub fn unselect_path(&self, path: &TreePath) {
        unsafe {
            ffi::gtk_icon_view_unselect_path(
                self.to_glib_none().0,
                mut_override(path.to_glib_none().0),
            );
        }
    }

    #[doc(alias = "gtk_icon_view_unset_model_drag_dest")]
    pub fn unset_model_drag_dest(&self) {
        unsafe {
            ffi::gtk_icon_view_unset_model_drag_dest(self.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_icon_view_unset_model_drag_source")]
    pub fn unset_model_drag_source(&self) {
        unsafe {
            ffi::gtk_icon_view_unset_model_drag_source(self.to_glib_none().0);
        }
    }

    #[doc(alias = "cell-area")]
    pub fn cell_area(&self) -> Option<CellArea> {
        unsafe {
            let mut value = glib::Value::from_type(<CellArea as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.as_ptr() as *mut glib::gobject_ffi::GObject,
                b"cell-area\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `cell-area` getter")
        }
    }

    #[doc(alias = "activate-cursor-item")]
    pub fn connect_activate_cursor_item<F: Fn(&Self) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn activate_cursor_item_trampoline<F: Fn(&IconView) -> bool + 'static>(
            this: *mut ffi::GtkIconView,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this)).into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"activate-cursor-item\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    activate_cursor_item_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    pub fn emit_activate_cursor_item(&self) -> bool {
        let res = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("activate-cursor-item", &[])
                .unwrap()
        };
        res.unwrap()
            .get()
            .expect("Return Value for `emit_activate_cursor_item`")
    }

    #[doc(alias = "item-activated")]
    pub fn connect_item_activated<F: Fn(&Self, &TreePath) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn item_activated_trampoline<F: Fn(&IconView, &TreePath) + 'static>(
            this: *mut ffi::GtkIconView,
            path: *mut ffi::GtkTreePath,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), &from_glib_borrow(path))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"item-activated\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    item_activated_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "move-cursor")]
    pub fn connect_move_cursor<F: Fn(&Self, MovementStep, i32, bool, bool) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn move_cursor_trampoline<
            F: Fn(&IconView, MovementStep, i32, bool, bool) -> bool + 'static,
        >(
            this: *mut ffi::GtkIconView,
            step: ffi::GtkMovementStep,
            count: libc::c_int,
            extend: glib::ffi::gboolean,
            modify: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                &from_glib_borrow(this),
                from_glib(step),
                count,
                from_glib(extend),
                from_glib(modify),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"move-cursor\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    move_cursor_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    pub fn emit_move_cursor(
        &self,
        step: MovementStep,
        count: i32,
        extend: bool,
        modify: bool,
    ) -> bool {
        let res = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("move-cursor", &[&step, &count, &extend, &modify])
                .unwrap()
        };
        res.unwrap()
            .get()
            .expect("Return Value for `emit_move_cursor`")
    }

    #[doc(alias = "select-all")]
    pub fn connect_select_all<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn select_all_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"select-all\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    select_all_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    pub fn emit_select_all(&self) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("select-all", &[])
                .unwrap()
        };
    }

    #[doc(alias = "select-cursor-item")]
    pub fn connect_select_cursor_item<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn select_cursor_item_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"select-cursor-item\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    select_cursor_item_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    pub fn emit_select_cursor_item(&self) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("select-cursor-item", &[])
                .unwrap()
        };
    }

    #[doc(alias = "selection-changed")]
    pub fn connect_selection_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn selection_changed_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"selection-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    selection_changed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "toggle-cursor-item")]
    pub fn connect_toggle_cursor_item<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn toggle_cursor_item_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"toggle-cursor-item\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    toggle_cursor_item_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    pub fn emit_toggle_cursor_item(&self) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("toggle-cursor-item", &[])
                .unwrap()
        };
    }

    #[doc(alias = "unselect-all")]
    pub fn connect_unselect_all<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn unselect_all_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"unselect-all\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    unselect_all_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    pub fn emit_unselect_all(&self) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("unselect-all", &[])
                .unwrap()
        };
    }

    #[doc(alias = "activate-on-single-click")]
    pub fn connect_activate_on_single_click_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_activate_on_single_click_trampoline<
            F: Fn(&IconView) + 'static,
        >(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::activate-on-single-click\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_activate_on_single_click_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "column-spacing")]
    pub fn connect_column_spacing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_column_spacing_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::column-spacing\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_column_spacing_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "columns")]
    pub fn connect_columns_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_columns_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::columns\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_columns_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "item-orientation")]
    pub fn connect_item_orientation_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_item_orientation_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::item-orientation\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_item_orientation_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "item-padding")]
    pub fn connect_item_padding_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_item_padding_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::item-padding\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_item_padding_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "item-width")]
    pub fn connect_item_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_item_width_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::item-width\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_item_width_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "margin")]
    pub fn connect_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_margin_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::margin\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_margin_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "markup-column")]
    pub fn connect_markup_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_markup_column_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::markup-column\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_markup_column_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "model")]
    pub fn connect_model_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_model_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::model\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_model_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "pixbuf-column")]
    pub fn connect_pixbuf_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixbuf_column_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pixbuf-column\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pixbuf_column_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "reorderable")]
    pub fn connect_reorderable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_reorderable_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::reorderable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_reorderable_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "row-spacing")]
    pub fn connect_row_spacing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_row_spacing_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::row-spacing\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_row_spacing_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "selection-mode")]
    pub fn connect_selection_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_selection_mode_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::selection-mode\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_selection_mode_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "spacing")]
    pub fn connect_spacing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_spacing_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::spacing\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_spacing_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "text-column")]
    pub fn connect_text_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_text_column_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::text-column\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_text_column_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "tooltip-column")]
    pub fn connect_tooltip_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tooltip_column_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tooltip-column\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tooltip_column_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for IconView {
    fn default() -> Self {
        Self::new()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`IconView`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
pub struct IconViewBuilder {
    activate_on_single_click: Option<bool>,
    cell_area: Option<CellArea>,
    column_spacing: Option<i32>,
    columns: Option<i32>,
    item_orientation: Option<Orientation>,
    item_padding: Option<i32>,
    item_width: Option<i32>,
    margin: Option<i32>,
    markup_column: Option<i32>,
    model: Option<TreeModel>,
    pixbuf_column: Option<i32>,
    reorderable: Option<bool>,
    row_spacing: Option<i32>,
    selection_mode: Option<SelectionMode>,
    spacing: Option<i32>,
    text_column: Option<i32>,
    tooltip_column: Option<i32>,
    can_focus: Option<bool>,
    can_target: Option<bool>,
    css_classes: Option<Vec<String>>,
    css_name: Option<String>,
    cursor: Option<gdk::Cursor>,
    focus_on_click: Option<bool>,
    focusable: Option<bool>,
    halign: Option<Align>,
    has_tooltip: Option<bool>,
    height_request: Option<i32>,
    hexpand: Option<bool>,
    hexpand_set: Option<bool>,
    layout_manager: Option<LayoutManager>,
    margin_bottom: Option<i32>,
    margin_end: Option<i32>,
    margin_start: Option<i32>,
    margin_top: Option<i32>,
    name: Option<String>,
    opacity: Option<f64>,
    overflow: Option<Overflow>,
    receives_default: Option<bool>,
    sensitive: Option<bool>,
    tooltip_markup: Option<String>,
    tooltip_text: Option<String>,
    valign: Option<Align>,
    vexpand: Option<bool>,
    vexpand_set: Option<bool>,
    visible: Option<bool>,
    width_request: Option<i32>,
    accessible_role: Option<AccessibleRole>,
    hadjustment: Option<Adjustment>,
    hscroll_policy: Option<ScrollablePolicy>,
    vadjustment: Option<Adjustment>,
    vscroll_policy: Option<ScrollablePolicy>,
}

impl IconViewBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`IconViewBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`IconView`].
    pub fn build(self) -> IconView {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref activate_on_single_click) = self.activate_on_single_click {
            properties.push(("activate-on-single-click", activate_on_single_click));
        }
        if let Some(ref cell_area) = self.cell_area {
            properties.push(("cell-area", cell_area));
        }
        if let Some(ref column_spacing) = self.column_spacing {
            properties.push(("column-spacing", column_spacing));
        }
        if let Some(ref columns) = self.columns {
            properties.push(("columns", columns));
        }
        if let Some(ref item_orientation) = self.item_orientation {
            properties.push(("item-orientation", item_orientation));
        }
        if let Some(ref item_padding) = self.item_padding {
            properties.push(("item-padding", item_padding));
        }
        if let Some(ref item_width) = self.item_width {
            properties.push(("item-width", item_width));
        }
        if let Some(ref margin) = self.margin {
            properties.push(("margin", margin));
        }
        if let Some(ref markup_column) = self.markup_column {
            properties.push(("markup-column", markup_column));
        }
        if let Some(ref model) = self.model {
            properties.push(("model", model));
        }
        if let Some(ref pixbuf_column) = self.pixbuf_column {
            properties.push(("pixbuf-column", pixbuf_column));
        }
        if let Some(ref reorderable) = self.reorderable {
            properties.push(("reorderable", reorderable));
        }
        if let Some(ref row_spacing) = self.row_spacing {
            properties.push(("row-spacing", row_spacing));
        }
        if let Some(ref selection_mode) = self.selection_mode {
            properties.push(("selection-mode", selection_mode));
        }
        if let Some(ref spacing) = self.spacing {
            properties.push(("spacing", spacing));
        }
        if let Some(ref text_column) = self.text_column {
            properties.push(("text-column", text_column));
        }
        if let Some(ref tooltip_column) = self.tooltip_column {
            properties.push(("tooltip-column", tooltip_column));
        }
        if let Some(ref can_focus) = self.can_focus {
            properties.push(("can-focus", can_focus));
        }
        if let Some(ref can_target) = self.can_target {
            properties.push(("can-target", can_target));
        }
        if let Some(ref css_classes) = self.css_classes {
            properties.push(("css-classes", css_classes));
        }
        if let Some(ref css_name) = self.css_name {
            properties.push(("css-name", css_name));
        }
        if let Some(ref cursor) = self.cursor {
            properties.push(("cursor", cursor));
        }
        if let Some(ref focus_on_click) = self.focus_on_click {
            properties.push(("focus-on-click", focus_on_click));
        }
        if let Some(ref focusable) = self.focusable {
            properties.push(("focusable", focusable));
        }
        if let Some(ref halign) = self.halign {
            properties.push(("halign", halign));
        }
        if let Some(ref has_tooltip) = self.has_tooltip {
            properties.push(("has-tooltip", has_tooltip));
        }
        if let Some(ref height_request) = self.height_request {
            properties.push(("height-request", height_request));
        }
        if let Some(ref hexpand) = self.hexpand {
            properties.push(("hexpand", hexpand));
        }
        if let Some(ref hexpand_set) = self.hexpand_set {
            properties.push(("hexpand-set", hexpand_set));
        }
        if let Some(ref layout_manager) = self.layout_manager {
            properties.push(("layout-manager", layout_manager));
        }
        if let Some(ref margin_bottom) = self.margin_bottom {
            properties.push(("margin-bottom", margin_bottom));
        }
        if let Some(ref margin_end) = self.margin_end {
            properties.push(("margin-end", margin_end));
        }
        if let Some(ref margin_start) = self.margin_start {
            properties.push(("margin-start", margin_start));
        }
        if let Some(ref margin_top) = self.margin_top {
            properties.push(("margin-top", margin_top));
        }
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        if let Some(ref opacity) = self.opacity {
            properties.push(("opacity", opacity));
        }
        if let Some(ref overflow) = self.overflow {
            properties.push(("overflow", overflow));
        }
        if let Some(ref receives_default) = self.receives_default {
            properties.push(("receives-default", receives_default));
        }
        if let Some(ref sensitive) = self.sensitive {
            properties.push(("sensitive", sensitive));
        }
        if let Some(ref tooltip_markup) = self.tooltip_markup {
            properties.push(("tooltip-markup", tooltip_markup));
        }
        if let Some(ref tooltip_text) = self.tooltip_text {
            properties.push(("tooltip-text", tooltip_text));
        }
        if let Some(ref valign) = self.valign {
            properties.push(("valign", valign));
        }
        if let Some(ref vexpand) = self.vexpand {
            properties.push(("vexpand", vexpand));
        }
        if let Some(ref vexpand_set) = self.vexpand_set {
            properties.push(("vexpand-set", vexpand_set));
        }
        if let Some(ref visible) = self.visible {
            properties.push(("visible", visible));
        }
        if let Some(ref width_request) = self.width_request {
            properties.push(("width-request", width_request));
        }
        if let Some(ref accessible_role) = self.accessible_role {
            properties.push(("accessible-role", accessible_role));
        }
        if let Some(ref hadjustment) = self.hadjustment {
            properties.push(("hadjustment", hadjustment));
        }
        if let Some(ref hscroll_policy) = self.hscroll_policy {
            properties.push(("hscroll-policy", hscroll_policy));
        }
        if let Some(ref vadjustment) = self.vadjustment {
            properties.push(("vadjustment", vadjustment));
        }
        if let Some(ref vscroll_policy) = self.vscroll_policy {
            properties.push(("vscroll-policy", vscroll_policy));
        }
        glib::Object::new::<IconView>(&properties)
            .expect("Failed to create an instance of IconView")
    }

    pub fn activate_on_single_click(mut self, activate_on_single_click: bool) -> Self {
        self.activate_on_single_click = Some(activate_on_single_click);
        self
    }

    pub fn cell_area<P: IsA<CellArea>>(mut self, cell_area: &P) -> Self {
        self.cell_area = Some(cell_area.clone().upcast());
        self
    }

    pub fn column_spacing(mut self, column_spacing: i32) -> Self {
        self.column_spacing = Some(column_spacing);
        self
    }

    pub fn columns(mut self, columns: i32) -> Self {
        self.columns = Some(columns);
        self
    }

    pub fn item_orientation(mut self, item_orientation: Orientation) -> Self {
        self.item_orientation = Some(item_orientation);
        self
    }

    pub fn item_padding(mut self, item_padding: i32) -> Self {
        self.item_padding = Some(item_padding);
        self
    }

    pub fn item_width(mut self, item_width: i32) -> Self {
        self.item_width = Some(item_width);
        self
    }

    pub fn margin(mut self, margin: i32) -> Self {
        self.margin = Some(margin);
        self
    }

    pub fn markup_column(mut self, markup_column: i32) -> Self {
        self.markup_column = Some(markup_column);
        self
    }

    pub fn model<P: IsA<TreeModel>>(mut self, model: &P) -> Self {
        self.model = Some(model.clone().upcast());
        self
    }

    pub fn pixbuf_column(mut self, pixbuf_column: i32) -> Self {
        self.pixbuf_column = Some(pixbuf_column);
        self
    }

    pub fn reorderable(mut self, reorderable: bool) -> Self {
        self.reorderable = Some(reorderable);
        self
    }

    pub fn row_spacing(mut self, row_spacing: i32) -> Self {
        self.row_spacing = Some(row_spacing);
        self
    }

    pub fn selection_mode(mut self, selection_mode: SelectionMode) -> Self {
        self.selection_mode = Some(selection_mode);
        self
    }

    pub fn spacing(mut self, spacing: i32) -> Self {
        self.spacing = Some(spacing);
        self
    }

    pub fn text_column(mut self, text_column: i32) -> Self {
        self.text_column = Some(text_column);
        self
    }

    pub fn tooltip_column(mut self, tooltip_column: i32) -> Self {
        self.tooltip_column = Some(tooltip_column);
        self
    }

    pub fn can_focus(mut self, can_focus: bool) -> Self {
        self.can_focus = Some(can_focus);
        self
    }

    pub fn can_target(mut self, can_target: bool) -> Self {
        self.can_target = Some(can_target);
        self
    }

    pub fn css_classes(mut self, css_classes: Vec<String>) -> Self {
        self.css_classes = Some(css_classes);
        self
    }

    pub fn css_name(mut self, css_name: &str) -> Self {
        self.css_name = Some(css_name.to_string());
        self
    }

    pub fn cursor(mut self, cursor: &gdk::Cursor) -> Self {
        self.cursor = Some(cursor.clone());
        self
    }

    pub fn focus_on_click(mut self, focus_on_click: bool) -> Self {
        self.focus_on_click = Some(focus_on_click);
        self
    }

    pub fn focusable(mut self, focusable: bool) -> Self {
        self.focusable = Some(focusable);
        self
    }

    pub fn halign(mut self, halign: Align) -> Self {
        self.halign = Some(halign);
        self
    }

    pub fn has_tooltip(mut self, has_tooltip: bool) -> Self {
        self.has_tooltip = Some(has_tooltip);
        self
    }

    pub fn height_request(mut self, height_request: i32) -> Self {
        self.height_request = Some(height_request);
        self
    }

    pub fn hexpand(mut self, hexpand: bool) -> Self {
        self.hexpand = Some(hexpand);
        self
    }

    pub fn hexpand_set(mut self, hexpand_set: bool) -> Self {
        self.hexpand_set = Some(hexpand_set);
        self
    }

    pub fn layout_manager<P: IsA<LayoutManager>>(mut self, layout_manager: &P) -> Self {
        self.layout_manager = Some(layout_manager.clone().upcast());
        self
    }

    pub fn margin_bottom(mut self, margin_bottom: i32) -> Self {
        self.margin_bottom = Some(margin_bottom);
        self
    }

    pub fn margin_end(mut self, margin_end: i32) -> Self {
        self.margin_end = Some(margin_end);
        self
    }

    pub fn margin_start(mut self, margin_start: i32) -> Self {
        self.margin_start = Some(margin_start);
        self
    }

    pub fn margin_top(mut self, margin_top: i32) -> Self {
        self.margin_top = Some(margin_top);
        self
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }

    pub fn opacity(mut self, opacity: f64) -> Self {
        self.opacity = Some(opacity);
        self
    }

    pub fn overflow(mut self, overflow: Overflow) -> Self {
        self.overflow = Some(overflow);
        self
    }

    pub fn receives_default(mut self, receives_default: bool) -> Self {
        self.receives_default = Some(receives_default);
        self
    }

    pub fn sensitive(mut self, sensitive: bool) -> Self {
        self.sensitive = Some(sensitive);
        self
    }

    pub fn tooltip_markup(mut self, tooltip_markup: &str) -> Self {
        self.tooltip_markup = Some(tooltip_markup.to_string());
        self
    }

    pub fn tooltip_text(mut self, tooltip_text: &str) -> Self {
        self.tooltip_text = Some(tooltip_text.to_string());
        self
    }

    pub fn valign(mut self, valign: Align) -> Self {
        self.valign = Some(valign);
        self
    }

    pub fn vexpand(mut self, vexpand: bool) -> Self {
        self.vexpand = Some(vexpand);
        self
    }

    pub fn vexpand_set(mut self, vexpand_set: bool) -> Self {
        self.vexpand_set = Some(vexpand_set);
        self
    }

    pub fn visible(mut self, visible: bool) -> Self {
        self.visible = Some(visible);
        self
    }

    pub fn width_request(mut self, width_request: i32) -> Self {
        self.width_request = Some(width_request);
        self
    }

    pub fn accessible_role(mut self, accessible_role: AccessibleRole) -> Self {
        self.accessible_role = Some(accessible_role);
        self
    }

    pub fn hadjustment<P: IsA<Adjustment>>(mut self, hadjustment: &P) -> Self {
        self.hadjustment = Some(hadjustment.clone().upcast());
        self
    }

    pub fn hscroll_policy(mut self, hscroll_policy: ScrollablePolicy) -> Self {
        self.hscroll_policy = Some(hscroll_policy);
        self
    }

    pub fn vadjustment<P: IsA<Adjustment>>(mut self, vadjustment: &P) -> Self {
        self.vadjustment = Some(vadjustment.clone().upcast());
        self
    }

    pub fn vscroll_policy(mut self, vscroll_policy: ScrollablePolicy) -> Self {
        self.vscroll_policy = Some(vscroll_policy);
        self
    }
}

impl fmt::Display for IconView {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("IconView")
    }
}
