// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::CellRenderer;
use crate::CellRendererMode;
use crate::TreePath;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "GtkCellRendererText")]
    pub struct CellRendererText(Object<ffi::GtkCellRendererText, ffi::GtkCellRendererTextClass>) @extends CellRenderer;

    match fn {
        type_ => || ffi::gtk_cell_renderer_text_get_type(),
    }
}

impl CellRendererText {
    pub const NONE: Option<&'static CellRendererText> = None;

    #[doc(alias = "gtk_cell_renderer_text_new")]
    pub fn new() -> CellRendererText {
        assert_initialized_main_thread!();
        unsafe { CellRenderer::from_glib_none(ffi::gtk_cell_renderer_text_new()).unsafe_cast() }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`CellRendererText`] objects.
    ///
    /// This method returns an instance of [`CellRendererTextBuilder`](crate::builders::CellRendererTextBuilder) which can be used to create [`CellRendererText`] objects.
    pub fn builder() -> CellRendererTextBuilder {
        CellRendererTextBuilder::default()
    }
}

impl Default for CellRendererText {
    fn default() -> Self {
        Self::new()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`CellRendererText`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct CellRendererTextBuilder {
    align_set: Option<bool>,
    alignment: Option<pango::Alignment>,
    attributes: Option<pango::AttrList>,
    background: Option<String>,
    background_rgba: Option<gdk::RGBA>,
    background_set: Option<bool>,
    editable: Option<bool>,
    editable_set: Option<bool>,
    ellipsize: Option<pango::EllipsizeMode>,
    ellipsize_set: Option<bool>,
    family: Option<String>,
    family_set: Option<bool>,
    font: Option<String>,
    font_desc: Option<pango::FontDescription>,
    foreground: Option<String>,
    foreground_rgba: Option<gdk::RGBA>,
    foreground_set: Option<bool>,
    language: Option<String>,
    language_set: Option<bool>,
    markup: Option<String>,
    max_width_chars: Option<i32>,
    placeholder_text: Option<String>,
    rise: Option<i32>,
    rise_set: Option<bool>,
    scale: Option<f64>,
    scale_set: Option<bool>,
    single_paragraph_mode: Option<bool>,
    size: Option<i32>,
    size_points: Option<f64>,
    size_set: Option<bool>,
    stretch: Option<pango::Stretch>,
    stretch_set: Option<bool>,
    strikethrough: Option<bool>,
    strikethrough_set: Option<bool>,
    style: Option<pango::Style>,
    style_set: Option<bool>,
    text: Option<String>,
    underline: Option<pango::Underline>,
    underline_set: Option<bool>,
    variant: Option<pango::Variant>,
    variant_set: Option<bool>,
    weight: Option<i32>,
    weight_set: Option<bool>,
    width_chars: Option<i32>,
    wrap_mode: Option<pango::WrapMode>,
    wrap_width: Option<i32>,
    cell_background: Option<String>,
    cell_background_rgba: Option<gdk::RGBA>,
    cell_background_set: Option<bool>,
    height: Option<i32>,
    is_expanded: Option<bool>,
    is_expander: Option<bool>,
    mode: Option<CellRendererMode>,
    sensitive: Option<bool>,
    visible: Option<bool>,
    width: Option<i32>,
    xalign: Option<f32>,
    xpad: Option<u32>,
    yalign: Option<f32>,
    ypad: Option<u32>,
}

impl CellRendererTextBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`CellRendererTextBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`CellRendererText`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> CellRendererText {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref align_set) = self.align_set {
            properties.push(("align-set", align_set));
        }
        if let Some(ref alignment) = self.alignment {
            properties.push(("alignment", alignment));
        }
        if let Some(ref attributes) = self.attributes {
            properties.push(("attributes", attributes));
        }
        if let Some(ref background) = self.background {
            properties.push(("background", background));
        }
        if let Some(ref background_rgba) = self.background_rgba {
            properties.push(("background-rgba", background_rgba));
        }
        if let Some(ref background_set) = self.background_set {
            properties.push(("background-set", background_set));
        }
        if let Some(ref editable) = self.editable {
            properties.push(("editable", editable));
        }
        if let Some(ref editable_set) = self.editable_set {
            properties.push(("editable-set", editable_set));
        }
        if let Some(ref ellipsize) = self.ellipsize {
            properties.push(("ellipsize", ellipsize));
        }
        if let Some(ref ellipsize_set) = self.ellipsize_set {
            properties.push(("ellipsize-set", ellipsize_set));
        }
        if let Some(ref family) = self.family {
            properties.push(("family", family));
        }
        if let Some(ref family_set) = self.family_set {
            properties.push(("family-set", family_set));
        }
        if let Some(ref font) = self.font {
            properties.push(("font", font));
        }
        if let Some(ref font_desc) = self.font_desc {
            properties.push(("font-desc", font_desc));
        }
        if let Some(ref foreground) = self.foreground {
            properties.push(("foreground", foreground));
        }
        if let Some(ref foreground_rgba) = self.foreground_rgba {
            properties.push(("foreground-rgba", foreground_rgba));
        }
        if let Some(ref foreground_set) = self.foreground_set {
            properties.push(("foreground-set", foreground_set));
        }
        if let Some(ref language) = self.language {
            properties.push(("language", language));
        }
        if let Some(ref language_set) = self.language_set {
            properties.push(("language-set", language_set));
        }
        if let Some(ref markup) = self.markup {
            properties.push(("markup", markup));
        }
        if let Some(ref max_width_chars) = self.max_width_chars {
            properties.push(("max-width-chars", max_width_chars));
        }
        if let Some(ref placeholder_text) = self.placeholder_text {
            properties.push(("placeholder-text", placeholder_text));
        }
        if let Some(ref rise) = self.rise {
            properties.push(("rise", rise));
        }
        if let Some(ref rise_set) = self.rise_set {
            properties.push(("rise-set", rise_set));
        }
        if let Some(ref scale) = self.scale {
            properties.push(("scale", scale));
        }
        if let Some(ref scale_set) = self.scale_set {
            properties.push(("scale-set", scale_set));
        }
        if let Some(ref single_paragraph_mode) = self.single_paragraph_mode {
            properties.push(("single-paragraph-mode", single_paragraph_mode));
        }
        if let Some(ref size) = self.size {
            properties.push(("size", size));
        }
        if let Some(ref size_points) = self.size_points {
            properties.push(("size-points", size_points));
        }
        if let Some(ref size_set) = self.size_set {
            properties.push(("size-set", size_set));
        }
        if let Some(ref stretch) = self.stretch {
            properties.push(("stretch", stretch));
        }
        if let Some(ref stretch_set) = self.stretch_set {
            properties.push(("stretch-set", stretch_set));
        }
        if let Some(ref strikethrough) = self.strikethrough {
            properties.push(("strikethrough", strikethrough));
        }
        if let Some(ref strikethrough_set) = self.strikethrough_set {
            properties.push(("strikethrough-set", strikethrough_set));
        }
        if let Some(ref style) = self.style {
            properties.push(("style", style));
        }
        if let Some(ref style_set) = self.style_set {
            properties.push(("style-set", style_set));
        }
        if let Some(ref text) = self.text {
            properties.push(("text", text));
        }
        if let Some(ref underline) = self.underline {
            properties.push(("underline", underline));
        }
        if let Some(ref underline_set) = self.underline_set {
            properties.push(("underline-set", underline_set));
        }
        if let Some(ref variant) = self.variant {
            properties.push(("variant", variant));
        }
        if let Some(ref variant_set) = self.variant_set {
            properties.push(("variant-set", variant_set));
        }
        if let Some(ref weight) = self.weight {
            properties.push(("weight", weight));
        }
        if let Some(ref weight_set) = self.weight_set {
            properties.push(("weight-set", weight_set));
        }
        if let Some(ref width_chars) = self.width_chars {
            properties.push(("width-chars", width_chars));
        }
        if let Some(ref wrap_mode) = self.wrap_mode {
            properties.push(("wrap-mode", wrap_mode));
        }
        if let Some(ref wrap_width) = self.wrap_width {
            properties.push(("wrap-width", wrap_width));
        }
        if let Some(ref cell_background) = self.cell_background {
            properties.push(("cell-background", cell_background));
        }
        if let Some(ref cell_background_rgba) = self.cell_background_rgba {
            properties.push(("cell-background-rgba", cell_background_rgba));
        }
        if let Some(ref cell_background_set) = self.cell_background_set {
            properties.push(("cell-background-set", cell_background_set));
        }
        if let Some(ref height) = self.height {
            properties.push(("height", height));
        }
        if let Some(ref is_expanded) = self.is_expanded {
            properties.push(("is-expanded", is_expanded));
        }
        if let Some(ref is_expander) = self.is_expander {
            properties.push(("is-expander", is_expander));
        }
        if let Some(ref mode) = self.mode {
            properties.push(("mode", mode));
        }
        if let Some(ref sensitive) = self.sensitive {
            properties.push(("sensitive", sensitive));
        }
        if let Some(ref visible) = self.visible {
            properties.push(("visible", visible));
        }
        if let Some(ref width) = self.width {
            properties.push(("width", width));
        }
        if let Some(ref xalign) = self.xalign {
            properties.push(("xalign", xalign));
        }
        if let Some(ref xpad) = self.xpad {
            properties.push(("xpad", xpad));
        }
        if let Some(ref yalign) = self.yalign {
            properties.push(("yalign", yalign));
        }
        if let Some(ref ypad) = self.ypad {
            properties.push(("ypad", ypad));
        }
        glib::Object::new::<CellRendererText>(&properties)
            .expect("Failed to create an instance of CellRendererText")
    }

    pub fn align_set(mut self, align_set: bool) -> Self {
        self.align_set = Some(align_set);
        self
    }

    pub fn alignment(mut self, alignment: pango::Alignment) -> Self {
        self.alignment = Some(alignment);
        self
    }

    pub fn attributes(mut self, attributes: &pango::AttrList) -> Self {
        self.attributes = Some(attributes.clone());
        self
    }

    pub fn background(mut self, background: &str) -> Self {
        self.background = Some(background.to_string());
        self
    }

    pub fn background_rgba(mut self, background_rgba: &gdk::RGBA) -> Self {
        self.background_rgba = Some(background_rgba.clone());
        self
    }

    pub fn background_set(mut self, background_set: bool) -> Self {
        self.background_set = Some(background_set);
        self
    }

    pub fn editable(mut self, editable: bool) -> Self {
        self.editable = Some(editable);
        self
    }

    pub fn editable_set(mut self, editable_set: bool) -> Self {
        self.editable_set = Some(editable_set);
        self
    }

    pub fn ellipsize(mut self, ellipsize: pango::EllipsizeMode) -> Self {
        self.ellipsize = Some(ellipsize);
        self
    }

    pub fn ellipsize_set(mut self, ellipsize_set: bool) -> Self {
        self.ellipsize_set = Some(ellipsize_set);
        self
    }

    pub fn family(mut self, family: &str) -> Self {
        self.family = Some(family.to_string());
        self
    }

    pub fn family_set(mut self, family_set: bool) -> Self {
        self.family_set = Some(family_set);
        self
    }

    pub fn font(mut self, font: &str) -> Self {
        self.font = Some(font.to_string());
        self
    }

    pub fn font_desc(mut self, font_desc: &pango::FontDescription) -> Self {
        self.font_desc = Some(font_desc.clone());
        self
    }

    pub fn foreground(mut self, foreground: &str) -> Self {
        self.foreground = Some(foreground.to_string());
        self
    }

    pub fn foreground_rgba(mut self, foreground_rgba: &gdk::RGBA) -> Self {
        self.foreground_rgba = Some(foreground_rgba.clone());
        self
    }

    pub fn foreground_set(mut self, foreground_set: bool) -> Self {
        self.foreground_set = Some(foreground_set);
        self
    }

    pub fn language(mut self, language: &str) -> Self {
        self.language = Some(language.to_string());
        self
    }

    pub fn language_set(mut self, language_set: bool) -> Self {
        self.language_set = Some(language_set);
        self
    }

    pub fn markup(mut self, markup: &str) -> Self {
        self.markup = Some(markup.to_string());
        self
    }

    pub fn max_width_chars(mut self, max_width_chars: i32) -> Self {
        self.max_width_chars = Some(max_width_chars);
        self
    }

    pub fn placeholder_text(mut self, placeholder_text: &str) -> Self {
        self.placeholder_text = Some(placeholder_text.to_string());
        self
    }

    pub fn rise(mut self, rise: i32) -> Self {
        self.rise = Some(rise);
        self
    }

    pub fn rise_set(mut self, rise_set: bool) -> Self {
        self.rise_set = Some(rise_set);
        self
    }

    pub fn scale(mut self, scale: f64) -> Self {
        self.scale = Some(scale);
        self
    }

    pub fn scale_set(mut self, scale_set: bool) -> Self {
        self.scale_set = Some(scale_set);
        self
    }

    pub fn single_paragraph_mode(mut self, single_paragraph_mode: bool) -> Self {
        self.single_paragraph_mode = Some(single_paragraph_mode);
        self
    }

    pub fn size(mut self, size: i32) -> Self {
        self.size = Some(size);
        self
    }

    pub fn size_points(mut self, size_points: f64) -> Self {
        self.size_points = Some(size_points);
        self
    }

    pub fn size_set(mut self, size_set: bool) -> Self {
        self.size_set = Some(size_set);
        self
    }

    pub fn stretch(mut self, stretch: pango::Stretch) -> Self {
        self.stretch = Some(stretch);
        self
    }

    pub fn stretch_set(mut self, stretch_set: bool) -> Self {
        self.stretch_set = Some(stretch_set);
        self
    }

    pub fn strikethrough(mut self, strikethrough: bool) -> Self {
        self.strikethrough = Some(strikethrough);
        self
    }

    pub fn strikethrough_set(mut self, strikethrough_set: bool) -> Self {
        self.strikethrough_set = Some(strikethrough_set);
        self
    }

    pub fn style(mut self, style: pango::Style) -> Self {
        self.style = Some(style);
        self
    }

    pub fn style_set(mut self, style_set: bool) -> Self {
        self.style_set = Some(style_set);
        self
    }

    pub fn text(mut self, text: &str) -> Self {
        self.text = Some(text.to_string());
        self
    }

    pub fn underline(mut self, underline: pango::Underline) -> Self {
        self.underline = Some(underline);
        self
    }

    pub fn underline_set(mut self, underline_set: bool) -> Self {
        self.underline_set = Some(underline_set);
        self
    }

    pub fn variant(mut self, variant: pango::Variant) -> Self {
        self.variant = Some(variant);
        self
    }

    pub fn variant_set(mut self, variant_set: bool) -> Self {
        self.variant_set = Some(variant_set);
        self
    }

    pub fn weight(mut self, weight: i32) -> Self {
        self.weight = Some(weight);
        self
    }

    pub fn weight_set(mut self, weight_set: bool) -> Self {
        self.weight_set = Some(weight_set);
        self
    }

    pub fn width_chars(mut self, width_chars: i32) -> Self {
        self.width_chars = Some(width_chars);
        self
    }

    pub fn wrap_mode(mut self, wrap_mode: pango::WrapMode) -> Self {
        self.wrap_mode = Some(wrap_mode);
        self
    }

    pub fn wrap_width(mut self, wrap_width: i32) -> Self {
        self.wrap_width = Some(wrap_width);
        self
    }

    pub fn cell_background(mut self, cell_background: &str) -> Self {
        self.cell_background = Some(cell_background.to_string());
        self
    }

    pub fn cell_background_rgba(mut self, cell_background_rgba: &gdk::RGBA) -> Self {
        self.cell_background_rgba = Some(cell_background_rgba.clone());
        self
    }

    pub fn cell_background_set(mut self, cell_background_set: bool) -> Self {
        self.cell_background_set = Some(cell_background_set);
        self
    }

    pub fn height(mut self, height: i32) -> Self {
        self.height = Some(height);
        self
    }

    pub fn is_expanded(mut self, is_expanded: bool) -> Self {
        self.is_expanded = Some(is_expanded);
        self
    }

    pub fn is_expander(mut self, is_expander: bool) -> Self {
        self.is_expander = Some(is_expander);
        self
    }

    pub fn mode(mut self, mode: CellRendererMode) -> Self {
        self.mode = Some(mode);
        self
    }

    pub fn sensitive(mut self, sensitive: bool) -> Self {
        self.sensitive = Some(sensitive);
        self
    }

    pub fn visible(mut self, visible: bool) -> Self {
        self.visible = Some(visible);
        self
    }

    pub fn width(mut self, width: i32) -> Self {
        self.width = Some(width);
        self
    }

    pub fn xalign(mut self, xalign: f32) -> Self {
        self.xalign = Some(xalign);
        self
    }

    pub fn xpad(mut self, xpad: u32) -> Self {
        self.xpad = Some(xpad);
        self
    }

    pub fn yalign(mut self, yalign: f32) -> Self {
        self.yalign = Some(yalign);
        self
    }

    pub fn ypad(mut self, ypad: u32) -> Self {
        self.ypad = Some(ypad);
        self
    }
}

pub trait CellRendererTextExt: 'static {
    #[doc(alias = "gtk_cell_renderer_text_set_fixed_height_from_font")]
    fn set_fixed_height_from_font(&self, number_of_rows: i32);

    #[doc(alias = "align-set")]
    fn is_align_set(&self) -> bool;

    #[doc(alias = "align-set")]
    fn set_align_set(&self, align_set: bool);

    fn alignment(&self) -> pango::Alignment;

    fn set_alignment(&self, alignment: pango::Alignment);

    fn attributes(&self) -> Option<pango::AttrList>;

    fn set_attributes(&self, attributes: Option<&pango::AttrList>);

    fn set_background(&self, background: Option<&str>);

    #[doc(alias = "background-rgba")]
    fn background_rgba(&self) -> Option<gdk::RGBA>;

    #[doc(alias = "background-rgba")]
    fn set_background_rgba(&self, background_rgba: Option<&gdk::RGBA>);

    #[doc(alias = "background-set")]
    fn is_background_set(&self) -> bool;

    #[doc(alias = "background-set")]
    fn set_background_set(&self, background_set: bool);

    fn is_editable(&self) -> bool;

    fn set_editable(&self, editable: bool);

    #[doc(alias = "editable-set")]
    fn is_editable_set(&self) -> bool;

    #[doc(alias = "editable-set")]
    fn set_editable_set(&self, editable_set: bool);

    fn ellipsize(&self) -> pango::EllipsizeMode;

    fn set_ellipsize(&self, ellipsize: pango::EllipsizeMode);

    #[doc(alias = "ellipsize-set")]
    fn is_ellipsize_set(&self) -> bool;

    #[doc(alias = "ellipsize-set")]
    fn set_ellipsize_set(&self, ellipsize_set: bool);

    fn family(&self) -> Option<glib::GString>;

    fn set_family(&self, family: Option<&str>);

    #[doc(alias = "family-set")]
    fn is_family_set(&self) -> bool;

    #[doc(alias = "family-set")]
    fn set_family_set(&self, family_set: bool);

    fn font(&self) -> Option<glib::GString>;

    fn set_font(&self, font: Option<&str>);

    #[doc(alias = "font-desc")]
    fn font_desc(&self) -> Option<pango::FontDescription>;

    #[doc(alias = "font-desc")]
    fn set_font_desc(&self, font_desc: Option<&pango::FontDescription>);

    fn set_foreground(&self, foreground: Option<&str>);

    #[doc(alias = "foreground-rgba")]
    fn foreground_rgba(&self) -> Option<gdk::RGBA>;

    #[doc(alias = "foreground-rgba")]
    fn set_foreground_rgba(&self, foreground_rgba: Option<&gdk::RGBA>);

    #[doc(alias = "foreground-set")]
    fn is_foreground_set(&self) -> bool;

    #[doc(alias = "foreground-set")]
    fn set_foreground_set(&self, foreground_set: bool);

    fn language(&self) -> Option<glib::GString>;

    fn set_language(&self, language: Option<&str>);

    #[doc(alias = "language-set")]
    fn is_language_set(&self) -> bool;

    #[doc(alias = "language-set")]
    fn set_language_set(&self, language_set: bool);

    fn set_markup(&self, markup: Option<&str>);

    #[doc(alias = "max-width-chars")]
    fn max_width_chars(&self) -> i32;

    #[doc(alias = "max-width-chars")]
    fn set_max_width_chars(&self, max_width_chars: i32);

    #[doc(alias = "placeholder-text")]
    fn placeholder_text(&self) -> Option<glib::GString>;

    #[doc(alias = "placeholder-text")]
    fn set_placeholder_text(&self, placeholder_text: Option<&str>);

    fn rise(&self) -> i32;

    fn set_rise(&self, rise: i32);

    #[doc(alias = "rise-set")]
    fn is_rise_set(&self) -> bool;

    #[doc(alias = "rise-set")]
    fn set_rise_set(&self, rise_set: bool);

    fn scale(&self) -> f64;

    fn set_scale(&self, scale: f64);

    #[doc(alias = "scale-set")]
    fn is_scale_set(&self) -> bool;

    #[doc(alias = "scale-set")]
    fn set_scale_set(&self, scale_set: bool);

    #[doc(alias = "single-paragraph-mode")]
    fn is_single_paragraph_mode(&self) -> bool;

    #[doc(alias = "single-paragraph-mode")]
    fn set_single_paragraph_mode(&self, single_paragraph_mode: bool);

    fn size(&self) -> i32;

    fn set_size(&self, size: i32);

    #[doc(alias = "size-points")]
    fn size_points(&self) -> f64;

    #[doc(alias = "size-points")]
    fn set_size_points(&self, size_points: f64);

    #[doc(alias = "size-set")]
    fn is_size_set(&self) -> bool;

    #[doc(alias = "size-set")]
    fn set_size_set(&self, size_set: bool);

    fn stretch(&self) -> pango::Stretch;

    fn set_stretch(&self, stretch: pango::Stretch);

    #[doc(alias = "stretch-set")]
    fn is_stretch_set(&self) -> bool;

    #[doc(alias = "stretch-set")]
    fn set_stretch_set(&self, stretch_set: bool);

    fn is_strikethrough(&self) -> bool;

    fn set_strikethrough(&self, strikethrough: bool);

    #[doc(alias = "strikethrough-set")]
    fn is_strikethrough_set(&self) -> bool;

    #[doc(alias = "strikethrough-set")]
    fn set_strikethrough_set(&self, strikethrough_set: bool);

    fn style(&self) -> pango::Style;

    fn set_style(&self, style: pango::Style);

    #[doc(alias = "style-set")]
    fn is_style_set(&self) -> bool;

    #[doc(alias = "style-set")]
    fn set_style_set(&self, style_set: bool);

    fn text(&self) -> Option<glib::GString>;

    fn set_text(&self, text: Option<&str>);

    fn underline(&self) -> pango::Underline;

    fn set_underline(&self, underline: pango::Underline);

    #[doc(alias = "underline-set")]
    fn is_underline_set(&self) -> bool;

    #[doc(alias = "underline-set")]
    fn set_underline_set(&self, underline_set: bool);

    fn variant(&self) -> pango::Variant;

    fn set_variant(&self, variant: pango::Variant);

    #[doc(alias = "variant-set")]
    fn is_variant_set(&self) -> bool;

    #[doc(alias = "variant-set")]
    fn set_variant_set(&self, variant_set: bool);

    fn weight(&self) -> i32;

    fn set_weight(&self, weight: i32);

    #[doc(alias = "weight-set")]
    fn is_weight_set(&self) -> bool;

    #[doc(alias = "weight-set")]
    fn set_weight_set(&self, weight_set: bool);

    #[doc(alias = "width-chars")]
    fn width_chars(&self) -> i32;

    #[doc(alias = "width-chars")]
    fn set_width_chars(&self, width_chars: i32);

    #[doc(alias = "wrap-mode")]
    fn wrap_mode(&self) -> pango::WrapMode;

    #[doc(alias = "wrap-mode")]
    fn set_wrap_mode(&self, wrap_mode: pango::WrapMode);

    #[doc(alias = "wrap-width")]
    fn wrap_width(&self) -> i32;

    #[doc(alias = "wrap-width")]
    fn set_wrap_width(&self, wrap_width: i32);

    #[doc(alias = "edited")]
    fn connect_edited<F: Fn(&Self, TreePath, &str) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "align-set")]
    fn connect_align_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "alignment")]
    fn connect_alignment_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "attributes")]
    fn connect_attributes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "background")]
    fn connect_background_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "background-rgba")]
    fn connect_background_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "background-set")]
    fn connect_background_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "editable")]
    fn connect_editable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "editable-set")]
    fn connect_editable_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "ellipsize")]
    fn connect_ellipsize_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "ellipsize-set")]
    fn connect_ellipsize_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "family")]
    fn connect_family_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "family-set")]
    fn connect_family_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "font")]
    fn connect_font_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "font-desc")]
    fn connect_font_desc_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "foreground")]
    fn connect_foreground_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "foreground-rgba")]
    fn connect_foreground_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "foreground-set")]
    fn connect_foreground_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "language")]
    fn connect_language_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "language-set")]
    fn connect_language_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "markup")]
    fn connect_markup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "max-width-chars")]
    fn connect_max_width_chars_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "placeholder-text")]
    fn connect_placeholder_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "rise")]
    fn connect_rise_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "rise-set")]
    fn connect_rise_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "scale")]
    fn connect_scale_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "scale-set")]
    fn connect_scale_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "single-paragraph-mode")]
    fn connect_single_paragraph_mode_notify<F: Fn(&Self) + 'static>(&self, f: F)
        -> SignalHandlerId;

    #[doc(alias = "size")]
    fn connect_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "size-points")]
    fn connect_size_points_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "size-set")]
    fn connect_size_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "stretch")]
    fn connect_stretch_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "stretch-set")]
    fn connect_stretch_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "strikethrough")]
    fn connect_strikethrough_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "strikethrough-set")]
    fn connect_strikethrough_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "style")]
    fn connect_style_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "style-set")]
    fn connect_style_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "text")]
    fn connect_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "underline")]
    fn connect_underline_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "underline-set")]
    fn connect_underline_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "variant")]
    fn connect_variant_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "variant-set")]
    fn connect_variant_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "weight")]
    fn connect_weight_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "weight-set")]
    fn connect_weight_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "width-chars")]
    fn connect_width_chars_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "wrap-mode")]
    fn connect_wrap_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "wrap-width")]
    fn connect_wrap_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<CellRendererText>> CellRendererTextExt for O {
    fn set_fixed_height_from_font(&self, number_of_rows: i32) {
        unsafe {
            ffi::gtk_cell_renderer_text_set_fixed_height_from_font(
                self.as_ref().to_glib_none().0,
                number_of_rows,
            );
        }
    }

    fn is_align_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "align-set")
    }

    fn set_align_set(&self, align_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "align-set", &align_set)
    }

    fn alignment(&self) -> pango::Alignment {
        glib::ObjectExt::property(self.as_ref(), "alignment")
    }

    fn set_alignment(&self, alignment: pango::Alignment) {
        glib::ObjectExt::set_property(self.as_ref(), "alignment", &alignment)
    }

    fn attributes(&self) -> Option<pango::AttrList> {
        glib::ObjectExt::property(self.as_ref(), "attributes")
    }

    fn set_attributes(&self, attributes: Option<&pango::AttrList>) {
        glib::ObjectExt::set_property(self.as_ref(), "attributes", &attributes)
    }

    fn set_background(&self, background: Option<&str>) {
        glib::ObjectExt::set_property(self.as_ref(), "background", &background)
    }

    fn background_rgba(&self) -> Option<gdk::RGBA> {
        glib::ObjectExt::property(self.as_ref(), "background-rgba")
    }

    fn set_background_rgba(&self, background_rgba: Option<&gdk::RGBA>) {
        glib::ObjectExt::set_property(self.as_ref(), "background-rgba", &background_rgba)
    }

    fn is_background_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "background-set")
    }

    fn set_background_set(&self, background_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "background-set", &background_set)
    }

    fn is_editable(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "editable")
    }

    fn set_editable(&self, editable: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "editable", &editable)
    }

    fn is_editable_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "editable-set")
    }

    fn set_editable_set(&self, editable_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "editable-set", &editable_set)
    }

    fn ellipsize(&self) -> pango::EllipsizeMode {
        glib::ObjectExt::property(self.as_ref(), "ellipsize")
    }

    fn set_ellipsize(&self, ellipsize: pango::EllipsizeMode) {
        glib::ObjectExt::set_property(self.as_ref(), "ellipsize", &ellipsize)
    }

    fn is_ellipsize_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "ellipsize-set")
    }

    fn set_ellipsize_set(&self, ellipsize_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "ellipsize-set", &ellipsize_set)
    }

    fn family(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self.as_ref(), "family")
    }

    fn set_family(&self, family: Option<&str>) {
        glib::ObjectExt::set_property(self.as_ref(), "family", &family)
    }

    fn is_family_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "family-set")
    }

    fn set_family_set(&self, family_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "family-set", &family_set)
    }

    fn font(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self.as_ref(), "font")
    }

    fn set_font(&self, font: Option<&str>) {
        glib::ObjectExt::set_property(self.as_ref(), "font", &font)
    }

    fn font_desc(&self) -> Option<pango::FontDescription> {
        glib::ObjectExt::property(self.as_ref(), "font-desc")
    }

    fn set_font_desc(&self, font_desc: Option<&pango::FontDescription>) {
        glib::ObjectExt::set_property(self.as_ref(), "font-desc", &font_desc)
    }

    fn set_foreground(&self, foreground: Option<&str>) {
        glib::ObjectExt::set_property(self.as_ref(), "foreground", &foreground)
    }

    fn foreground_rgba(&self) -> Option<gdk::RGBA> {
        glib::ObjectExt::property(self.as_ref(), "foreground-rgba")
    }

    fn set_foreground_rgba(&self, foreground_rgba: Option<&gdk::RGBA>) {
        glib::ObjectExt::set_property(self.as_ref(), "foreground-rgba", &foreground_rgba)
    }

    fn is_foreground_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "foreground-set")
    }

    fn set_foreground_set(&self, foreground_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "foreground-set", &foreground_set)
    }

    fn language(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self.as_ref(), "language")
    }

    fn set_language(&self, language: Option<&str>) {
        glib::ObjectExt::set_property(self.as_ref(), "language", &language)
    }

    fn is_language_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "language-set")
    }

    fn set_language_set(&self, language_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "language-set", &language_set)
    }

    fn set_markup(&self, markup: Option<&str>) {
        glib::ObjectExt::set_property(self.as_ref(), "markup", &markup)
    }

    fn max_width_chars(&self) -> i32 {
        glib::ObjectExt::property(self.as_ref(), "max-width-chars")
    }

    fn set_max_width_chars(&self, max_width_chars: i32) {
        glib::ObjectExt::set_property(self.as_ref(), "max-width-chars", &max_width_chars)
    }

    fn placeholder_text(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self.as_ref(), "placeholder-text")
    }

    fn set_placeholder_text(&self, placeholder_text: Option<&str>) {
        glib::ObjectExt::set_property(self.as_ref(), "placeholder-text", &placeholder_text)
    }

    fn rise(&self) -> i32 {
        glib::ObjectExt::property(self.as_ref(), "rise")
    }

    fn set_rise(&self, rise: i32) {
        glib::ObjectExt::set_property(self.as_ref(), "rise", &rise)
    }

    fn is_rise_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "rise-set")
    }

    fn set_rise_set(&self, rise_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "rise-set", &rise_set)
    }

    fn scale(&self) -> f64 {
        glib::ObjectExt::property(self.as_ref(), "scale")
    }

    fn set_scale(&self, scale: f64) {
        glib::ObjectExt::set_property(self.as_ref(), "scale", &scale)
    }

    fn is_scale_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "scale-set")
    }

    fn set_scale_set(&self, scale_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "scale-set", &scale_set)
    }

    fn is_single_paragraph_mode(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "single-paragraph-mode")
    }

    fn set_single_paragraph_mode(&self, single_paragraph_mode: bool) {
        glib::ObjectExt::set_property(
            self.as_ref(),
            "single-paragraph-mode",
            &single_paragraph_mode,
        )
    }

    fn size(&self) -> i32 {
        glib::ObjectExt::property(self.as_ref(), "size")
    }

    fn set_size(&self, size: i32) {
        glib::ObjectExt::set_property(self.as_ref(), "size", &size)
    }

    fn size_points(&self) -> f64 {
        glib::ObjectExt::property(self.as_ref(), "size-points")
    }

    fn set_size_points(&self, size_points: f64) {
        glib::ObjectExt::set_property(self.as_ref(), "size-points", &size_points)
    }

    fn is_size_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "size-set")
    }

    fn set_size_set(&self, size_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "size-set", &size_set)
    }

    fn stretch(&self) -> pango::Stretch {
        glib::ObjectExt::property(self.as_ref(), "stretch")
    }

    fn set_stretch(&self, stretch: pango::Stretch) {
        glib::ObjectExt::set_property(self.as_ref(), "stretch", &stretch)
    }

    fn is_stretch_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "stretch-set")
    }

    fn set_stretch_set(&self, stretch_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "stretch-set", &stretch_set)
    }

    fn is_strikethrough(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "strikethrough")
    }

    fn set_strikethrough(&self, strikethrough: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "strikethrough", &strikethrough)
    }

    fn is_strikethrough_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "strikethrough-set")
    }

    fn set_strikethrough_set(&self, strikethrough_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "strikethrough-set", &strikethrough_set)
    }

    fn style(&self) -> pango::Style {
        glib::ObjectExt::property(self.as_ref(), "style")
    }

    fn set_style(&self, style: pango::Style) {
        glib::ObjectExt::set_property(self.as_ref(), "style", &style)
    }

    fn is_style_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "style-set")
    }

    fn set_style_set(&self, style_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "style-set", &style_set)
    }

    fn text(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self.as_ref(), "text")
    }

    fn set_text(&self, text: Option<&str>) {
        glib::ObjectExt::set_property(self.as_ref(), "text", &text)
    }

    fn underline(&self) -> pango::Underline {
        glib::ObjectExt::property(self.as_ref(), "underline")
    }

    fn set_underline(&self, underline: pango::Underline) {
        glib::ObjectExt::set_property(self.as_ref(), "underline", &underline)
    }

    fn is_underline_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "underline-set")
    }

    fn set_underline_set(&self, underline_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "underline-set", &underline_set)
    }

    fn variant(&self) -> pango::Variant {
        glib::ObjectExt::property(self.as_ref(), "variant")
    }

    fn set_variant(&self, variant: pango::Variant) {
        glib::ObjectExt::set_property(self.as_ref(), "variant", &variant)
    }

    fn is_variant_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "variant-set")
    }

    fn set_variant_set(&self, variant_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "variant-set", &variant_set)
    }

    fn weight(&self) -> i32 {
        glib::ObjectExt::property(self.as_ref(), "weight")
    }

    fn set_weight(&self, weight: i32) {
        glib::ObjectExt::set_property(self.as_ref(), "weight", &weight)
    }

    fn is_weight_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "weight-set")
    }

    fn set_weight_set(&self, weight_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "weight-set", &weight_set)
    }

    fn width_chars(&self) -> i32 {
        glib::ObjectExt::property(self.as_ref(), "width-chars")
    }

    fn set_width_chars(&self, width_chars: i32) {
        glib::ObjectExt::set_property(self.as_ref(), "width-chars", &width_chars)
    }

    fn wrap_mode(&self) -> pango::WrapMode {
        glib::ObjectExt::property(self.as_ref(), "wrap-mode")
    }

    fn set_wrap_mode(&self, wrap_mode: pango::WrapMode) {
        glib::ObjectExt::set_property(self.as_ref(), "wrap-mode", &wrap_mode)
    }

    fn wrap_width(&self) -> i32 {
        glib::ObjectExt::property(self.as_ref(), "wrap-width")
    }

    fn set_wrap_width(&self, wrap_width: i32) {
        glib::ObjectExt::set_property(self.as_ref(), "wrap-width", &wrap_width)
    }

    fn connect_edited<F: Fn(&Self, TreePath, &str) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn edited_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P, TreePath, &str) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            path: *mut libc::c_char,
            new_text: *mut libc::c_char,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            let path = from_glib_full(crate::ffi::gtk_tree_path_new_from_string(path));
            f(
                CellRendererText::from_glib_borrow(this).unsafe_cast_ref(),
                path,
                &glib::GString::from_glib_borrow(new_text),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"edited\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    edited_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_align_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_align_set_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::align-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_align_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_alignment_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_alignment_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::alignment\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_alignment_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_attributes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_attributes_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::attributes\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_attributes_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_background_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_background_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::background\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_background_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_background_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_background_rgba_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::background-rgba\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_background_rgba_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_background_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_background_set_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::background-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_background_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_editable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_editable_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::editable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_editable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_editable_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_editable_set_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::editable-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_editable_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_ellipsize_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_ellipsize_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::ellipsize\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_ellipsize_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_ellipsize_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_ellipsize_set_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::ellipsize-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_ellipsize_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_family_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_family_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::family\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_family_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_family_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_family_set_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::family-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_family_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_font_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_font_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::font\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_font_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_font_desc_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_font_desc_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::font-desc\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_font_desc_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_foreground_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_foreground_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::foreground\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_foreground_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_foreground_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_foreground_rgba_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::foreground-rgba\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_foreground_rgba_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_foreground_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_foreground_set_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::foreground-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_foreground_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_language_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_language_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::language\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_language_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_language_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_language_set_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::language-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_language_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_markup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_markup_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::markup\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_markup_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_max_width_chars_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_max_width_chars_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::max-width-chars\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_max_width_chars_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_placeholder_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_placeholder_text_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::placeholder-text\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_placeholder_text_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_rise_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_rise_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::rise\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_rise_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_rise_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_rise_set_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::rise-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_rise_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_scale_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scale_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::scale\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_scale_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_scale_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scale_set_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::scale-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_scale_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_single_paragraph_mode_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_single_paragraph_mode_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::single-paragraph-mode\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_single_paragraph_mode_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_size_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_size_points_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_size_points_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::size-points\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_size_points_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_size_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_size_set_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::size-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_size_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_stretch_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_stretch_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::stretch\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_stretch_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_stretch_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_stretch_set_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::stretch-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_stretch_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_strikethrough_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_strikethrough_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::strikethrough\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_strikethrough_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_strikethrough_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_strikethrough_set_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::strikethrough-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_strikethrough_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_style_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_style_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::style\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_style_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_style_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_style_set_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::style-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_style_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_text_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::text\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_text_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_underline_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_underline_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::underline\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_underline_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_underline_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_underline_set_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::underline-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_underline_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_variant_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_variant_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::variant\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_variant_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_variant_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_variant_set_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::variant-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_variant_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_weight_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_weight_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::weight\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_weight_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_weight_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_weight_set_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::weight-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_weight_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_width_chars_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_width_chars_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::width-chars\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_width_chars_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_wrap_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_wrap_mode_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::wrap-mode\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_wrap_mode_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_wrap_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_wrap_width_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::wrap-width\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_wrap_width_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for CellRendererText {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("CellRendererText")
    }
}
