// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use glib::error::ErrorDomain;
use glib::translate::*;
use glib::value::FromValue;
use glib::value::ToValue;
use glib::Quark;
use glib::StaticType;
use glib::Type;
use std::fmt;
use std::mem;

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkAlign")]
pub enum Align {
    #[doc(alias = "GTK_ALIGN_FILL")]
    Fill,
    #[doc(alias = "GTK_ALIGN_START")]
    Start,
    #[doc(alias = "GTK_ALIGN_END")]
    End,
    #[doc(alias = "GTK_ALIGN_CENTER")]
    Center,
    #[doc(alias = "GTK_ALIGN_BASELINE")]
    Baseline,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Align {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Align::{}",
            match *self {
                Self::Fill => "Fill",
                Self::Start => "Start",
                Self::End => "End",
                Self::Center => "Center",
                Self::Baseline => "Baseline",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for Align {
    type GlibType = ffi::GtkAlign;

    fn into_glib(self) -> ffi::GtkAlign {
        match self {
            Self::Fill => ffi::GTK_ALIGN_FILL,
            Self::Start => ffi::GTK_ALIGN_START,
            Self::End => ffi::GTK_ALIGN_END,
            Self::Center => ffi::GTK_ALIGN_CENTER,
            Self::Baseline => ffi::GTK_ALIGN_BASELINE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkAlign> for Align {
    unsafe fn from_glib(value: ffi::GtkAlign) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_ALIGN_FILL => Self::Fill,
            ffi::GTK_ALIGN_START => Self::Start,
            ffi::GTK_ALIGN_END => Self::End,
            ffi::GTK_ALIGN_CENTER => Self::Center,
            ffi::GTK_ALIGN_BASELINE => Self::Baseline,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for Align {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_align_get_type()) }
    }
}

impl glib::value::ValueType for Align {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for Align {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for Align {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkArrowType")]
pub enum ArrowType {
    #[doc(alias = "GTK_ARROW_UP")]
    Up,
    #[doc(alias = "GTK_ARROW_DOWN")]
    Down,
    #[doc(alias = "GTK_ARROW_LEFT")]
    Left,
    #[doc(alias = "GTK_ARROW_RIGHT")]
    Right,
    #[doc(alias = "GTK_ARROW_NONE")]
    None,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for ArrowType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "ArrowType::{}",
            match *self {
                Self::Up => "Up",
                Self::Down => "Down",
                Self::Left => "Left",
                Self::Right => "Right",
                Self::None => "None",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for ArrowType {
    type GlibType = ffi::GtkArrowType;

    fn into_glib(self) -> ffi::GtkArrowType {
        match self {
            Self::Up => ffi::GTK_ARROW_UP,
            Self::Down => ffi::GTK_ARROW_DOWN,
            Self::Left => ffi::GTK_ARROW_LEFT,
            Self::Right => ffi::GTK_ARROW_RIGHT,
            Self::None => ffi::GTK_ARROW_NONE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkArrowType> for ArrowType {
    unsafe fn from_glib(value: ffi::GtkArrowType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_ARROW_UP => Self::Up,
            ffi::GTK_ARROW_DOWN => Self::Down,
            ffi::GTK_ARROW_LEFT => Self::Left,
            ffi::GTK_ARROW_RIGHT => Self::Right,
            ffi::GTK_ARROW_NONE => Self::None,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for ArrowType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_arrow_type_get_type()) }
    }
}

impl glib::value::ValueType for ArrowType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for ArrowType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ArrowType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkAssistantPageType")]
pub enum AssistantPageType {
    #[doc(alias = "GTK_ASSISTANT_PAGE_CONTENT")]
    Content,
    #[doc(alias = "GTK_ASSISTANT_PAGE_INTRO")]
    Intro,
    #[doc(alias = "GTK_ASSISTANT_PAGE_CONFIRM")]
    Confirm,
    #[doc(alias = "GTK_ASSISTANT_PAGE_SUMMARY")]
    Summary,
    #[doc(alias = "GTK_ASSISTANT_PAGE_PROGRESS")]
    Progress,
    #[doc(alias = "GTK_ASSISTANT_PAGE_CUSTOM")]
    Custom,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for AssistantPageType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "AssistantPageType::{}",
            match *self {
                Self::Content => "Content",
                Self::Intro => "Intro",
                Self::Confirm => "Confirm",
                Self::Summary => "Summary",
                Self::Progress => "Progress",
                Self::Custom => "Custom",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for AssistantPageType {
    type GlibType = ffi::GtkAssistantPageType;

    fn into_glib(self) -> ffi::GtkAssistantPageType {
        match self {
            Self::Content => ffi::GTK_ASSISTANT_PAGE_CONTENT,
            Self::Intro => ffi::GTK_ASSISTANT_PAGE_INTRO,
            Self::Confirm => ffi::GTK_ASSISTANT_PAGE_CONFIRM,
            Self::Summary => ffi::GTK_ASSISTANT_PAGE_SUMMARY,
            Self::Progress => ffi::GTK_ASSISTANT_PAGE_PROGRESS,
            Self::Custom => ffi::GTK_ASSISTANT_PAGE_CUSTOM,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkAssistantPageType> for AssistantPageType {
    unsafe fn from_glib(value: ffi::GtkAssistantPageType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_ASSISTANT_PAGE_CONTENT => Self::Content,
            ffi::GTK_ASSISTANT_PAGE_INTRO => Self::Intro,
            ffi::GTK_ASSISTANT_PAGE_CONFIRM => Self::Confirm,
            ffi::GTK_ASSISTANT_PAGE_SUMMARY => Self::Summary,
            ffi::GTK_ASSISTANT_PAGE_PROGRESS => Self::Progress,
            ffi::GTK_ASSISTANT_PAGE_CUSTOM => Self::Custom,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for AssistantPageType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_assistant_page_type_get_type()) }
    }
}

impl glib::value::ValueType for AssistantPageType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for AssistantPageType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for AssistantPageType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkBaselinePosition")]
pub enum BaselinePosition {
    #[doc(alias = "GTK_BASELINE_POSITION_TOP")]
    Top,
    #[doc(alias = "GTK_BASELINE_POSITION_CENTER")]
    Center,
    #[doc(alias = "GTK_BASELINE_POSITION_BOTTOM")]
    Bottom,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for BaselinePosition {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "BaselinePosition::{}",
            match *self {
                Self::Top => "Top",
                Self::Center => "Center",
                Self::Bottom => "Bottom",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for BaselinePosition {
    type GlibType = ffi::GtkBaselinePosition;

    fn into_glib(self) -> ffi::GtkBaselinePosition {
        match self {
            Self::Top => ffi::GTK_BASELINE_POSITION_TOP,
            Self::Center => ffi::GTK_BASELINE_POSITION_CENTER,
            Self::Bottom => ffi::GTK_BASELINE_POSITION_BOTTOM,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkBaselinePosition> for BaselinePosition {
    unsafe fn from_glib(value: ffi::GtkBaselinePosition) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_BASELINE_POSITION_TOP => Self::Top,
            ffi::GTK_BASELINE_POSITION_CENTER => Self::Center,
            ffi::GTK_BASELINE_POSITION_BOTTOM => Self::Bottom,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for BaselinePosition {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_baseline_position_get_type()) }
    }
}

impl glib::value::ValueType for BaselinePosition {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for BaselinePosition {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for BaselinePosition {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkBorderStyle")]
pub enum BorderStyle {
    #[doc(alias = "GTK_BORDER_STYLE_NONE")]
    None,
    #[doc(alias = "GTK_BORDER_STYLE_SOLID")]
    Solid,
    #[doc(alias = "GTK_BORDER_STYLE_INSET")]
    Inset,
    #[doc(alias = "GTK_BORDER_STYLE_OUTSET")]
    Outset,
    #[doc(alias = "GTK_BORDER_STYLE_HIDDEN")]
    Hidden,
    #[doc(alias = "GTK_BORDER_STYLE_DOTTED")]
    Dotted,
    #[doc(alias = "GTK_BORDER_STYLE_DASHED")]
    Dashed,
    #[doc(alias = "GTK_BORDER_STYLE_DOUBLE")]
    Double,
    #[doc(alias = "GTK_BORDER_STYLE_GROOVE")]
    Groove,
    #[doc(alias = "GTK_BORDER_STYLE_RIDGE")]
    Ridge,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for BorderStyle {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "BorderStyle::{}",
            match *self {
                Self::None => "None",
                Self::Solid => "Solid",
                Self::Inset => "Inset",
                Self::Outset => "Outset",
                Self::Hidden => "Hidden",
                Self::Dotted => "Dotted",
                Self::Dashed => "Dashed",
                Self::Double => "Double",
                Self::Groove => "Groove",
                Self::Ridge => "Ridge",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for BorderStyle {
    type GlibType = ffi::GtkBorderStyle;

    fn into_glib(self) -> ffi::GtkBorderStyle {
        match self {
            Self::None => ffi::GTK_BORDER_STYLE_NONE,
            Self::Solid => ffi::GTK_BORDER_STYLE_SOLID,
            Self::Inset => ffi::GTK_BORDER_STYLE_INSET,
            Self::Outset => ffi::GTK_BORDER_STYLE_OUTSET,
            Self::Hidden => ffi::GTK_BORDER_STYLE_HIDDEN,
            Self::Dotted => ffi::GTK_BORDER_STYLE_DOTTED,
            Self::Dashed => ffi::GTK_BORDER_STYLE_DASHED,
            Self::Double => ffi::GTK_BORDER_STYLE_DOUBLE,
            Self::Groove => ffi::GTK_BORDER_STYLE_GROOVE,
            Self::Ridge => ffi::GTK_BORDER_STYLE_RIDGE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkBorderStyle> for BorderStyle {
    unsafe fn from_glib(value: ffi::GtkBorderStyle) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_BORDER_STYLE_NONE => Self::None,
            ffi::GTK_BORDER_STYLE_SOLID => Self::Solid,
            ffi::GTK_BORDER_STYLE_INSET => Self::Inset,
            ffi::GTK_BORDER_STYLE_OUTSET => Self::Outset,
            ffi::GTK_BORDER_STYLE_HIDDEN => Self::Hidden,
            ffi::GTK_BORDER_STYLE_DOTTED => Self::Dotted,
            ffi::GTK_BORDER_STYLE_DASHED => Self::Dashed,
            ffi::GTK_BORDER_STYLE_DOUBLE => Self::Double,
            ffi::GTK_BORDER_STYLE_GROOVE => Self::Groove,
            ffi::GTK_BORDER_STYLE_RIDGE => Self::Ridge,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for BorderStyle {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_border_style_get_type()) }
    }
}

impl glib::value::ValueType for BorderStyle {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for BorderStyle {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for BorderStyle {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkBuilderError")]
pub enum BuilderError {
    #[doc(alias = "GTK_BUILDER_ERROR_INVALID_TYPE_FUNCTION")]
    InvalidTypeFunction,
    #[doc(alias = "GTK_BUILDER_ERROR_UNHANDLED_TAG")]
    UnhandledTag,
    #[doc(alias = "GTK_BUILDER_ERROR_MISSING_ATTRIBUTE")]
    MissingAttribute,
    #[doc(alias = "GTK_BUILDER_ERROR_INVALID_ATTRIBUTE")]
    InvalidAttribute,
    #[doc(alias = "GTK_BUILDER_ERROR_INVALID_TAG")]
    InvalidTag,
    #[doc(alias = "GTK_BUILDER_ERROR_MISSING_PROPERTY_VALUE")]
    MissingPropertyValue,
    #[doc(alias = "GTK_BUILDER_ERROR_INVALID_VALUE")]
    InvalidValue,
    #[doc(alias = "GTK_BUILDER_ERROR_VERSION_MISMATCH")]
    VersionMismatch,
    #[doc(alias = "GTK_BUILDER_ERROR_DUPLICATE_ID")]
    DuplicateId,
    #[doc(alias = "GTK_BUILDER_ERROR_OBJECT_TYPE_REFUSED")]
    ObjectTypeRefused,
    #[doc(alias = "GTK_BUILDER_ERROR_TEMPLATE_MISMATCH")]
    TemplateMismatch,
    #[doc(alias = "GTK_BUILDER_ERROR_INVALID_PROPERTY")]
    InvalidProperty,
    #[doc(alias = "GTK_BUILDER_ERROR_INVALID_SIGNAL")]
    InvalidSignal,
    #[doc(alias = "GTK_BUILDER_ERROR_INVALID_ID")]
    InvalidId,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for BuilderError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "BuilderError::{}",
            match *self {
                Self::InvalidTypeFunction => "InvalidTypeFunction",
                Self::UnhandledTag => "UnhandledTag",
                Self::MissingAttribute => "MissingAttribute",
                Self::InvalidAttribute => "InvalidAttribute",
                Self::InvalidTag => "InvalidTag",
                Self::MissingPropertyValue => "MissingPropertyValue",
                Self::InvalidValue => "InvalidValue",
                Self::VersionMismatch => "VersionMismatch",
                Self::DuplicateId => "DuplicateId",
                Self::ObjectTypeRefused => "ObjectTypeRefused",
                Self::TemplateMismatch => "TemplateMismatch",
                Self::InvalidProperty => "InvalidProperty",
                Self::InvalidSignal => "InvalidSignal",
                Self::InvalidId => "InvalidId",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for BuilderError {
    type GlibType = ffi::GtkBuilderError;

    fn into_glib(self) -> ffi::GtkBuilderError {
        match self {
            Self::InvalidTypeFunction => ffi::GTK_BUILDER_ERROR_INVALID_TYPE_FUNCTION,
            Self::UnhandledTag => ffi::GTK_BUILDER_ERROR_UNHANDLED_TAG,
            Self::MissingAttribute => ffi::GTK_BUILDER_ERROR_MISSING_ATTRIBUTE,
            Self::InvalidAttribute => ffi::GTK_BUILDER_ERROR_INVALID_ATTRIBUTE,
            Self::InvalidTag => ffi::GTK_BUILDER_ERROR_INVALID_TAG,
            Self::MissingPropertyValue => ffi::GTK_BUILDER_ERROR_MISSING_PROPERTY_VALUE,
            Self::InvalidValue => ffi::GTK_BUILDER_ERROR_INVALID_VALUE,
            Self::VersionMismatch => ffi::GTK_BUILDER_ERROR_VERSION_MISMATCH,
            Self::DuplicateId => ffi::GTK_BUILDER_ERROR_DUPLICATE_ID,
            Self::ObjectTypeRefused => ffi::GTK_BUILDER_ERROR_OBJECT_TYPE_REFUSED,
            Self::TemplateMismatch => ffi::GTK_BUILDER_ERROR_TEMPLATE_MISMATCH,
            Self::InvalidProperty => ffi::GTK_BUILDER_ERROR_INVALID_PROPERTY,
            Self::InvalidSignal => ffi::GTK_BUILDER_ERROR_INVALID_SIGNAL,
            Self::InvalidId => ffi::GTK_BUILDER_ERROR_INVALID_ID,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkBuilderError> for BuilderError {
    unsafe fn from_glib(value: ffi::GtkBuilderError) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_BUILDER_ERROR_INVALID_TYPE_FUNCTION => Self::InvalidTypeFunction,
            ffi::GTK_BUILDER_ERROR_UNHANDLED_TAG => Self::UnhandledTag,
            ffi::GTK_BUILDER_ERROR_MISSING_ATTRIBUTE => Self::MissingAttribute,
            ffi::GTK_BUILDER_ERROR_INVALID_ATTRIBUTE => Self::InvalidAttribute,
            ffi::GTK_BUILDER_ERROR_INVALID_TAG => Self::InvalidTag,
            ffi::GTK_BUILDER_ERROR_MISSING_PROPERTY_VALUE => Self::MissingPropertyValue,
            ffi::GTK_BUILDER_ERROR_INVALID_VALUE => Self::InvalidValue,
            ffi::GTK_BUILDER_ERROR_VERSION_MISMATCH => Self::VersionMismatch,
            ffi::GTK_BUILDER_ERROR_DUPLICATE_ID => Self::DuplicateId,
            ffi::GTK_BUILDER_ERROR_OBJECT_TYPE_REFUSED => Self::ObjectTypeRefused,
            ffi::GTK_BUILDER_ERROR_TEMPLATE_MISMATCH => Self::TemplateMismatch,
            ffi::GTK_BUILDER_ERROR_INVALID_PROPERTY => Self::InvalidProperty,
            ffi::GTK_BUILDER_ERROR_INVALID_SIGNAL => Self::InvalidSignal,
            ffi::GTK_BUILDER_ERROR_INVALID_ID => Self::InvalidId,
            value => Self::__Unknown(value),
        }
    }
}

impl ErrorDomain for BuilderError {
    fn domain() -> Quark {
        skip_assert_initialized!();

        unsafe { from_glib(ffi::gtk_builder_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            ffi::GTK_BUILDER_ERROR_INVALID_TYPE_FUNCTION => Some(Self::InvalidTypeFunction),
            ffi::GTK_BUILDER_ERROR_UNHANDLED_TAG => Some(Self::UnhandledTag),
            ffi::GTK_BUILDER_ERROR_MISSING_ATTRIBUTE => Some(Self::MissingAttribute),
            ffi::GTK_BUILDER_ERROR_INVALID_ATTRIBUTE => Some(Self::InvalidAttribute),
            ffi::GTK_BUILDER_ERROR_INVALID_TAG => Some(Self::InvalidTag),
            ffi::GTK_BUILDER_ERROR_MISSING_PROPERTY_VALUE => Some(Self::MissingPropertyValue),
            ffi::GTK_BUILDER_ERROR_INVALID_VALUE => Some(Self::InvalidValue),
            ffi::GTK_BUILDER_ERROR_VERSION_MISMATCH => Some(Self::VersionMismatch),
            ffi::GTK_BUILDER_ERROR_DUPLICATE_ID => Some(Self::DuplicateId),
            ffi::GTK_BUILDER_ERROR_OBJECT_TYPE_REFUSED => Some(Self::ObjectTypeRefused),
            ffi::GTK_BUILDER_ERROR_TEMPLATE_MISMATCH => Some(Self::TemplateMismatch),
            ffi::GTK_BUILDER_ERROR_INVALID_PROPERTY => Some(Self::InvalidProperty),
            ffi::GTK_BUILDER_ERROR_INVALID_SIGNAL => Some(Self::InvalidSignal),
            ffi::GTK_BUILDER_ERROR_INVALID_ID => Some(Self::InvalidId),
            value => Some(Self::__Unknown(value)),
        }
    }
}

impl StaticType for BuilderError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_builder_error_get_type()) }
    }
}

impl glib::value::ValueType for BuilderError {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for BuilderError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for BuilderError {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkButtonBoxStyle")]
pub enum ButtonBoxStyle {
    #[doc(alias = "GTK_BUTTONBOX_SPREAD")]
    Spread,
    #[doc(alias = "GTK_BUTTONBOX_EDGE")]
    Edge,
    #[doc(alias = "GTK_BUTTONBOX_START")]
    Start,
    #[doc(alias = "GTK_BUTTONBOX_END")]
    End,
    #[doc(alias = "GTK_BUTTONBOX_CENTER")]
    Center,
    #[doc(alias = "GTK_BUTTONBOX_EXPAND")]
    Expand,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for ButtonBoxStyle {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "ButtonBoxStyle::{}",
            match *self {
                Self::Spread => "Spread",
                Self::Edge => "Edge",
                Self::Start => "Start",
                Self::End => "End",
                Self::Center => "Center",
                Self::Expand => "Expand",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for ButtonBoxStyle {
    type GlibType = ffi::GtkButtonBoxStyle;

    fn into_glib(self) -> ffi::GtkButtonBoxStyle {
        match self {
            Self::Spread => ffi::GTK_BUTTONBOX_SPREAD,
            Self::Edge => ffi::GTK_BUTTONBOX_EDGE,
            Self::Start => ffi::GTK_BUTTONBOX_START,
            Self::End => ffi::GTK_BUTTONBOX_END,
            Self::Center => ffi::GTK_BUTTONBOX_CENTER,
            Self::Expand => ffi::GTK_BUTTONBOX_EXPAND,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkButtonBoxStyle> for ButtonBoxStyle {
    unsafe fn from_glib(value: ffi::GtkButtonBoxStyle) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_BUTTONBOX_SPREAD => Self::Spread,
            ffi::GTK_BUTTONBOX_EDGE => Self::Edge,
            ffi::GTK_BUTTONBOX_START => Self::Start,
            ffi::GTK_BUTTONBOX_END => Self::End,
            ffi::GTK_BUTTONBOX_CENTER => Self::Center,
            ffi::GTK_BUTTONBOX_EXPAND => Self::Expand,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for ButtonBoxStyle {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_button_box_style_get_type()) }
    }
}

impl glib::value::ValueType for ButtonBoxStyle {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for ButtonBoxStyle {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ButtonBoxStyle {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkButtonRole")]
pub enum ButtonRole {
    #[doc(alias = "GTK_BUTTON_ROLE_NORMAL")]
    Normal,
    #[doc(alias = "GTK_BUTTON_ROLE_CHECK")]
    Check,
    #[doc(alias = "GTK_BUTTON_ROLE_RADIO")]
    Radio,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for ButtonRole {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "ButtonRole::{}",
            match *self {
                Self::Normal => "Normal",
                Self::Check => "Check",
                Self::Radio => "Radio",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for ButtonRole {
    type GlibType = ffi::GtkButtonRole;

    fn into_glib(self) -> ffi::GtkButtonRole {
        match self {
            Self::Normal => ffi::GTK_BUTTON_ROLE_NORMAL,
            Self::Check => ffi::GTK_BUTTON_ROLE_CHECK,
            Self::Radio => ffi::GTK_BUTTON_ROLE_RADIO,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkButtonRole> for ButtonRole {
    unsafe fn from_glib(value: ffi::GtkButtonRole) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_BUTTON_ROLE_NORMAL => Self::Normal,
            ffi::GTK_BUTTON_ROLE_CHECK => Self::Check,
            ffi::GTK_BUTTON_ROLE_RADIO => Self::Radio,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for ButtonRole {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_button_role_get_type()) }
    }
}

impl glib::value::ValueType for ButtonRole {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for ButtonRole {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ButtonRole {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkButtonsType")]
pub enum ButtonsType {
    #[doc(alias = "GTK_BUTTONS_NONE")]
    None,
    #[doc(alias = "GTK_BUTTONS_OK")]
    Ok,
    #[doc(alias = "GTK_BUTTONS_CLOSE")]
    Close,
    #[doc(alias = "GTK_BUTTONS_CANCEL")]
    Cancel,
    #[doc(alias = "GTK_BUTTONS_YES_NO")]
    YesNo,
    #[doc(alias = "GTK_BUTTONS_OK_CANCEL")]
    OkCancel,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for ButtonsType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "ButtonsType::{}",
            match *self {
                Self::None => "None",
                Self::Ok => "Ok",
                Self::Close => "Close",
                Self::Cancel => "Cancel",
                Self::YesNo => "YesNo",
                Self::OkCancel => "OkCancel",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for ButtonsType {
    type GlibType = ffi::GtkButtonsType;

    fn into_glib(self) -> ffi::GtkButtonsType {
        match self {
            Self::None => ffi::GTK_BUTTONS_NONE,
            Self::Ok => ffi::GTK_BUTTONS_OK,
            Self::Close => ffi::GTK_BUTTONS_CLOSE,
            Self::Cancel => ffi::GTK_BUTTONS_CANCEL,
            Self::YesNo => ffi::GTK_BUTTONS_YES_NO,
            Self::OkCancel => ffi::GTK_BUTTONS_OK_CANCEL,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkButtonsType> for ButtonsType {
    unsafe fn from_glib(value: ffi::GtkButtonsType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_BUTTONS_NONE => Self::None,
            ffi::GTK_BUTTONS_OK => Self::Ok,
            ffi::GTK_BUTTONS_CLOSE => Self::Close,
            ffi::GTK_BUTTONS_CANCEL => Self::Cancel,
            ffi::GTK_BUTTONS_YES_NO => Self::YesNo,
            ffi::GTK_BUTTONS_OK_CANCEL => Self::OkCancel,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for ButtonsType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_buttons_type_get_type()) }
    }
}

impl glib::value::ValueType for ButtonsType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for ButtonsType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ButtonsType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkCellRendererAccelMode")]
pub enum CellRendererAccelMode {
    #[doc(alias = "GTK_CELL_RENDERER_ACCEL_MODE_GTK")]
    Gtk,
    #[doc(alias = "GTK_CELL_RENDERER_ACCEL_MODE_OTHER")]
    Other,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for CellRendererAccelMode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "CellRendererAccelMode::{}",
            match *self {
                Self::Gtk => "Gtk",
                Self::Other => "Other",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for CellRendererAccelMode {
    type GlibType = ffi::GtkCellRendererAccelMode;

    fn into_glib(self) -> ffi::GtkCellRendererAccelMode {
        match self {
            Self::Gtk => ffi::GTK_CELL_RENDERER_ACCEL_MODE_GTK,
            Self::Other => ffi::GTK_CELL_RENDERER_ACCEL_MODE_OTHER,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkCellRendererAccelMode> for CellRendererAccelMode {
    unsafe fn from_glib(value: ffi::GtkCellRendererAccelMode) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_CELL_RENDERER_ACCEL_MODE_GTK => Self::Gtk,
            ffi::GTK_CELL_RENDERER_ACCEL_MODE_OTHER => Self::Other,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for CellRendererAccelMode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_cell_renderer_accel_mode_get_type()) }
    }
}

impl glib::value::ValueType for CellRendererAccelMode {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for CellRendererAccelMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for CellRendererAccelMode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkCellRendererMode")]
pub enum CellRendererMode {
    #[doc(alias = "GTK_CELL_RENDERER_MODE_INERT")]
    Inert,
    #[doc(alias = "GTK_CELL_RENDERER_MODE_ACTIVATABLE")]
    Activatable,
    #[doc(alias = "GTK_CELL_RENDERER_MODE_EDITABLE")]
    Editable,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for CellRendererMode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "CellRendererMode::{}",
            match *self {
                Self::Inert => "Inert",
                Self::Activatable => "Activatable",
                Self::Editable => "Editable",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for CellRendererMode {
    type GlibType = ffi::GtkCellRendererMode;

    fn into_glib(self) -> ffi::GtkCellRendererMode {
        match self {
            Self::Inert => ffi::GTK_CELL_RENDERER_MODE_INERT,
            Self::Activatable => ffi::GTK_CELL_RENDERER_MODE_ACTIVATABLE,
            Self::Editable => ffi::GTK_CELL_RENDERER_MODE_EDITABLE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkCellRendererMode> for CellRendererMode {
    unsafe fn from_glib(value: ffi::GtkCellRendererMode) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_CELL_RENDERER_MODE_INERT => Self::Inert,
            ffi::GTK_CELL_RENDERER_MODE_ACTIVATABLE => Self::Activatable,
            ffi::GTK_CELL_RENDERER_MODE_EDITABLE => Self::Editable,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for CellRendererMode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_cell_renderer_mode_get_type()) }
    }
}

impl glib::value::ValueType for CellRendererMode {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for CellRendererMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for CellRendererMode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkCornerType")]
pub enum CornerType {
    #[doc(alias = "GTK_CORNER_TOP_LEFT")]
    TopLeft,
    #[doc(alias = "GTK_CORNER_BOTTOM_LEFT")]
    BottomLeft,
    #[doc(alias = "GTK_CORNER_TOP_RIGHT")]
    TopRight,
    #[doc(alias = "GTK_CORNER_BOTTOM_RIGHT")]
    BottomRight,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for CornerType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "CornerType::{}",
            match *self {
                Self::TopLeft => "TopLeft",
                Self::BottomLeft => "BottomLeft",
                Self::TopRight => "TopRight",
                Self::BottomRight => "BottomRight",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for CornerType {
    type GlibType = ffi::GtkCornerType;

    fn into_glib(self) -> ffi::GtkCornerType {
        match self {
            Self::TopLeft => ffi::GTK_CORNER_TOP_LEFT,
            Self::BottomLeft => ffi::GTK_CORNER_BOTTOM_LEFT,
            Self::TopRight => ffi::GTK_CORNER_TOP_RIGHT,
            Self::BottomRight => ffi::GTK_CORNER_BOTTOM_RIGHT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkCornerType> for CornerType {
    unsafe fn from_glib(value: ffi::GtkCornerType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_CORNER_TOP_LEFT => Self::TopLeft,
            ffi::GTK_CORNER_BOTTOM_LEFT => Self::BottomLeft,
            ffi::GTK_CORNER_TOP_RIGHT => Self::TopRight,
            ffi::GTK_CORNER_BOTTOM_RIGHT => Self::BottomRight,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for CornerType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_corner_type_get_type()) }
    }
}

impl glib::value::ValueType for CornerType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for CornerType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for CornerType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkCssProviderError")]
pub enum CssProviderError {
    #[doc(alias = "GTK_CSS_PROVIDER_ERROR_FAILED")]
    Failed,
    #[doc(alias = "GTK_CSS_PROVIDER_ERROR_SYNTAX")]
    Syntax,
    #[doc(alias = "GTK_CSS_PROVIDER_ERROR_IMPORT")]
    Import,
    #[doc(alias = "GTK_CSS_PROVIDER_ERROR_NAME")]
    Name,
    #[doc(alias = "GTK_CSS_PROVIDER_ERROR_DEPRECATED")]
    Deprecated,
    #[doc(alias = "GTK_CSS_PROVIDER_ERROR_UNKNOWN_VALUE")]
    UnknownValue,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for CssProviderError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "CssProviderError::{}",
            match *self {
                Self::Failed => "Failed",
                Self::Syntax => "Syntax",
                Self::Import => "Import",
                Self::Name => "Name",
                Self::Deprecated => "Deprecated",
                Self::UnknownValue => "UnknownValue",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for CssProviderError {
    type GlibType = ffi::GtkCssProviderError;

    fn into_glib(self) -> ffi::GtkCssProviderError {
        match self {
            Self::Failed => ffi::GTK_CSS_PROVIDER_ERROR_FAILED,
            Self::Syntax => ffi::GTK_CSS_PROVIDER_ERROR_SYNTAX,
            Self::Import => ffi::GTK_CSS_PROVIDER_ERROR_IMPORT,
            Self::Name => ffi::GTK_CSS_PROVIDER_ERROR_NAME,
            Self::Deprecated => ffi::GTK_CSS_PROVIDER_ERROR_DEPRECATED,
            Self::UnknownValue => ffi::GTK_CSS_PROVIDER_ERROR_UNKNOWN_VALUE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkCssProviderError> for CssProviderError {
    unsafe fn from_glib(value: ffi::GtkCssProviderError) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_CSS_PROVIDER_ERROR_FAILED => Self::Failed,
            ffi::GTK_CSS_PROVIDER_ERROR_SYNTAX => Self::Syntax,
            ffi::GTK_CSS_PROVIDER_ERROR_IMPORT => Self::Import,
            ffi::GTK_CSS_PROVIDER_ERROR_NAME => Self::Name,
            ffi::GTK_CSS_PROVIDER_ERROR_DEPRECATED => Self::Deprecated,
            ffi::GTK_CSS_PROVIDER_ERROR_UNKNOWN_VALUE => Self::UnknownValue,
            value => Self::__Unknown(value),
        }
    }
}

impl ErrorDomain for CssProviderError {
    fn domain() -> Quark {
        skip_assert_initialized!();

        unsafe { from_glib(ffi::gtk_css_provider_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            ffi::GTK_CSS_PROVIDER_ERROR_FAILED => Some(Self::Failed),
            ffi::GTK_CSS_PROVIDER_ERROR_SYNTAX => Some(Self::Syntax),
            ffi::GTK_CSS_PROVIDER_ERROR_IMPORT => Some(Self::Import),
            ffi::GTK_CSS_PROVIDER_ERROR_NAME => Some(Self::Name),
            ffi::GTK_CSS_PROVIDER_ERROR_DEPRECATED => Some(Self::Deprecated),
            ffi::GTK_CSS_PROVIDER_ERROR_UNKNOWN_VALUE => Some(Self::UnknownValue),
            _ => Some(Self::Failed),
        }
    }
}

impl StaticType for CssProviderError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_css_provider_error_get_type()) }
    }
}

impl glib::value::ValueType for CssProviderError {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for CssProviderError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for CssProviderError {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkCssSectionType")]
pub enum CssSectionType {
    #[doc(alias = "GTK_CSS_SECTION_DOCUMENT")]
    Document,
    #[doc(alias = "GTK_CSS_SECTION_IMPORT")]
    Import,
    #[doc(alias = "GTK_CSS_SECTION_COLOR_DEFINITION")]
    ColorDefinition,
    #[doc(alias = "GTK_CSS_SECTION_BINDING_SET")]
    BindingSet,
    #[doc(alias = "GTK_CSS_SECTION_RULESET")]
    Ruleset,
    #[doc(alias = "GTK_CSS_SECTION_SELECTOR")]
    Selector,
    #[doc(alias = "GTK_CSS_SECTION_DECLARATION")]
    Declaration,
    #[doc(alias = "GTK_CSS_SECTION_VALUE")]
    Value,
    #[doc(alias = "GTK_CSS_SECTION_KEYFRAMES")]
    Keyframes,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for CssSectionType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "CssSectionType::{}",
            match *self {
                Self::Document => "Document",
                Self::Import => "Import",
                Self::ColorDefinition => "ColorDefinition",
                Self::BindingSet => "BindingSet",
                Self::Ruleset => "Ruleset",
                Self::Selector => "Selector",
                Self::Declaration => "Declaration",
                Self::Value => "Value",
                Self::Keyframes => "Keyframes",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for CssSectionType {
    type GlibType = ffi::GtkCssSectionType;

    fn into_glib(self) -> ffi::GtkCssSectionType {
        match self {
            Self::Document => ffi::GTK_CSS_SECTION_DOCUMENT,
            Self::Import => ffi::GTK_CSS_SECTION_IMPORT,
            Self::ColorDefinition => ffi::GTK_CSS_SECTION_COLOR_DEFINITION,
            Self::BindingSet => ffi::GTK_CSS_SECTION_BINDING_SET,
            Self::Ruleset => ffi::GTK_CSS_SECTION_RULESET,
            Self::Selector => ffi::GTK_CSS_SECTION_SELECTOR,
            Self::Declaration => ffi::GTK_CSS_SECTION_DECLARATION,
            Self::Value => ffi::GTK_CSS_SECTION_VALUE,
            Self::Keyframes => ffi::GTK_CSS_SECTION_KEYFRAMES,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkCssSectionType> for CssSectionType {
    unsafe fn from_glib(value: ffi::GtkCssSectionType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_CSS_SECTION_DOCUMENT => Self::Document,
            ffi::GTK_CSS_SECTION_IMPORT => Self::Import,
            ffi::GTK_CSS_SECTION_COLOR_DEFINITION => Self::ColorDefinition,
            ffi::GTK_CSS_SECTION_BINDING_SET => Self::BindingSet,
            ffi::GTK_CSS_SECTION_RULESET => Self::Ruleset,
            ffi::GTK_CSS_SECTION_SELECTOR => Self::Selector,
            ffi::GTK_CSS_SECTION_DECLARATION => Self::Declaration,
            ffi::GTK_CSS_SECTION_VALUE => Self::Value,
            ffi::GTK_CSS_SECTION_KEYFRAMES => Self::Keyframes,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for CssSectionType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_css_section_type_get_type()) }
    }
}

impl glib::value::ValueType for CssSectionType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for CssSectionType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for CssSectionType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkDeleteType")]
pub enum DeleteType {
    #[doc(alias = "GTK_DELETE_CHARS")]
    Chars,
    #[doc(alias = "GTK_DELETE_WORD_ENDS")]
    WordEnds,
    #[doc(alias = "GTK_DELETE_WORDS")]
    Words,
    #[doc(alias = "GTK_DELETE_DISPLAY_LINES")]
    DisplayLines,
    #[doc(alias = "GTK_DELETE_DISPLAY_LINE_ENDS")]
    DisplayLineEnds,
    #[doc(alias = "GTK_DELETE_PARAGRAPH_ENDS")]
    ParagraphEnds,
    #[doc(alias = "GTK_DELETE_PARAGRAPHS")]
    Paragraphs,
    #[doc(alias = "GTK_DELETE_WHITESPACE")]
    Whitespace,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for DeleteType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "DeleteType::{}",
            match *self {
                Self::Chars => "Chars",
                Self::WordEnds => "WordEnds",
                Self::Words => "Words",
                Self::DisplayLines => "DisplayLines",
                Self::DisplayLineEnds => "DisplayLineEnds",
                Self::ParagraphEnds => "ParagraphEnds",
                Self::Paragraphs => "Paragraphs",
                Self::Whitespace => "Whitespace",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for DeleteType {
    type GlibType = ffi::GtkDeleteType;

    fn into_glib(self) -> ffi::GtkDeleteType {
        match self {
            Self::Chars => ffi::GTK_DELETE_CHARS,
            Self::WordEnds => ffi::GTK_DELETE_WORD_ENDS,
            Self::Words => ffi::GTK_DELETE_WORDS,
            Self::DisplayLines => ffi::GTK_DELETE_DISPLAY_LINES,
            Self::DisplayLineEnds => ffi::GTK_DELETE_DISPLAY_LINE_ENDS,
            Self::ParagraphEnds => ffi::GTK_DELETE_PARAGRAPH_ENDS,
            Self::Paragraphs => ffi::GTK_DELETE_PARAGRAPHS,
            Self::Whitespace => ffi::GTK_DELETE_WHITESPACE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkDeleteType> for DeleteType {
    unsafe fn from_glib(value: ffi::GtkDeleteType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_DELETE_CHARS => Self::Chars,
            ffi::GTK_DELETE_WORD_ENDS => Self::WordEnds,
            ffi::GTK_DELETE_WORDS => Self::Words,
            ffi::GTK_DELETE_DISPLAY_LINES => Self::DisplayLines,
            ffi::GTK_DELETE_DISPLAY_LINE_ENDS => Self::DisplayLineEnds,
            ffi::GTK_DELETE_PARAGRAPH_ENDS => Self::ParagraphEnds,
            ffi::GTK_DELETE_PARAGRAPHS => Self::Paragraphs,
            ffi::GTK_DELETE_WHITESPACE => Self::Whitespace,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for DeleteType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_delete_type_get_type()) }
    }
}

impl glib::value::ValueType for DeleteType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for DeleteType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for DeleteType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkDirectionType")]
pub enum DirectionType {
    #[doc(alias = "GTK_DIR_TAB_FORWARD")]
    TabForward,
    #[doc(alias = "GTK_DIR_TAB_BACKWARD")]
    TabBackward,
    #[doc(alias = "GTK_DIR_UP")]
    Up,
    #[doc(alias = "GTK_DIR_DOWN")]
    Down,
    #[doc(alias = "GTK_DIR_LEFT")]
    Left,
    #[doc(alias = "GTK_DIR_RIGHT")]
    Right,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for DirectionType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "DirectionType::{}",
            match *self {
                Self::TabForward => "TabForward",
                Self::TabBackward => "TabBackward",
                Self::Up => "Up",
                Self::Down => "Down",
                Self::Left => "Left",
                Self::Right => "Right",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for DirectionType {
    type GlibType = ffi::GtkDirectionType;

    fn into_glib(self) -> ffi::GtkDirectionType {
        match self {
            Self::TabForward => ffi::GTK_DIR_TAB_FORWARD,
            Self::TabBackward => ffi::GTK_DIR_TAB_BACKWARD,
            Self::Up => ffi::GTK_DIR_UP,
            Self::Down => ffi::GTK_DIR_DOWN,
            Self::Left => ffi::GTK_DIR_LEFT,
            Self::Right => ffi::GTK_DIR_RIGHT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkDirectionType> for DirectionType {
    unsafe fn from_glib(value: ffi::GtkDirectionType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_DIR_TAB_FORWARD => Self::TabForward,
            ffi::GTK_DIR_TAB_BACKWARD => Self::TabBackward,
            ffi::GTK_DIR_UP => Self::Up,
            ffi::GTK_DIR_DOWN => Self::Down,
            ffi::GTK_DIR_LEFT => Self::Left,
            ffi::GTK_DIR_RIGHT => Self::Right,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for DirectionType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_direction_type_get_type()) }
    }
}

impl glib::value::ValueType for DirectionType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for DirectionType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for DirectionType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkDragResult")]
pub enum DragResult {
    #[doc(alias = "GTK_DRAG_RESULT_SUCCESS")]
    Success,
    #[doc(alias = "GTK_DRAG_RESULT_NO_TARGET")]
    NoTarget,
    #[doc(alias = "GTK_DRAG_RESULT_USER_CANCELLED")]
    UserCancelled,
    #[doc(alias = "GTK_DRAG_RESULT_TIMEOUT_EXPIRED")]
    TimeoutExpired,
    #[doc(alias = "GTK_DRAG_RESULT_GRAB_BROKEN")]
    GrabBroken,
    #[doc(alias = "GTK_DRAG_RESULT_ERROR")]
    Error,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for DragResult {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "DragResult::{}",
            match *self {
                Self::Success => "Success",
                Self::NoTarget => "NoTarget",
                Self::UserCancelled => "UserCancelled",
                Self::TimeoutExpired => "TimeoutExpired",
                Self::GrabBroken => "GrabBroken",
                Self::Error => "Error",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for DragResult {
    type GlibType = ffi::GtkDragResult;

    fn into_glib(self) -> ffi::GtkDragResult {
        match self {
            Self::Success => ffi::GTK_DRAG_RESULT_SUCCESS,
            Self::NoTarget => ffi::GTK_DRAG_RESULT_NO_TARGET,
            Self::UserCancelled => ffi::GTK_DRAG_RESULT_USER_CANCELLED,
            Self::TimeoutExpired => ffi::GTK_DRAG_RESULT_TIMEOUT_EXPIRED,
            Self::GrabBroken => ffi::GTK_DRAG_RESULT_GRAB_BROKEN,
            Self::Error => ffi::GTK_DRAG_RESULT_ERROR,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkDragResult> for DragResult {
    unsafe fn from_glib(value: ffi::GtkDragResult) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_DRAG_RESULT_SUCCESS => Self::Success,
            ffi::GTK_DRAG_RESULT_NO_TARGET => Self::NoTarget,
            ffi::GTK_DRAG_RESULT_USER_CANCELLED => Self::UserCancelled,
            ffi::GTK_DRAG_RESULT_TIMEOUT_EXPIRED => Self::TimeoutExpired,
            ffi::GTK_DRAG_RESULT_GRAB_BROKEN => Self::GrabBroken,
            ffi::GTK_DRAG_RESULT_ERROR => Self::Error,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for DragResult {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_drag_result_get_type()) }
    }
}

impl glib::value::ValueType for DragResult {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for DragResult {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for DragResult {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkEntryIconPosition")]
pub enum EntryIconPosition {
    #[doc(alias = "GTK_ENTRY_ICON_PRIMARY")]
    Primary,
    #[doc(alias = "GTK_ENTRY_ICON_SECONDARY")]
    Secondary,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for EntryIconPosition {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "EntryIconPosition::{}",
            match *self {
                Self::Primary => "Primary",
                Self::Secondary => "Secondary",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for EntryIconPosition {
    type GlibType = ffi::GtkEntryIconPosition;

    fn into_glib(self) -> ffi::GtkEntryIconPosition {
        match self {
            Self::Primary => ffi::GTK_ENTRY_ICON_PRIMARY,
            Self::Secondary => ffi::GTK_ENTRY_ICON_SECONDARY,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkEntryIconPosition> for EntryIconPosition {
    unsafe fn from_glib(value: ffi::GtkEntryIconPosition) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_ENTRY_ICON_PRIMARY => Self::Primary,
            ffi::GTK_ENTRY_ICON_SECONDARY => Self::Secondary,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for EntryIconPosition {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_entry_icon_position_get_type()) }
    }
}

impl glib::value::ValueType for EntryIconPosition {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for EntryIconPosition {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for EntryIconPosition {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkEventSequenceState")]
pub enum EventSequenceState {
    #[doc(alias = "GTK_EVENT_SEQUENCE_NONE")]
    None,
    #[doc(alias = "GTK_EVENT_SEQUENCE_CLAIMED")]
    Claimed,
    #[doc(alias = "GTK_EVENT_SEQUENCE_DENIED")]
    Denied,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for EventSequenceState {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "EventSequenceState::{}",
            match *self {
                Self::None => "None",
                Self::Claimed => "Claimed",
                Self::Denied => "Denied",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for EventSequenceState {
    type GlibType = ffi::GtkEventSequenceState;

    fn into_glib(self) -> ffi::GtkEventSequenceState {
        match self {
            Self::None => ffi::GTK_EVENT_SEQUENCE_NONE,
            Self::Claimed => ffi::GTK_EVENT_SEQUENCE_CLAIMED,
            Self::Denied => ffi::GTK_EVENT_SEQUENCE_DENIED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkEventSequenceState> for EventSequenceState {
    unsafe fn from_glib(value: ffi::GtkEventSequenceState) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_EVENT_SEQUENCE_NONE => Self::None,
            ffi::GTK_EVENT_SEQUENCE_CLAIMED => Self::Claimed,
            ffi::GTK_EVENT_SEQUENCE_DENIED => Self::Denied,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for EventSequenceState {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_event_sequence_state_get_type()) }
    }
}

impl glib::value::ValueType for EventSequenceState {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for EventSequenceState {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for EventSequenceState {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkFileChooserAction")]
pub enum FileChooserAction {
    #[doc(alias = "GTK_FILE_CHOOSER_ACTION_OPEN")]
    Open,
    #[doc(alias = "GTK_FILE_CHOOSER_ACTION_SAVE")]
    Save,
    #[doc(alias = "GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER")]
    SelectFolder,
    #[doc(alias = "GTK_FILE_CHOOSER_ACTION_CREATE_FOLDER")]
    CreateFolder,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for FileChooserAction {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "FileChooserAction::{}",
            match *self {
                Self::Open => "Open",
                Self::Save => "Save",
                Self::SelectFolder => "SelectFolder",
                Self::CreateFolder => "CreateFolder",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for FileChooserAction {
    type GlibType = ffi::GtkFileChooserAction;

    fn into_glib(self) -> ffi::GtkFileChooserAction {
        match self {
            Self::Open => ffi::GTK_FILE_CHOOSER_ACTION_OPEN,
            Self::Save => ffi::GTK_FILE_CHOOSER_ACTION_SAVE,
            Self::SelectFolder => ffi::GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER,
            Self::CreateFolder => ffi::GTK_FILE_CHOOSER_ACTION_CREATE_FOLDER,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkFileChooserAction> for FileChooserAction {
    unsafe fn from_glib(value: ffi::GtkFileChooserAction) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_FILE_CHOOSER_ACTION_OPEN => Self::Open,
            ffi::GTK_FILE_CHOOSER_ACTION_SAVE => Self::Save,
            ffi::GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER => Self::SelectFolder,
            ffi::GTK_FILE_CHOOSER_ACTION_CREATE_FOLDER => Self::CreateFolder,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for FileChooserAction {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_file_chooser_action_get_type()) }
    }
}

impl glib::value::ValueType for FileChooserAction {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for FileChooserAction {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for FileChooserAction {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkFileChooserConfirmation")]
pub enum FileChooserConfirmation {
    #[doc(alias = "GTK_FILE_CHOOSER_CONFIRMATION_CONFIRM")]
    Confirm,
    #[doc(alias = "GTK_FILE_CHOOSER_CONFIRMATION_ACCEPT_FILENAME")]
    AcceptFilename,
    #[doc(alias = "GTK_FILE_CHOOSER_CONFIRMATION_SELECT_AGAIN")]
    SelectAgain,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for FileChooserConfirmation {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "FileChooserConfirmation::{}",
            match *self {
                Self::Confirm => "Confirm",
                Self::AcceptFilename => "AcceptFilename",
                Self::SelectAgain => "SelectAgain",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for FileChooserConfirmation {
    type GlibType = ffi::GtkFileChooserConfirmation;

    fn into_glib(self) -> ffi::GtkFileChooserConfirmation {
        match self {
            Self::Confirm => ffi::GTK_FILE_CHOOSER_CONFIRMATION_CONFIRM,
            Self::AcceptFilename => ffi::GTK_FILE_CHOOSER_CONFIRMATION_ACCEPT_FILENAME,
            Self::SelectAgain => ffi::GTK_FILE_CHOOSER_CONFIRMATION_SELECT_AGAIN,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkFileChooserConfirmation> for FileChooserConfirmation {
    unsafe fn from_glib(value: ffi::GtkFileChooserConfirmation) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_FILE_CHOOSER_CONFIRMATION_CONFIRM => Self::Confirm,
            ffi::GTK_FILE_CHOOSER_CONFIRMATION_ACCEPT_FILENAME => Self::AcceptFilename,
            ffi::GTK_FILE_CHOOSER_CONFIRMATION_SELECT_AGAIN => Self::SelectAgain,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for FileChooserConfirmation {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_file_chooser_confirmation_get_type()) }
    }
}

impl glib::value::ValueType for FileChooserConfirmation {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for FileChooserConfirmation {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for FileChooserConfirmation {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkFileChooserError")]
pub enum FileChooserError {
    #[doc(alias = "GTK_FILE_CHOOSER_ERROR_NONEXISTENT")]
    Nonexistent,
    #[doc(alias = "GTK_FILE_CHOOSER_ERROR_BAD_FILENAME")]
    BadFilename,
    #[doc(alias = "GTK_FILE_CHOOSER_ERROR_ALREADY_EXISTS")]
    AlreadyExists,
    #[doc(alias = "GTK_FILE_CHOOSER_ERROR_INCOMPLETE_HOSTNAME")]
    IncompleteHostname,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for FileChooserError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "FileChooserError::{}",
            match *self {
                Self::Nonexistent => "Nonexistent",
                Self::BadFilename => "BadFilename",
                Self::AlreadyExists => "AlreadyExists",
                Self::IncompleteHostname => "IncompleteHostname",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for FileChooserError {
    type GlibType = ffi::GtkFileChooserError;

    fn into_glib(self) -> ffi::GtkFileChooserError {
        match self {
            Self::Nonexistent => ffi::GTK_FILE_CHOOSER_ERROR_NONEXISTENT,
            Self::BadFilename => ffi::GTK_FILE_CHOOSER_ERROR_BAD_FILENAME,
            Self::AlreadyExists => ffi::GTK_FILE_CHOOSER_ERROR_ALREADY_EXISTS,
            Self::IncompleteHostname => ffi::GTK_FILE_CHOOSER_ERROR_INCOMPLETE_HOSTNAME,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkFileChooserError> for FileChooserError {
    unsafe fn from_glib(value: ffi::GtkFileChooserError) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_FILE_CHOOSER_ERROR_NONEXISTENT => Self::Nonexistent,
            ffi::GTK_FILE_CHOOSER_ERROR_BAD_FILENAME => Self::BadFilename,
            ffi::GTK_FILE_CHOOSER_ERROR_ALREADY_EXISTS => Self::AlreadyExists,
            ffi::GTK_FILE_CHOOSER_ERROR_INCOMPLETE_HOSTNAME => Self::IncompleteHostname,
            value => Self::__Unknown(value),
        }
    }
}

impl ErrorDomain for FileChooserError {
    fn domain() -> Quark {
        skip_assert_initialized!();

        unsafe { from_glib(ffi::gtk_file_chooser_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            ffi::GTK_FILE_CHOOSER_ERROR_NONEXISTENT => Some(Self::Nonexistent),
            ffi::GTK_FILE_CHOOSER_ERROR_BAD_FILENAME => Some(Self::BadFilename),
            ffi::GTK_FILE_CHOOSER_ERROR_ALREADY_EXISTS => Some(Self::AlreadyExists),
            ffi::GTK_FILE_CHOOSER_ERROR_INCOMPLETE_HOSTNAME => Some(Self::IncompleteHostname),
            value => Some(Self::__Unknown(value)),
        }
    }
}

impl StaticType for FileChooserError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_file_chooser_error_get_type()) }
    }
}

impl glib::value::ValueType for FileChooserError {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for FileChooserError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for FileChooserError {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkIconSize")]
pub enum IconSize {
    #[doc(alias = "GTK_ICON_SIZE_INVALID")]
    Invalid,
    #[doc(alias = "GTK_ICON_SIZE_MENU")]
    Menu,
    #[doc(alias = "GTK_ICON_SIZE_SMALL_TOOLBAR")]
    SmallToolbar,
    #[doc(alias = "GTK_ICON_SIZE_LARGE_TOOLBAR")]
    LargeToolbar,
    #[doc(alias = "GTK_ICON_SIZE_BUTTON")]
    Button,
    #[doc(alias = "GTK_ICON_SIZE_DND")]
    Dnd,
    #[doc(alias = "GTK_ICON_SIZE_DIALOG")]
    Dialog,
    #[doc(hidden)]
    __Unknown(i32),
}

impl IconSize {
    #[doc(alias = "gtk_icon_size_lookup")]
    pub fn lookup(self) -> Option<(i32, i32)> {
        assert_initialized_main_thread!();
        unsafe {
            let mut width = mem::MaybeUninit::uninit();
            let mut height = mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gtk_icon_size_lookup(
                self.into_glib(),
                width.as_mut_ptr(),
                height.as_mut_ptr(),
            ));
            let width = width.assume_init();
            let height = height.assume_init();
            if ret {
                Some((width, height))
            } else {
                None
            }
        }
    }
}

impl fmt::Display for IconSize {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "IconSize::{}",
            match *self {
                Self::Invalid => "Invalid",
                Self::Menu => "Menu",
                Self::SmallToolbar => "SmallToolbar",
                Self::LargeToolbar => "LargeToolbar",
                Self::Button => "Button",
                Self::Dnd => "Dnd",
                Self::Dialog => "Dialog",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for IconSize {
    type GlibType = ffi::GtkIconSize;

    fn into_glib(self) -> ffi::GtkIconSize {
        match self {
            Self::Invalid => ffi::GTK_ICON_SIZE_INVALID,
            Self::Menu => ffi::GTK_ICON_SIZE_MENU,
            Self::SmallToolbar => ffi::GTK_ICON_SIZE_SMALL_TOOLBAR,
            Self::LargeToolbar => ffi::GTK_ICON_SIZE_LARGE_TOOLBAR,
            Self::Button => ffi::GTK_ICON_SIZE_BUTTON,
            Self::Dnd => ffi::GTK_ICON_SIZE_DND,
            Self::Dialog => ffi::GTK_ICON_SIZE_DIALOG,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkIconSize> for IconSize {
    unsafe fn from_glib(value: ffi::GtkIconSize) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_ICON_SIZE_INVALID => Self::Invalid,
            ffi::GTK_ICON_SIZE_MENU => Self::Menu,
            ffi::GTK_ICON_SIZE_SMALL_TOOLBAR => Self::SmallToolbar,
            ffi::GTK_ICON_SIZE_LARGE_TOOLBAR => Self::LargeToolbar,
            ffi::GTK_ICON_SIZE_BUTTON => Self::Button,
            ffi::GTK_ICON_SIZE_DND => Self::Dnd,
            ffi::GTK_ICON_SIZE_DIALOG => Self::Dialog,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for IconSize {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_icon_size_get_type()) }
    }
}

impl glib::value::ValueType for IconSize {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for IconSize {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for IconSize {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkIconThemeError")]
pub enum IconThemeError {
    #[doc(alias = "GTK_ICON_THEME_NOT_FOUND")]
    NotFound,
    #[doc(alias = "GTK_ICON_THEME_FAILED")]
    Failed,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for IconThemeError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "IconThemeError::{}",
            match *self {
                Self::NotFound => "NotFound",
                Self::Failed => "Failed",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for IconThemeError {
    type GlibType = ffi::GtkIconThemeError;

    fn into_glib(self) -> ffi::GtkIconThemeError {
        match self {
            Self::NotFound => ffi::GTK_ICON_THEME_NOT_FOUND,
            Self::Failed => ffi::GTK_ICON_THEME_FAILED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkIconThemeError> for IconThemeError {
    unsafe fn from_glib(value: ffi::GtkIconThemeError) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_ICON_THEME_NOT_FOUND => Self::NotFound,
            ffi::GTK_ICON_THEME_FAILED => Self::Failed,
            value => Self::__Unknown(value),
        }
    }
}

impl ErrorDomain for IconThemeError {
    fn domain() -> Quark {
        skip_assert_initialized!();

        unsafe { from_glib(ffi::gtk_icon_theme_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            ffi::GTK_ICON_THEME_NOT_FOUND => Some(Self::NotFound),
            ffi::GTK_ICON_THEME_FAILED => Some(Self::Failed),
            _ => Some(Self::Failed),
        }
    }
}

impl StaticType for IconThemeError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_icon_theme_error_get_type()) }
    }
}

impl glib::value::ValueType for IconThemeError {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for IconThemeError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for IconThemeError {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkIconViewDropPosition")]
pub enum IconViewDropPosition {
    #[doc(alias = "GTK_ICON_VIEW_NO_DROP")]
    NoDrop,
    #[doc(alias = "GTK_ICON_VIEW_DROP_INTO")]
    DropInto,
    #[doc(alias = "GTK_ICON_VIEW_DROP_LEFT")]
    DropLeft,
    #[doc(alias = "GTK_ICON_VIEW_DROP_RIGHT")]
    DropRight,
    #[doc(alias = "GTK_ICON_VIEW_DROP_ABOVE")]
    DropAbove,
    #[doc(alias = "GTK_ICON_VIEW_DROP_BELOW")]
    DropBelow,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for IconViewDropPosition {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "IconViewDropPosition::{}",
            match *self {
                Self::NoDrop => "NoDrop",
                Self::DropInto => "DropInto",
                Self::DropLeft => "DropLeft",
                Self::DropRight => "DropRight",
                Self::DropAbove => "DropAbove",
                Self::DropBelow => "DropBelow",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for IconViewDropPosition {
    type GlibType = ffi::GtkIconViewDropPosition;

    fn into_glib(self) -> ffi::GtkIconViewDropPosition {
        match self {
            Self::NoDrop => ffi::GTK_ICON_VIEW_NO_DROP,
            Self::DropInto => ffi::GTK_ICON_VIEW_DROP_INTO,
            Self::DropLeft => ffi::GTK_ICON_VIEW_DROP_LEFT,
            Self::DropRight => ffi::GTK_ICON_VIEW_DROP_RIGHT,
            Self::DropAbove => ffi::GTK_ICON_VIEW_DROP_ABOVE,
            Self::DropBelow => ffi::GTK_ICON_VIEW_DROP_BELOW,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkIconViewDropPosition> for IconViewDropPosition {
    unsafe fn from_glib(value: ffi::GtkIconViewDropPosition) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_ICON_VIEW_NO_DROP => Self::NoDrop,
            ffi::GTK_ICON_VIEW_DROP_INTO => Self::DropInto,
            ffi::GTK_ICON_VIEW_DROP_LEFT => Self::DropLeft,
            ffi::GTK_ICON_VIEW_DROP_RIGHT => Self::DropRight,
            ffi::GTK_ICON_VIEW_DROP_ABOVE => Self::DropAbove,
            ffi::GTK_ICON_VIEW_DROP_BELOW => Self::DropBelow,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for IconViewDropPosition {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_icon_view_drop_position_get_type()) }
    }
}

impl glib::value::ValueType for IconViewDropPosition {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for IconViewDropPosition {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for IconViewDropPosition {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkImageType")]
pub enum ImageType {
    #[doc(alias = "GTK_IMAGE_EMPTY")]
    Empty,
    #[doc(alias = "GTK_IMAGE_PIXBUF")]
    Pixbuf,
    #[doc(alias = "GTK_IMAGE_STOCK")]
    Stock,
    #[doc(alias = "GTK_IMAGE_ICON_SET")]
    IconSet,
    #[doc(alias = "GTK_IMAGE_ANIMATION")]
    Animation,
    #[doc(alias = "GTK_IMAGE_ICON_NAME")]
    IconName,
    #[doc(alias = "GTK_IMAGE_GICON")]
    Gicon,
    #[doc(alias = "GTK_IMAGE_SURFACE")]
    Surface,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for ImageType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "ImageType::{}",
            match *self {
                Self::Empty => "Empty",
                Self::Pixbuf => "Pixbuf",
                Self::Stock => "Stock",
                Self::IconSet => "IconSet",
                Self::Animation => "Animation",
                Self::IconName => "IconName",
                Self::Gicon => "Gicon",
                Self::Surface => "Surface",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for ImageType {
    type GlibType = ffi::GtkImageType;

    fn into_glib(self) -> ffi::GtkImageType {
        match self {
            Self::Empty => ffi::GTK_IMAGE_EMPTY,
            Self::Pixbuf => ffi::GTK_IMAGE_PIXBUF,
            Self::Stock => ffi::GTK_IMAGE_STOCK,
            Self::IconSet => ffi::GTK_IMAGE_ICON_SET,
            Self::Animation => ffi::GTK_IMAGE_ANIMATION,
            Self::IconName => ffi::GTK_IMAGE_ICON_NAME,
            Self::Gicon => ffi::GTK_IMAGE_GICON,
            Self::Surface => ffi::GTK_IMAGE_SURFACE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkImageType> for ImageType {
    unsafe fn from_glib(value: ffi::GtkImageType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_IMAGE_EMPTY => Self::Empty,
            ffi::GTK_IMAGE_PIXBUF => Self::Pixbuf,
            ffi::GTK_IMAGE_STOCK => Self::Stock,
            ffi::GTK_IMAGE_ICON_SET => Self::IconSet,
            ffi::GTK_IMAGE_ANIMATION => Self::Animation,
            ffi::GTK_IMAGE_ICON_NAME => Self::IconName,
            ffi::GTK_IMAGE_GICON => Self::Gicon,
            ffi::GTK_IMAGE_SURFACE => Self::Surface,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for ImageType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_image_type_get_type()) }
    }
}

impl glib::value::ValueType for ImageType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for ImageType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ImageType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkInputPurpose")]
pub enum InputPurpose {
    #[doc(alias = "GTK_INPUT_PURPOSE_FREE_FORM")]
    FreeForm,
    #[doc(alias = "GTK_INPUT_PURPOSE_ALPHA")]
    Alpha,
    #[doc(alias = "GTK_INPUT_PURPOSE_DIGITS")]
    Digits,
    #[doc(alias = "GTK_INPUT_PURPOSE_NUMBER")]
    Number,
    #[doc(alias = "GTK_INPUT_PURPOSE_PHONE")]
    Phone,
    #[doc(alias = "GTK_INPUT_PURPOSE_URL")]
    Url,
    #[doc(alias = "GTK_INPUT_PURPOSE_EMAIL")]
    Email,
    #[doc(alias = "GTK_INPUT_PURPOSE_NAME")]
    Name,
    #[doc(alias = "GTK_INPUT_PURPOSE_PASSWORD")]
    Password,
    #[doc(alias = "GTK_INPUT_PURPOSE_PIN")]
    Pin,
    #[doc(alias = "GTK_INPUT_PURPOSE_TERMINAL")]
    Terminal,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for InputPurpose {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "InputPurpose::{}",
            match *self {
                Self::FreeForm => "FreeForm",
                Self::Alpha => "Alpha",
                Self::Digits => "Digits",
                Self::Number => "Number",
                Self::Phone => "Phone",
                Self::Url => "Url",
                Self::Email => "Email",
                Self::Name => "Name",
                Self::Password => "Password",
                Self::Pin => "Pin",
                Self::Terminal => "Terminal",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for InputPurpose {
    type GlibType = ffi::GtkInputPurpose;

    fn into_glib(self) -> ffi::GtkInputPurpose {
        match self {
            Self::FreeForm => ffi::GTK_INPUT_PURPOSE_FREE_FORM,
            Self::Alpha => ffi::GTK_INPUT_PURPOSE_ALPHA,
            Self::Digits => ffi::GTK_INPUT_PURPOSE_DIGITS,
            Self::Number => ffi::GTK_INPUT_PURPOSE_NUMBER,
            Self::Phone => ffi::GTK_INPUT_PURPOSE_PHONE,
            Self::Url => ffi::GTK_INPUT_PURPOSE_URL,
            Self::Email => ffi::GTK_INPUT_PURPOSE_EMAIL,
            Self::Name => ffi::GTK_INPUT_PURPOSE_NAME,
            Self::Password => ffi::GTK_INPUT_PURPOSE_PASSWORD,
            Self::Pin => ffi::GTK_INPUT_PURPOSE_PIN,
            Self::Terminal => ffi::GTK_INPUT_PURPOSE_TERMINAL,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkInputPurpose> for InputPurpose {
    unsafe fn from_glib(value: ffi::GtkInputPurpose) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_INPUT_PURPOSE_FREE_FORM => Self::FreeForm,
            ffi::GTK_INPUT_PURPOSE_ALPHA => Self::Alpha,
            ffi::GTK_INPUT_PURPOSE_DIGITS => Self::Digits,
            ffi::GTK_INPUT_PURPOSE_NUMBER => Self::Number,
            ffi::GTK_INPUT_PURPOSE_PHONE => Self::Phone,
            ffi::GTK_INPUT_PURPOSE_URL => Self::Url,
            ffi::GTK_INPUT_PURPOSE_EMAIL => Self::Email,
            ffi::GTK_INPUT_PURPOSE_NAME => Self::Name,
            ffi::GTK_INPUT_PURPOSE_PASSWORD => Self::Password,
            ffi::GTK_INPUT_PURPOSE_PIN => Self::Pin,
            ffi::GTK_INPUT_PURPOSE_TERMINAL => Self::Terminal,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for InputPurpose {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_input_purpose_get_type()) }
    }
}

impl glib::value::ValueType for InputPurpose {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for InputPurpose {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for InputPurpose {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkJustification")]
pub enum Justification {
    #[doc(alias = "GTK_JUSTIFY_LEFT")]
    Left,
    #[doc(alias = "GTK_JUSTIFY_RIGHT")]
    Right,
    #[doc(alias = "GTK_JUSTIFY_CENTER")]
    Center,
    #[doc(alias = "GTK_JUSTIFY_FILL")]
    Fill,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Justification {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Justification::{}",
            match *self {
                Self::Left => "Left",
                Self::Right => "Right",
                Self::Center => "Center",
                Self::Fill => "Fill",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for Justification {
    type GlibType = ffi::GtkJustification;

    fn into_glib(self) -> ffi::GtkJustification {
        match self {
            Self::Left => ffi::GTK_JUSTIFY_LEFT,
            Self::Right => ffi::GTK_JUSTIFY_RIGHT,
            Self::Center => ffi::GTK_JUSTIFY_CENTER,
            Self::Fill => ffi::GTK_JUSTIFY_FILL,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkJustification> for Justification {
    unsafe fn from_glib(value: ffi::GtkJustification) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_JUSTIFY_LEFT => Self::Left,
            ffi::GTK_JUSTIFY_RIGHT => Self::Right,
            ffi::GTK_JUSTIFY_CENTER => Self::Center,
            ffi::GTK_JUSTIFY_FILL => Self::Fill,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for Justification {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_justification_get_type()) }
    }
}

impl glib::value::ValueType for Justification {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for Justification {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for Justification {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkLevelBarMode")]
pub enum LevelBarMode {
    #[doc(alias = "GTK_LEVEL_BAR_MODE_CONTINUOUS")]
    Continuous,
    #[doc(alias = "GTK_LEVEL_BAR_MODE_DISCRETE")]
    Discrete,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for LevelBarMode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "LevelBarMode::{}",
            match *self {
                Self::Continuous => "Continuous",
                Self::Discrete => "Discrete",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for LevelBarMode {
    type GlibType = ffi::GtkLevelBarMode;

    fn into_glib(self) -> ffi::GtkLevelBarMode {
        match self {
            Self::Continuous => ffi::GTK_LEVEL_BAR_MODE_CONTINUOUS,
            Self::Discrete => ffi::GTK_LEVEL_BAR_MODE_DISCRETE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkLevelBarMode> for LevelBarMode {
    unsafe fn from_glib(value: ffi::GtkLevelBarMode) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_LEVEL_BAR_MODE_CONTINUOUS => Self::Continuous,
            ffi::GTK_LEVEL_BAR_MODE_DISCRETE => Self::Discrete,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for LevelBarMode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_level_bar_mode_get_type()) }
    }
}

impl glib::value::ValueType for LevelBarMode {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for LevelBarMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for LevelBarMode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkLicense")]
pub enum License {
    #[doc(alias = "GTK_LICENSE_UNKNOWN")]
    Unknown,
    #[doc(alias = "GTK_LICENSE_CUSTOM")]
    Custom,
    #[doc(alias = "GTK_LICENSE_GPL_2_0")]
    Gpl20,
    #[doc(alias = "GTK_LICENSE_GPL_3_0")]
    Gpl30,
    #[doc(alias = "GTK_LICENSE_LGPL_2_1")]
    Lgpl21,
    #[doc(alias = "GTK_LICENSE_LGPL_3_0")]
    Lgpl30,
    #[doc(alias = "GTK_LICENSE_BSD")]
    Bsd,
    #[doc(alias = "GTK_LICENSE_MIT_X11")]
    MitX11,
    #[doc(alias = "GTK_LICENSE_ARTISTIC")]
    Artistic,
    #[doc(alias = "GTK_LICENSE_GPL_2_0_ONLY")]
    Gpl20Only,
    #[doc(alias = "GTK_LICENSE_GPL_3_0_ONLY")]
    Gpl30Only,
    #[doc(alias = "GTK_LICENSE_LGPL_2_1_ONLY")]
    Lgpl21Only,
    #[doc(alias = "GTK_LICENSE_LGPL_3_0_ONLY")]
    Lgpl30Only,
    #[doc(alias = "GTK_LICENSE_AGPL_3_0")]
    Agpl30,
    #[doc(alias = "GTK_LICENSE_AGPL_3_0_ONLY")]
    Agpl30Only,
    #[doc(alias = "GTK_LICENSE_BSD_3")]
    Bsd3,
    #[doc(alias = "GTK_LICENSE_APACHE_2_0")]
    Apache20,
    #[doc(alias = "GTK_LICENSE_MPL_2_0")]
    Mpl20,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for License {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "License::{}",
            match *self {
                Self::Unknown => "Unknown",
                Self::Custom => "Custom",
                Self::Gpl20 => "Gpl20",
                Self::Gpl30 => "Gpl30",
                Self::Lgpl21 => "Lgpl21",
                Self::Lgpl30 => "Lgpl30",
                Self::Bsd => "Bsd",
                Self::MitX11 => "MitX11",
                Self::Artistic => "Artistic",
                Self::Gpl20Only => "Gpl20Only",
                Self::Gpl30Only => "Gpl30Only",
                Self::Lgpl21Only => "Lgpl21Only",
                Self::Lgpl30Only => "Lgpl30Only",
                Self::Agpl30 => "Agpl30",
                Self::Agpl30Only => "Agpl30Only",
                Self::Bsd3 => "Bsd3",
                Self::Apache20 => "Apache20",
                Self::Mpl20 => "Mpl20",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for License {
    type GlibType = ffi::GtkLicense;

    fn into_glib(self) -> ffi::GtkLicense {
        match self {
            Self::Unknown => ffi::GTK_LICENSE_UNKNOWN,
            Self::Custom => ffi::GTK_LICENSE_CUSTOM,
            Self::Gpl20 => ffi::GTK_LICENSE_GPL_2_0,
            Self::Gpl30 => ffi::GTK_LICENSE_GPL_3_0,
            Self::Lgpl21 => ffi::GTK_LICENSE_LGPL_2_1,
            Self::Lgpl30 => ffi::GTK_LICENSE_LGPL_3_0,
            Self::Bsd => ffi::GTK_LICENSE_BSD,
            Self::MitX11 => ffi::GTK_LICENSE_MIT_X11,
            Self::Artistic => ffi::GTK_LICENSE_ARTISTIC,
            Self::Gpl20Only => ffi::GTK_LICENSE_GPL_2_0_ONLY,
            Self::Gpl30Only => ffi::GTK_LICENSE_GPL_3_0_ONLY,
            Self::Lgpl21Only => ffi::GTK_LICENSE_LGPL_2_1_ONLY,
            Self::Lgpl30Only => ffi::GTK_LICENSE_LGPL_3_0_ONLY,
            Self::Agpl30 => ffi::GTK_LICENSE_AGPL_3_0,
            Self::Agpl30Only => ffi::GTK_LICENSE_AGPL_3_0_ONLY,
            Self::Bsd3 => ffi::GTK_LICENSE_BSD_3,
            Self::Apache20 => ffi::GTK_LICENSE_APACHE_2_0,
            Self::Mpl20 => ffi::GTK_LICENSE_MPL_2_0,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkLicense> for License {
    unsafe fn from_glib(value: ffi::GtkLicense) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_LICENSE_UNKNOWN => Self::Unknown,
            ffi::GTK_LICENSE_CUSTOM => Self::Custom,
            ffi::GTK_LICENSE_GPL_2_0 => Self::Gpl20,
            ffi::GTK_LICENSE_GPL_3_0 => Self::Gpl30,
            ffi::GTK_LICENSE_LGPL_2_1 => Self::Lgpl21,
            ffi::GTK_LICENSE_LGPL_3_0 => Self::Lgpl30,
            ffi::GTK_LICENSE_BSD => Self::Bsd,
            ffi::GTK_LICENSE_MIT_X11 => Self::MitX11,
            ffi::GTK_LICENSE_ARTISTIC => Self::Artistic,
            ffi::GTK_LICENSE_GPL_2_0_ONLY => Self::Gpl20Only,
            ffi::GTK_LICENSE_GPL_3_0_ONLY => Self::Gpl30Only,
            ffi::GTK_LICENSE_LGPL_2_1_ONLY => Self::Lgpl21Only,
            ffi::GTK_LICENSE_LGPL_3_0_ONLY => Self::Lgpl30Only,
            ffi::GTK_LICENSE_AGPL_3_0 => Self::Agpl30,
            ffi::GTK_LICENSE_AGPL_3_0_ONLY => Self::Agpl30Only,
            ffi::GTK_LICENSE_BSD_3 => Self::Bsd3,
            ffi::GTK_LICENSE_APACHE_2_0 => Self::Apache20,
            ffi::GTK_LICENSE_MPL_2_0 => Self::Mpl20,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for License {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_license_get_type()) }
    }
}

impl glib::value::ValueType for License {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for License {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for License {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkMenuDirectionType")]
pub enum MenuDirectionType {
    #[doc(alias = "GTK_MENU_DIR_PARENT")]
    Parent,
    #[doc(alias = "GTK_MENU_DIR_CHILD")]
    Child,
    #[doc(alias = "GTK_MENU_DIR_NEXT")]
    Next,
    #[doc(alias = "GTK_MENU_DIR_PREV")]
    Prev,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for MenuDirectionType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "MenuDirectionType::{}",
            match *self {
                Self::Parent => "Parent",
                Self::Child => "Child",
                Self::Next => "Next",
                Self::Prev => "Prev",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for MenuDirectionType {
    type GlibType = ffi::GtkMenuDirectionType;

    fn into_glib(self) -> ffi::GtkMenuDirectionType {
        match self {
            Self::Parent => ffi::GTK_MENU_DIR_PARENT,
            Self::Child => ffi::GTK_MENU_DIR_CHILD,
            Self::Next => ffi::GTK_MENU_DIR_NEXT,
            Self::Prev => ffi::GTK_MENU_DIR_PREV,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkMenuDirectionType> for MenuDirectionType {
    unsafe fn from_glib(value: ffi::GtkMenuDirectionType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_MENU_DIR_PARENT => Self::Parent,
            ffi::GTK_MENU_DIR_CHILD => Self::Child,
            ffi::GTK_MENU_DIR_NEXT => Self::Next,
            ffi::GTK_MENU_DIR_PREV => Self::Prev,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for MenuDirectionType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_menu_direction_type_get_type()) }
    }
}

impl glib::value::ValueType for MenuDirectionType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for MenuDirectionType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for MenuDirectionType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkMessageType")]
pub enum MessageType {
    #[doc(alias = "GTK_MESSAGE_INFO")]
    Info,
    #[doc(alias = "GTK_MESSAGE_WARNING")]
    Warning,
    #[doc(alias = "GTK_MESSAGE_QUESTION")]
    Question,
    #[doc(alias = "GTK_MESSAGE_ERROR")]
    Error,
    #[doc(alias = "GTK_MESSAGE_OTHER")]
    Other,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for MessageType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "MessageType::{}",
            match *self {
                Self::Info => "Info",
                Self::Warning => "Warning",
                Self::Question => "Question",
                Self::Error => "Error",
                Self::Other => "Other",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for MessageType {
    type GlibType = ffi::GtkMessageType;

    fn into_glib(self) -> ffi::GtkMessageType {
        match self {
            Self::Info => ffi::GTK_MESSAGE_INFO,
            Self::Warning => ffi::GTK_MESSAGE_WARNING,
            Self::Question => ffi::GTK_MESSAGE_QUESTION,
            Self::Error => ffi::GTK_MESSAGE_ERROR,
            Self::Other => ffi::GTK_MESSAGE_OTHER,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkMessageType> for MessageType {
    unsafe fn from_glib(value: ffi::GtkMessageType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_MESSAGE_INFO => Self::Info,
            ffi::GTK_MESSAGE_WARNING => Self::Warning,
            ffi::GTK_MESSAGE_QUESTION => Self::Question,
            ffi::GTK_MESSAGE_ERROR => Self::Error,
            ffi::GTK_MESSAGE_OTHER => Self::Other,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for MessageType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_message_type_get_type()) }
    }
}

impl glib::value::ValueType for MessageType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for MessageType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for MessageType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkMovementStep")]
pub enum MovementStep {
    #[doc(alias = "GTK_MOVEMENT_LOGICAL_POSITIONS")]
    LogicalPositions,
    #[doc(alias = "GTK_MOVEMENT_VISUAL_POSITIONS")]
    VisualPositions,
    #[doc(alias = "GTK_MOVEMENT_WORDS")]
    Words,
    #[doc(alias = "GTK_MOVEMENT_DISPLAY_LINES")]
    DisplayLines,
    #[doc(alias = "GTK_MOVEMENT_DISPLAY_LINE_ENDS")]
    DisplayLineEnds,
    #[doc(alias = "GTK_MOVEMENT_PARAGRAPHS")]
    Paragraphs,
    #[doc(alias = "GTK_MOVEMENT_PARAGRAPH_ENDS")]
    ParagraphEnds,
    #[doc(alias = "GTK_MOVEMENT_PAGES")]
    Pages,
    #[doc(alias = "GTK_MOVEMENT_BUFFER_ENDS")]
    BufferEnds,
    #[doc(alias = "GTK_MOVEMENT_HORIZONTAL_PAGES")]
    HorizontalPages,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for MovementStep {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "MovementStep::{}",
            match *self {
                Self::LogicalPositions => "LogicalPositions",
                Self::VisualPositions => "VisualPositions",
                Self::Words => "Words",
                Self::DisplayLines => "DisplayLines",
                Self::DisplayLineEnds => "DisplayLineEnds",
                Self::Paragraphs => "Paragraphs",
                Self::ParagraphEnds => "ParagraphEnds",
                Self::Pages => "Pages",
                Self::BufferEnds => "BufferEnds",
                Self::HorizontalPages => "HorizontalPages",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for MovementStep {
    type GlibType = ffi::GtkMovementStep;

    fn into_glib(self) -> ffi::GtkMovementStep {
        match self {
            Self::LogicalPositions => ffi::GTK_MOVEMENT_LOGICAL_POSITIONS,
            Self::VisualPositions => ffi::GTK_MOVEMENT_VISUAL_POSITIONS,
            Self::Words => ffi::GTK_MOVEMENT_WORDS,
            Self::DisplayLines => ffi::GTK_MOVEMENT_DISPLAY_LINES,
            Self::DisplayLineEnds => ffi::GTK_MOVEMENT_DISPLAY_LINE_ENDS,
            Self::Paragraphs => ffi::GTK_MOVEMENT_PARAGRAPHS,
            Self::ParagraphEnds => ffi::GTK_MOVEMENT_PARAGRAPH_ENDS,
            Self::Pages => ffi::GTK_MOVEMENT_PAGES,
            Self::BufferEnds => ffi::GTK_MOVEMENT_BUFFER_ENDS,
            Self::HorizontalPages => ffi::GTK_MOVEMENT_HORIZONTAL_PAGES,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkMovementStep> for MovementStep {
    unsafe fn from_glib(value: ffi::GtkMovementStep) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_MOVEMENT_LOGICAL_POSITIONS => Self::LogicalPositions,
            ffi::GTK_MOVEMENT_VISUAL_POSITIONS => Self::VisualPositions,
            ffi::GTK_MOVEMENT_WORDS => Self::Words,
            ffi::GTK_MOVEMENT_DISPLAY_LINES => Self::DisplayLines,
            ffi::GTK_MOVEMENT_DISPLAY_LINE_ENDS => Self::DisplayLineEnds,
            ffi::GTK_MOVEMENT_PARAGRAPHS => Self::Paragraphs,
            ffi::GTK_MOVEMENT_PARAGRAPH_ENDS => Self::ParagraphEnds,
            ffi::GTK_MOVEMENT_PAGES => Self::Pages,
            ffi::GTK_MOVEMENT_BUFFER_ENDS => Self::BufferEnds,
            ffi::GTK_MOVEMENT_HORIZONTAL_PAGES => Self::HorizontalPages,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for MovementStep {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_movement_step_get_type()) }
    }
}

impl glib::value::ValueType for MovementStep {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for MovementStep {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for MovementStep {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkNotebookTab")]
pub enum NotebookTab {
    #[doc(alias = "GTK_NOTEBOOK_TAB_FIRST")]
    First,
    #[doc(alias = "GTK_NOTEBOOK_TAB_LAST")]
    Last,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for NotebookTab {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "NotebookTab::{}",
            match *self {
                Self::First => "First",
                Self::Last => "Last",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for NotebookTab {
    type GlibType = ffi::GtkNotebookTab;

    fn into_glib(self) -> ffi::GtkNotebookTab {
        match self {
            Self::First => ffi::GTK_NOTEBOOK_TAB_FIRST,
            Self::Last => ffi::GTK_NOTEBOOK_TAB_LAST,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkNotebookTab> for NotebookTab {
    unsafe fn from_glib(value: ffi::GtkNotebookTab) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_NOTEBOOK_TAB_FIRST => Self::First,
            ffi::GTK_NOTEBOOK_TAB_LAST => Self::Last,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for NotebookTab {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_notebook_tab_get_type()) }
    }
}

impl glib::value::ValueType for NotebookTab {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for NotebookTab {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for NotebookTab {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkNumberUpLayout")]
pub enum NumberUpLayout {
    #[doc(alias = "GTK_NUMBER_UP_LAYOUT_LEFT_TO_RIGHT_TOP_TO_BOTTOM")]
    Lrtb,
    #[doc(alias = "GTK_NUMBER_UP_LAYOUT_LEFT_TO_RIGHT_BOTTOM_TO_TOP")]
    Lrbt,
    #[doc(alias = "GTK_NUMBER_UP_LAYOUT_RIGHT_TO_LEFT_TOP_TO_BOTTOM")]
    Rltb,
    #[doc(alias = "GTK_NUMBER_UP_LAYOUT_RIGHT_TO_LEFT_BOTTOM_TO_TOP")]
    Rlbt,
    #[doc(alias = "GTK_NUMBER_UP_LAYOUT_TOP_TO_BOTTOM_LEFT_TO_RIGHT")]
    Tblr,
    #[doc(alias = "GTK_NUMBER_UP_LAYOUT_TOP_TO_BOTTOM_RIGHT_TO_LEFT")]
    Tbrl,
    #[doc(alias = "GTK_NUMBER_UP_LAYOUT_BOTTOM_TO_TOP_LEFT_TO_RIGHT")]
    Btlr,
    #[doc(alias = "GTK_NUMBER_UP_LAYOUT_BOTTOM_TO_TOP_RIGHT_TO_LEFT")]
    Btrl,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for NumberUpLayout {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "NumberUpLayout::{}",
            match *self {
                Self::Lrtb => "Lrtb",
                Self::Lrbt => "Lrbt",
                Self::Rltb => "Rltb",
                Self::Rlbt => "Rlbt",
                Self::Tblr => "Tblr",
                Self::Tbrl => "Tbrl",
                Self::Btlr => "Btlr",
                Self::Btrl => "Btrl",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for NumberUpLayout {
    type GlibType = ffi::GtkNumberUpLayout;

    fn into_glib(self) -> ffi::GtkNumberUpLayout {
        match self {
            Self::Lrtb => ffi::GTK_NUMBER_UP_LAYOUT_LEFT_TO_RIGHT_TOP_TO_BOTTOM,
            Self::Lrbt => ffi::GTK_NUMBER_UP_LAYOUT_LEFT_TO_RIGHT_BOTTOM_TO_TOP,
            Self::Rltb => ffi::GTK_NUMBER_UP_LAYOUT_RIGHT_TO_LEFT_TOP_TO_BOTTOM,
            Self::Rlbt => ffi::GTK_NUMBER_UP_LAYOUT_RIGHT_TO_LEFT_BOTTOM_TO_TOP,
            Self::Tblr => ffi::GTK_NUMBER_UP_LAYOUT_TOP_TO_BOTTOM_LEFT_TO_RIGHT,
            Self::Tbrl => ffi::GTK_NUMBER_UP_LAYOUT_TOP_TO_BOTTOM_RIGHT_TO_LEFT,
            Self::Btlr => ffi::GTK_NUMBER_UP_LAYOUT_BOTTOM_TO_TOP_LEFT_TO_RIGHT,
            Self::Btrl => ffi::GTK_NUMBER_UP_LAYOUT_BOTTOM_TO_TOP_RIGHT_TO_LEFT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkNumberUpLayout> for NumberUpLayout {
    unsafe fn from_glib(value: ffi::GtkNumberUpLayout) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_NUMBER_UP_LAYOUT_LEFT_TO_RIGHT_TOP_TO_BOTTOM => Self::Lrtb,
            ffi::GTK_NUMBER_UP_LAYOUT_LEFT_TO_RIGHT_BOTTOM_TO_TOP => Self::Lrbt,
            ffi::GTK_NUMBER_UP_LAYOUT_RIGHT_TO_LEFT_TOP_TO_BOTTOM => Self::Rltb,
            ffi::GTK_NUMBER_UP_LAYOUT_RIGHT_TO_LEFT_BOTTOM_TO_TOP => Self::Rlbt,
            ffi::GTK_NUMBER_UP_LAYOUT_TOP_TO_BOTTOM_LEFT_TO_RIGHT => Self::Tblr,
            ffi::GTK_NUMBER_UP_LAYOUT_TOP_TO_BOTTOM_RIGHT_TO_LEFT => Self::Tbrl,
            ffi::GTK_NUMBER_UP_LAYOUT_BOTTOM_TO_TOP_LEFT_TO_RIGHT => Self::Btlr,
            ffi::GTK_NUMBER_UP_LAYOUT_BOTTOM_TO_TOP_RIGHT_TO_LEFT => Self::Btrl,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for NumberUpLayout {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_number_up_layout_get_type()) }
    }
}

impl glib::value::ValueType for NumberUpLayout {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for NumberUpLayout {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for NumberUpLayout {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkOrientation")]
pub enum Orientation {
    #[doc(alias = "GTK_ORIENTATION_HORIZONTAL")]
    Horizontal,
    #[doc(alias = "GTK_ORIENTATION_VERTICAL")]
    Vertical,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Orientation {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Orientation::{}",
            match *self {
                Self::Horizontal => "Horizontal",
                Self::Vertical => "Vertical",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for Orientation {
    type GlibType = ffi::GtkOrientation;

    fn into_glib(self) -> ffi::GtkOrientation {
        match self {
            Self::Horizontal => ffi::GTK_ORIENTATION_HORIZONTAL,
            Self::Vertical => ffi::GTK_ORIENTATION_VERTICAL,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkOrientation> for Orientation {
    unsafe fn from_glib(value: ffi::GtkOrientation) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_ORIENTATION_HORIZONTAL => Self::Horizontal,
            ffi::GTK_ORIENTATION_VERTICAL => Self::Vertical,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for Orientation {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_orientation_get_type()) }
    }
}

impl glib::value::ValueType for Orientation {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for Orientation {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for Orientation {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkPackDirection")]
pub enum PackDirection {
    #[doc(alias = "GTK_PACK_DIRECTION_LTR")]
    Ltr,
    #[doc(alias = "GTK_PACK_DIRECTION_RTL")]
    Rtl,
    #[doc(alias = "GTK_PACK_DIRECTION_TTB")]
    Ttb,
    #[doc(alias = "GTK_PACK_DIRECTION_BTT")]
    Btt,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for PackDirection {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "PackDirection::{}",
            match *self {
                Self::Ltr => "Ltr",
                Self::Rtl => "Rtl",
                Self::Ttb => "Ttb",
                Self::Btt => "Btt",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for PackDirection {
    type GlibType = ffi::GtkPackDirection;

    fn into_glib(self) -> ffi::GtkPackDirection {
        match self {
            Self::Ltr => ffi::GTK_PACK_DIRECTION_LTR,
            Self::Rtl => ffi::GTK_PACK_DIRECTION_RTL,
            Self::Ttb => ffi::GTK_PACK_DIRECTION_TTB,
            Self::Btt => ffi::GTK_PACK_DIRECTION_BTT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkPackDirection> for PackDirection {
    unsafe fn from_glib(value: ffi::GtkPackDirection) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_PACK_DIRECTION_LTR => Self::Ltr,
            ffi::GTK_PACK_DIRECTION_RTL => Self::Rtl,
            ffi::GTK_PACK_DIRECTION_TTB => Self::Ttb,
            ffi::GTK_PACK_DIRECTION_BTT => Self::Btt,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for PackDirection {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_pack_direction_get_type()) }
    }
}

impl glib::value::ValueType for PackDirection {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PackDirection {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PackDirection {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkPackType")]
pub enum PackType {
    #[doc(alias = "GTK_PACK_START")]
    Start,
    #[doc(alias = "GTK_PACK_END")]
    End,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for PackType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "PackType::{}",
            match *self {
                Self::Start => "Start",
                Self::End => "End",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for PackType {
    type GlibType = ffi::GtkPackType;

    fn into_glib(self) -> ffi::GtkPackType {
        match self {
            Self::Start => ffi::GTK_PACK_START,
            Self::End => ffi::GTK_PACK_END,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkPackType> for PackType {
    unsafe fn from_glib(value: ffi::GtkPackType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_PACK_START => Self::Start,
            ffi::GTK_PACK_END => Self::End,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for PackType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_pack_type_get_type()) }
    }
}

impl glib::value::ValueType for PackType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PackType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PackType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_22")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkPadActionType")]
pub enum PadActionType {
    #[doc(alias = "GTK_PAD_ACTION_BUTTON")]
    Button,
    #[doc(alias = "GTK_PAD_ACTION_RING")]
    Ring,
    #[doc(alias = "GTK_PAD_ACTION_STRIP")]
    Strip,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_22")))]
impl fmt::Display for PadActionType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "PadActionType::{}",
            match *self {
                Self::Button => "Button",
                Self::Ring => "Ring",
                Self::Strip => "Strip",
                _ => "Unknown",
            }
        )
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_22")))]
#[doc(hidden)]
impl IntoGlib for PadActionType {
    type GlibType = ffi::GtkPadActionType;

    fn into_glib(self) -> ffi::GtkPadActionType {
        match self {
            Self::Button => ffi::GTK_PAD_ACTION_BUTTON,
            Self::Ring => ffi::GTK_PAD_ACTION_RING,
            Self::Strip => ffi::GTK_PAD_ACTION_STRIP,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_22")))]
#[doc(hidden)]
impl FromGlib<ffi::GtkPadActionType> for PadActionType {
    unsafe fn from_glib(value: ffi::GtkPadActionType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_PAD_ACTION_BUTTON => Self::Button,
            ffi::GTK_PAD_ACTION_RING => Self::Ring,
            ffi::GTK_PAD_ACTION_STRIP => Self::Strip,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_22")))]
impl StaticType for PadActionType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_pad_action_type_get_type()) }
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_22")))]
impl glib::value::ValueType for PadActionType {
    type Type = Self;
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_22")))]
unsafe impl<'a> FromValue<'a> for PadActionType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_22")))]
impl ToValue for PadActionType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkPageOrientation")]
pub enum PageOrientation {
    #[doc(alias = "GTK_PAGE_ORIENTATION_PORTRAIT")]
    Portrait,
    #[doc(alias = "GTK_PAGE_ORIENTATION_LANDSCAPE")]
    Landscape,
    #[doc(alias = "GTK_PAGE_ORIENTATION_REVERSE_PORTRAIT")]
    ReversePortrait,
    #[doc(alias = "GTK_PAGE_ORIENTATION_REVERSE_LANDSCAPE")]
    ReverseLandscape,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for PageOrientation {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "PageOrientation::{}",
            match *self {
                Self::Portrait => "Portrait",
                Self::Landscape => "Landscape",
                Self::ReversePortrait => "ReversePortrait",
                Self::ReverseLandscape => "ReverseLandscape",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for PageOrientation {
    type GlibType = ffi::GtkPageOrientation;

    fn into_glib(self) -> ffi::GtkPageOrientation {
        match self {
            Self::Portrait => ffi::GTK_PAGE_ORIENTATION_PORTRAIT,
            Self::Landscape => ffi::GTK_PAGE_ORIENTATION_LANDSCAPE,
            Self::ReversePortrait => ffi::GTK_PAGE_ORIENTATION_REVERSE_PORTRAIT,
            Self::ReverseLandscape => ffi::GTK_PAGE_ORIENTATION_REVERSE_LANDSCAPE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkPageOrientation> for PageOrientation {
    unsafe fn from_glib(value: ffi::GtkPageOrientation) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_PAGE_ORIENTATION_PORTRAIT => Self::Portrait,
            ffi::GTK_PAGE_ORIENTATION_LANDSCAPE => Self::Landscape,
            ffi::GTK_PAGE_ORIENTATION_REVERSE_PORTRAIT => Self::ReversePortrait,
            ffi::GTK_PAGE_ORIENTATION_REVERSE_LANDSCAPE => Self::ReverseLandscape,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for PageOrientation {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_page_orientation_get_type()) }
    }
}

impl glib::value::ValueType for PageOrientation {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PageOrientation {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PageOrientation {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkPageSet")]
pub enum PageSet {
    #[doc(alias = "GTK_PAGE_SET_ALL")]
    All,
    #[doc(alias = "GTK_PAGE_SET_EVEN")]
    Even,
    #[doc(alias = "GTK_PAGE_SET_ODD")]
    Odd,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for PageSet {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "PageSet::{}",
            match *self {
                Self::All => "All",
                Self::Even => "Even",
                Self::Odd => "Odd",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for PageSet {
    type GlibType = ffi::GtkPageSet;

    fn into_glib(self) -> ffi::GtkPageSet {
        match self {
            Self::All => ffi::GTK_PAGE_SET_ALL,
            Self::Even => ffi::GTK_PAGE_SET_EVEN,
            Self::Odd => ffi::GTK_PAGE_SET_ODD,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkPageSet> for PageSet {
    unsafe fn from_glib(value: ffi::GtkPageSet) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_PAGE_SET_ALL => Self::All,
            ffi::GTK_PAGE_SET_EVEN => Self::Even,
            ffi::GTK_PAGE_SET_ODD => Self::Odd,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for PageSet {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_page_set_get_type()) }
    }
}

impl glib::value::ValueType for PageSet {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PageSet {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PageSet {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkPanDirection")]
pub enum PanDirection {
    #[doc(alias = "GTK_PAN_DIRECTION_LEFT")]
    Left,
    #[doc(alias = "GTK_PAN_DIRECTION_RIGHT")]
    Right,
    #[doc(alias = "GTK_PAN_DIRECTION_UP")]
    Up,
    #[doc(alias = "GTK_PAN_DIRECTION_DOWN")]
    Down,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for PanDirection {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "PanDirection::{}",
            match *self {
                Self::Left => "Left",
                Self::Right => "Right",
                Self::Up => "Up",
                Self::Down => "Down",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for PanDirection {
    type GlibType = ffi::GtkPanDirection;

    fn into_glib(self) -> ffi::GtkPanDirection {
        match self {
            Self::Left => ffi::GTK_PAN_DIRECTION_LEFT,
            Self::Right => ffi::GTK_PAN_DIRECTION_RIGHT,
            Self::Up => ffi::GTK_PAN_DIRECTION_UP,
            Self::Down => ffi::GTK_PAN_DIRECTION_DOWN,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkPanDirection> for PanDirection {
    unsafe fn from_glib(value: ffi::GtkPanDirection) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_PAN_DIRECTION_LEFT => Self::Left,
            ffi::GTK_PAN_DIRECTION_RIGHT => Self::Right,
            ffi::GTK_PAN_DIRECTION_UP => Self::Up,
            ffi::GTK_PAN_DIRECTION_DOWN => Self::Down,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for PanDirection {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_pan_direction_get_type()) }
    }
}

impl glib::value::ValueType for PanDirection {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PanDirection {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PanDirection {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkPolicyType")]
pub enum PolicyType {
    #[doc(alias = "GTK_POLICY_ALWAYS")]
    Always,
    #[doc(alias = "GTK_POLICY_AUTOMATIC")]
    Automatic,
    #[doc(alias = "GTK_POLICY_NEVER")]
    Never,
    #[doc(alias = "GTK_POLICY_EXTERNAL")]
    External,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for PolicyType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "PolicyType::{}",
            match *self {
                Self::Always => "Always",
                Self::Automatic => "Automatic",
                Self::Never => "Never",
                Self::External => "External",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for PolicyType {
    type GlibType = ffi::GtkPolicyType;

    fn into_glib(self) -> ffi::GtkPolicyType {
        match self {
            Self::Always => ffi::GTK_POLICY_ALWAYS,
            Self::Automatic => ffi::GTK_POLICY_AUTOMATIC,
            Self::Never => ffi::GTK_POLICY_NEVER,
            Self::External => ffi::GTK_POLICY_EXTERNAL,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkPolicyType> for PolicyType {
    unsafe fn from_glib(value: ffi::GtkPolicyType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_POLICY_ALWAYS => Self::Always,
            ffi::GTK_POLICY_AUTOMATIC => Self::Automatic,
            ffi::GTK_POLICY_NEVER => Self::Never,
            ffi::GTK_POLICY_EXTERNAL => Self::External,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for PolicyType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_policy_type_get_type()) }
    }
}

impl glib::value::ValueType for PolicyType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PolicyType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PolicyType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_20")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkPopoverConstraint")]
pub enum PopoverConstraint {
    #[doc(alias = "GTK_POPOVER_CONSTRAINT_NONE")]
    None,
    #[doc(alias = "GTK_POPOVER_CONSTRAINT_WINDOW")]
    Window,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_20")))]
impl fmt::Display for PopoverConstraint {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "PopoverConstraint::{}",
            match *self {
                Self::None => "None",
                Self::Window => "Window",
                _ => "Unknown",
            }
        )
    }
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_20")))]
#[doc(hidden)]
impl IntoGlib for PopoverConstraint {
    type GlibType = ffi::GtkPopoverConstraint;

    fn into_glib(self) -> ffi::GtkPopoverConstraint {
        match self {
            Self::None => ffi::GTK_POPOVER_CONSTRAINT_NONE,
            Self::Window => ffi::GTK_POPOVER_CONSTRAINT_WINDOW,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_20")))]
#[doc(hidden)]
impl FromGlib<ffi::GtkPopoverConstraint> for PopoverConstraint {
    unsafe fn from_glib(value: ffi::GtkPopoverConstraint) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_POPOVER_CONSTRAINT_NONE => Self::None,
            ffi::GTK_POPOVER_CONSTRAINT_WINDOW => Self::Window,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_20")))]
impl StaticType for PopoverConstraint {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_popover_constraint_get_type()) }
    }
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_20")))]
impl glib::value::ValueType for PopoverConstraint {
    type Type = Self;
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_20")))]
unsafe impl<'a> FromValue<'a> for PopoverConstraint {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_20")))]
impl ToValue for PopoverConstraint {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkPositionType")]
pub enum PositionType {
    #[doc(alias = "GTK_POS_LEFT")]
    Left,
    #[doc(alias = "GTK_POS_RIGHT")]
    Right,
    #[doc(alias = "GTK_POS_TOP")]
    Top,
    #[doc(alias = "GTK_POS_BOTTOM")]
    Bottom,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for PositionType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "PositionType::{}",
            match *self {
                Self::Left => "Left",
                Self::Right => "Right",
                Self::Top => "Top",
                Self::Bottom => "Bottom",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for PositionType {
    type GlibType = ffi::GtkPositionType;

    fn into_glib(self) -> ffi::GtkPositionType {
        match self {
            Self::Left => ffi::GTK_POS_LEFT,
            Self::Right => ffi::GTK_POS_RIGHT,
            Self::Top => ffi::GTK_POS_TOP,
            Self::Bottom => ffi::GTK_POS_BOTTOM,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkPositionType> for PositionType {
    unsafe fn from_glib(value: ffi::GtkPositionType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_POS_LEFT => Self::Left,
            ffi::GTK_POS_RIGHT => Self::Right,
            ffi::GTK_POS_TOP => Self::Top,
            ffi::GTK_POS_BOTTOM => Self::Bottom,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for PositionType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_position_type_get_type()) }
    }
}

impl glib::value::ValueType for PositionType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PositionType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PositionType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkPrintDuplex")]
pub enum PrintDuplex {
    #[doc(alias = "GTK_PRINT_DUPLEX_SIMPLEX")]
    Simplex,
    #[doc(alias = "GTK_PRINT_DUPLEX_HORIZONTAL")]
    Horizontal,
    #[doc(alias = "GTK_PRINT_DUPLEX_VERTICAL")]
    Vertical,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for PrintDuplex {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "PrintDuplex::{}",
            match *self {
                Self::Simplex => "Simplex",
                Self::Horizontal => "Horizontal",
                Self::Vertical => "Vertical",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for PrintDuplex {
    type GlibType = ffi::GtkPrintDuplex;

    fn into_glib(self) -> ffi::GtkPrintDuplex {
        match self {
            Self::Simplex => ffi::GTK_PRINT_DUPLEX_SIMPLEX,
            Self::Horizontal => ffi::GTK_PRINT_DUPLEX_HORIZONTAL,
            Self::Vertical => ffi::GTK_PRINT_DUPLEX_VERTICAL,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkPrintDuplex> for PrintDuplex {
    unsafe fn from_glib(value: ffi::GtkPrintDuplex) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_PRINT_DUPLEX_SIMPLEX => Self::Simplex,
            ffi::GTK_PRINT_DUPLEX_HORIZONTAL => Self::Horizontal,
            ffi::GTK_PRINT_DUPLEX_VERTICAL => Self::Vertical,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for PrintDuplex {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_print_duplex_get_type()) }
    }
}

impl glib::value::ValueType for PrintDuplex {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PrintDuplex {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PrintDuplex {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkPrintError")]
pub enum PrintError {
    #[doc(alias = "GTK_PRINT_ERROR_GENERAL")]
    General,
    #[doc(alias = "GTK_PRINT_ERROR_INTERNAL_ERROR")]
    InternalError,
    #[doc(alias = "GTK_PRINT_ERROR_NOMEM")]
    Nomem,
    #[doc(alias = "GTK_PRINT_ERROR_INVALID_FILE")]
    InvalidFile,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for PrintError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "PrintError::{}",
            match *self {
                Self::General => "General",
                Self::InternalError => "InternalError",
                Self::Nomem => "Nomem",
                Self::InvalidFile => "InvalidFile",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for PrintError {
    type GlibType = ffi::GtkPrintError;

    fn into_glib(self) -> ffi::GtkPrintError {
        match self {
            Self::General => ffi::GTK_PRINT_ERROR_GENERAL,
            Self::InternalError => ffi::GTK_PRINT_ERROR_INTERNAL_ERROR,
            Self::Nomem => ffi::GTK_PRINT_ERROR_NOMEM,
            Self::InvalidFile => ffi::GTK_PRINT_ERROR_INVALID_FILE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkPrintError> for PrintError {
    unsafe fn from_glib(value: ffi::GtkPrintError) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_PRINT_ERROR_GENERAL => Self::General,
            ffi::GTK_PRINT_ERROR_INTERNAL_ERROR => Self::InternalError,
            ffi::GTK_PRINT_ERROR_NOMEM => Self::Nomem,
            ffi::GTK_PRINT_ERROR_INVALID_FILE => Self::InvalidFile,
            value => Self::__Unknown(value),
        }
    }
}

impl ErrorDomain for PrintError {
    fn domain() -> Quark {
        skip_assert_initialized!();

        unsafe { from_glib(ffi::gtk_print_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            ffi::GTK_PRINT_ERROR_GENERAL => Some(Self::General),
            ffi::GTK_PRINT_ERROR_INTERNAL_ERROR => Some(Self::InternalError),
            ffi::GTK_PRINT_ERROR_NOMEM => Some(Self::Nomem),
            ffi::GTK_PRINT_ERROR_INVALID_FILE => Some(Self::InvalidFile),
            value => Some(Self::__Unknown(value)),
        }
    }
}

impl StaticType for PrintError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_print_error_get_type()) }
    }
}

impl glib::value::ValueType for PrintError {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PrintError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PrintError {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkPrintOperationAction")]
pub enum PrintOperationAction {
    #[doc(alias = "GTK_PRINT_OPERATION_ACTION_PRINT_DIALOG")]
    PrintDialog,
    #[doc(alias = "GTK_PRINT_OPERATION_ACTION_PRINT")]
    Print,
    #[doc(alias = "GTK_PRINT_OPERATION_ACTION_PREVIEW")]
    Preview,
    #[doc(alias = "GTK_PRINT_OPERATION_ACTION_EXPORT")]
    Export,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for PrintOperationAction {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "PrintOperationAction::{}",
            match *self {
                Self::PrintDialog => "PrintDialog",
                Self::Print => "Print",
                Self::Preview => "Preview",
                Self::Export => "Export",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for PrintOperationAction {
    type GlibType = ffi::GtkPrintOperationAction;

    fn into_glib(self) -> ffi::GtkPrintOperationAction {
        match self {
            Self::PrintDialog => ffi::GTK_PRINT_OPERATION_ACTION_PRINT_DIALOG,
            Self::Print => ffi::GTK_PRINT_OPERATION_ACTION_PRINT,
            Self::Preview => ffi::GTK_PRINT_OPERATION_ACTION_PREVIEW,
            Self::Export => ffi::GTK_PRINT_OPERATION_ACTION_EXPORT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkPrintOperationAction> for PrintOperationAction {
    unsafe fn from_glib(value: ffi::GtkPrintOperationAction) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_PRINT_OPERATION_ACTION_PRINT_DIALOG => Self::PrintDialog,
            ffi::GTK_PRINT_OPERATION_ACTION_PRINT => Self::Print,
            ffi::GTK_PRINT_OPERATION_ACTION_PREVIEW => Self::Preview,
            ffi::GTK_PRINT_OPERATION_ACTION_EXPORT => Self::Export,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for PrintOperationAction {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_print_operation_action_get_type()) }
    }
}

impl glib::value::ValueType for PrintOperationAction {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PrintOperationAction {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PrintOperationAction {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkPrintOperationResult")]
pub enum PrintOperationResult {
    #[doc(alias = "GTK_PRINT_OPERATION_RESULT_ERROR")]
    Error,
    #[doc(alias = "GTK_PRINT_OPERATION_RESULT_APPLY")]
    Apply,
    #[doc(alias = "GTK_PRINT_OPERATION_RESULT_CANCEL")]
    Cancel,
    #[doc(alias = "GTK_PRINT_OPERATION_RESULT_IN_PROGRESS")]
    InProgress,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for PrintOperationResult {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "PrintOperationResult::{}",
            match *self {
                Self::Error => "Error",
                Self::Apply => "Apply",
                Self::Cancel => "Cancel",
                Self::InProgress => "InProgress",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for PrintOperationResult {
    type GlibType = ffi::GtkPrintOperationResult;

    fn into_glib(self) -> ffi::GtkPrintOperationResult {
        match self {
            Self::Error => ffi::GTK_PRINT_OPERATION_RESULT_ERROR,
            Self::Apply => ffi::GTK_PRINT_OPERATION_RESULT_APPLY,
            Self::Cancel => ffi::GTK_PRINT_OPERATION_RESULT_CANCEL,
            Self::InProgress => ffi::GTK_PRINT_OPERATION_RESULT_IN_PROGRESS,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkPrintOperationResult> for PrintOperationResult {
    unsafe fn from_glib(value: ffi::GtkPrintOperationResult) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_PRINT_OPERATION_RESULT_ERROR => Self::Error,
            ffi::GTK_PRINT_OPERATION_RESULT_APPLY => Self::Apply,
            ffi::GTK_PRINT_OPERATION_RESULT_CANCEL => Self::Cancel,
            ffi::GTK_PRINT_OPERATION_RESULT_IN_PROGRESS => Self::InProgress,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for PrintOperationResult {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_print_operation_result_get_type()) }
    }
}

impl glib::value::ValueType for PrintOperationResult {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PrintOperationResult {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PrintOperationResult {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkPrintPages")]
pub enum PrintPages {
    #[doc(alias = "GTK_PRINT_PAGES_ALL")]
    All,
    #[doc(alias = "GTK_PRINT_PAGES_CURRENT")]
    Current,
    #[doc(alias = "GTK_PRINT_PAGES_RANGES")]
    Ranges,
    #[doc(alias = "GTK_PRINT_PAGES_SELECTION")]
    Selection,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for PrintPages {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "PrintPages::{}",
            match *self {
                Self::All => "All",
                Self::Current => "Current",
                Self::Ranges => "Ranges",
                Self::Selection => "Selection",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for PrintPages {
    type GlibType = ffi::GtkPrintPages;

    fn into_glib(self) -> ffi::GtkPrintPages {
        match self {
            Self::All => ffi::GTK_PRINT_PAGES_ALL,
            Self::Current => ffi::GTK_PRINT_PAGES_CURRENT,
            Self::Ranges => ffi::GTK_PRINT_PAGES_RANGES,
            Self::Selection => ffi::GTK_PRINT_PAGES_SELECTION,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkPrintPages> for PrintPages {
    unsafe fn from_glib(value: ffi::GtkPrintPages) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_PRINT_PAGES_ALL => Self::All,
            ffi::GTK_PRINT_PAGES_CURRENT => Self::Current,
            ffi::GTK_PRINT_PAGES_RANGES => Self::Ranges,
            ffi::GTK_PRINT_PAGES_SELECTION => Self::Selection,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for PrintPages {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_print_pages_get_type()) }
    }
}

impl glib::value::ValueType for PrintPages {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PrintPages {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PrintPages {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkPrintQuality")]
pub enum PrintQuality {
    #[doc(alias = "GTK_PRINT_QUALITY_LOW")]
    Low,
    #[doc(alias = "GTK_PRINT_QUALITY_NORMAL")]
    Normal,
    #[doc(alias = "GTK_PRINT_QUALITY_HIGH")]
    High,
    #[doc(alias = "GTK_PRINT_QUALITY_DRAFT")]
    Draft,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for PrintQuality {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "PrintQuality::{}",
            match *self {
                Self::Low => "Low",
                Self::Normal => "Normal",
                Self::High => "High",
                Self::Draft => "Draft",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for PrintQuality {
    type GlibType = ffi::GtkPrintQuality;

    fn into_glib(self) -> ffi::GtkPrintQuality {
        match self {
            Self::Low => ffi::GTK_PRINT_QUALITY_LOW,
            Self::Normal => ffi::GTK_PRINT_QUALITY_NORMAL,
            Self::High => ffi::GTK_PRINT_QUALITY_HIGH,
            Self::Draft => ffi::GTK_PRINT_QUALITY_DRAFT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkPrintQuality> for PrintQuality {
    unsafe fn from_glib(value: ffi::GtkPrintQuality) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_PRINT_QUALITY_LOW => Self::Low,
            ffi::GTK_PRINT_QUALITY_NORMAL => Self::Normal,
            ffi::GTK_PRINT_QUALITY_HIGH => Self::High,
            ffi::GTK_PRINT_QUALITY_DRAFT => Self::Draft,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for PrintQuality {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_print_quality_get_type()) }
    }
}

impl glib::value::ValueType for PrintQuality {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PrintQuality {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PrintQuality {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkPrintStatus")]
pub enum PrintStatus {
    #[doc(alias = "GTK_PRINT_STATUS_INITIAL")]
    Initial,
    #[doc(alias = "GTK_PRINT_STATUS_PREPARING")]
    Preparing,
    #[doc(alias = "GTK_PRINT_STATUS_GENERATING_DATA")]
    GeneratingData,
    #[doc(alias = "GTK_PRINT_STATUS_SENDING_DATA")]
    SendingData,
    #[doc(alias = "GTK_PRINT_STATUS_PENDING")]
    Pending,
    #[doc(alias = "GTK_PRINT_STATUS_PENDING_ISSUE")]
    PendingIssue,
    #[doc(alias = "GTK_PRINT_STATUS_PRINTING")]
    Printing,
    #[doc(alias = "GTK_PRINT_STATUS_FINISHED")]
    Finished,
    #[doc(alias = "GTK_PRINT_STATUS_FINISHED_ABORTED")]
    FinishedAborted,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for PrintStatus {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "PrintStatus::{}",
            match *self {
                Self::Initial => "Initial",
                Self::Preparing => "Preparing",
                Self::GeneratingData => "GeneratingData",
                Self::SendingData => "SendingData",
                Self::Pending => "Pending",
                Self::PendingIssue => "PendingIssue",
                Self::Printing => "Printing",
                Self::Finished => "Finished",
                Self::FinishedAborted => "FinishedAborted",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for PrintStatus {
    type GlibType = ffi::GtkPrintStatus;

    fn into_glib(self) -> ffi::GtkPrintStatus {
        match self {
            Self::Initial => ffi::GTK_PRINT_STATUS_INITIAL,
            Self::Preparing => ffi::GTK_PRINT_STATUS_PREPARING,
            Self::GeneratingData => ffi::GTK_PRINT_STATUS_GENERATING_DATA,
            Self::SendingData => ffi::GTK_PRINT_STATUS_SENDING_DATA,
            Self::Pending => ffi::GTK_PRINT_STATUS_PENDING,
            Self::PendingIssue => ffi::GTK_PRINT_STATUS_PENDING_ISSUE,
            Self::Printing => ffi::GTK_PRINT_STATUS_PRINTING,
            Self::Finished => ffi::GTK_PRINT_STATUS_FINISHED,
            Self::FinishedAborted => ffi::GTK_PRINT_STATUS_FINISHED_ABORTED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkPrintStatus> for PrintStatus {
    unsafe fn from_glib(value: ffi::GtkPrintStatus) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_PRINT_STATUS_INITIAL => Self::Initial,
            ffi::GTK_PRINT_STATUS_PREPARING => Self::Preparing,
            ffi::GTK_PRINT_STATUS_GENERATING_DATA => Self::GeneratingData,
            ffi::GTK_PRINT_STATUS_SENDING_DATA => Self::SendingData,
            ffi::GTK_PRINT_STATUS_PENDING => Self::Pending,
            ffi::GTK_PRINT_STATUS_PENDING_ISSUE => Self::PendingIssue,
            ffi::GTK_PRINT_STATUS_PRINTING => Self::Printing,
            ffi::GTK_PRINT_STATUS_FINISHED => Self::Finished,
            ffi::GTK_PRINT_STATUS_FINISHED_ABORTED => Self::FinishedAborted,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for PrintStatus {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_print_status_get_type()) }
    }
}

impl glib::value::ValueType for PrintStatus {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PrintStatus {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PrintStatus {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkPropagationPhase")]
pub enum PropagationPhase {
    #[doc(alias = "GTK_PHASE_NONE")]
    None,
    #[doc(alias = "GTK_PHASE_CAPTURE")]
    Capture,
    #[doc(alias = "GTK_PHASE_BUBBLE")]
    Bubble,
    #[doc(alias = "GTK_PHASE_TARGET")]
    Target,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for PropagationPhase {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "PropagationPhase::{}",
            match *self {
                Self::None => "None",
                Self::Capture => "Capture",
                Self::Bubble => "Bubble",
                Self::Target => "Target",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for PropagationPhase {
    type GlibType = ffi::GtkPropagationPhase;

    fn into_glib(self) -> ffi::GtkPropagationPhase {
        match self {
            Self::None => ffi::GTK_PHASE_NONE,
            Self::Capture => ffi::GTK_PHASE_CAPTURE,
            Self::Bubble => ffi::GTK_PHASE_BUBBLE,
            Self::Target => ffi::GTK_PHASE_TARGET,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkPropagationPhase> for PropagationPhase {
    unsafe fn from_glib(value: ffi::GtkPropagationPhase) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_PHASE_NONE => Self::None,
            ffi::GTK_PHASE_CAPTURE => Self::Capture,
            ffi::GTK_PHASE_BUBBLE => Self::Bubble,
            ffi::GTK_PHASE_TARGET => Self::Target,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for PropagationPhase {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_propagation_phase_get_type()) }
    }
}

impl glib::value::ValueType for PropagationPhase {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PropagationPhase {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PropagationPhase {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkRecentChooserError")]
pub enum RecentChooserError {
    #[doc(alias = "GTK_RECENT_CHOOSER_ERROR_NOT_FOUND")]
    NotFound,
    #[doc(alias = "GTK_RECENT_CHOOSER_ERROR_INVALID_URI")]
    InvalidUri,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for RecentChooserError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "RecentChooserError::{}",
            match *self {
                Self::NotFound => "NotFound",
                Self::InvalidUri => "InvalidUri",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for RecentChooserError {
    type GlibType = ffi::GtkRecentChooserError;

    fn into_glib(self) -> ffi::GtkRecentChooserError {
        match self {
            Self::NotFound => ffi::GTK_RECENT_CHOOSER_ERROR_NOT_FOUND,
            Self::InvalidUri => ffi::GTK_RECENT_CHOOSER_ERROR_INVALID_URI,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkRecentChooserError> for RecentChooserError {
    unsafe fn from_glib(value: ffi::GtkRecentChooserError) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_RECENT_CHOOSER_ERROR_NOT_FOUND => Self::NotFound,
            ffi::GTK_RECENT_CHOOSER_ERROR_INVALID_URI => Self::InvalidUri,
            value => Self::__Unknown(value),
        }
    }
}

impl ErrorDomain for RecentChooserError {
    fn domain() -> Quark {
        skip_assert_initialized!();

        unsafe { from_glib(ffi::gtk_recent_chooser_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            ffi::GTK_RECENT_CHOOSER_ERROR_NOT_FOUND => Some(Self::NotFound),
            ffi::GTK_RECENT_CHOOSER_ERROR_INVALID_URI => Some(Self::InvalidUri),
            value => Some(Self::__Unknown(value)),
        }
    }
}

impl StaticType for RecentChooserError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_recent_chooser_error_get_type()) }
    }
}

impl glib::value::ValueType for RecentChooserError {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for RecentChooserError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for RecentChooserError {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkRecentManagerError")]
pub enum RecentManagerError {
    #[doc(alias = "GTK_RECENT_MANAGER_ERROR_NOT_FOUND")]
    NotFound,
    #[doc(alias = "GTK_RECENT_MANAGER_ERROR_INVALID_URI")]
    InvalidUri,
    #[doc(alias = "GTK_RECENT_MANAGER_ERROR_INVALID_ENCODING")]
    InvalidEncoding,
    #[doc(alias = "GTK_RECENT_MANAGER_ERROR_NOT_REGISTERED")]
    NotRegistered,
    #[doc(alias = "GTK_RECENT_MANAGER_ERROR_READ")]
    Read,
    #[doc(alias = "GTK_RECENT_MANAGER_ERROR_WRITE")]
    Write,
    #[doc(alias = "GTK_RECENT_MANAGER_ERROR_UNKNOWN")]
    Unknown,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for RecentManagerError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "RecentManagerError::{}",
            match *self {
                Self::NotFound => "NotFound",
                Self::InvalidUri => "InvalidUri",
                Self::InvalidEncoding => "InvalidEncoding",
                Self::NotRegistered => "NotRegistered",
                Self::Read => "Read",
                Self::Write => "Write",
                Self::Unknown => "Unknown",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for RecentManagerError {
    type GlibType = ffi::GtkRecentManagerError;

    fn into_glib(self) -> ffi::GtkRecentManagerError {
        match self {
            Self::NotFound => ffi::GTK_RECENT_MANAGER_ERROR_NOT_FOUND,
            Self::InvalidUri => ffi::GTK_RECENT_MANAGER_ERROR_INVALID_URI,
            Self::InvalidEncoding => ffi::GTK_RECENT_MANAGER_ERROR_INVALID_ENCODING,
            Self::NotRegistered => ffi::GTK_RECENT_MANAGER_ERROR_NOT_REGISTERED,
            Self::Read => ffi::GTK_RECENT_MANAGER_ERROR_READ,
            Self::Write => ffi::GTK_RECENT_MANAGER_ERROR_WRITE,
            Self::Unknown => ffi::GTK_RECENT_MANAGER_ERROR_UNKNOWN,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkRecentManagerError> for RecentManagerError {
    unsafe fn from_glib(value: ffi::GtkRecentManagerError) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_RECENT_MANAGER_ERROR_NOT_FOUND => Self::NotFound,
            ffi::GTK_RECENT_MANAGER_ERROR_INVALID_URI => Self::InvalidUri,
            ffi::GTK_RECENT_MANAGER_ERROR_INVALID_ENCODING => Self::InvalidEncoding,
            ffi::GTK_RECENT_MANAGER_ERROR_NOT_REGISTERED => Self::NotRegistered,
            ffi::GTK_RECENT_MANAGER_ERROR_READ => Self::Read,
            ffi::GTK_RECENT_MANAGER_ERROR_WRITE => Self::Write,
            ffi::GTK_RECENT_MANAGER_ERROR_UNKNOWN => Self::Unknown,
            value => Self::__Unknown(value),
        }
    }
}

impl ErrorDomain for RecentManagerError {
    fn domain() -> Quark {
        skip_assert_initialized!();

        unsafe { from_glib(ffi::gtk_recent_manager_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            ffi::GTK_RECENT_MANAGER_ERROR_NOT_FOUND => Some(Self::NotFound),
            ffi::GTK_RECENT_MANAGER_ERROR_INVALID_URI => Some(Self::InvalidUri),
            ffi::GTK_RECENT_MANAGER_ERROR_INVALID_ENCODING => Some(Self::InvalidEncoding),
            ffi::GTK_RECENT_MANAGER_ERROR_NOT_REGISTERED => Some(Self::NotRegistered),
            ffi::GTK_RECENT_MANAGER_ERROR_READ => Some(Self::Read),
            ffi::GTK_RECENT_MANAGER_ERROR_WRITE => Some(Self::Write),
            ffi::GTK_RECENT_MANAGER_ERROR_UNKNOWN => Some(Self::Unknown),
            value => Some(Self::__Unknown(value)),
        }
    }
}

impl StaticType for RecentManagerError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_recent_manager_error_get_type()) }
    }
}

impl glib::value::ValueType for RecentManagerError {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for RecentManagerError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for RecentManagerError {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkRecentSortType")]
pub enum RecentSortType {
    #[doc(alias = "GTK_RECENT_SORT_NONE")]
    None,
    #[doc(alias = "GTK_RECENT_SORT_MRU")]
    Mru,
    #[doc(alias = "GTK_RECENT_SORT_LRU")]
    Lru,
    #[doc(alias = "GTK_RECENT_SORT_CUSTOM")]
    Custom,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for RecentSortType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "RecentSortType::{}",
            match *self {
                Self::None => "None",
                Self::Mru => "Mru",
                Self::Lru => "Lru",
                Self::Custom => "Custom",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for RecentSortType {
    type GlibType = ffi::GtkRecentSortType;

    fn into_glib(self) -> ffi::GtkRecentSortType {
        match self {
            Self::None => ffi::GTK_RECENT_SORT_NONE,
            Self::Mru => ffi::GTK_RECENT_SORT_MRU,
            Self::Lru => ffi::GTK_RECENT_SORT_LRU,
            Self::Custom => ffi::GTK_RECENT_SORT_CUSTOM,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkRecentSortType> for RecentSortType {
    unsafe fn from_glib(value: ffi::GtkRecentSortType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_RECENT_SORT_NONE => Self::None,
            ffi::GTK_RECENT_SORT_MRU => Self::Mru,
            ffi::GTK_RECENT_SORT_LRU => Self::Lru,
            ffi::GTK_RECENT_SORT_CUSTOM => Self::Custom,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for RecentSortType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_recent_sort_type_get_type()) }
    }
}

impl glib::value::ValueType for RecentSortType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for RecentSortType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for RecentSortType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkReliefStyle")]
pub enum ReliefStyle {
    #[doc(alias = "GTK_RELIEF_NORMAL")]
    Normal,
    #[doc(alias = "GTK_RELIEF_HALF")]
    Half,
    #[doc(alias = "GTK_RELIEF_NONE")]
    None,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for ReliefStyle {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "ReliefStyle::{}",
            match *self {
                Self::Normal => "Normal",
                Self::Half => "Half",
                Self::None => "None",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for ReliefStyle {
    type GlibType = ffi::GtkReliefStyle;

    fn into_glib(self) -> ffi::GtkReliefStyle {
        match self {
            Self::Normal => ffi::GTK_RELIEF_NORMAL,
            Self::Half => ffi::GTK_RELIEF_HALF,
            Self::None => ffi::GTK_RELIEF_NONE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkReliefStyle> for ReliefStyle {
    unsafe fn from_glib(value: ffi::GtkReliefStyle) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_RELIEF_NORMAL => Self::Normal,
            ffi::GTK_RELIEF_HALF => Self::Half,
            ffi::GTK_RELIEF_NONE => Self::None,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for ReliefStyle {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_relief_style_get_type()) }
    }
}

impl glib::value::ValueType for ReliefStyle {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for ReliefStyle {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ReliefStyle {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkResizeMode")]
pub enum ResizeMode {
    #[doc(alias = "GTK_RESIZE_PARENT")]
    Parent,
    #[doc(alias = "GTK_RESIZE_QUEUE")]
    Queue,
    #[doc(alias = "GTK_RESIZE_IMMEDIATE")]
    Immediate,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for ResizeMode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "ResizeMode::{}",
            match *self {
                Self::Parent => "Parent",
                Self::Queue => "Queue",
                Self::Immediate => "Immediate",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for ResizeMode {
    type GlibType = ffi::GtkResizeMode;

    fn into_glib(self) -> ffi::GtkResizeMode {
        match self {
            Self::Parent => ffi::GTK_RESIZE_PARENT,
            Self::Queue => ffi::GTK_RESIZE_QUEUE,
            Self::Immediate => ffi::GTK_RESIZE_IMMEDIATE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkResizeMode> for ResizeMode {
    unsafe fn from_glib(value: ffi::GtkResizeMode) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_RESIZE_PARENT => Self::Parent,
            ffi::GTK_RESIZE_QUEUE => Self::Queue,
            ffi::GTK_RESIZE_IMMEDIATE => Self::Immediate,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for ResizeMode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_resize_mode_get_type()) }
    }
}

impl glib::value::ValueType for ResizeMode {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for ResizeMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ResizeMode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkRevealerTransitionType")]
pub enum RevealerTransitionType {
    #[doc(alias = "GTK_REVEALER_TRANSITION_TYPE_NONE")]
    None,
    #[doc(alias = "GTK_REVEALER_TRANSITION_TYPE_CROSSFADE")]
    Crossfade,
    #[doc(alias = "GTK_REVEALER_TRANSITION_TYPE_SLIDE_RIGHT")]
    SlideRight,
    #[doc(alias = "GTK_REVEALER_TRANSITION_TYPE_SLIDE_LEFT")]
    SlideLeft,
    #[doc(alias = "GTK_REVEALER_TRANSITION_TYPE_SLIDE_UP")]
    SlideUp,
    #[doc(alias = "GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN")]
    SlideDown,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for RevealerTransitionType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "RevealerTransitionType::{}",
            match *self {
                Self::None => "None",
                Self::Crossfade => "Crossfade",
                Self::SlideRight => "SlideRight",
                Self::SlideLeft => "SlideLeft",
                Self::SlideUp => "SlideUp",
                Self::SlideDown => "SlideDown",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for RevealerTransitionType {
    type GlibType = ffi::GtkRevealerTransitionType;

    fn into_glib(self) -> ffi::GtkRevealerTransitionType {
        match self {
            Self::None => ffi::GTK_REVEALER_TRANSITION_TYPE_NONE,
            Self::Crossfade => ffi::GTK_REVEALER_TRANSITION_TYPE_CROSSFADE,
            Self::SlideRight => ffi::GTK_REVEALER_TRANSITION_TYPE_SLIDE_RIGHT,
            Self::SlideLeft => ffi::GTK_REVEALER_TRANSITION_TYPE_SLIDE_LEFT,
            Self::SlideUp => ffi::GTK_REVEALER_TRANSITION_TYPE_SLIDE_UP,
            Self::SlideDown => ffi::GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkRevealerTransitionType> for RevealerTransitionType {
    unsafe fn from_glib(value: ffi::GtkRevealerTransitionType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_REVEALER_TRANSITION_TYPE_NONE => Self::None,
            ffi::GTK_REVEALER_TRANSITION_TYPE_CROSSFADE => Self::Crossfade,
            ffi::GTK_REVEALER_TRANSITION_TYPE_SLIDE_RIGHT => Self::SlideRight,
            ffi::GTK_REVEALER_TRANSITION_TYPE_SLIDE_LEFT => Self::SlideLeft,
            ffi::GTK_REVEALER_TRANSITION_TYPE_SLIDE_UP => Self::SlideUp,
            ffi::GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN => Self::SlideDown,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for RevealerTransitionType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_revealer_transition_type_get_type()) }
    }
}

impl glib::value::ValueType for RevealerTransitionType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for RevealerTransitionType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for RevealerTransitionType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkScrollStep")]
pub enum ScrollStep {
    #[doc(alias = "GTK_SCROLL_STEPS")]
    Steps,
    #[doc(alias = "GTK_SCROLL_PAGES")]
    Pages,
    #[doc(alias = "GTK_SCROLL_ENDS")]
    Ends,
    #[doc(alias = "GTK_SCROLL_HORIZONTAL_STEPS")]
    HorizontalSteps,
    #[doc(alias = "GTK_SCROLL_HORIZONTAL_PAGES")]
    HorizontalPages,
    #[doc(alias = "GTK_SCROLL_HORIZONTAL_ENDS")]
    HorizontalEnds,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for ScrollStep {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "ScrollStep::{}",
            match *self {
                Self::Steps => "Steps",
                Self::Pages => "Pages",
                Self::Ends => "Ends",
                Self::HorizontalSteps => "HorizontalSteps",
                Self::HorizontalPages => "HorizontalPages",
                Self::HorizontalEnds => "HorizontalEnds",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for ScrollStep {
    type GlibType = ffi::GtkScrollStep;

    fn into_glib(self) -> ffi::GtkScrollStep {
        match self {
            Self::Steps => ffi::GTK_SCROLL_STEPS,
            Self::Pages => ffi::GTK_SCROLL_PAGES,
            Self::Ends => ffi::GTK_SCROLL_ENDS,
            Self::HorizontalSteps => ffi::GTK_SCROLL_HORIZONTAL_STEPS,
            Self::HorizontalPages => ffi::GTK_SCROLL_HORIZONTAL_PAGES,
            Self::HorizontalEnds => ffi::GTK_SCROLL_HORIZONTAL_ENDS,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkScrollStep> for ScrollStep {
    unsafe fn from_glib(value: ffi::GtkScrollStep) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_SCROLL_STEPS => Self::Steps,
            ffi::GTK_SCROLL_PAGES => Self::Pages,
            ffi::GTK_SCROLL_ENDS => Self::Ends,
            ffi::GTK_SCROLL_HORIZONTAL_STEPS => Self::HorizontalSteps,
            ffi::GTK_SCROLL_HORIZONTAL_PAGES => Self::HorizontalPages,
            ffi::GTK_SCROLL_HORIZONTAL_ENDS => Self::HorizontalEnds,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for ScrollStep {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_scroll_step_get_type()) }
    }
}

impl glib::value::ValueType for ScrollStep {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for ScrollStep {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ScrollStep {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkScrollType")]
pub enum ScrollType {
    #[doc(alias = "GTK_SCROLL_NONE")]
    None,
    #[doc(alias = "GTK_SCROLL_JUMP")]
    Jump,
    #[doc(alias = "GTK_SCROLL_STEP_BACKWARD")]
    StepBackward,
    #[doc(alias = "GTK_SCROLL_STEP_FORWARD")]
    StepForward,
    #[doc(alias = "GTK_SCROLL_PAGE_BACKWARD")]
    PageBackward,
    #[doc(alias = "GTK_SCROLL_PAGE_FORWARD")]
    PageForward,
    #[doc(alias = "GTK_SCROLL_STEP_UP")]
    StepUp,
    #[doc(alias = "GTK_SCROLL_STEP_DOWN")]
    StepDown,
    #[doc(alias = "GTK_SCROLL_PAGE_UP")]
    PageUp,
    #[doc(alias = "GTK_SCROLL_PAGE_DOWN")]
    PageDown,
    #[doc(alias = "GTK_SCROLL_STEP_LEFT")]
    StepLeft,
    #[doc(alias = "GTK_SCROLL_STEP_RIGHT")]
    StepRight,
    #[doc(alias = "GTK_SCROLL_PAGE_LEFT")]
    PageLeft,
    #[doc(alias = "GTK_SCROLL_PAGE_RIGHT")]
    PageRight,
    #[doc(alias = "GTK_SCROLL_START")]
    Start,
    #[doc(alias = "GTK_SCROLL_END")]
    End,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for ScrollType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "ScrollType::{}",
            match *self {
                Self::None => "None",
                Self::Jump => "Jump",
                Self::StepBackward => "StepBackward",
                Self::StepForward => "StepForward",
                Self::PageBackward => "PageBackward",
                Self::PageForward => "PageForward",
                Self::StepUp => "StepUp",
                Self::StepDown => "StepDown",
                Self::PageUp => "PageUp",
                Self::PageDown => "PageDown",
                Self::StepLeft => "StepLeft",
                Self::StepRight => "StepRight",
                Self::PageLeft => "PageLeft",
                Self::PageRight => "PageRight",
                Self::Start => "Start",
                Self::End => "End",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for ScrollType {
    type GlibType = ffi::GtkScrollType;

    fn into_glib(self) -> ffi::GtkScrollType {
        match self {
            Self::None => ffi::GTK_SCROLL_NONE,
            Self::Jump => ffi::GTK_SCROLL_JUMP,
            Self::StepBackward => ffi::GTK_SCROLL_STEP_BACKWARD,
            Self::StepForward => ffi::GTK_SCROLL_STEP_FORWARD,
            Self::PageBackward => ffi::GTK_SCROLL_PAGE_BACKWARD,
            Self::PageForward => ffi::GTK_SCROLL_PAGE_FORWARD,
            Self::StepUp => ffi::GTK_SCROLL_STEP_UP,
            Self::StepDown => ffi::GTK_SCROLL_STEP_DOWN,
            Self::PageUp => ffi::GTK_SCROLL_PAGE_UP,
            Self::PageDown => ffi::GTK_SCROLL_PAGE_DOWN,
            Self::StepLeft => ffi::GTK_SCROLL_STEP_LEFT,
            Self::StepRight => ffi::GTK_SCROLL_STEP_RIGHT,
            Self::PageLeft => ffi::GTK_SCROLL_PAGE_LEFT,
            Self::PageRight => ffi::GTK_SCROLL_PAGE_RIGHT,
            Self::Start => ffi::GTK_SCROLL_START,
            Self::End => ffi::GTK_SCROLL_END,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkScrollType> for ScrollType {
    unsafe fn from_glib(value: ffi::GtkScrollType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_SCROLL_NONE => Self::None,
            ffi::GTK_SCROLL_JUMP => Self::Jump,
            ffi::GTK_SCROLL_STEP_BACKWARD => Self::StepBackward,
            ffi::GTK_SCROLL_STEP_FORWARD => Self::StepForward,
            ffi::GTK_SCROLL_PAGE_BACKWARD => Self::PageBackward,
            ffi::GTK_SCROLL_PAGE_FORWARD => Self::PageForward,
            ffi::GTK_SCROLL_STEP_UP => Self::StepUp,
            ffi::GTK_SCROLL_STEP_DOWN => Self::StepDown,
            ffi::GTK_SCROLL_PAGE_UP => Self::PageUp,
            ffi::GTK_SCROLL_PAGE_DOWN => Self::PageDown,
            ffi::GTK_SCROLL_STEP_LEFT => Self::StepLeft,
            ffi::GTK_SCROLL_STEP_RIGHT => Self::StepRight,
            ffi::GTK_SCROLL_PAGE_LEFT => Self::PageLeft,
            ffi::GTK_SCROLL_PAGE_RIGHT => Self::PageRight,
            ffi::GTK_SCROLL_START => Self::Start,
            ffi::GTK_SCROLL_END => Self::End,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for ScrollType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_scroll_type_get_type()) }
    }
}

impl glib::value::ValueType for ScrollType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for ScrollType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ScrollType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkScrollablePolicy")]
pub enum ScrollablePolicy {
    #[doc(alias = "GTK_SCROLL_MINIMUM")]
    Minimum,
    #[doc(alias = "GTK_SCROLL_NATURAL")]
    Natural,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for ScrollablePolicy {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "ScrollablePolicy::{}",
            match *self {
                Self::Minimum => "Minimum",
                Self::Natural => "Natural",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for ScrollablePolicy {
    type GlibType = ffi::GtkScrollablePolicy;

    fn into_glib(self) -> ffi::GtkScrollablePolicy {
        match self {
            Self::Minimum => ffi::GTK_SCROLL_MINIMUM,
            Self::Natural => ffi::GTK_SCROLL_NATURAL,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkScrollablePolicy> for ScrollablePolicy {
    unsafe fn from_glib(value: ffi::GtkScrollablePolicy) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_SCROLL_MINIMUM => Self::Minimum,
            ffi::GTK_SCROLL_NATURAL => Self::Natural,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for ScrollablePolicy {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_scrollable_policy_get_type()) }
    }
}

impl glib::value::ValueType for ScrollablePolicy {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for ScrollablePolicy {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ScrollablePolicy {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkSelectionMode")]
pub enum SelectionMode {
    #[doc(alias = "GTK_SELECTION_NONE")]
    None,
    #[doc(alias = "GTK_SELECTION_SINGLE")]
    Single,
    #[doc(alias = "GTK_SELECTION_BROWSE")]
    Browse,
    #[doc(alias = "GTK_SELECTION_MULTIPLE")]
    Multiple,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for SelectionMode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "SelectionMode::{}",
            match *self {
                Self::None => "None",
                Self::Single => "Single",
                Self::Browse => "Browse",
                Self::Multiple => "Multiple",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for SelectionMode {
    type GlibType = ffi::GtkSelectionMode;

    fn into_glib(self) -> ffi::GtkSelectionMode {
        match self {
            Self::None => ffi::GTK_SELECTION_NONE,
            Self::Single => ffi::GTK_SELECTION_SINGLE,
            Self::Browse => ffi::GTK_SELECTION_BROWSE,
            Self::Multiple => ffi::GTK_SELECTION_MULTIPLE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkSelectionMode> for SelectionMode {
    unsafe fn from_glib(value: ffi::GtkSelectionMode) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_SELECTION_NONE => Self::None,
            ffi::GTK_SELECTION_SINGLE => Self::Single,
            ffi::GTK_SELECTION_BROWSE => Self::Browse,
            ffi::GTK_SELECTION_MULTIPLE => Self::Multiple,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for SelectionMode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_selection_mode_get_type()) }
    }
}

impl glib::value::ValueType for SelectionMode {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for SelectionMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for SelectionMode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkSensitivityType")]
pub enum SensitivityType {
    #[doc(alias = "GTK_SENSITIVITY_AUTO")]
    Auto,
    #[doc(alias = "GTK_SENSITIVITY_ON")]
    On,
    #[doc(alias = "GTK_SENSITIVITY_OFF")]
    Off,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for SensitivityType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "SensitivityType::{}",
            match *self {
                Self::Auto => "Auto",
                Self::On => "On",
                Self::Off => "Off",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for SensitivityType {
    type GlibType = ffi::GtkSensitivityType;

    fn into_glib(self) -> ffi::GtkSensitivityType {
        match self {
            Self::Auto => ffi::GTK_SENSITIVITY_AUTO,
            Self::On => ffi::GTK_SENSITIVITY_ON,
            Self::Off => ffi::GTK_SENSITIVITY_OFF,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkSensitivityType> for SensitivityType {
    unsafe fn from_glib(value: ffi::GtkSensitivityType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_SENSITIVITY_AUTO => Self::Auto,
            ffi::GTK_SENSITIVITY_ON => Self::On,
            ffi::GTK_SENSITIVITY_OFF => Self::Off,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for SensitivityType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_sensitivity_type_get_type()) }
    }
}

impl glib::value::ValueType for SensitivityType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for SensitivityType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for SensitivityType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkShadowType")]
pub enum ShadowType {
    #[doc(alias = "GTK_SHADOW_NONE")]
    None,
    #[doc(alias = "GTK_SHADOW_IN")]
    In,
    #[doc(alias = "GTK_SHADOW_OUT")]
    Out,
    #[doc(alias = "GTK_SHADOW_ETCHED_IN")]
    EtchedIn,
    #[doc(alias = "GTK_SHADOW_ETCHED_OUT")]
    EtchedOut,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for ShadowType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "ShadowType::{}",
            match *self {
                Self::None => "None",
                Self::In => "In",
                Self::Out => "Out",
                Self::EtchedIn => "EtchedIn",
                Self::EtchedOut => "EtchedOut",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for ShadowType {
    type GlibType = ffi::GtkShadowType;

    fn into_glib(self) -> ffi::GtkShadowType {
        match self {
            Self::None => ffi::GTK_SHADOW_NONE,
            Self::In => ffi::GTK_SHADOW_IN,
            Self::Out => ffi::GTK_SHADOW_OUT,
            Self::EtchedIn => ffi::GTK_SHADOW_ETCHED_IN,
            Self::EtchedOut => ffi::GTK_SHADOW_ETCHED_OUT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkShadowType> for ShadowType {
    unsafe fn from_glib(value: ffi::GtkShadowType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_SHADOW_NONE => Self::None,
            ffi::GTK_SHADOW_IN => Self::In,
            ffi::GTK_SHADOW_OUT => Self::Out,
            ffi::GTK_SHADOW_ETCHED_IN => Self::EtchedIn,
            ffi::GTK_SHADOW_ETCHED_OUT => Self::EtchedOut,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for ShadowType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_shadow_type_get_type()) }
    }
}

impl glib::value::ValueType for ShadowType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for ShadowType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ShadowType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_20")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkShortcutType")]
pub enum ShortcutType {
    #[doc(alias = "GTK_SHORTCUT_ACCELERATOR")]
    Accelerator,
    #[doc(alias = "GTK_SHORTCUT_GESTURE_PINCH")]
    GesturePinch,
    #[doc(alias = "GTK_SHORTCUT_GESTURE_STRETCH")]
    GestureStretch,
    #[doc(alias = "GTK_SHORTCUT_GESTURE_ROTATE_CLOCKWISE")]
    GestureRotateClockwise,
    #[doc(alias = "GTK_SHORTCUT_GESTURE_ROTATE_COUNTERCLOCKWISE")]
    GestureRotateCounterclockwise,
    #[doc(alias = "GTK_SHORTCUT_GESTURE_TWO_FINGER_SWIPE_LEFT")]
    GestureTwoFingerSwipeLeft,
    #[doc(alias = "GTK_SHORTCUT_GESTURE_TWO_FINGER_SWIPE_RIGHT")]
    GestureTwoFingerSwipeRight,
    #[doc(alias = "GTK_SHORTCUT_GESTURE")]
    Gesture,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_20")))]
impl fmt::Display for ShortcutType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "ShortcutType::{}",
            match *self {
                Self::Accelerator => "Accelerator",
                Self::GesturePinch => "GesturePinch",
                Self::GestureStretch => "GestureStretch",
                Self::GestureRotateClockwise => "GestureRotateClockwise",
                Self::GestureRotateCounterclockwise => "GestureRotateCounterclockwise",
                Self::GestureTwoFingerSwipeLeft => "GestureTwoFingerSwipeLeft",
                Self::GestureTwoFingerSwipeRight => "GestureTwoFingerSwipeRight",
                Self::Gesture => "Gesture",
                _ => "Unknown",
            }
        )
    }
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_20")))]
#[doc(hidden)]
impl IntoGlib for ShortcutType {
    type GlibType = ffi::GtkShortcutType;

    fn into_glib(self) -> ffi::GtkShortcutType {
        match self {
            Self::Accelerator => ffi::GTK_SHORTCUT_ACCELERATOR,
            Self::GesturePinch => ffi::GTK_SHORTCUT_GESTURE_PINCH,
            Self::GestureStretch => ffi::GTK_SHORTCUT_GESTURE_STRETCH,
            Self::GestureRotateClockwise => ffi::GTK_SHORTCUT_GESTURE_ROTATE_CLOCKWISE,
            Self::GestureRotateCounterclockwise => {
                ffi::GTK_SHORTCUT_GESTURE_ROTATE_COUNTERCLOCKWISE
            }
            Self::GestureTwoFingerSwipeLeft => ffi::GTK_SHORTCUT_GESTURE_TWO_FINGER_SWIPE_LEFT,
            Self::GestureTwoFingerSwipeRight => ffi::GTK_SHORTCUT_GESTURE_TWO_FINGER_SWIPE_RIGHT,
            Self::Gesture => ffi::GTK_SHORTCUT_GESTURE,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_20")))]
#[doc(hidden)]
impl FromGlib<ffi::GtkShortcutType> for ShortcutType {
    unsafe fn from_glib(value: ffi::GtkShortcutType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_SHORTCUT_ACCELERATOR => Self::Accelerator,
            ffi::GTK_SHORTCUT_GESTURE_PINCH => Self::GesturePinch,
            ffi::GTK_SHORTCUT_GESTURE_STRETCH => Self::GestureStretch,
            ffi::GTK_SHORTCUT_GESTURE_ROTATE_CLOCKWISE => Self::GestureRotateClockwise,
            ffi::GTK_SHORTCUT_GESTURE_ROTATE_COUNTERCLOCKWISE => {
                Self::GestureRotateCounterclockwise
            }
            ffi::GTK_SHORTCUT_GESTURE_TWO_FINGER_SWIPE_LEFT => Self::GestureTwoFingerSwipeLeft,
            ffi::GTK_SHORTCUT_GESTURE_TWO_FINGER_SWIPE_RIGHT => Self::GestureTwoFingerSwipeRight,
            ffi::GTK_SHORTCUT_GESTURE => Self::Gesture,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_20")))]
impl StaticType for ShortcutType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_shortcut_type_get_type()) }
    }
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_20")))]
impl glib::value::ValueType for ShortcutType {
    type Type = Self;
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_20")))]
unsafe impl<'a> FromValue<'a> for ShortcutType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_20")))]
impl ToValue for ShortcutType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkSizeGroupMode")]
pub enum SizeGroupMode {
    #[doc(alias = "GTK_SIZE_GROUP_NONE")]
    None,
    #[doc(alias = "GTK_SIZE_GROUP_HORIZONTAL")]
    Horizontal,
    #[doc(alias = "GTK_SIZE_GROUP_VERTICAL")]
    Vertical,
    #[doc(alias = "GTK_SIZE_GROUP_BOTH")]
    Both,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for SizeGroupMode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "SizeGroupMode::{}",
            match *self {
                Self::None => "None",
                Self::Horizontal => "Horizontal",
                Self::Vertical => "Vertical",
                Self::Both => "Both",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for SizeGroupMode {
    type GlibType = ffi::GtkSizeGroupMode;

    fn into_glib(self) -> ffi::GtkSizeGroupMode {
        match self {
            Self::None => ffi::GTK_SIZE_GROUP_NONE,
            Self::Horizontal => ffi::GTK_SIZE_GROUP_HORIZONTAL,
            Self::Vertical => ffi::GTK_SIZE_GROUP_VERTICAL,
            Self::Both => ffi::GTK_SIZE_GROUP_BOTH,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkSizeGroupMode> for SizeGroupMode {
    unsafe fn from_glib(value: ffi::GtkSizeGroupMode) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_SIZE_GROUP_NONE => Self::None,
            ffi::GTK_SIZE_GROUP_HORIZONTAL => Self::Horizontal,
            ffi::GTK_SIZE_GROUP_VERTICAL => Self::Vertical,
            ffi::GTK_SIZE_GROUP_BOTH => Self::Both,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for SizeGroupMode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_size_group_mode_get_type()) }
    }
}

impl glib::value::ValueType for SizeGroupMode {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for SizeGroupMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for SizeGroupMode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkSizeRequestMode")]
pub enum SizeRequestMode {
    #[doc(alias = "GTK_SIZE_REQUEST_HEIGHT_FOR_WIDTH")]
    HeightForWidth,
    #[doc(alias = "GTK_SIZE_REQUEST_WIDTH_FOR_HEIGHT")]
    WidthForHeight,
    #[doc(alias = "GTK_SIZE_REQUEST_CONSTANT_SIZE")]
    ConstantSize,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for SizeRequestMode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "SizeRequestMode::{}",
            match *self {
                Self::HeightForWidth => "HeightForWidth",
                Self::WidthForHeight => "WidthForHeight",
                Self::ConstantSize => "ConstantSize",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for SizeRequestMode {
    type GlibType = ffi::GtkSizeRequestMode;

    fn into_glib(self) -> ffi::GtkSizeRequestMode {
        match self {
            Self::HeightForWidth => ffi::GTK_SIZE_REQUEST_HEIGHT_FOR_WIDTH,
            Self::WidthForHeight => ffi::GTK_SIZE_REQUEST_WIDTH_FOR_HEIGHT,
            Self::ConstantSize => ffi::GTK_SIZE_REQUEST_CONSTANT_SIZE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkSizeRequestMode> for SizeRequestMode {
    unsafe fn from_glib(value: ffi::GtkSizeRequestMode) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_SIZE_REQUEST_HEIGHT_FOR_WIDTH => Self::HeightForWidth,
            ffi::GTK_SIZE_REQUEST_WIDTH_FOR_HEIGHT => Self::WidthForHeight,
            ffi::GTK_SIZE_REQUEST_CONSTANT_SIZE => Self::ConstantSize,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for SizeRequestMode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_size_request_mode_get_type()) }
    }
}

impl glib::value::ValueType for SizeRequestMode {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for SizeRequestMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for SizeRequestMode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkSortType")]
pub enum SortType {
    #[doc(alias = "GTK_SORT_ASCENDING")]
    Ascending,
    #[doc(alias = "GTK_SORT_DESCENDING")]
    Descending,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for SortType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "SortType::{}",
            match *self {
                Self::Ascending => "Ascending",
                Self::Descending => "Descending",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for SortType {
    type GlibType = ffi::GtkSortType;

    fn into_glib(self) -> ffi::GtkSortType {
        match self {
            Self::Ascending => ffi::GTK_SORT_ASCENDING,
            Self::Descending => ffi::GTK_SORT_DESCENDING,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkSortType> for SortType {
    unsafe fn from_glib(value: ffi::GtkSortType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_SORT_ASCENDING => Self::Ascending,
            ffi::GTK_SORT_DESCENDING => Self::Descending,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for SortType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_sort_type_get_type()) }
    }
}

impl glib::value::ValueType for SortType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for SortType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for SortType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkSpinButtonUpdatePolicy")]
pub enum SpinButtonUpdatePolicy {
    #[doc(alias = "GTK_UPDATE_ALWAYS")]
    Always,
    #[doc(alias = "GTK_UPDATE_IF_VALID")]
    IfValid,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for SpinButtonUpdatePolicy {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "SpinButtonUpdatePolicy::{}",
            match *self {
                Self::Always => "Always",
                Self::IfValid => "IfValid",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for SpinButtonUpdatePolicy {
    type GlibType = ffi::GtkSpinButtonUpdatePolicy;

    fn into_glib(self) -> ffi::GtkSpinButtonUpdatePolicy {
        match self {
            Self::Always => ffi::GTK_UPDATE_ALWAYS,
            Self::IfValid => ffi::GTK_UPDATE_IF_VALID,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkSpinButtonUpdatePolicy> for SpinButtonUpdatePolicy {
    unsafe fn from_glib(value: ffi::GtkSpinButtonUpdatePolicy) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_UPDATE_ALWAYS => Self::Always,
            ffi::GTK_UPDATE_IF_VALID => Self::IfValid,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for SpinButtonUpdatePolicy {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_spin_button_update_policy_get_type()) }
    }
}

impl glib::value::ValueType for SpinButtonUpdatePolicy {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for SpinButtonUpdatePolicy {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for SpinButtonUpdatePolicy {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkSpinType")]
pub enum SpinType {
    #[doc(alias = "GTK_SPIN_STEP_FORWARD")]
    StepForward,
    #[doc(alias = "GTK_SPIN_STEP_BACKWARD")]
    StepBackward,
    #[doc(alias = "GTK_SPIN_PAGE_FORWARD")]
    PageForward,
    #[doc(alias = "GTK_SPIN_PAGE_BACKWARD")]
    PageBackward,
    #[doc(alias = "GTK_SPIN_HOME")]
    Home,
    #[doc(alias = "GTK_SPIN_END")]
    End,
    #[doc(alias = "GTK_SPIN_USER_DEFINED")]
    UserDefined,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for SpinType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "SpinType::{}",
            match *self {
                Self::StepForward => "StepForward",
                Self::StepBackward => "StepBackward",
                Self::PageForward => "PageForward",
                Self::PageBackward => "PageBackward",
                Self::Home => "Home",
                Self::End => "End",
                Self::UserDefined => "UserDefined",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for SpinType {
    type GlibType = ffi::GtkSpinType;

    fn into_glib(self) -> ffi::GtkSpinType {
        match self {
            Self::StepForward => ffi::GTK_SPIN_STEP_FORWARD,
            Self::StepBackward => ffi::GTK_SPIN_STEP_BACKWARD,
            Self::PageForward => ffi::GTK_SPIN_PAGE_FORWARD,
            Self::PageBackward => ffi::GTK_SPIN_PAGE_BACKWARD,
            Self::Home => ffi::GTK_SPIN_HOME,
            Self::End => ffi::GTK_SPIN_END,
            Self::UserDefined => ffi::GTK_SPIN_USER_DEFINED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkSpinType> for SpinType {
    unsafe fn from_glib(value: ffi::GtkSpinType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_SPIN_STEP_FORWARD => Self::StepForward,
            ffi::GTK_SPIN_STEP_BACKWARD => Self::StepBackward,
            ffi::GTK_SPIN_PAGE_FORWARD => Self::PageForward,
            ffi::GTK_SPIN_PAGE_BACKWARD => Self::PageBackward,
            ffi::GTK_SPIN_HOME => Self::Home,
            ffi::GTK_SPIN_END => Self::End,
            ffi::GTK_SPIN_USER_DEFINED => Self::UserDefined,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for SpinType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_spin_type_get_type()) }
    }
}

impl glib::value::ValueType for SpinType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for SpinType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for SpinType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkStackTransitionType")]
pub enum StackTransitionType {
    #[doc(alias = "GTK_STACK_TRANSITION_TYPE_NONE")]
    None,
    #[doc(alias = "GTK_STACK_TRANSITION_TYPE_CROSSFADE")]
    Crossfade,
    #[doc(alias = "GTK_STACK_TRANSITION_TYPE_SLIDE_RIGHT")]
    SlideRight,
    #[doc(alias = "GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT")]
    SlideLeft,
    #[doc(alias = "GTK_STACK_TRANSITION_TYPE_SLIDE_UP")]
    SlideUp,
    #[doc(alias = "GTK_STACK_TRANSITION_TYPE_SLIDE_DOWN")]
    SlideDown,
    #[doc(alias = "GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT_RIGHT")]
    SlideLeftRight,
    #[doc(alias = "GTK_STACK_TRANSITION_TYPE_SLIDE_UP_DOWN")]
    SlideUpDown,
    #[doc(alias = "GTK_STACK_TRANSITION_TYPE_OVER_UP")]
    OverUp,
    #[doc(alias = "GTK_STACK_TRANSITION_TYPE_OVER_DOWN")]
    OverDown,
    #[doc(alias = "GTK_STACK_TRANSITION_TYPE_OVER_LEFT")]
    OverLeft,
    #[doc(alias = "GTK_STACK_TRANSITION_TYPE_OVER_RIGHT")]
    OverRight,
    #[doc(alias = "GTK_STACK_TRANSITION_TYPE_UNDER_UP")]
    UnderUp,
    #[doc(alias = "GTK_STACK_TRANSITION_TYPE_UNDER_DOWN")]
    UnderDown,
    #[doc(alias = "GTK_STACK_TRANSITION_TYPE_UNDER_LEFT")]
    UnderLeft,
    #[doc(alias = "GTK_STACK_TRANSITION_TYPE_UNDER_RIGHT")]
    UnderRight,
    #[doc(alias = "GTK_STACK_TRANSITION_TYPE_OVER_UP_DOWN")]
    OverUpDown,
    #[doc(alias = "GTK_STACK_TRANSITION_TYPE_OVER_DOWN_UP")]
    OverDownUp,
    #[doc(alias = "GTK_STACK_TRANSITION_TYPE_OVER_LEFT_RIGHT")]
    OverLeftRight,
    #[doc(alias = "GTK_STACK_TRANSITION_TYPE_OVER_RIGHT_LEFT")]
    OverRightLeft,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for StackTransitionType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "StackTransitionType::{}",
            match *self {
                Self::None => "None",
                Self::Crossfade => "Crossfade",
                Self::SlideRight => "SlideRight",
                Self::SlideLeft => "SlideLeft",
                Self::SlideUp => "SlideUp",
                Self::SlideDown => "SlideDown",
                Self::SlideLeftRight => "SlideLeftRight",
                Self::SlideUpDown => "SlideUpDown",
                Self::OverUp => "OverUp",
                Self::OverDown => "OverDown",
                Self::OverLeft => "OverLeft",
                Self::OverRight => "OverRight",
                Self::UnderUp => "UnderUp",
                Self::UnderDown => "UnderDown",
                Self::UnderLeft => "UnderLeft",
                Self::UnderRight => "UnderRight",
                Self::OverUpDown => "OverUpDown",
                Self::OverDownUp => "OverDownUp",
                Self::OverLeftRight => "OverLeftRight",
                Self::OverRightLeft => "OverRightLeft",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for StackTransitionType {
    type GlibType = ffi::GtkStackTransitionType;

    fn into_glib(self) -> ffi::GtkStackTransitionType {
        match self {
            Self::None => ffi::GTK_STACK_TRANSITION_TYPE_NONE,
            Self::Crossfade => ffi::GTK_STACK_TRANSITION_TYPE_CROSSFADE,
            Self::SlideRight => ffi::GTK_STACK_TRANSITION_TYPE_SLIDE_RIGHT,
            Self::SlideLeft => ffi::GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT,
            Self::SlideUp => ffi::GTK_STACK_TRANSITION_TYPE_SLIDE_UP,
            Self::SlideDown => ffi::GTK_STACK_TRANSITION_TYPE_SLIDE_DOWN,
            Self::SlideLeftRight => ffi::GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT_RIGHT,
            Self::SlideUpDown => ffi::GTK_STACK_TRANSITION_TYPE_SLIDE_UP_DOWN,
            Self::OverUp => ffi::GTK_STACK_TRANSITION_TYPE_OVER_UP,
            Self::OverDown => ffi::GTK_STACK_TRANSITION_TYPE_OVER_DOWN,
            Self::OverLeft => ffi::GTK_STACK_TRANSITION_TYPE_OVER_LEFT,
            Self::OverRight => ffi::GTK_STACK_TRANSITION_TYPE_OVER_RIGHT,
            Self::UnderUp => ffi::GTK_STACK_TRANSITION_TYPE_UNDER_UP,
            Self::UnderDown => ffi::GTK_STACK_TRANSITION_TYPE_UNDER_DOWN,
            Self::UnderLeft => ffi::GTK_STACK_TRANSITION_TYPE_UNDER_LEFT,
            Self::UnderRight => ffi::GTK_STACK_TRANSITION_TYPE_UNDER_RIGHT,
            Self::OverUpDown => ffi::GTK_STACK_TRANSITION_TYPE_OVER_UP_DOWN,
            Self::OverDownUp => ffi::GTK_STACK_TRANSITION_TYPE_OVER_DOWN_UP,
            Self::OverLeftRight => ffi::GTK_STACK_TRANSITION_TYPE_OVER_LEFT_RIGHT,
            Self::OverRightLeft => ffi::GTK_STACK_TRANSITION_TYPE_OVER_RIGHT_LEFT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkStackTransitionType> for StackTransitionType {
    unsafe fn from_glib(value: ffi::GtkStackTransitionType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_STACK_TRANSITION_TYPE_NONE => Self::None,
            ffi::GTK_STACK_TRANSITION_TYPE_CROSSFADE => Self::Crossfade,
            ffi::GTK_STACK_TRANSITION_TYPE_SLIDE_RIGHT => Self::SlideRight,
            ffi::GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT => Self::SlideLeft,
            ffi::GTK_STACK_TRANSITION_TYPE_SLIDE_UP => Self::SlideUp,
            ffi::GTK_STACK_TRANSITION_TYPE_SLIDE_DOWN => Self::SlideDown,
            ffi::GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT_RIGHT => Self::SlideLeftRight,
            ffi::GTK_STACK_TRANSITION_TYPE_SLIDE_UP_DOWN => Self::SlideUpDown,
            ffi::GTK_STACK_TRANSITION_TYPE_OVER_UP => Self::OverUp,
            ffi::GTK_STACK_TRANSITION_TYPE_OVER_DOWN => Self::OverDown,
            ffi::GTK_STACK_TRANSITION_TYPE_OVER_LEFT => Self::OverLeft,
            ffi::GTK_STACK_TRANSITION_TYPE_OVER_RIGHT => Self::OverRight,
            ffi::GTK_STACK_TRANSITION_TYPE_UNDER_UP => Self::UnderUp,
            ffi::GTK_STACK_TRANSITION_TYPE_UNDER_DOWN => Self::UnderDown,
            ffi::GTK_STACK_TRANSITION_TYPE_UNDER_LEFT => Self::UnderLeft,
            ffi::GTK_STACK_TRANSITION_TYPE_UNDER_RIGHT => Self::UnderRight,
            ffi::GTK_STACK_TRANSITION_TYPE_OVER_UP_DOWN => Self::OverUpDown,
            ffi::GTK_STACK_TRANSITION_TYPE_OVER_DOWN_UP => Self::OverDownUp,
            ffi::GTK_STACK_TRANSITION_TYPE_OVER_LEFT_RIGHT => Self::OverLeftRight,
            ffi::GTK_STACK_TRANSITION_TYPE_OVER_RIGHT_LEFT => Self::OverRightLeft,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for StackTransitionType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_stack_transition_type_get_type()) }
    }
}

impl glib::value::ValueType for StackTransitionType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for StackTransitionType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for StackTransitionType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkTextDirection")]
pub enum TextDirection {
    #[doc(alias = "GTK_TEXT_DIR_NONE")]
    None,
    #[doc(alias = "GTK_TEXT_DIR_LTR")]
    Ltr,
    #[doc(alias = "GTK_TEXT_DIR_RTL")]
    Rtl,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for TextDirection {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "TextDirection::{}",
            match *self {
                Self::None => "None",
                Self::Ltr => "Ltr",
                Self::Rtl => "Rtl",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for TextDirection {
    type GlibType = ffi::GtkTextDirection;

    fn into_glib(self) -> ffi::GtkTextDirection {
        match self {
            Self::None => ffi::GTK_TEXT_DIR_NONE,
            Self::Ltr => ffi::GTK_TEXT_DIR_LTR,
            Self::Rtl => ffi::GTK_TEXT_DIR_RTL,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkTextDirection> for TextDirection {
    unsafe fn from_glib(value: ffi::GtkTextDirection) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_TEXT_DIR_NONE => Self::None,
            ffi::GTK_TEXT_DIR_LTR => Self::Ltr,
            ffi::GTK_TEXT_DIR_RTL => Self::Rtl,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for TextDirection {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_text_direction_get_type()) }
    }
}

impl glib::value::ValueType for TextDirection {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for TextDirection {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for TextDirection {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkTextExtendSelection")]
pub enum TextExtendSelection {
    #[doc(alias = "GTK_TEXT_EXTEND_SELECTION_WORD")]
    Word,
    #[doc(alias = "GTK_TEXT_EXTEND_SELECTION_LINE")]
    Line,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for TextExtendSelection {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "TextExtendSelection::{}",
            match *self {
                Self::Word => "Word",
                Self::Line => "Line",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for TextExtendSelection {
    type GlibType = ffi::GtkTextExtendSelection;

    fn into_glib(self) -> ffi::GtkTextExtendSelection {
        match self {
            Self::Word => ffi::GTK_TEXT_EXTEND_SELECTION_WORD,
            Self::Line => ffi::GTK_TEXT_EXTEND_SELECTION_LINE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkTextExtendSelection> for TextExtendSelection {
    unsafe fn from_glib(value: ffi::GtkTextExtendSelection) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_TEXT_EXTEND_SELECTION_WORD => Self::Word,
            ffi::GTK_TEXT_EXTEND_SELECTION_LINE => Self::Line,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for TextExtendSelection {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_text_extend_selection_get_type()) }
    }
}

impl glib::value::ValueType for TextExtendSelection {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for TextExtendSelection {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for TextExtendSelection {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkTextViewLayer")]
pub enum TextViewLayer {
    #[doc(alias = "GTK_TEXT_VIEW_LAYER_BELOW")]
    Below,
    #[doc(alias = "GTK_TEXT_VIEW_LAYER_ABOVE")]
    Above,
    #[doc(alias = "GTK_TEXT_VIEW_LAYER_BELOW_TEXT")]
    BelowText,
    #[doc(alias = "GTK_TEXT_VIEW_LAYER_ABOVE_TEXT")]
    AboveText,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for TextViewLayer {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "TextViewLayer::{}",
            match *self {
                Self::Below => "Below",
                Self::Above => "Above",
                Self::BelowText => "BelowText",
                Self::AboveText => "AboveText",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for TextViewLayer {
    type GlibType = ffi::GtkTextViewLayer;

    fn into_glib(self) -> ffi::GtkTextViewLayer {
        match self {
            Self::Below => ffi::GTK_TEXT_VIEW_LAYER_BELOW,
            Self::Above => ffi::GTK_TEXT_VIEW_LAYER_ABOVE,
            Self::BelowText => ffi::GTK_TEXT_VIEW_LAYER_BELOW_TEXT,
            Self::AboveText => ffi::GTK_TEXT_VIEW_LAYER_ABOVE_TEXT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkTextViewLayer> for TextViewLayer {
    unsafe fn from_glib(value: ffi::GtkTextViewLayer) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_TEXT_VIEW_LAYER_BELOW => Self::Below,
            ffi::GTK_TEXT_VIEW_LAYER_ABOVE => Self::Above,
            ffi::GTK_TEXT_VIEW_LAYER_BELOW_TEXT => Self::BelowText,
            ffi::GTK_TEXT_VIEW_LAYER_ABOVE_TEXT => Self::AboveText,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for TextViewLayer {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_text_view_layer_get_type()) }
    }
}

impl glib::value::ValueType for TextViewLayer {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for TextViewLayer {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for TextViewLayer {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkTextWindowType")]
pub enum TextWindowType {
    #[doc(alias = "GTK_TEXT_WINDOW_PRIVATE")]
    Private,
    #[doc(alias = "GTK_TEXT_WINDOW_WIDGET")]
    Widget,
    #[doc(alias = "GTK_TEXT_WINDOW_TEXT")]
    Text,
    #[doc(alias = "GTK_TEXT_WINDOW_LEFT")]
    Left,
    #[doc(alias = "GTK_TEXT_WINDOW_RIGHT")]
    Right,
    #[doc(alias = "GTK_TEXT_WINDOW_TOP")]
    Top,
    #[doc(alias = "GTK_TEXT_WINDOW_BOTTOM")]
    Bottom,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for TextWindowType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "TextWindowType::{}",
            match *self {
                Self::Private => "Private",
                Self::Widget => "Widget",
                Self::Text => "Text",
                Self::Left => "Left",
                Self::Right => "Right",
                Self::Top => "Top",
                Self::Bottom => "Bottom",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for TextWindowType {
    type GlibType = ffi::GtkTextWindowType;

    fn into_glib(self) -> ffi::GtkTextWindowType {
        match self {
            Self::Private => ffi::GTK_TEXT_WINDOW_PRIVATE,
            Self::Widget => ffi::GTK_TEXT_WINDOW_WIDGET,
            Self::Text => ffi::GTK_TEXT_WINDOW_TEXT,
            Self::Left => ffi::GTK_TEXT_WINDOW_LEFT,
            Self::Right => ffi::GTK_TEXT_WINDOW_RIGHT,
            Self::Top => ffi::GTK_TEXT_WINDOW_TOP,
            Self::Bottom => ffi::GTK_TEXT_WINDOW_BOTTOM,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkTextWindowType> for TextWindowType {
    unsafe fn from_glib(value: ffi::GtkTextWindowType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_TEXT_WINDOW_PRIVATE => Self::Private,
            ffi::GTK_TEXT_WINDOW_WIDGET => Self::Widget,
            ffi::GTK_TEXT_WINDOW_TEXT => Self::Text,
            ffi::GTK_TEXT_WINDOW_LEFT => Self::Left,
            ffi::GTK_TEXT_WINDOW_RIGHT => Self::Right,
            ffi::GTK_TEXT_WINDOW_TOP => Self::Top,
            ffi::GTK_TEXT_WINDOW_BOTTOM => Self::Bottom,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for TextWindowType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_text_window_type_get_type()) }
    }
}

impl glib::value::ValueType for TextWindowType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for TextWindowType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for TextWindowType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkToolbarStyle")]
pub enum ToolbarStyle {
    #[doc(alias = "GTK_TOOLBAR_ICONS")]
    Icons,
    #[doc(alias = "GTK_TOOLBAR_TEXT")]
    Text,
    #[doc(alias = "GTK_TOOLBAR_BOTH")]
    Both,
    #[doc(alias = "GTK_TOOLBAR_BOTH_HORIZ")]
    BothHoriz,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for ToolbarStyle {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "ToolbarStyle::{}",
            match *self {
                Self::Icons => "Icons",
                Self::Text => "Text",
                Self::Both => "Both",
                Self::BothHoriz => "BothHoriz",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for ToolbarStyle {
    type GlibType = ffi::GtkToolbarStyle;

    fn into_glib(self) -> ffi::GtkToolbarStyle {
        match self {
            Self::Icons => ffi::GTK_TOOLBAR_ICONS,
            Self::Text => ffi::GTK_TOOLBAR_TEXT,
            Self::Both => ffi::GTK_TOOLBAR_BOTH,
            Self::BothHoriz => ffi::GTK_TOOLBAR_BOTH_HORIZ,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkToolbarStyle> for ToolbarStyle {
    unsafe fn from_glib(value: ffi::GtkToolbarStyle) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_TOOLBAR_ICONS => Self::Icons,
            ffi::GTK_TOOLBAR_TEXT => Self::Text,
            ffi::GTK_TOOLBAR_BOTH => Self::Both,
            ffi::GTK_TOOLBAR_BOTH_HORIZ => Self::BothHoriz,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for ToolbarStyle {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_toolbar_style_get_type()) }
    }
}

impl glib::value::ValueType for ToolbarStyle {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for ToolbarStyle {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ToolbarStyle {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkTreeViewColumnSizing")]
pub enum TreeViewColumnSizing {
    #[doc(alias = "GTK_TREE_VIEW_COLUMN_GROW_ONLY")]
    GrowOnly,
    #[doc(alias = "GTK_TREE_VIEW_COLUMN_AUTOSIZE")]
    Autosize,
    #[doc(alias = "GTK_TREE_VIEW_COLUMN_FIXED")]
    Fixed,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for TreeViewColumnSizing {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "TreeViewColumnSizing::{}",
            match *self {
                Self::GrowOnly => "GrowOnly",
                Self::Autosize => "Autosize",
                Self::Fixed => "Fixed",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for TreeViewColumnSizing {
    type GlibType = ffi::GtkTreeViewColumnSizing;

    fn into_glib(self) -> ffi::GtkTreeViewColumnSizing {
        match self {
            Self::GrowOnly => ffi::GTK_TREE_VIEW_COLUMN_GROW_ONLY,
            Self::Autosize => ffi::GTK_TREE_VIEW_COLUMN_AUTOSIZE,
            Self::Fixed => ffi::GTK_TREE_VIEW_COLUMN_FIXED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkTreeViewColumnSizing> for TreeViewColumnSizing {
    unsafe fn from_glib(value: ffi::GtkTreeViewColumnSizing) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_TREE_VIEW_COLUMN_GROW_ONLY => Self::GrowOnly,
            ffi::GTK_TREE_VIEW_COLUMN_AUTOSIZE => Self::Autosize,
            ffi::GTK_TREE_VIEW_COLUMN_FIXED => Self::Fixed,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for TreeViewColumnSizing {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_tree_view_column_sizing_get_type()) }
    }
}

impl glib::value::ValueType for TreeViewColumnSizing {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for TreeViewColumnSizing {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for TreeViewColumnSizing {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkTreeViewDropPosition")]
pub enum TreeViewDropPosition {
    #[doc(alias = "GTK_TREE_VIEW_DROP_BEFORE")]
    Before,
    #[doc(alias = "GTK_TREE_VIEW_DROP_AFTER")]
    After,
    #[doc(alias = "GTK_TREE_VIEW_DROP_INTO_OR_BEFORE")]
    IntoOrBefore,
    #[doc(alias = "GTK_TREE_VIEW_DROP_INTO_OR_AFTER")]
    IntoOrAfter,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for TreeViewDropPosition {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "TreeViewDropPosition::{}",
            match *self {
                Self::Before => "Before",
                Self::After => "After",
                Self::IntoOrBefore => "IntoOrBefore",
                Self::IntoOrAfter => "IntoOrAfter",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for TreeViewDropPosition {
    type GlibType = ffi::GtkTreeViewDropPosition;

    fn into_glib(self) -> ffi::GtkTreeViewDropPosition {
        match self {
            Self::Before => ffi::GTK_TREE_VIEW_DROP_BEFORE,
            Self::After => ffi::GTK_TREE_VIEW_DROP_AFTER,
            Self::IntoOrBefore => ffi::GTK_TREE_VIEW_DROP_INTO_OR_BEFORE,
            Self::IntoOrAfter => ffi::GTK_TREE_VIEW_DROP_INTO_OR_AFTER,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkTreeViewDropPosition> for TreeViewDropPosition {
    unsafe fn from_glib(value: ffi::GtkTreeViewDropPosition) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_TREE_VIEW_DROP_BEFORE => Self::Before,
            ffi::GTK_TREE_VIEW_DROP_AFTER => Self::After,
            ffi::GTK_TREE_VIEW_DROP_INTO_OR_BEFORE => Self::IntoOrBefore,
            ffi::GTK_TREE_VIEW_DROP_INTO_OR_AFTER => Self::IntoOrAfter,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for TreeViewDropPosition {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_tree_view_drop_position_get_type()) }
    }
}

impl glib::value::ValueType for TreeViewDropPosition {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for TreeViewDropPosition {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for TreeViewDropPosition {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkTreeViewGridLines")]
pub enum TreeViewGridLines {
    #[doc(alias = "GTK_TREE_VIEW_GRID_LINES_NONE")]
    None,
    #[doc(alias = "GTK_TREE_VIEW_GRID_LINES_HORIZONTAL")]
    Horizontal,
    #[doc(alias = "GTK_TREE_VIEW_GRID_LINES_VERTICAL")]
    Vertical,
    #[doc(alias = "GTK_TREE_VIEW_GRID_LINES_BOTH")]
    Both,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for TreeViewGridLines {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "TreeViewGridLines::{}",
            match *self {
                Self::None => "None",
                Self::Horizontal => "Horizontal",
                Self::Vertical => "Vertical",
                Self::Both => "Both",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for TreeViewGridLines {
    type GlibType = ffi::GtkTreeViewGridLines;

    fn into_glib(self) -> ffi::GtkTreeViewGridLines {
        match self {
            Self::None => ffi::GTK_TREE_VIEW_GRID_LINES_NONE,
            Self::Horizontal => ffi::GTK_TREE_VIEW_GRID_LINES_HORIZONTAL,
            Self::Vertical => ffi::GTK_TREE_VIEW_GRID_LINES_VERTICAL,
            Self::Both => ffi::GTK_TREE_VIEW_GRID_LINES_BOTH,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkTreeViewGridLines> for TreeViewGridLines {
    unsafe fn from_glib(value: ffi::GtkTreeViewGridLines) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_TREE_VIEW_GRID_LINES_NONE => Self::None,
            ffi::GTK_TREE_VIEW_GRID_LINES_HORIZONTAL => Self::Horizontal,
            ffi::GTK_TREE_VIEW_GRID_LINES_VERTICAL => Self::Vertical,
            ffi::GTK_TREE_VIEW_GRID_LINES_BOTH => Self::Both,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for TreeViewGridLines {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_tree_view_grid_lines_get_type()) }
    }
}

impl glib::value::ValueType for TreeViewGridLines {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for TreeViewGridLines {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for TreeViewGridLines {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkUnit")]
pub enum Unit {
    #[doc(alias = "GTK_UNIT_NONE")]
    None,
    #[doc(alias = "GTK_UNIT_POINTS")]
    Points,
    #[doc(alias = "GTK_UNIT_INCH")]
    Inch,
    #[doc(alias = "GTK_UNIT_MM")]
    Mm,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Unit {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Unit::{}",
            match *self {
                Self::None => "None",
                Self::Points => "Points",
                Self::Inch => "Inch",
                Self::Mm => "Mm",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for Unit {
    type GlibType = ffi::GtkUnit;

    fn into_glib(self) -> ffi::GtkUnit {
        match self {
            Self::None => ffi::GTK_UNIT_NONE,
            Self::Points => ffi::GTK_UNIT_POINTS,
            Self::Inch => ffi::GTK_UNIT_INCH,
            Self::Mm => ffi::GTK_UNIT_MM,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkUnit> for Unit {
    unsafe fn from_glib(value: ffi::GtkUnit) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_UNIT_NONE => Self::None,
            ffi::GTK_UNIT_POINTS => Self::Points,
            ffi::GTK_UNIT_INCH => Self::Inch,
            ffi::GTK_UNIT_MM => Self::Mm,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for Unit {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_unit_get_type()) }
    }
}

impl glib::value::ValueType for Unit {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for Unit {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for Unit {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkWidgetHelpType")]
pub enum WidgetHelpType {
    #[doc(alias = "GTK_WIDGET_HELP_TOOLTIP")]
    Tooltip,
    #[doc(alias = "GTK_WIDGET_HELP_WHATS_THIS")]
    WhatsThis,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for WidgetHelpType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "WidgetHelpType::{}",
            match *self {
                Self::Tooltip => "Tooltip",
                Self::WhatsThis => "WhatsThis",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for WidgetHelpType {
    type GlibType = ffi::GtkWidgetHelpType;

    fn into_glib(self) -> ffi::GtkWidgetHelpType {
        match self {
            Self::Tooltip => ffi::GTK_WIDGET_HELP_TOOLTIP,
            Self::WhatsThis => ffi::GTK_WIDGET_HELP_WHATS_THIS,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkWidgetHelpType> for WidgetHelpType {
    unsafe fn from_glib(value: ffi::GtkWidgetHelpType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_WIDGET_HELP_TOOLTIP => Self::Tooltip,
            ffi::GTK_WIDGET_HELP_WHATS_THIS => Self::WhatsThis,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for WidgetHelpType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_widget_help_type_get_type()) }
    }
}

impl glib::value::ValueType for WidgetHelpType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for WidgetHelpType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for WidgetHelpType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkWindowPosition")]
pub enum WindowPosition {
    #[doc(alias = "GTK_WIN_POS_NONE")]
    None,
    #[doc(alias = "GTK_WIN_POS_CENTER")]
    Center,
    #[doc(alias = "GTK_WIN_POS_MOUSE")]
    Mouse,
    #[doc(alias = "GTK_WIN_POS_CENTER_ALWAYS")]
    CenterAlways,
    #[doc(alias = "GTK_WIN_POS_CENTER_ON_PARENT")]
    CenterOnParent,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for WindowPosition {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "WindowPosition::{}",
            match *self {
                Self::None => "None",
                Self::Center => "Center",
                Self::Mouse => "Mouse",
                Self::CenterAlways => "CenterAlways",
                Self::CenterOnParent => "CenterOnParent",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for WindowPosition {
    type GlibType = ffi::GtkWindowPosition;

    fn into_glib(self) -> ffi::GtkWindowPosition {
        match self {
            Self::None => ffi::GTK_WIN_POS_NONE,
            Self::Center => ffi::GTK_WIN_POS_CENTER,
            Self::Mouse => ffi::GTK_WIN_POS_MOUSE,
            Self::CenterAlways => ffi::GTK_WIN_POS_CENTER_ALWAYS,
            Self::CenterOnParent => ffi::GTK_WIN_POS_CENTER_ON_PARENT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkWindowPosition> for WindowPosition {
    unsafe fn from_glib(value: ffi::GtkWindowPosition) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_WIN_POS_NONE => Self::None,
            ffi::GTK_WIN_POS_CENTER => Self::Center,
            ffi::GTK_WIN_POS_MOUSE => Self::Mouse,
            ffi::GTK_WIN_POS_CENTER_ALWAYS => Self::CenterAlways,
            ffi::GTK_WIN_POS_CENTER_ON_PARENT => Self::CenterOnParent,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for WindowPosition {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_window_position_get_type()) }
    }
}

impl glib::value::ValueType for WindowPosition {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for WindowPosition {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for WindowPosition {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkWindowType")]
pub enum WindowType {
    #[doc(alias = "GTK_WINDOW_TOPLEVEL")]
    Toplevel,
    #[doc(alias = "GTK_WINDOW_POPUP")]
    Popup,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for WindowType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "WindowType::{}",
            match *self {
                Self::Toplevel => "Toplevel",
                Self::Popup => "Popup",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for WindowType {
    type GlibType = ffi::GtkWindowType;

    fn into_glib(self) -> ffi::GtkWindowType {
        match self {
            Self::Toplevel => ffi::GTK_WINDOW_TOPLEVEL,
            Self::Popup => ffi::GTK_WINDOW_POPUP,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkWindowType> for WindowType {
    unsafe fn from_glib(value: ffi::GtkWindowType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_WINDOW_TOPLEVEL => Self::Toplevel,
            ffi::GTK_WINDOW_POPUP => Self::Popup,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for WindowType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_window_type_get_type()) }
    }
}

impl glib::value::ValueType for WindowType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for WindowType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for WindowType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GtkWrapMode")]
pub enum WrapMode {
    #[doc(alias = "GTK_WRAP_NONE")]
    None,
    #[doc(alias = "GTK_WRAP_CHAR")]
    Char,
    #[doc(alias = "GTK_WRAP_WORD")]
    Word,
    #[doc(alias = "GTK_WRAP_WORD_CHAR")]
    WordChar,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for WrapMode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "WrapMode::{}",
            match *self {
                Self::None => "None",
                Self::Char => "Char",
                Self::Word => "Word",
                Self::WordChar => "WordChar",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for WrapMode {
    type GlibType = ffi::GtkWrapMode;

    fn into_glib(self) -> ffi::GtkWrapMode {
        match self {
            Self::None => ffi::GTK_WRAP_NONE,
            Self::Char => ffi::GTK_WRAP_CHAR,
            Self::Word => ffi::GTK_WRAP_WORD,
            Self::WordChar => ffi::GTK_WRAP_WORD_CHAR,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GtkWrapMode> for WrapMode {
    unsafe fn from_glib(value: ffi::GtkWrapMode) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GTK_WRAP_NONE => Self::None,
            ffi::GTK_WRAP_CHAR => Self::Char,
            ffi::GTK_WRAP_WORD => Self::Word,
            ffi::GTK_WRAP_WORD_CHAR => Self::WordChar,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for WrapMode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gtk_wrap_mode_get_type()) }
    }
}

impl glib::value::ValueType for WrapMode {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for WrapMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for WrapMode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}
