//! Practical Salinity Constants
//!

// Constants from Appendix E.1
pub(crate) const A0: f64 = 0.008_0;
pub(crate) const A1: f64 = -0.169_2;
pub(crate) const A2: f64 = 25.385_1;
pub(crate) const A3: f64 = 14.094_1;
pub(crate) const A4: f64 = -7.026_1;
pub(crate) const A5: f64 = 2.708_1;

pub(crate) const B0: f64 = 0.000_5;
pub(crate) const B1: f64 = -0.005_6;
pub(crate) const B2: f64 = -0.006_6;
pub(crate) const B3: f64 = -0.037_5;
pub(crate) const B4: f64 = 0.063_6;
pub(crate) const B5: f64 = -0.014_4;

pub(crate) const C0: f64 = 0.676_609_7;
pub(crate) const C1: f64 = 2.005_64e-2;
pub(crate) const C2: f64 = 1.104_259e-4;
pub(crate) const C3: f64 = -6.969_8e-7;
pub(crate) const C4: f64 = 1.003_1e-9;

pub(crate) const D1: f64 = 3.426e-2;
pub(crate) const D2: f64 = 4.464e-4;
pub(crate) const D3: f64 = 4.215e-1;
pub(crate) const D4: f64 = -3.107e-3;

pub(crate) const E1: f64 = 2.070e-5;
pub(crate) const E2: f64 = -6.370e-10;
pub(crate) const E3: f64 = 3.989e-15;

// Consider rename K to something different
pub(crate) const K: f64 = 0.016_2;

pub(crate) const P0: f64 = 4.577_801_212_923_119e-3;
pub(crate) const P1: f64 = 1.924_049_429_136_64e-1;
pub(crate) const P2: f64 = 2.183_871_685_127_932e-5;
pub(crate) const P3: f64 = -7.292_156_330_457_999e-3;
pub(crate) const P4: f64 = 1.568_129_536_470_258e-4;
pub(crate) const P5: f64 = -1.478_995_271_680_869e-6;
pub(crate) const P6: f64 = 9.086_442_524_716_395e-4;
pub(crate) const P7: f64 = -1.949_560_839_540_487e-5;
pub(crate) const P8: f64 = -3.223_058_111_118_377e-6;
pub(crate) const P9: f64 = 1.175_871_639_741_131e-7;
pub(crate) const P10: f64 = -7.522_895_856_600_089e-5;
pub(crate) const P11: f64 = -2.254_458_513_439_107e-6;
pub(crate) const P12: f64 = 6.179_992_190_192_848e-7;
pub(crate) const P13: f64 = 1.005_054_226_996_868e-8;
pub(crate) const P14: f64 = -1.923_745_566_122_602e-9;
pub(crate) const P15: f64 = 2.259_550_611_212_616e-6;
pub(crate) const P16: f64 = 1.631_749_165_091_437e-7;
pub(crate) const P17: f64 = -5.931_857_989_915_256e-9;
pub(crate) const P18: f64 = -4.693_392_029_005_252e-9;
pub(crate) const P19: f64 = 2.571_854_839_274_148e-10;
pub(crate) const P20: f64 = 4.198_786_822_861_038e-12;

pub(crate) const Q0: f64 = 5.540_896_868_127_855e-5;
pub(crate) const Q1: f64 = 2.015_419_291_097_848e-1;
pub(crate) const Q2: f64 = -1.445_310_045_430_192e-5;
pub(crate) const Q3: f64 = -1.567_047_628_411_722e-2;
pub(crate) const Q4: f64 = 2.464_756_294_660_119e-4;
pub(crate) const Q5: f64 = -2.575_458_304_732_166e-7;
pub(crate) const Q6: f64 = 5.071_449_842_454_419e-3;
pub(crate) const Q7: f64 = -9.081_985_795_339_206e-5;
pub(crate) const Q8: f64 = -3.635_420_818_812_898e-6;
pub(crate) const Q9: f64 = 2.249_490_528_450_555e-8;
pub(crate) const Q10: f64 = -1.143_810_377_431_888e-3;
pub(crate) const Q11: f64 = 2.066_112_484_281_53e-5;
pub(crate) const Q12: f64 = 7.482_907_137_737_503e-7;
pub(crate) const Q13: f64 = 4.019_321_577_844_724e-8;
pub(crate) const Q14: f64 = -5.755_568_141_370_501e-10;
pub(crate) const Q15: f64 = 1.120_748_754_429_459e-4;
pub(crate) const Q16: f64 = -2.420_274_029_674_485e-6;
pub(crate) const Q17: f64 = -4.774_829_347_564_67e-8;
pub(crate) const Q18: f64 = -4.279_037_686_797_859e-9;
pub(crate) const Q19: f64 = -2.045_829_202_713_288e-10;
pub(crate) const Q20: f64 = 5.025_109_163_112_005e-12;

/*
pub(crate) const R0: f64 = 3.432285006604888e-3;
pub(crate) const R1: f64 = 1.672940491817403e-1;
pub(crate) const R2: f64 = 2.640304401023995e-5;
pub(crate) const R3: f64 = 1.082267090441036e-1;
pub(crate) const R4: f64 = -6.296778883666940e-5;
pub(crate) const R5: f64 = -4.542775152303671e-7;
pub(crate) const R6: f64 = -1.859711038699727e-1;
pub(crate) const R7: f64 = 7.659006320303959e-4;
pub(crate) const R8: f64 = -4.794661268817618e-7;
pub(crate) const R9: f64 = 8.093368602891911e-9;
pub(crate) const R10: f64 = 1.001140606840692e-1;
pub(crate) const R11: f64 = -1.038712945546608e-3;
pub(crate) const R12: f64 = -6.227915160991074e-6;
pub(crate) const R13: f64 = 2.798564479737090e-8;
pub(crate) const R14: f64 = -1.343623657549961e-10;
pub(crate) const R15: f64 = 1.024345179842964e-2;
pub(crate) const R16: f64 = 4.981135430579384e-4;
pub(crate) const R17: f64 = 4.466087528793912e-6;
pub(crate) const R18: f64 = 1.960872795577774e-8;
pub(crate) const R19: f64 = -2.723159418888634e-10;
pub(crate) const R20: f64 = 1.122200786423241e-12;
*/

pub(crate) const S0: f64 = 3.432_285_006_604_888e-3;
pub(crate) const S1: f64 = 1.672_940_491_817_403e-1;
pub(crate) const S2: f64 = 2.640_304_401_023_995e-5;
pub(crate) const S3: f64 = 1.082_267_090_441_036e-1;
pub(crate) const S4: f64 = -6.296_778_883_666_94e-5;
pub(crate) const S5: f64 = -4.542_775_152_303_671e-7;
pub(crate) const S6: f64 = -1.859_711_038_699_727e-1;
pub(crate) const S7: f64 = 7.659_006_320_303_959e-4;
pub(crate) const S8: f64 = -4.794_661_268_817_618e-7;
pub(crate) const S9: f64 = 8.093_368_602_891_911e-9;
pub(crate) const S10: f64 = 1.001_140_606_840_692e-1;
pub(crate) const S11: f64 = -1.038_712_945_546_608e-3;
pub(crate) const S12: f64 = -6.227_915_160_991_074e-6;
pub(crate) const S13: f64 = 2.798_564_479_737_09e-8;
pub(crate) const S14: f64 = -1.343_623_657_549_961e-10;
pub(crate) const S15: f64 = 1.024_345_179_842_964e-2;
pub(crate) const S16: f64 = 4.981_135_430_579_384e-4;
pub(crate) const S17: f64 = 4.466_087_528_793_912e-6;
pub(crate) const S18: f64 = 1.960_872_795_577_774e-8;
pub(crate) const S19: f64 = -2.723_159_418_888_634e-10;
pub(crate) const S20: f64 = 1.122_200_786_423_241e-12;

pub(crate) const U0: f64 = 5.180_529_787_390_576e-3;
pub(crate) const U1: f64 = 1.052_097_167_201_052e-3;
pub(crate) const U2: f64 = 3.666_193_708_310_848e-5;
pub(crate) const U3: f64 = 7.112_223_828_976_632;
pub(crate) const U4: f64 = -3.631_366_777_096_209e-4;
pub(crate) const U5: f64 = -7.336_295_318_742_821e-7;
pub(crate) const U6: f64 = -1.576_886_793_288_888e2;
pub(crate) const U7: f64 = -1.840_239_113_483_083e-3;
pub(crate) const U8: f64 = 8.624_279_120_240_952e-6;
pub(crate) const U9: f64 = 1.233_529_799_729_501e-8;
pub(crate) const U10: f64 = 1.826_482_800_939_545e3;
pub(crate) const U11: f64 = 1.633_903_983_457_674e-1;
pub(crate) const U12: f64 = -9.201_096_427_222_349e-5;
pub(crate) const U13: f64 = -9.187_900_959_754_842e-8;
pub(crate) const U14: f64 = -1.442_010_369_809_705e-10;
pub(crate) const U15: f64 = -8.542_357_182_595_853e3;
pub(crate) const U16: f64 = -1.408_635_241_899_082;
pub(crate) const U17: f64 = 1.660_164_829_963_661e-4;
pub(crate) const U18: f64 = 6.797_409_608_973_845e-7;
pub(crate) const U19: f64 = 3.345_074_990_451_475e-10;
pub(crate) const U20: f64 = 8.285_687_652_694_768e-13;
