// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

use crate::Object;
use crate::TaskPool;
use crate::TaskState;
use glib::object::IsA;
use glib::translate::*;

glib::wrapper! {
    #[doc(alias = "GstTask")]
    pub struct Task(Object<ffi::GstTask, ffi::GstTaskClass>) @extends Object;

    match fn {
        type_ => || ffi::gst_task_get_type(),
    }
}

impl Task {
    pub const NONE: Option<&'static Task> = None;

    #[doc(alias = "gst_task_cleanup_all")]
    pub fn cleanup_all() {
        assert_initialized_main_thread!();
        unsafe {
            ffi::gst_task_cleanup_all();
        }
    }
}

unsafe impl Send for Task {}
unsafe impl Sync for Task {}

pub trait TaskExt: 'static {
    #[doc(alias = "gst_task_get_pool")]
    #[doc(alias = "get_pool")]
    fn pool(&self) -> TaskPool;

    #[doc(alias = "gst_task_get_state")]
    #[doc(alias = "get_state")]
    fn state(&self) -> TaskState;

    #[doc(alias = "gst_task_join")]
    fn join(&self) -> bool;

    #[doc(alias = "gst_task_pause")]
    fn pause(&self) -> bool;

    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    #[doc(alias = "gst_task_resume")]
    fn resume(&self) -> bool;

    #[doc(alias = "gst_task_set_pool")]
    fn set_pool(&self, pool: &impl IsA<TaskPool>);

    #[doc(alias = "gst_task_start")]
    fn start(&self) -> bool;

    #[doc(alias = "gst_task_stop")]
    fn stop(&self) -> bool;
}

impl<O: IsA<Task>> TaskExt for O {
    fn pool(&self) -> TaskPool {
        unsafe { from_glib_full(ffi::gst_task_get_pool(self.as_ref().to_glib_none().0)) }
    }

    fn state(&self) -> TaskState {
        unsafe { from_glib(ffi::gst_task_get_state(self.as_ref().to_glib_none().0)) }
    }

    fn join(&self) -> bool {
        unsafe { from_glib(ffi::gst_task_join(self.as_ref().to_glib_none().0)) }
    }

    fn pause(&self) -> bool {
        unsafe { from_glib(ffi::gst_task_pause(self.as_ref().to_glib_none().0)) }
    }

    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    fn resume(&self) -> bool {
        unsafe { from_glib(ffi::gst_task_resume(self.as_ref().to_glib_none().0)) }
    }

    fn set_pool(&self, pool: &impl IsA<TaskPool>) {
        unsafe {
            ffi::gst_task_set_pool(
                self.as_ref().to_glib_none().0,
                pool.as_ref().to_glib_none().0,
            );
        }
    }

    fn start(&self) -> bool {
        unsafe { from_glib(ffi::gst_task_start(self.as_ref().to_glib_none().0)) }
    }

    fn stop(&self) -> bool {
        unsafe { from_glib(ffi::gst_task_stop(self.as_ref().to_glib_none().0)) }
    }
}
