// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

use glib::translate::*;
use glib::value::FromValue;
use glib::value::ToValue;
use glib::StaticType;
use glib::Type;
use std::ffi::CStr;
use std::fmt;

#[cfg(any(feature = "v1_18", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstVideoAFDSpec")]
pub enum VideoAFDSpec {
    #[doc(alias = "GST_VIDEO_AFD_SPEC_DVB_ETSI")]
    DvbEtsi,
    #[doc(alias = "GST_VIDEO_AFD_SPEC_ATSC_A53")]
    AtscA53,
    #[doc(alias = "GST_VIDEO_AFD_SPEC_SMPTE_ST2016_1")]
    SmpteSt20161,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v1_18", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
#[doc(hidden)]
impl IntoGlib for VideoAFDSpec {
    type GlibType = ffi::GstVideoAFDSpec;

    fn into_glib(self) -> ffi::GstVideoAFDSpec {
        match self {
            Self::DvbEtsi => ffi::GST_VIDEO_AFD_SPEC_DVB_ETSI,
            Self::AtscA53 => ffi::GST_VIDEO_AFD_SPEC_ATSC_A53,
            Self::SmpteSt20161 => ffi::GST_VIDEO_AFD_SPEC_SMPTE_ST2016_1,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(any(feature = "v1_18", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
#[doc(hidden)]
impl FromGlib<ffi::GstVideoAFDSpec> for VideoAFDSpec {
    unsafe fn from_glib(value: ffi::GstVideoAFDSpec) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_VIDEO_AFD_SPEC_DVB_ETSI => Self::DvbEtsi,
            ffi::GST_VIDEO_AFD_SPEC_ATSC_A53 => Self::AtscA53,
            ffi::GST_VIDEO_AFD_SPEC_SMPTE_ST2016_1 => Self::SmpteSt20161,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v1_18", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
impl StaticType for VideoAFDSpec {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_video_afd_spec_get_type()) }
    }
}

#[cfg(any(feature = "v1_18", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
impl glib::value::ValueType for VideoAFDSpec {
    type Type = Self;
}

#[cfg(any(feature = "v1_18", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
unsafe impl<'a> FromValue<'a> for VideoAFDSpec {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v1_18", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
impl ToValue for VideoAFDSpec {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(any(feature = "v1_18", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstVideoAFDValue")]
pub enum VideoAFDValue {
    #[doc(alias = "GST_VIDEO_AFD_UNAVAILABLE")]
    Unavailable,
    #[doc(alias = "GST_VIDEO_AFD_16_9_TOP_ALIGNED")]
    _169TopAligned,
    #[doc(alias = "GST_VIDEO_AFD_14_9_TOP_ALIGNED")]
    _149TopAligned,
    #[doc(alias = "GST_VIDEO_AFD_GREATER_THAN_16_9")]
    GreaterThan169,
    #[doc(alias = "GST_VIDEO_AFD_4_3_FULL_16_9_FULL")]
    _43Full169Full,
    #[doc(alias = "GST_VIDEO_AFD_4_3_FULL_4_3_PILLAR")]
    _43Full43Pillar,
    #[doc(alias = "GST_VIDEO_AFD_16_9_LETTER_16_9_FULL")]
    _169Letter169Full,
    #[doc(alias = "GST_VIDEO_AFD_14_9_LETTER_14_9_PILLAR")]
    _149Letter149Pillar,
    #[doc(alias = "GST_VIDEO_AFD_4_3_FULL_14_9_CENTER")]
    _43Full149Center,
    #[doc(alias = "GST_VIDEO_AFD_16_9_LETTER_14_9_CENTER")]
    _169Letter149Center,
    #[doc(alias = "GST_VIDEO_AFD_16_9_LETTER_4_3_CENTER")]
    _169Letter43Center,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v1_18", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
#[doc(hidden)]
impl IntoGlib for VideoAFDValue {
    type GlibType = ffi::GstVideoAFDValue;

    fn into_glib(self) -> ffi::GstVideoAFDValue {
        match self {
            Self::Unavailable => ffi::GST_VIDEO_AFD_UNAVAILABLE,
            Self::_169TopAligned => ffi::GST_VIDEO_AFD_16_9_TOP_ALIGNED,
            Self::_149TopAligned => ffi::GST_VIDEO_AFD_14_9_TOP_ALIGNED,
            Self::GreaterThan169 => ffi::GST_VIDEO_AFD_GREATER_THAN_16_9,
            Self::_43Full169Full => ffi::GST_VIDEO_AFD_4_3_FULL_16_9_FULL,
            Self::_43Full43Pillar => ffi::GST_VIDEO_AFD_4_3_FULL_4_3_PILLAR,
            Self::_169Letter169Full => ffi::GST_VIDEO_AFD_16_9_LETTER_16_9_FULL,
            Self::_149Letter149Pillar => ffi::GST_VIDEO_AFD_14_9_LETTER_14_9_PILLAR,
            Self::_43Full149Center => ffi::GST_VIDEO_AFD_4_3_FULL_14_9_CENTER,
            Self::_169Letter149Center => ffi::GST_VIDEO_AFD_16_9_LETTER_14_9_CENTER,
            Self::_169Letter43Center => ffi::GST_VIDEO_AFD_16_9_LETTER_4_3_CENTER,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(any(feature = "v1_18", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
#[doc(hidden)]
impl FromGlib<ffi::GstVideoAFDValue> for VideoAFDValue {
    unsafe fn from_glib(value: ffi::GstVideoAFDValue) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_VIDEO_AFD_UNAVAILABLE => Self::Unavailable,
            ffi::GST_VIDEO_AFD_16_9_TOP_ALIGNED => Self::_169TopAligned,
            ffi::GST_VIDEO_AFD_14_9_TOP_ALIGNED => Self::_149TopAligned,
            ffi::GST_VIDEO_AFD_GREATER_THAN_16_9 => Self::GreaterThan169,
            ffi::GST_VIDEO_AFD_4_3_FULL_16_9_FULL => Self::_43Full169Full,
            ffi::GST_VIDEO_AFD_4_3_FULL_4_3_PILLAR => Self::_43Full43Pillar,
            ffi::GST_VIDEO_AFD_16_9_LETTER_16_9_FULL => Self::_169Letter169Full,
            ffi::GST_VIDEO_AFD_14_9_LETTER_14_9_PILLAR => Self::_149Letter149Pillar,
            ffi::GST_VIDEO_AFD_4_3_FULL_14_9_CENTER => Self::_43Full149Center,
            ffi::GST_VIDEO_AFD_16_9_LETTER_14_9_CENTER => Self::_169Letter149Center,
            ffi::GST_VIDEO_AFD_16_9_LETTER_4_3_CENTER => Self::_169Letter43Center,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v1_18", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
impl StaticType for VideoAFDValue {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_video_afd_value_get_type()) }
    }
}

#[cfg(any(feature = "v1_18", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
impl glib::value::ValueType for VideoAFDValue {
    type Type = Self;
}

#[cfg(any(feature = "v1_18", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
unsafe impl<'a> FromValue<'a> for VideoAFDValue {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v1_18", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
impl ToValue for VideoAFDValue {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstVideoAlphaMode")]
pub enum VideoAlphaMode {
    #[doc(alias = "GST_VIDEO_ALPHA_MODE_COPY")]
    Copy,
    #[doc(alias = "GST_VIDEO_ALPHA_MODE_SET")]
    Set,
    #[doc(alias = "GST_VIDEO_ALPHA_MODE_MULT")]
    Mult,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for VideoAlphaMode {
    type GlibType = ffi::GstVideoAlphaMode;

    fn into_glib(self) -> ffi::GstVideoAlphaMode {
        match self {
            Self::Copy => ffi::GST_VIDEO_ALPHA_MODE_COPY,
            Self::Set => ffi::GST_VIDEO_ALPHA_MODE_SET,
            Self::Mult => ffi::GST_VIDEO_ALPHA_MODE_MULT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstVideoAlphaMode> for VideoAlphaMode {
    unsafe fn from_glib(value: ffi::GstVideoAlphaMode) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_VIDEO_ALPHA_MODE_COPY => Self::Copy,
            ffi::GST_VIDEO_ALPHA_MODE_SET => Self::Set,
            ffi::GST_VIDEO_ALPHA_MODE_MULT => Self::Mult,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for VideoAlphaMode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_video_alpha_mode_get_type()) }
    }
}

impl glib::value::ValueType for VideoAlphaMode {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for VideoAlphaMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for VideoAlphaMode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(any(feature = "v1_16", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_16")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstVideoCaptionType")]
pub enum VideoCaptionType {
    #[doc(alias = "GST_VIDEO_CAPTION_TYPE_UNKNOWN")]
    Unknown,
    #[doc(alias = "GST_VIDEO_CAPTION_TYPE_CEA608_RAW")]
    Cea608Raw,
    #[doc(alias = "GST_VIDEO_CAPTION_TYPE_CEA608_S334_1A")]
    Cea608S3341a,
    #[doc(alias = "GST_VIDEO_CAPTION_TYPE_CEA708_RAW")]
    Cea708Raw,
    #[doc(alias = "GST_VIDEO_CAPTION_TYPE_CEA708_CDP")]
    Cea708Cdp,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v1_16", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_16")))]
impl VideoCaptionType {
    #[doc(alias = "gst_video_caption_type_from_caps")]
    pub fn from_caps(caps: &gst::Caps) -> VideoCaptionType {
        assert_initialized_main_thread!();
        unsafe { from_glib(ffi::gst_video_caption_type_from_caps(caps.to_glib_none().0)) }
    }

    #[doc(alias = "gst_video_caption_type_to_caps")]
    pub fn to_caps(self) -> Option<gst::Caps> {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gst_video_caption_type_to_caps(self.into_glib())) }
    }
}

#[cfg(any(feature = "v1_16", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_16")))]
#[doc(hidden)]
impl IntoGlib for VideoCaptionType {
    type GlibType = ffi::GstVideoCaptionType;

    fn into_glib(self) -> ffi::GstVideoCaptionType {
        match self {
            Self::Unknown => ffi::GST_VIDEO_CAPTION_TYPE_UNKNOWN,
            Self::Cea608Raw => ffi::GST_VIDEO_CAPTION_TYPE_CEA608_RAW,
            Self::Cea608S3341a => ffi::GST_VIDEO_CAPTION_TYPE_CEA608_S334_1A,
            Self::Cea708Raw => ffi::GST_VIDEO_CAPTION_TYPE_CEA708_RAW,
            Self::Cea708Cdp => ffi::GST_VIDEO_CAPTION_TYPE_CEA708_CDP,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(any(feature = "v1_16", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_16")))]
#[doc(hidden)]
impl FromGlib<ffi::GstVideoCaptionType> for VideoCaptionType {
    unsafe fn from_glib(value: ffi::GstVideoCaptionType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_VIDEO_CAPTION_TYPE_UNKNOWN => Self::Unknown,
            ffi::GST_VIDEO_CAPTION_TYPE_CEA608_RAW => Self::Cea608Raw,
            ffi::GST_VIDEO_CAPTION_TYPE_CEA608_S334_1A => Self::Cea608S3341a,
            ffi::GST_VIDEO_CAPTION_TYPE_CEA708_RAW => Self::Cea708Raw,
            ffi::GST_VIDEO_CAPTION_TYPE_CEA708_CDP => Self::Cea708Cdp,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v1_16", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_16")))]
impl StaticType for VideoCaptionType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_video_caption_type_get_type()) }
    }
}

#[cfg(any(feature = "v1_16", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_16")))]
impl glib::value::ValueType for VideoCaptionType {
    type Type = Self;
}

#[cfg(any(feature = "v1_16", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_16")))]
unsafe impl<'a> FromValue<'a> for VideoCaptionType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v1_16", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_16")))]
impl ToValue for VideoCaptionType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstVideoChromaMode")]
pub enum VideoChromaMode {
    #[doc(alias = "GST_VIDEO_CHROMA_MODE_FULL")]
    Full,
    #[doc(alias = "GST_VIDEO_CHROMA_MODE_UPSAMPLE_ONLY")]
    UpsampleOnly,
    #[doc(alias = "GST_VIDEO_CHROMA_MODE_DOWNSAMPLE_ONLY")]
    DownsampleOnly,
    #[doc(alias = "GST_VIDEO_CHROMA_MODE_NONE")]
    None,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for VideoChromaMode {
    type GlibType = ffi::GstVideoChromaMode;

    fn into_glib(self) -> ffi::GstVideoChromaMode {
        match self {
            Self::Full => ffi::GST_VIDEO_CHROMA_MODE_FULL,
            Self::UpsampleOnly => ffi::GST_VIDEO_CHROMA_MODE_UPSAMPLE_ONLY,
            Self::DownsampleOnly => ffi::GST_VIDEO_CHROMA_MODE_DOWNSAMPLE_ONLY,
            Self::None => ffi::GST_VIDEO_CHROMA_MODE_NONE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstVideoChromaMode> for VideoChromaMode {
    unsafe fn from_glib(value: ffi::GstVideoChromaMode) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_VIDEO_CHROMA_MODE_FULL => Self::Full,
            ffi::GST_VIDEO_CHROMA_MODE_UPSAMPLE_ONLY => Self::UpsampleOnly,
            ffi::GST_VIDEO_CHROMA_MODE_DOWNSAMPLE_ONLY => Self::DownsampleOnly,
            ffi::GST_VIDEO_CHROMA_MODE_NONE => Self::None,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for VideoChromaMode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_video_chroma_mode_get_type()) }
    }
}

impl glib::value::ValueType for VideoChromaMode {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for VideoChromaMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for VideoChromaMode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstVideoColorMatrix")]
pub enum VideoColorMatrix {
    #[doc(alias = "GST_VIDEO_COLOR_MATRIX_UNKNOWN")]
    Unknown,
    #[doc(alias = "GST_VIDEO_COLOR_MATRIX_RGB")]
    Rgb,
    #[doc(alias = "GST_VIDEO_COLOR_MATRIX_FCC")]
    Fcc,
    #[doc(alias = "GST_VIDEO_COLOR_MATRIX_BT709")]
    Bt709,
    #[doc(alias = "GST_VIDEO_COLOR_MATRIX_BT601")]
    Bt601,
    #[doc(alias = "GST_VIDEO_COLOR_MATRIX_SMPTE240M")]
    Smpte240m,
    #[doc(alias = "GST_VIDEO_COLOR_MATRIX_BT2020")]
    Bt2020,
    #[doc(hidden)]
    __Unknown(i32),
}

impl VideoColorMatrix {
    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    #[doc(alias = "gst_video_color_matrix_from_iso")]
    pub fn from_iso(value: u32) -> VideoColorMatrix {
        assert_initialized_main_thread!();
        unsafe { from_glib(ffi::gst_video_color_matrix_from_iso(value)) }
    }

    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    #[doc(alias = "gst_video_color_matrix_to_iso")]
    pub fn to_iso(self) -> u32 {
        assert_initialized_main_thread!();
        unsafe { ffi::gst_video_color_matrix_to_iso(self.into_glib()) }
    }
}

#[doc(hidden)]
impl IntoGlib for VideoColorMatrix {
    type GlibType = ffi::GstVideoColorMatrix;

    fn into_glib(self) -> ffi::GstVideoColorMatrix {
        match self {
            Self::Unknown => ffi::GST_VIDEO_COLOR_MATRIX_UNKNOWN,
            Self::Rgb => ffi::GST_VIDEO_COLOR_MATRIX_RGB,
            Self::Fcc => ffi::GST_VIDEO_COLOR_MATRIX_FCC,
            Self::Bt709 => ffi::GST_VIDEO_COLOR_MATRIX_BT709,
            Self::Bt601 => ffi::GST_VIDEO_COLOR_MATRIX_BT601,
            Self::Smpte240m => ffi::GST_VIDEO_COLOR_MATRIX_SMPTE240M,
            Self::Bt2020 => ffi::GST_VIDEO_COLOR_MATRIX_BT2020,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstVideoColorMatrix> for VideoColorMatrix {
    unsafe fn from_glib(value: ffi::GstVideoColorMatrix) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_VIDEO_COLOR_MATRIX_UNKNOWN => Self::Unknown,
            ffi::GST_VIDEO_COLOR_MATRIX_RGB => Self::Rgb,
            ffi::GST_VIDEO_COLOR_MATRIX_FCC => Self::Fcc,
            ffi::GST_VIDEO_COLOR_MATRIX_BT709 => Self::Bt709,
            ffi::GST_VIDEO_COLOR_MATRIX_BT601 => Self::Bt601,
            ffi::GST_VIDEO_COLOR_MATRIX_SMPTE240M => Self::Smpte240m,
            ffi::GST_VIDEO_COLOR_MATRIX_BT2020 => Self::Bt2020,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for VideoColorMatrix {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_video_color_matrix_get_type()) }
    }
}

impl glib::value::ValueType for VideoColorMatrix {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for VideoColorMatrix {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for VideoColorMatrix {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstVideoColorPrimaries")]
pub enum VideoColorPrimaries {
    #[doc(alias = "GST_VIDEO_COLOR_PRIMARIES_UNKNOWN")]
    Unknown,
    #[doc(alias = "GST_VIDEO_COLOR_PRIMARIES_BT709")]
    Bt709,
    #[doc(alias = "GST_VIDEO_COLOR_PRIMARIES_BT470M")]
    Bt470m,
    #[doc(alias = "GST_VIDEO_COLOR_PRIMARIES_BT470BG")]
    Bt470bg,
    #[doc(alias = "GST_VIDEO_COLOR_PRIMARIES_SMPTE170M")]
    Smpte170m,
    #[doc(alias = "GST_VIDEO_COLOR_PRIMARIES_SMPTE240M")]
    Smpte240m,
    #[doc(alias = "GST_VIDEO_COLOR_PRIMARIES_FILM")]
    Film,
    #[doc(alias = "GST_VIDEO_COLOR_PRIMARIES_BT2020")]
    Bt2020,
    #[doc(alias = "GST_VIDEO_COLOR_PRIMARIES_ADOBERGB")]
    Adobergb,
    #[cfg(any(feature = "v1_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_16")))]
    #[doc(alias = "GST_VIDEO_COLOR_PRIMARIES_SMPTEST428")]
    Smptest428,
    #[cfg(any(feature = "v1_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_16")))]
    #[doc(alias = "GST_VIDEO_COLOR_PRIMARIES_SMPTERP431")]
    Smpterp431,
    #[cfg(any(feature = "v1_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_16")))]
    #[doc(alias = "GST_VIDEO_COLOR_PRIMARIES_SMPTEEG432")]
    Smpteeg432,
    #[cfg(any(feature = "v1_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_16")))]
    #[doc(alias = "GST_VIDEO_COLOR_PRIMARIES_EBU3213")]
    Ebu3213,
    #[doc(hidden)]
    __Unknown(i32),
}

impl VideoColorPrimaries {
    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    #[doc(alias = "gst_video_color_primaries_from_iso")]
    pub fn from_iso(value: u32) -> VideoColorPrimaries {
        assert_initialized_main_thread!();
        unsafe { from_glib(ffi::gst_video_color_primaries_from_iso(value)) }
    }

    //#[doc(alias = "gst_video_color_primaries_get_info")]
    //#[doc(alias = "get_info")]
    //pub fn info(self) -> /*Ignored*/Option<VideoColorPrimariesInfo> {
    //    unsafe { TODO: call ffi:gst_video_color_primaries_get_info() }
    //}

    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    #[doc(alias = "gst_video_color_primaries_to_iso")]
    pub fn to_iso(self) -> u32 {
        assert_initialized_main_thread!();
        unsafe { ffi::gst_video_color_primaries_to_iso(self.into_glib()) }
    }
}

#[doc(hidden)]
impl IntoGlib for VideoColorPrimaries {
    type GlibType = ffi::GstVideoColorPrimaries;

    fn into_glib(self) -> ffi::GstVideoColorPrimaries {
        match self {
            Self::Unknown => ffi::GST_VIDEO_COLOR_PRIMARIES_UNKNOWN,
            Self::Bt709 => ffi::GST_VIDEO_COLOR_PRIMARIES_BT709,
            Self::Bt470m => ffi::GST_VIDEO_COLOR_PRIMARIES_BT470M,
            Self::Bt470bg => ffi::GST_VIDEO_COLOR_PRIMARIES_BT470BG,
            Self::Smpte170m => ffi::GST_VIDEO_COLOR_PRIMARIES_SMPTE170M,
            Self::Smpte240m => ffi::GST_VIDEO_COLOR_PRIMARIES_SMPTE240M,
            Self::Film => ffi::GST_VIDEO_COLOR_PRIMARIES_FILM,
            Self::Bt2020 => ffi::GST_VIDEO_COLOR_PRIMARIES_BT2020,
            Self::Adobergb => ffi::GST_VIDEO_COLOR_PRIMARIES_ADOBERGB,
            #[cfg(any(feature = "v1_16", feature = "dox"))]
            Self::Smptest428 => ffi::GST_VIDEO_COLOR_PRIMARIES_SMPTEST428,
            #[cfg(any(feature = "v1_16", feature = "dox"))]
            Self::Smpterp431 => ffi::GST_VIDEO_COLOR_PRIMARIES_SMPTERP431,
            #[cfg(any(feature = "v1_16", feature = "dox"))]
            Self::Smpteeg432 => ffi::GST_VIDEO_COLOR_PRIMARIES_SMPTEEG432,
            #[cfg(any(feature = "v1_16", feature = "dox"))]
            Self::Ebu3213 => ffi::GST_VIDEO_COLOR_PRIMARIES_EBU3213,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstVideoColorPrimaries> for VideoColorPrimaries {
    unsafe fn from_glib(value: ffi::GstVideoColorPrimaries) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_VIDEO_COLOR_PRIMARIES_UNKNOWN => Self::Unknown,
            ffi::GST_VIDEO_COLOR_PRIMARIES_BT709 => Self::Bt709,
            ffi::GST_VIDEO_COLOR_PRIMARIES_BT470M => Self::Bt470m,
            ffi::GST_VIDEO_COLOR_PRIMARIES_BT470BG => Self::Bt470bg,
            ffi::GST_VIDEO_COLOR_PRIMARIES_SMPTE170M => Self::Smpte170m,
            ffi::GST_VIDEO_COLOR_PRIMARIES_SMPTE240M => Self::Smpte240m,
            ffi::GST_VIDEO_COLOR_PRIMARIES_FILM => Self::Film,
            ffi::GST_VIDEO_COLOR_PRIMARIES_BT2020 => Self::Bt2020,
            ffi::GST_VIDEO_COLOR_PRIMARIES_ADOBERGB => Self::Adobergb,
            #[cfg(any(feature = "v1_16", feature = "dox"))]
            ffi::GST_VIDEO_COLOR_PRIMARIES_SMPTEST428 => Self::Smptest428,
            #[cfg(any(feature = "v1_16", feature = "dox"))]
            ffi::GST_VIDEO_COLOR_PRIMARIES_SMPTERP431 => Self::Smpterp431,
            #[cfg(any(feature = "v1_16", feature = "dox"))]
            ffi::GST_VIDEO_COLOR_PRIMARIES_SMPTEEG432 => Self::Smpteeg432,
            #[cfg(any(feature = "v1_16", feature = "dox"))]
            ffi::GST_VIDEO_COLOR_PRIMARIES_EBU3213 => Self::Ebu3213,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for VideoColorPrimaries {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_video_color_primaries_get_type()) }
    }
}

impl glib::value::ValueType for VideoColorPrimaries {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for VideoColorPrimaries {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for VideoColorPrimaries {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstVideoDitherMethod")]
pub enum VideoDitherMethod {
    #[doc(alias = "GST_VIDEO_DITHER_NONE")]
    None,
    #[doc(alias = "GST_VIDEO_DITHER_VERTERR")]
    Verterr,
    #[doc(alias = "GST_VIDEO_DITHER_FLOYD_STEINBERG")]
    FloydSteinberg,
    #[doc(alias = "GST_VIDEO_DITHER_SIERRA_LITE")]
    SierraLite,
    #[doc(alias = "GST_VIDEO_DITHER_BAYER")]
    Bayer,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for VideoDitherMethod {
    type GlibType = ffi::GstVideoDitherMethod;

    fn into_glib(self) -> ffi::GstVideoDitherMethod {
        match self {
            Self::None => ffi::GST_VIDEO_DITHER_NONE,
            Self::Verterr => ffi::GST_VIDEO_DITHER_VERTERR,
            Self::FloydSteinberg => ffi::GST_VIDEO_DITHER_FLOYD_STEINBERG,
            Self::SierraLite => ffi::GST_VIDEO_DITHER_SIERRA_LITE,
            Self::Bayer => ffi::GST_VIDEO_DITHER_BAYER,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstVideoDitherMethod> for VideoDitherMethod {
    unsafe fn from_glib(value: ffi::GstVideoDitherMethod) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_VIDEO_DITHER_NONE => Self::None,
            ffi::GST_VIDEO_DITHER_VERTERR => Self::Verterr,
            ffi::GST_VIDEO_DITHER_FLOYD_STEINBERG => Self::FloydSteinberg,
            ffi::GST_VIDEO_DITHER_SIERRA_LITE => Self::SierraLite,
            ffi::GST_VIDEO_DITHER_BAYER => Self::Bayer,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for VideoDitherMethod {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_video_dither_method_get_type()) }
    }
}

impl glib::value::ValueType for VideoDitherMethod {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for VideoDitherMethod {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for VideoDitherMethod {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(any(feature = "v1_12", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_12")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstVideoFieldOrder")]
pub enum VideoFieldOrder {
    #[doc(alias = "GST_VIDEO_FIELD_ORDER_UNKNOWN")]
    Unknown,
    #[doc(alias = "GST_VIDEO_FIELD_ORDER_TOP_FIELD_FIRST")]
    TopFieldFirst,
    #[doc(alias = "GST_VIDEO_FIELD_ORDER_BOTTOM_FIELD_FIRST")]
    BottomFieldFirst,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v1_12", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_12")))]
impl VideoFieldOrder {
    #[doc(alias = "gst_video_field_order_from_string")]
    pub fn from_string(order: &str) -> VideoFieldOrder {
        assert_initialized_main_thread!();
        unsafe {
            from_glib(ffi::gst_video_field_order_from_string(
                order.to_glib_none().0,
            ))
        }
    }
}

#[cfg(any(feature = "v1_12", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_12")))]
impl fmt::Display for VideoFieldOrder {
    #[inline]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str(&self.to_str())
    }
}

#[cfg(any(feature = "v1_12", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_12")))]
#[doc(hidden)]
impl IntoGlib for VideoFieldOrder {
    type GlibType = ffi::GstVideoFieldOrder;

    fn into_glib(self) -> ffi::GstVideoFieldOrder {
        match self {
            Self::Unknown => ffi::GST_VIDEO_FIELD_ORDER_UNKNOWN,
            Self::TopFieldFirst => ffi::GST_VIDEO_FIELD_ORDER_TOP_FIELD_FIRST,
            Self::BottomFieldFirst => ffi::GST_VIDEO_FIELD_ORDER_BOTTOM_FIELD_FIRST,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(any(feature = "v1_12", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_12")))]
#[doc(hidden)]
impl FromGlib<ffi::GstVideoFieldOrder> for VideoFieldOrder {
    unsafe fn from_glib(value: ffi::GstVideoFieldOrder) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_VIDEO_FIELD_ORDER_UNKNOWN => Self::Unknown,
            ffi::GST_VIDEO_FIELD_ORDER_TOP_FIELD_FIRST => Self::TopFieldFirst,
            ffi::GST_VIDEO_FIELD_ORDER_BOTTOM_FIELD_FIRST => Self::BottomFieldFirst,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v1_12", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_12")))]
impl StaticType for VideoFieldOrder {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_video_field_order_get_type()) }
    }
}

#[cfg(any(feature = "v1_12", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_12")))]
impl glib::value::ValueType for VideoFieldOrder {
    type Type = Self;
}

#[cfg(any(feature = "v1_12", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_12")))]
unsafe impl<'a> FromValue<'a> for VideoFieldOrder {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v1_12", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_12")))]
impl ToValue for VideoFieldOrder {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstVideoFormat")]
pub enum VideoFormat {
    #[doc(alias = "GST_VIDEO_FORMAT_UNKNOWN")]
    Unknown,
    #[doc(alias = "GST_VIDEO_FORMAT_ENCODED")]
    Encoded,
    #[doc(alias = "GST_VIDEO_FORMAT_I420")]
    I420,
    #[doc(alias = "GST_VIDEO_FORMAT_YV12")]
    Yv12,
    #[doc(alias = "GST_VIDEO_FORMAT_YUY2")]
    Yuy2,
    #[doc(alias = "GST_VIDEO_FORMAT_UYVY")]
    Uyvy,
    #[doc(alias = "GST_VIDEO_FORMAT_AYUV")]
    Ayuv,
    #[doc(alias = "GST_VIDEO_FORMAT_RGBx")]
    Rgbx,
    #[doc(alias = "GST_VIDEO_FORMAT_BGRx")]
    Bgrx,
    #[doc(alias = "GST_VIDEO_FORMAT_xRGB")]
    Xrgb,
    #[doc(alias = "GST_VIDEO_FORMAT_xBGR")]
    Xbgr,
    #[doc(alias = "GST_VIDEO_FORMAT_RGBA")]
    Rgba,
    #[doc(alias = "GST_VIDEO_FORMAT_BGRA")]
    Bgra,
    #[doc(alias = "GST_VIDEO_FORMAT_ARGB")]
    Argb,
    #[doc(alias = "GST_VIDEO_FORMAT_ABGR")]
    Abgr,
    #[doc(alias = "GST_VIDEO_FORMAT_RGB")]
    Rgb,
    #[doc(alias = "GST_VIDEO_FORMAT_BGR")]
    Bgr,
    #[doc(alias = "GST_VIDEO_FORMAT_Y41B")]
    Y41b,
    #[doc(alias = "GST_VIDEO_FORMAT_Y42B")]
    Y42b,
    #[doc(alias = "GST_VIDEO_FORMAT_YVYU")]
    Yvyu,
    #[doc(alias = "GST_VIDEO_FORMAT_Y444")]
    Y444,
    #[doc(alias = "GST_VIDEO_FORMAT_v210")]
    V210,
    #[doc(alias = "GST_VIDEO_FORMAT_v216")]
    V216,
    #[doc(alias = "GST_VIDEO_FORMAT_NV12")]
    Nv12,
    #[doc(alias = "GST_VIDEO_FORMAT_NV21")]
    Nv21,
    #[doc(alias = "GST_VIDEO_FORMAT_GRAY8")]
    Gray8,
    #[doc(alias = "GST_VIDEO_FORMAT_GRAY16_BE")]
    Gray16Be,
    #[doc(alias = "GST_VIDEO_FORMAT_GRAY16_LE")]
    Gray16Le,
    #[doc(alias = "GST_VIDEO_FORMAT_v308")]
    V308,
    #[doc(alias = "GST_VIDEO_FORMAT_RGB16")]
    Rgb16,
    #[doc(alias = "GST_VIDEO_FORMAT_BGR16")]
    Bgr16,
    #[doc(alias = "GST_VIDEO_FORMAT_RGB15")]
    Rgb15,
    #[doc(alias = "GST_VIDEO_FORMAT_BGR15")]
    Bgr15,
    #[doc(alias = "GST_VIDEO_FORMAT_UYVP")]
    Uyvp,
    #[doc(alias = "GST_VIDEO_FORMAT_A420")]
    A420,
    #[doc(alias = "GST_VIDEO_FORMAT_RGB8P")]
    Rgb8p,
    #[doc(alias = "GST_VIDEO_FORMAT_YUV9")]
    Yuv9,
    #[doc(alias = "GST_VIDEO_FORMAT_YVU9")]
    Yvu9,
    #[doc(alias = "GST_VIDEO_FORMAT_IYU1")]
    Iyu1,
    #[doc(alias = "GST_VIDEO_FORMAT_ARGB64")]
    Argb64,
    #[doc(alias = "GST_VIDEO_FORMAT_AYUV64")]
    Ayuv64,
    #[doc(alias = "GST_VIDEO_FORMAT_r210")]
    R210,
    #[doc(alias = "GST_VIDEO_FORMAT_I420_10BE")]
    I42010be,
    #[doc(alias = "GST_VIDEO_FORMAT_I420_10LE")]
    I42010le,
    #[doc(alias = "GST_VIDEO_FORMAT_I422_10BE")]
    I42210be,
    #[doc(alias = "GST_VIDEO_FORMAT_I422_10LE")]
    I42210le,
    #[doc(alias = "GST_VIDEO_FORMAT_Y444_10BE")]
    Y44410be,
    #[doc(alias = "GST_VIDEO_FORMAT_Y444_10LE")]
    Y44410le,
    #[doc(alias = "GST_VIDEO_FORMAT_GBR")]
    Gbr,
    #[doc(alias = "GST_VIDEO_FORMAT_GBR_10BE")]
    Gbr10be,
    #[doc(alias = "GST_VIDEO_FORMAT_GBR_10LE")]
    Gbr10le,
    #[doc(alias = "GST_VIDEO_FORMAT_NV16")]
    Nv16,
    #[doc(alias = "GST_VIDEO_FORMAT_NV24")]
    Nv24,
    #[doc(alias = "GST_VIDEO_FORMAT_NV12_64Z32")]
    Nv1264z32,
    #[doc(alias = "GST_VIDEO_FORMAT_A420_10BE")]
    A42010be,
    #[doc(alias = "GST_VIDEO_FORMAT_A420_10LE")]
    A42010le,
    #[doc(alias = "GST_VIDEO_FORMAT_A422_10BE")]
    A42210be,
    #[doc(alias = "GST_VIDEO_FORMAT_A422_10LE")]
    A42210le,
    #[doc(alias = "GST_VIDEO_FORMAT_A444_10BE")]
    A44410be,
    #[doc(alias = "GST_VIDEO_FORMAT_A444_10LE")]
    A44410le,
    #[doc(alias = "GST_VIDEO_FORMAT_NV61")]
    Nv61,
    #[cfg(any(feature = "v1_10", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_10")))]
    #[doc(alias = "GST_VIDEO_FORMAT_P010_10BE")]
    P01010be,
    #[cfg(any(feature = "v1_10", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_10")))]
    #[doc(alias = "GST_VIDEO_FORMAT_P010_10LE")]
    P01010le,
    #[cfg(any(feature = "v1_10", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_10")))]
    #[doc(alias = "GST_VIDEO_FORMAT_IYU2")]
    Iyu2,
    #[cfg(any(feature = "v1_12", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_12")))]
    #[doc(alias = "GST_VIDEO_FORMAT_VYUY")]
    Vyuy,
    #[cfg(any(feature = "v1_12", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_12")))]
    #[doc(alias = "GST_VIDEO_FORMAT_GBRA")]
    Gbra,
    #[cfg(any(feature = "v1_12", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_12")))]
    #[doc(alias = "GST_VIDEO_FORMAT_GBRA_10BE")]
    Gbra10be,
    #[cfg(any(feature = "v1_12", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_12")))]
    #[doc(alias = "GST_VIDEO_FORMAT_GBRA_10LE")]
    Gbra10le,
    #[cfg(any(feature = "v1_12", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_12")))]
    #[doc(alias = "GST_VIDEO_FORMAT_GBR_12BE")]
    Gbr12be,
    #[cfg(any(feature = "v1_12", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_12")))]
    #[doc(alias = "GST_VIDEO_FORMAT_GBR_12LE")]
    Gbr12le,
    #[cfg(any(feature = "v1_12", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_12")))]
    #[doc(alias = "GST_VIDEO_FORMAT_GBRA_12BE")]
    Gbra12be,
    #[cfg(any(feature = "v1_12", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_12")))]
    #[doc(alias = "GST_VIDEO_FORMAT_GBRA_12LE")]
    Gbra12le,
    #[cfg(any(feature = "v1_12", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_12")))]
    #[doc(alias = "GST_VIDEO_FORMAT_I420_12BE")]
    I42012be,
    #[cfg(any(feature = "v1_12", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_12")))]
    #[doc(alias = "GST_VIDEO_FORMAT_I420_12LE")]
    I42012le,
    #[cfg(any(feature = "v1_12", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_12")))]
    #[doc(alias = "GST_VIDEO_FORMAT_I422_12BE")]
    I42212be,
    #[cfg(any(feature = "v1_12", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_12")))]
    #[doc(alias = "GST_VIDEO_FORMAT_I422_12LE")]
    I42212le,
    #[cfg(any(feature = "v1_12", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_12")))]
    #[doc(alias = "GST_VIDEO_FORMAT_Y444_12BE")]
    Y44412be,
    #[cfg(any(feature = "v1_12", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_12")))]
    #[doc(alias = "GST_VIDEO_FORMAT_Y444_12LE")]
    Y44412le,
    #[cfg(any(feature = "v1_14", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_14")))]
    #[doc(alias = "GST_VIDEO_FORMAT_GRAY10_LE32")]
    Gray10Le32,
    #[cfg(any(feature = "v1_14", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_14")))]
    #[doc(alias = "GST_VIDEO_FORMAT_NV12_10LE32")]
    Nv1210le32,
    #[cfg(any(feature = "v1_14", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_14")))]
    #[doc(alias = "GST_VIDEO_FORMAT_NV16_10LE32")]
    Nv1610le32,
    #[cfg(any(feature = "v1_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_16")))]
    #[doc(alias = "GST_VIDEO_FORMAT_NV12_10LE40")]
    Nv1210le40,
    #[cfg(any(feature = "v1_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_16")))]
    #[doc(alias = "GST_VIDEO_FORMAT_Y210")]
    Y210,
    #[cfg(any(feature = "v1_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_16")))]
    #[doc(alias = "GST_VIDEO_FORMAT_Y410")]
    Y410,
    #[cfg(any(feature = "v1_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_16")))]
    #[doc(alias = "GST_VIDEO_FORMAT_VUYA")]
    Vuya,
    #[cfg(any(feature = "v1_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_16")))]
    #[doc(alias = "GST_VIDEO_FORMAT_BGR10A2_LE")]
    Bgr10a2Le,
    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    #[doc(alias = "GST_VIDEO_FORMAT_RGB10A2_LE")]
    Rgb10a2Le,
    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    #[doc(alias = "GST_VIDEO_FORMAT_Y444_16BE")]
    Y44416be,
    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    #[doc(alias = "GST_VIDEO_FORMAT_Y444_16LE")]
    Y44416le,
    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    #[doc(alias = "GST_VIDEO_FORMAT_P016_BE")]
    P016Be,
    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    #[doc(alias = "GST_VIDEO_FORMAT_P016_LE")]
    P016Le,
    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    #[doc(alias = "GST_VIDEO_FORMAT_P012_BE")]
    P012Be,
    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    #[doc(alias = "GST_VIDEO_FORMAT_P012_LE")]
    P012Le,
    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    #[doc(alias = "GST_VIDEO_FORMAT_Y212_BE")]
    Y212Be,
    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    #[doc(alias = "GST_VIDEO_FORMAT_Y212_LE")]
    Y212Le,
    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    #[doc(alias = "GST_VIDEO_FORMAT_Y412_BE")]
    Y412Be,
    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    #[doc(alias = "GST_VIDEO_FORMAT_Y412_LE")]
    Y412Le,
    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    #[doc(alias = "GST_VIDEO_FORMAT_NV12_4L4")]
    Nv124l4,
    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    #[doc(alias = "GST_VIDEO_FORMAT_NV12_32L32")]
    Nv1232l32,
    #[cfg(any(feature = "v1_20", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_20")))]
    #[doc(alias = "GST_VIDEO_FORMAT_RGBP")]
    Rgbp,
    #[cfg(any(feature = "v1_20", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_20")))]
    #[doc(alias = "GST_VIDEO_FORMAT_BGRP")]
    Bgrp,
    #[cfg(any(feature = "v1_20", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_20")))]
    #[doc(alias = "GST_VIDEO_FORMAT_AV12")]
    Av12,
    #[doc(hidden)]
    __Unknown(i32),
}

impl VideoFormat {
    #[doc(alias = "gst_video_format_from_fourcc")]
    pub fn from_fourcc(fourcc: u32) -> VideoFormat {
        assert_initialized_main_thread!();
        unsafe { from_glib(ffi::gst_video_format_from_fourcc(fourcc)) }
    }

    #[doc(alias = "gst_video_format_from_string")]
    pub fn from_string(format: &str) -> VideoFormat {
        assert_initialized_main_thread!();
        unsafe { from_glib(ffi::gst_video_format_from_string(format.to_glib_none().0)) }
    }

    //#[doc(alias = "gst_video_format_get_palette")]
    //#[doc(alias = "get_palette")]
    //pub fn palette(self) -> (/*Unimplemented*/Option<Fundamental: Pointer>, usize) {
    //    unsafe { TODO: call ffi:gst_video_format_get_palette() }
    //}

    #[doc(alias = "gst_video_format_to_fourcc")]
    pub fn to_fourcc(self) -> u32 {
        assert_initialized_main_thread!();
        unsafe { ffi::gst_video_format_to_fourcc(self.into_glib()) }
    }
}

impl fmt::Display for VideoFormat {
    #[inline]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str(&self.to_str())
    }
}

#[doc(hidden)]
impl IntoGlib for VideoFormat {
    type GlibType = ffi::GstVideoFormat;

    fn into_glib(self) -> ffi::GstVideoFormat {
        match self {
            Self::Unknown => ffi::GST_VIDEO_FORMAT_UNKNOWN,
            Self::Encoded => ffi::GST_VIDEO_FORMAT_ENCODED,
            Self::I420 => ffi::GST_VIDEO_FORMAT_I420,
            Self::Yv12 => ffi::GST_VIDEO_FORMAT_YV12,
            Self::Yuy2 => ffi::GST_VIDEO_FORMAT_YUY2,
            Self::Uyvy => ffi::GST_VIDEO_FORMAT_UYVY,
            Self::Ayuv => ffi::GST_VIDEO_FORMAT_AYUV,
            Self::Rgbx => ffi::GST_VIDEO_FORMAT_RGBx,
            Self::Bgrx => ffi::GST_VIDEO_FORMAT_BGRx,
            Self::Xrgb => ffi::GST_VIDEO_FORMAT_xRGB,
            Self::Xbgr => ffi::GST_VIDEO_FORMAT_xBGR,
            Self::Rgba => ffi::GST_VIDEO_FORMAT_RGBA,
            Self::Bgra => ffi::GST_VIDEO_FORMAT_BGRA,
            Self::Argb => ffi::GST_VIDEO_FORMAT_ARGB,
            Self::Abgr => ffi::GST_VIDEO_FORMAT_ABGR,
            Self::Rgb => ffi::GST_VIDEO_FORMAT_RGB,
            Self::Bgr => ffi::GST_VIDEO_FORMAT_BGR,
            Self::Y41b => ffi::GST_VIDEO_FORMAT_Y41B,
            Self::Y42b => ffi::GST_VIDEO_FORMAT_Y42B,
            Self::Yvyu => ffi::GST_VIDEO_FORMAT_YVYU,
            Self::Y444 => ffi::GST_VIDEO_FORMAT_Y444,
            Self::V210 => ffi::GST_VIDEO_FORMAT_v210,
            Self::V216 => ffi::GST_VIDEO_FORMAT_v216,
            Self::Nv12 => ffi::GST_VIDEO_FORMAT_NV12,
            Self::Nv21 => ffi::GST_VIDEO_FORMAT_NV21,
            Self::Gray8 => ffi::GST_VIDEO_FORMAT_GRAY8,
            Self::Gray16Be => ffi::GST_VIDEO_FORMAT_GRAY16_BE,
            Self::Gray16Le => ffi::GST_VIDEO_FORMAT_GRAY16_LE,
            Self::V308 => ffi::GST_VIDEO_FORMAT_v308,
            Self::Rgb16 => ffi::GST_VIDEO_FORMAT_RGB16,
            Self::Bgr16 => ffi::GST_VIDEO_FORMAT_BGR16,
            Self::Rgb15 => ffi::GST_VIDEO_FORMAT_RGB15,
            Self::Bgr15 => ffi::GST_VIDEO_FORMAT_BGR15,
            Self::Uyvp => ffi::GST_VIDEO_FORMAT_UYVP,
            Self::A420 => ffi::GST_VIDEO_FORMAT_A420,
            Self::Rgb8p => ffi::GST_VIDEO_FORMAT_RGB8P,
            Self::Yuv9 => ffi::GST_VIDEO_FORMAT_YUV9,
            Self::Yvu9 => ffi::GST_VIDEO_FORMAT_YVU9,
            Self::Iyu1 => ffi::GST_VIDEO_FORMAT_IYU1,
            Self::Argb64 => ffi::GST_VIDEO_FORMAT_ARGB64,
            Self::Ayuv64 => ffi::GST_VIDEO_FORMAT_AYUV64,
            Self::R210 => ffi::GST_VIDEO_FORMAT_r210,
            Self::I42010be => ffi::GST_VIDEO_FORMAT_I420_10BE,
            Self::I42010le => ffi::GST_VIDEO_FORMAT_I420_10LE,
            Self::I42210be => ffi::GST_VIDEO_FORMAT_I422_10BE,
            Self::I42210le => ffi::GST_VIDEO_FORMAT_I422_10LE,
            Self::Y44410be => ffi::GST_VIDEO_FORMAT_Y444_10BE,
            Self::Y44410le => ffi::GST_VIDEO_FORMAT_Y444_10LE,
            Self::Gbr => ffi::GST_VIDEO_FORMAT_GBR,
            Self::Gbr10be => ffi::GST_VIDEO_FORMAT_GBR_10BE,
            Self::Gbr10le => ffi::GST_VIDEO_FORMAT_GBR_10LE,
            Self::Nv16 => ffi::GST_VIDEO_FORMAT_NV16,
            Self::Nv24 => ffi::GST_VIDEO_FORMAT_NV24,
            Self::Nv1264z32 => ffi::GST_VIDEO_FORMAT_NV12_64Z32,
            Self::A42010be => ffi::GST_VIDEO_FORMAT_A420_10BE,
            Self::A42010le => ffi::GST_VIDEO_FORMAT_A420_10LE,
            Self::A42210be => ffi::GST_VIDEO_FORMAT_A422_10BE,
            Self::A42210le => ffi::GST_VIDEO_FORMAT_A422_10LE,
            Self::A44410be => ffi::GST_VIDEO_FORMAT_A444_10BE,
            Self::A44410le => ffi::GST_VIDEO_FORMAT_A444_10LE,
            Self::Nv61 => ffi::GST_VIDEO_FORMAT_NV61,
            #[cfg(any(feature = "v1_10", feature = "dox"))]
            Self::P01010be => ffi::GST_VIDEO_FORMAT_P010_10BE,
            #[cfg(any(feature = "v1_10", feature = "dox"))]
            Self::P01010le => ffi::GST_VIDEO_FORMAT_P010_10LE,
            #[cfg(any(feature = "v1_10", feature = "dox"))]
            Self::Iyu2 => ffi::GST_VIDEO_FORMAT_IYU2,
            #[cfg(any(feature = "v1_12", feature = "dox"))]
            Self::Vyuy => ffi::GST_VIDEO_FORMAT_VYUY,
            #[cfg(any(feature = "v1_12", feature = "dox"))]
            Self::Gbra => ffi::GST_VIDEO_FORMAT_GBRA,
            #[cfg(any(feature = "v1_12", feature = "dox"))]
            Self::Gbra10be => ffi::GST_VIDEO_FORMAT_GBRA_10BE,
            #[cfg(any(feature = "v1_12", feature = "dox"))]
            Self::Gbra10le => ffi::GST_VIDEO_FORMAT_GBRA_10LE,
            #[cfg(any(feature = "v1_12", feature = "dox"))]
            Self::Gbr12be => ffi::GST_VIDEO_FORMAT_GBR_12BE,
            #[cfg(any(feature = "v1_12", feature = "dox"))]
            Self::Gbr12le => ffi::GST_VIDEO_FORMAT_GBR_12LE,
            #[cfg(any(feature = "v1_12", feature = "dox"))]
            Self::Gbra12be => ffi::GST_VIDEO_FORMAT_GBRA_12BE,
            #[cfg(any(feature = "v1_12", feature = "dox"))]
            Self::Gbra12le => ffi::GST_VIDEO_FORMAT_GBRA_12LE,
            #[cfg(any(feature = "v1_12", feature = "dox"))]
            Self::I42012be => ffi::GST_VIDEO_FORMAT_I420_12BE,
            #[cfg(any(feature = "v1_12", feature = "dox"))]
            Self::I42012le => ffi::GST_VIDEO_FORMAT_I420_12LE,
            #[cfg(any(feature = "v1_12", feature = "dox"))]
            Self::I42212be => ffi::GST_VIDEO_FORMAT_I422_12BE,
            #[cfg(any(feature = "v1_12", feature = "dox"))]
            Self::I42212le => ffi::GST_VIDEO_FORMAT_I422_12LE,
            #[cfg(any(feature = "v1_12", feature = "dox"))]
            Self::Y44412be => ffi::GST_VIDEO_FORMAT_Y444_12BE,
            #[cfg(any(feature = "v1_12", feature = "dox"))]
            Self::Y44412le => ffi::GST_VIDEO_FORMAT_Y444_12LE,
            #[cfg(any(feature = "v1_14", feature = "dox"))]
            Self::Gray10Le32 => ffi::GST_VIDEO_FORMAT_GRAY10_LE32,
            #[cfg(any(feature = "v1_14", feature = "dox"))]
            Self::Nv1210le32 => ffi::GST_VIDEO_FORMAT_NV12_10LE32,
            #[cfg(any(feature = "v1_14", feature = "dox"))]
            Self::Nv1610le32 => ffi::GST_VIDEO_FORMAT_NV16_10LE32,
            #[cfg(any(feature = "v1_16", feature = "dox"))]
            Self::Nv1210le40 => ffi::GST_VIDEO_FORMAT_NV12_10LE40,
            #[cfg(any(feature = "v1_16", feature = "dox"))]
            Self::Y210 => ffi::GST_VIDEO_FORMAT_Y210,
            #[cfg(any(feature = "v1_16", feature = "dox"))]
            Self::Y410 => ffi::GST_VIDEO_FORMAT_Y410,
            #[cfg(any(feature = "v1_16", feature = "dox"))]
            Self::Vuya => ffi::GST_VIDEO_FORMAT_VUYA,
            #[cfg(any(feature = "v1_16", feature = "dox"))]
            Self::Bgr10a2Le => ffi::GST_VIDEO_FORMAT_BGR10A2_LE,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            Self::Rgb10a2Le => ffi::GST_VIDEO_FORMAT_RGB10A2_LE,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            Self::Y44416be => ffi::GST_VIDEO_FORMAT_Y444_16BE,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            Self::Y44416le => ffi::GST_VIDEO_FORMAT_Y444_16LE,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            Self::P016Be => ffi::GST_VIDEO_FORMAT_P016_BE,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            Self::P016Le => ffi::GST_VIDEO_FORMAT_P016_LE,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            Self::P012Be => ffi::GST_VIDEO_FORMAT_P012_BE,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            Self::P012Le => ffi::GST_VIDEO_FORMAT_P012_LE,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            Self::Y212Be => ffi::GST_VIDEO_FORMAT_Y212_BE,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            Self::Y212Le => ffi::GST_VIDEO_FORMAT_Y212_LE,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            Self::Y412Be => ffi::GST_VIDEO_FORMAT_Y412_BE,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            Self::Y412Le => ffi::GST_VIDEO_FORMAT_Y412_LE,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            Self::Nv124l4 => ffi::GST_VIDEO_FORMAT_NV12_4L4,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            Self::Nv1232l32 => ffi::GST_VIDEO_FORMAT_NV12_32L32,
            #[cfg(any(feature = "v1_20", feature = "dox"))]
            Self::Rgbp => ffi::GST_VIDEO_FORMAT_RGBP,
            #[cfg(any(feature = "v1_20", feature = "dox"))]
            Self::Bgrp => ffi::GST_VIDEO_FORMAT_BGRP,
            #[cfg(any(feature = "v1_20", feature = "dox"))]
            Self::Av12 => ffi::GST_VIDEO_FORMAT_AV12,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstVideoFormat> for VideoFormat {
    unsafe fn from_glib(value: ffi::GstVideoFormat) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_VIDEO_FORMAT_UNKNOWN => Self::Unknown,
            ffi::GST_VIDEO_FORMAT_ENCODED => Self::Encoded,
            ffi::GST_VIDEO_FORMAT_I420 => Self::I420,
            ffi::GST_VIDEO_FORMAT_YV12 => Self::Yv12,
            ffi::GST_VIDEO_FORMAT_YUY2 => Self::Yuy2,
            ffi::GST_VIDEO_FORMAT_UYVY => Self::Uyvy,
            ffi::GST_VIDEO_FORMAT_AYUV => Self::Ayuv,
            ffi::GST_VIDEO_FORMAT_RGBx => Self::Rgbx,
            ffi::GST_VIDEO_FORMAT_BGRx => Self::Bgrx,
            ffi::GST_VIDEO_FORMAT_xRGB => Self::Xrgb,
            ffi::GST_VIDEO_FORMAT_xBGR => Self::Xbgr,
            ffi::GST_VIDEO_FORMAT_RGBA => Self::Rgba,
            ffi::GST_VIDEO_FORMAT_BGRA => Self::Bgra,
            ffi::GST_VIDEO_FORMAT_ARGB => Self::Argb,
            ffi::GST_VIDEO_FORMAT_ABGR => Self::Abgr,
            ffi::GST_VIDEO_FORMAT_RGB => Self::Rgb,
            ffi::GST_VIDEO_FORMAT_BGR => Self::Bgr,
            ffi::GST_VIDEO_FORMAT_Y41B => Self::Y41b,
            ffi::GST_VIDEO_FORMAT_Y42B => Self::Y42b,
            ffi::GST_VIDEO_FORMAT_YVYU => Self::Yvyu,
            ffi::GST_VIDEO_FORMAT_Y444 => Self::Y444,
            ffi::GST_VIDEO_FORMAT_v210 => Self::V210,
            ffi::GST_VIDEO_FORMAT_v216 => Self::V216,
            ffi::GST_VIDEO_FORMAT_NV12 => Self::Nv12,
            ffi::GST_VIDEO_FORMAT_NV21 => Self::Nv21,
            ffi::GST_VIDEO_FORMAT_GRAY8 => Self::Gray8,
            ffi::GST_VIDEO_FORMAT_GRAY16_BE => Self::Gray16Be,
            ffi::GST_VIDEO_FORMAT_GRAY16_LE => Self::Gray16Le,
            ffi::GST_VIDEO_FORMAT_v308 => Self::V308,
            ffi::GST_VIDEO_FORMAT_RGB16 => Self::Rgb16,
            ffi::GST_VIDEO_FORMAT_BGR16 => Self::Bgr16,
            ffi::GST_VIDEO_FORMAT_RGB15 => Self::Rgb15,
            ffi::GST_VIDEO_FORMAT_BGR15 => Self::Bgr15,
            ffi::GST_VIDEO_FORMAT_UYVP => Self::Uyvp,
            ffi::GST_VIDEO_FORMAT_A420 => Self::A420,
            ffi::GST_VIDEO_FORMAT_RGB8P => Self::Rgb8p,
            ffi::GST_VIDEO_FORMAT_YUV9 => Self::Yuv9,
            ffi::GST_VIDEO_FORMAT_YVU9 => Self::Yvu9,
            ffi::GST_VIDEO_FORMAT_IYU1 => Self::Iyu1,
            ffi::GST_VIDEO_FORMAT_ARGB64 => Self::Argb64,
            ffi::GST_VIDEO_FORMAT_AYUV64 => Self::Ayuv64,
            ffi::GST_VIDEO_FORMAT_r210 => Self::R210,
            ffi::GST_VIDEO_FORMAT_I420_10BE => Self::I42010be,
            ffi::GST_VIDEO_FORMAT_I420_10LE => Self::I42010le,
            ffi::GST_VIDEO_FORMAT_I422_10BE => Self::I42210be,
            ffi::GST_VIDEO_FORMAT_I422_10LE => Self::I42210le,
            ffi::GST_VIDEO_FORMAT_Y444_10BE => Self::Y44410be,
            ffi::GST_VIDEO_FORMAT_Y444_10LE => Self::Y44410le,
            ffi::GST_VIDEO_FORMAT_GBR => Self::Gbr,
            ffi::GST_VIDEO_FORMAT_GBR_10BE => Self::Gbr10be,
            ffi::GST_VIDEO_FORMAT_GBR_10LE => Self::Gbr10le,
            ffi::GST_VIDEO_FORMAT_NV16 => Self::Nv16,
            ffi::GST_VIDEO_FORMAT_NV24 => Self::Nv24,
            ffi::GST_VIDEO_FORMAT_NV12_64Z32 => Self::Nv1264z32,
            ffi::GST_VIDEO_FORMAT_A420_10BE => Self::A42010be,
            ffi::GST_VIDEO_FORMAT_A420_10LE => Self::A42010le,
            ffi::GST_VIDEO_FORMAT_A422_10BE => Self::A42210be,
            ffi::GST_VIDEO_FORMAT_A422_10LE => Self::A42210le,
            ffi::GST_VIDEO_FORMAT_A444_10BE => Self::A44410be,
            ffi::GST_VIDEO_FORMAT_A444_10LE => Self::A44410le,
            ffi::GST_VIDEO_FORMAT_NV61 => Self::Nv61,
            #[cfg(any(feature = "v1_10", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_P010_10BE => Self::P01010be,
            #[cfg(any(feature = "v1_10", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_P010_10LE => Self::P01010le,
            #[cfg(any(feature = "v1_10", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_IYU2 => Self::Iyu2,
            #[cfg(any(feature = "v1_12", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_VYUY => Self::Vyuy,
            #[cfg(any(feature = "v1_12", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_GBRA => Self::Gbra,
            #[cfg(any(feature = "v1_12", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_GBRA_10BE => Self::Gbra10be,
            #[cfg(any(feature = "v1_12", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_GBRA_10LE => Self::Gbra10le,
            #[cfg(any(feature = "v1_12", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_GBR_12BE => Self::Gbr12be,
            #[cfg(any(feature = "v1_12", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_GBR_12LE => Self::Gbr12le,
            #[cfg(any(feature = "v1_12", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_GBRA_12BE => Self::Gbra12be,
            #[cfg(any(feature = "v1_12", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_GBRA_12LE => Self::Gbra12le,
            #[cfg(any(feature = "v1_12", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_I420_12BE => Self::I42012be,
            #[cfg(any(feature = "v1_12", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_I420_12LE => Self::I42012le,
            #[cfg(any(feature = "v1_12", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_I422_12BE => Self::I42212be,
            #[cfg(any(feature = "v1_12", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_I422_12LE => Self::I42212le,
            #[cfg(any(feature = "v1_12", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_Y444_12BE => Self::Y44412be,
            #[cfg(any(feature = "v1_12", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_Y444_12LE => Self::Y44412le,
            #[cfg(any(feature = "v1_14", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_GRAY10_LE32 => Self::Gray10Le32,
            #[cfg(any(feature = "v1_14", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_NV12_10LE32 => Self::Nv1210le32,
            #[cfg(any(feature = "v1_14", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_NV16_10LE32 => Self::Nv1610le32,
            #[cfg(any(feature = "v1_16", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_NV12_10LE40 => Self::Nv1210le40,
            #[cfg(any(feature = "v1_16", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_Y210 => Self::Y210,
            #[cfg(any(feature = "v1_16", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_Y410 => Self::Y410,
            #[cfg(any(feature = "v1_16", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_VUYA => Self::Vuya,
            #[cfg(any(feature = "v1_16", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_BGR10A2_LE => Self::Bgr10a2Le,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_RGB10A2_LE => Self::Rgb10a2Le,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_Y444_16BE => Self::Y44416be,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_Y444_16LE => Self::Y44416le,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_P016_BE => Self::P016Be,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_P016_LE => Self::P016Le,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_P012_BE => Self::P012Be,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_P012_LE => Self::P012Le,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_Y212_BE => Self::Y212Be,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_Y212_LE => Self::Y212Le,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_Y412_BE => Self::Y412Be,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_Y412_LE => Self::Y412Le,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_NV12_4L4 => Self::Nv124l4,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_NV12_32L32 => Self::Nv1232l32,
            #[cfg(any(feature = "v1_20", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_RGBP => Self::Rgbp,
            #[cfg(any(feature = "v1_20", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_BGRP => Self::Bgrp,
            #[cfg(any(feature = "v1_20", feature = "dox"))]
            ffi::GST_VIDEO_FORMAT_AV12 => Self::Av12,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for VideoFormat {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_video_format_get_type()) }
    }
}

impl glib::value::ValueType for VideoFormat {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for VideoFormat {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for VideoFormat {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstVideoGammaMode")]
pub enum VideoGammaMode {
    #[doc(alias = "GST_VIDEO_GAMMA_MODE_NONE")]
    None,
    #[doc(alias = "GST_VIDEO_GAMMA_MODE_REMAP")]
    Remap,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for VideoGammaMode {
    type GlibType = ffi::GstVideoGammaMode;

    fn into_glib(self) -> ffi::GstVideoGammaMode {
        match self {
            Self::None => ffi::GST_VIDEO_GAMMA_MODE_NONE,
            Self::Remap => ffi::GST_VIDEO_GAMMA_MODE_REMAP,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstVideoGammaMode> for VideoGammaMode {
    unsafe fn from_glib(value: ffi::GstVideoGammaMode) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_VIDEO_GAMMA_MODE_NONE => Self::None,
            ffi::GST_VIDEO_GAMMA_MODE_REMAP => Self::Remap,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for VideoGammaMode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_video_gamma_mode_get_type()) }
    }
}

impl glib::value::ValueType for VideoGammaMode {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for VideoGammaMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for VideoGammaMode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstVideoInterlaceMode")]
pub enum VideoInterlaceMode {
    #[doc(alias = "GST_VIDEO_INTERLACE_MODE_PROGRESSIVE")]
    Progressive,
    #[doc(alias = "GST_VIDEO_INTERLACE_MODE_INTERLEAVED")]
    Interleaved,
    #[doc(alias = "GST_VIDEO_INTERLACE_MODE_MIXED")]
    Mixed,
    #[doc(alias = "GST_VIDEO_INTERLACE_MODE_FIELDS")]
    Fields,
    #[cfg(any(feature = "v1_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_16")))]
    #[doc(alias = "GST_VIDEO_INTERLACE_MODE_ALTERNATE")]
    Alternate,
    #[doc(hidden)]
    __Unknown(i32),
}

impl VideoInterlaceMode {
    #[doc(alias = "gst_video_interlace_mode_from_string")]
    pub fn from_string(mode: &str) -> VideoInterlaceMode {
        assert_initialized_main_thread!();
        unsafe {
            from_glib(ffi::gst_video_interlace_mode_from_string(
                mode.to_glib_none().0,
            ))
        }
    }

    pub fn to_str<'a>(self) -> &'a str {
        unsafe {
            CStr::from_ptr(
                ffi::gst_video_interlace_mode_to_string(self.into_glib())
                    .as_ref()
                    .expect("gst_video_interlace_mode_to_string returned NULL"),
            )
            .to_str()
            .expect("gst_video_interlace_mode_to_string returned an invalid string")
        }
    }
}

impl fmt::Display for VideoInterlaceMode {
    #[inline]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str(&self.to_str())
    }
}

#[doc(hidden)]
impl IntoGlib for VideoInterlaceMode {
    type GlibType = ffi::GstVideoInterlaceMode;

    fn into_glib(self) -> ffi::GstVideoInterlaceMode {
        match self {
            Self::Progressive => ffi::GST_VIDEO_INTERLACE_MODE_PROGRESSIVE,
            Self::Interleaved => ffi::GST_VIDEO_INTERLACE_MODE_INTERLEAVED,
            Self::Mixed => ffi::GST_VIDEO_INTERLACE_MODE_MIXED,
            Self::Fields => ffi::GST_VIDEO_INTERLACE_MODE_FIELDS,
            #[cfg(any(feature = "v1_16", feature = "dox"))]
            Self::Alternate => ffi::GST_VIDEO_INTERLACE_MODE_ALTERNATE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstVideoInterlaceMode> for VideoInterlaceMode {
    unsafe fn from_glib(value: ffi::GstVideoInterlaceMode) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_VIDEO_INTERLACE_MODE_PROGRESSIVE => Self::Progressive,
            ffi::GST_VIDEO_INTERLACE_MODE_INTERLEAVED => Self::Interleaved,
            ffi::GST_VIDEO_INTERLACE_MODE_MIXED => Self::Mixed,
            ffi::GST_VIDEO_INTERLACE_MODE_FIELDS => Self::Fields,
            #[cfg(any(feature = "v1_16", feature = "dox"))]
            ffi::GST_VIDEO_INTERLACE_MODE_ALTERNATE => Self::Alternate,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for VideoInterlaceMode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_video_interlace_mode_get_type()) }
    }
}

impl glib::value::ValueType for VideoInterlaceMode {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for VideoInterlaceMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for VideoInterlaceMode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstVideoMatrixMode")]
pub enum VideoMatrixMode {
    #[doc(alias = "GST_VIDEO_MATRIX_MODE_FULL")]
    Full,
    #[doc(alias = "GST_VIDEO_MATRIX_MODE_INPUT_ONLY")]
    InputOnly,
    #[doc(alias = "GST_VIDEO_MATRIX_MODE_OUTPUT_ONLY")]
    OutputOnly,
    #[doc(alias = "GST_VIDEO_MATRIX_MODE_NONE")]
    None,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for VideoMatrixMode {
    type GlibType = ffi::GstVideoMatrixMode;

    fn into_glib(self) -> ffi::GstVideoMatrixMode {
        match self {
            Self::Full => ffi::GST_VIDEO_MATRIX_MODE_FULL,
            Self::InputOnly => ffi::GST_VIDEO_MATRIX_MODE_INPUT_ONLY,
            Self::OutputOnly => ffi::GST_VIDEO_MATRIX_MODE_OUTPUT_ONLY,
            Self::None => ffi::GST_VIDEO_MATRIX_MODE_NONE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstVideoMatrixMode> for VideoMatrixMode {
    unsafe fn from_glib(value: ffi::GstVideoMatrixMode) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_VIDEO_MATRIX_MODE_FULL => Self::Full,
            ffi::GST_VIDEO_MATRIX_MODE_INPUT_ONLY => Self::InputOnly,
            ffi::GST_VIDEO_MATRIX_MODE_OUTPUT_ONLY => Self::OutputOnly,
            ffi::GST_VIDEO_MATRIX_MODE_NONE => Self::None,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for VideoMatrixMode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_video_matrix_mode_get_type()) }
    }
}

impl glib::value::ValueType for VideoMatrixMode {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for VideoMatrixMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for VideoMatrixMode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstVideoMultiviewFramePacking")]
pub enum VideoMultiviewFramePacking {
    #[doc(alias = "GST_VIDEO_MULTIVIEW_FRAME_PACKING_NONE")]
    None,
    #[doc(alias = "GST_VIDEO_MULTIVIEW_FRAME_PACKING_MONO")]
    Mono,
    #[doc(alias = "GST_VIDEO_MULTIVIEW_FRAME_PACKING_LEFT")]
    Left,
    #[doc(alias = "GST_VIDEO_MULTIVIEW_FRAME_PACKING_RIGHT")]
    Right,
    #[doc(alias = "GST_VIDEO_MULTIVIEW_FRAME_PACKING_SIDE_BY_SIDE")]
    SideBySide,
    #[doc(alias = "GST_VIDEO_MULTIVIEW_FRAME_PACKING_SIDE_BY_SIDE_QUINCUNX")]
    SideBySideQuincunx,
    #[doc(alias = "GST_VIDEO_MULTIVIEW_FRAME_PACKING_COLUMN_INTERLEAVED")]
    ColumnInterleaved,
    #[doc(alias = "GST_VIDEO_MULTIVIEW_FRAME_PACKING_ROW_INTERLEAVED")]
    RowInterleaved,
    #[doc(alias = "GST_VIDEO_MULTIVIEW_FRAME_PACKING_TOP_BOTTOM")]
    TopBottom,
    #[doc(alias = "GST_VIDEO_MULTIVIEW_FRAME_PACKING_CHECKERBOARD")]
    Checkerboard,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for VideoMultiviewFramePacking {
    type GlibType = ffi::GstVideoMultiviewFramePacking;

    fn into_glib(self) -> ffi::GstVideoMultiviewFramePacking {
        match self {
            Self::None => ffi::GST_VIDEO_MULTIVIEW_FRAME_PACKING_NONE,
            Self::Mono => ffi::GST_VIDEO_MULTIVIEW_FRAME_PACKING_MONO,
            Self::Left => ffi::GST_VIDEO_MULTIVIEW_FRAME_PACKING_LEFT,
            Self::Right => ffi::GST_VIDEO_MULTIVIEW_FRAME_PACKING_RIGHT,
            Self::SideBySide => ffi::GST_VIDEO_MULTIVIEW_FRAME_PACKING_SIDE_BY_SIDE,
            Self::SideBySideQuincunx => {
                ffi::GST_VIDEO_MULTIVIEW_FRAME_PACKING_SIDE_BY_SIDE_QUINCUNX
            }
            Self::ColumnInterleaved => ffi::GST_VIDEO_MULTIVIEW_FRAME_PACKING_COLUMN_INTERLEAVED,
            Self::RowInterleaved => ffi::GST_VIDEO_MULTIVIEW_FRAME_PACKING_ROW_INTERLEAVED,
            Self::TopBottom => ffi::GST_VIDEO_MULTIVIEW_FRAME_PACKING_TOP_BOTTOM,
            Self::Checkerboard => ffi::GST_VIDEO_MULTIVIEW_FRAME_PACKING_CHECKERBOARD,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstVideoMultiviewFramePacking> for VideoMultiviewFramePacking {
    unsafe fn from_glib(value: ffi::GstVideoMultiviewFramePacking) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_VIDEO_MULTIVIEW_FRAME_PACKING_NONE => Self::None,
            ffi::GST_VIDEO_MULTIVIEW_FRAME_PACKING_MONO => Self::Mono,
            ffi::GST_VIDEO_MULTIVIEW_FRAME_PACKING_LEFT => Self::Left,
            ffi::GST_VIDEO_MULTIVIEW_FRAME_PACKING_RIGHT => Self::Right,
            ffi::GST_VIDEO_MULTIVIEW_FRAME_PACKING_SIDE_BY_SIDE => Self::SideBySide,
            ffi::GST_VIDEO_MULTIVIEW_FRAME_PACKING_SIDE_BY_SIDE_QUINCUNX => {
                Self::SideBySideQuincunx
            }
            ffi::GST_VIDEO_MULTIVIEW_FRAME_PACKING_COLUMN_INTERLEAVED => Self::ColumnInterleaved,
            ffi::GST_VIDEO_MULTIVIEW_FRAME_PACKING_ROW_INTERLEAVED => Self::RowInterleaved,
            ffi::GST_VIDEO_MULTIVIEW_FRAME_PACKING_TOP_BOTTOM => Self::TopBottom,
            ffi::GST_VIDEO_MULTIVIEW_FRAME_PACKING_CHECKERBOARD => Self::Checkerboard,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for VideoMultiviewFramePacking {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_video_multiview_frame_packing_get_type()) }
    }
}

impl glib::value::ValueType for VideoMultiviewFramePacking {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for VideoMultiviewFramePacking {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for VideoMultiviewFramePacking {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstVideoMultiviewMode")]
pub enum VideoMultiviewMode {
    #[doc(alias = "GST_VIDEO_MULTIVIEW_MODE_NONE")]
    None,
    #[doc(alias = "GST_VIDEO_MULTIVIEW_MODE_MONO")]
    Mono,
    #[doc(alias = "GST_VIDEO_MULTIVIEW_MODE_LEFT")]
    Left,
    #[doc(alias = "GST_VIDEO_MULTIVIEW_MODE_RIGHT")]
    Right,
    #[doc(alias = "GST_VIDEO_MULTIVIEW_MODE_SIDE_BY_SIDE")]
    SideBySide,
    #[doc(alias = "GST_VIDEO_MULTIVIEW_MODE_SIDE_BY_SIDE_QUINCUNX")]
    SideBySideQuincunx,
    #[doc(alias = "GST_VIDEO_MULTIVIEW_MODE_COLUMN_INTERLEAVED")]
    ColumnInterleaved,
    #[doc(alias = "GST_VIDEO_MULTIVIEW_MODE_ROW_INTERLEAVED")]
    RowInterleaved,
    #[doc(alias = "GST_VIDEO_MULTIVIEW_MODE_TOP_BOTTOM")]
    TopBottom,
    #[doc(alias = "GST_VIDEO_MULTIVIEW_MODE_CHECKERBOARD")]
    Checkerboard,
    #[doc(alias = "GST_VIDEO_MULTIVIEW_MODE_FRAME_BY_FRAME")]
    FrameByFrame,
    #[doc(alias = "GST_VIDEO_MULTIVIEW_MODE_MULTIVIEW_FRAME_BY_FRAME")]
    MultiviewFrameByFrame,
    #[doc(alias = "GST_VIDEO_MULTIVIEW_MODE_SEPARATED")]
    Separated,
    #[doc(hidden)]
    __Unknown(i32),
}

impl VideoMultiviewMode {
    #[doc(alias = "gst_video_multiview_mode_from_caps_string")]
    pub fn from_caps_string(caps_mview_mode: &str) -> VideoMultiviewMode {
        assert_initialized_main_thread!();
        unsafe {
            from_glib(ffi::gst_video_multiview_mode_from_caps_string(
                caps_mview_mode.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_video_multiview_mode_to_caps_string")]
    pub fn to_caps_string(self) -> Option<glib::GString> {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_none(ffi::gst_video_multiview_mode_to_caps_string(
                self.into_glib(),
            ))
        }
    }
}

#[doc(hidden)]
impl IntoGlib for VideoMultiviewMode {
    type GlibType = ffi::GstVideoMultiviewMode;

    fn into_glib(self) -> ffi::GstVideoMultiviewMode {
        match self {
            Self::None => ffi::GST_VIDEO_MULTIVIEW_MODE_NONE,
            Self::Mono => ffi::GST_VIDEO_MULTIVIEW_MODE_MONO,
            Self::Left => ffi::GST_VIDEO_MULTIVIEW_MODE_LEFT,
            Self::Right => ffi::GST_VIDEO_MULTIVIEW_MODE_RIGHT,
            Self::SideBySide => ffi::GST_VIDEO_MULTIVIEW_MODE_SIDE_BY_SIDE,
            Self::SideBySideQuincunx => ffi::GST_VIDEO_MULTIVIEW_MODE_SIDE_BY_SIDE_QUINCUNX,
            Self::ColumnInterleaved => ffi::GST_VIDEO_MULTIVIEW_MODE_COLUMN_INTERLEAVED,
            Self::RowInterleaved => ffi::GST_VIDEO_MULTIVIEW_MODE_ROW_INTERLEAVED,
            Self::TopBottom => ffi::GST_VIDEO_MULTIVIEW_MODE_TOP_BOTTOM,
            Self::Checkerboard => ffi::GST_VIDEO_MULTIVIEW_MODE_CHECKERBOARD,
            Self::FrameByFrame => ffi::GST_VIDEO_MULTIVIEW_MODE_FRAME_BY_FRAME,
            Self::MultiviewFrameByFrame => ffi::GST_VIDEO_MULTIVIEW_MODE_MULTIVIEW_FRAME_BY_FRAME,
            Self::Separated => ffi::GST_VIDEO_MULTIVIEW_MODE_SEPARATED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstVideoMultiviewMode> for VideoMultiviewMode {
    unsafe fn from_glib(value: ffi::GstVideoMultiviewMode) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_VIDEO_MULTIVIEW_MODE_NONE => Self::None,
            ffi::GST_VIDEO_MULTIVIEW_MODE_MONO => Self::Mono,
            ffi::GST_VIDEO_MULTIVIEW_MODE_LEFT => Self::Left,
            ffi::GST_VIDEO_MULTIVIEW_MODE_RIGHT => Self::Right,
            ffi::GST_VIDEO_MULTIVIEW_MODE_SIDE_BY_SIDE => Self::SideBySide,
            ffi::GST_VIDEO_MULTIVIEW_MODE_SIDE_BY_SIDE_QUINCUNX => Self::SideBySideQuincunx,
            ffi::GST_VIDEO_MULTIVIEW_MODE_COLUMN_INTERLEAVED => Self::ColumnInterleaved,
            ffi::GST_VIDEO_MULTIVIEW_MODE_ROW_INTERLEAVED => Self::RowInterleaved,
            ffi::GST_VIDEO_MULTIVIEW_MODE_TOP_BOTTOM => Self::TopBottom,
            ffi::GST_VIDEO_MULTIVIEW_MODE_CHECKERBOARD => Self::Checkerboard,
            ffi::GST_VIDEO_MULTIVIEW_MODE_FRAME_BY_FRAME => Self::FrameByFrame,
            ffi::GST_VIDEO_MULTIVIEW_MODE_MULTIVIEW_FRAME_BY_FRAME => Self::MultiviewFrameByFrame,
            ffi::GST_VIDEO_MULTIVIEW_MODE_SEPARATED => Self::Separated,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for VideoMultiviewMode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_video_multiview_mode_get_type()) }
    }
}

impl glib::value::ValueType for VideoMultiviewMode {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for VideoMultiviewMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for VideoMultiviewMode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(any(feature = "v1_10", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_10")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstVideoOrientationMethod")]
pub enum VideoOrientationMethod {
    #[doc(alias = "GST_VIDEO_ORIENTATION_IDENTITY")]
    Identity,
    #[doc(alias = "GST_VIDEO_ORIENTATION_90R")]
    _90r,
    #[doc(alias = "GST_VIDEO_ORIENTATION_180")]
    _180,
    #[doc(alias = "GST_VIDEO_ORIENTATION_90L")]
    _90l,
    #[doc(alias = "GST_VIDEO_ORIENTATION_HORIZ")]
    Horiz,
    #[doc(alias = "GST_VIDEO_ORIENTATION_VERT")]
    Vert,
    #[doc(alias = "GST_VIDEO_ORIENTATION_UL_LR")]
    UlLr,
    #[doc(alias = "GST_VIDEO_ORIENTATION_UR_LL")]
    UrLl,
    #[doc(alias = "GST_VIDEO_ORIENTATION_AUTO")]
    Auto,
    #[doc(alias = "GST_VIDEO_ORIENTATION_CUSTOM")]
    Custom,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v1_10", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_10")))]
#[doc(hidden)]
impl IntoGlib for VideoOrientationMethod {
    type GlibType = ffi::GstVideoOrientationMethod;

    fn into_glib(self) -> ffi::GstVideoOrientationMethod {
        match self {
            Self::Identity => ffi::GST_VIDEO_ORIENTATION_IDENTITY,
            Self::_90r => ffi::GST_VIDEO_ORIENTATION_90R,
            Self::_180 => ffi::GST_VIDEO_ORIENTATION_180,
            Self::_90l => ffi::GST_VIDEO_ORIENTATION_90L,
            Self::Horiz => ffi::GST_VIDEO_ORIENTATION_HORIZ,
            Self::Vert => ffi::GST_VIDEO_ORIENTATION_VERT,
            Self::UlLr => ffi::GST_VIDEO_ORIENTATION_UL_LR,
            Self::UrLl => ffi::GST_VIDEO_ORIENTATION_UR_LL,
            Self::Auto => ffi::GST_VIDEO_ORIENTATION_AUTO,
            Self::Custom => ffi::GST_VIDEO_ORIENTATION_CUSTOM,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(any(feature = "v1_10", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_10")))]
#[doc(hidden)]
impl FromGlib<ffi::GstVideoOrientationMethod> for VideoOrientationMethod {
    unsafe fn from_glib(value: ffi::GstVideoOrientationMethod) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_VIDEO_ORIENTATION_IDENTITY => Self::Identity,
            ffi::GST_VIDEO_ORIENTATION_90R => Self::_90r,
            ffi::GST_VIDEO_ORIENTATION_180 => Self::_180,
            ffi::GST_VIDEO_ORIENTATION_90L => Self::_90l,
            ffi::GST_VIDEO_ORIENTATION_HORIZ => Self::Horiz,
            ffi::GST_VIDEO_ORIENTATION_VERT => Self::Vert,
            ffi::GST_VIDEO_ORIENTATION_UL_LR => Self::UlLr,
            ffi::GST_VIDEO_ORIENTATION_UR_LL => Self::UrLl,
            ffi::GST_VIDEO_ORIENTATION_AUTO => Self::Auto,
            ffi::GST_VIDEO_ORIENTATION_CUSTOM => Self::Custom,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v1_10", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_10")))]
impl StaticType for VideoOrientationMethod {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_video_orientation_method_get_type()) }
    }
}

#[cfg(any(feature = "v1_10", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_10")))]
impl glib::value::ValueType for VideoOrientationMethod {
    type Type = Self;
}

#[cfg(any(feature = "v1_10", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_10")))]
unsafe impl<'a> FromValue<'a> for VideoOrientationMethod {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v1_10", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_10")))]
impl ToValue for VideoOrientationMethod {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstVideoPrimariesMode")]
pub enum VideoPrimariesMode {
    #[doc(alias = "GST_VIDEO_PRIMARIES_MODE_NONE")]
    None,
    #[doc(alias = "GST_VIDEO_PRIMARIES_MODE_MERGE_ONLY")]
    MergeOnly,
    #[doc(alias = "GST_VIDEO_PRIMARIES_MODE_FAST")]
    Fast,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for VideoPrimariesMode {
    type GlibType = ffi::GstVideoPrimariesMode;

    fn into_glib(self) -> ffi::GstVideoPrimariesMode {
        match self {
            Self::None => ffi::GST_VIDEO_PRIMARIES_MODE_NONE,
            Self::MergeOnly => ffi::GST_VIDEO_PRIMARIES_MODE_MERGE_ONLY,
            Self::Fast => ffi::GST_VIDEO_PRIMARIES_MODE_FAST,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstVideoPrimariesMode> for VideoPrimariesMode {
    unsafe fn from_glib(value: ffi::GstVideoPrimariesMode) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_VIDEO_PRIMARIES_MODE_NONE => Self::None,
            ffi::GST_VIDEO_PRIMARIES_MODE_MERGE_ONLY => Self::MergeOnly,
            ffi::GST_VIDEO_PRIMARIES_MODE_FAST => Self::Fast,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for VideoPrimariesMode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_video_primaries_mode_get_type()) }
    }
}

impl glib::value::ValueType for VideoPrimariesMode {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for VideoPrimariesMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for VideoPrimariesMode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstVideoResamplerMethod")]
pub enum VideoResamplerMethod {
    #[doc(alias = "GST_VIDEO_RESAMPLER_METHOD_NEAREST")]
    Nearest,
    #[doc(alias = "GST_VIDEO_RESAMPLER_METHOD_LINEAR")]
    Linear,
    #[doc(alias = "GST_VIDEO_RESAMPLER_METHOD_CUBIC")]
    Cubic,
    #[doc(alias = "GST_VIDEO_RESAMPLER_METHOD_SINC")]
    Sinc,
    #[doc(alias = "GST_VIDEO_RESAMPLER_METHOD_LANCZOS")]
    Lanczos,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for VideoResamplerMethod {
    type GlibType = ffi::GstVideoResamplerMethod;

    fn into_glib(self) -> ffi::GstVideoResamplerMethod {
        match self {
            Self::Nearest => ffi::GST_VIDEO_RESAMPLER_METHOD_NEAREST,
            Self::Linear => ffi::GST_VIDEO_RESAMPLER_METHOD_LINEAR,
            Self::Cubic => ffi::GST_VIDEO_RESAMPLER_METHOD_CUBIC,
            Self::Sinc => ffi::GST_VIDEO_RESAMPLER_METHOD_SINC,
            Self::Lanczos => ffi::GST_VIDEO_RESAMPLER_METHOD_LANCZOS,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstVideoResamplerMethod> for VideoResamplerMethod {
    unsafe fn from_glib(value: ffi::GstVideoResamplerMethod) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_VIDEO_RESAMPLER_METHOD_NEAREST => Self::Nearest,
            ffi::GST_VIDEO_RESAMPLER_METHOD_LINEAR => Self::Linear,
            ffi::GST_VIDEO_RESAMPLER_METHOD_CUBIC => Self::Cubic,
            ffi::GST_VIDEO_RESAMPLER_METHOD_SINC => Self::Sinc,
            ffi::GST_VIDEO_RESAMPLER_METHOD_LANCZOS => Self::Lanczos,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for VideoResamplerMethod {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_video_resampler_method_get_type()) }
    }
}

impl glib::value::ValueType for VideoResamplerMethod {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for VideoResamplerMethod {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for VideoResamplerMethod {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstVideoTileMode")]
pub enum VideoTileMode {
    #[doc(alias = "GST_VIDEO_TILE_MODE_UNKNOWN")]
    Unknown,
    #[doc(alias = "GST_VIDEO_TILE_MODE_ZFLIPZ_2X2")]
    Zflipz2x2,
    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    #[doc(alias = "GST_VIDEO_TILE_MODE_LINEAR")]
    Linear,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for VideoTileMode {
    type GlibType = ffi::GstVideoTileMode;

    fn into_glib(self) -> ffi::GstVideoTileMode {
        match self {
            Self::Unknown => ffi::GST_VIDEO_TILE_MODE_UNKNOWN,
            Self::Zflipz2x2 => ffi::GST_VIDEO_TILE_MODE_ZFLIPZ_2X2,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            Self::Linear => ffi::GST_VIDEO_TILE_MODE_LINEAR,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstVideoTileMode> for VideoTileMode {
    unsafe fn from_glib(value: ffi::GstVideoTileMode) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_VIDEO_TILE_MODE_UNKNOWN => Self::Unknown,
            ffi::GST_VIDEO_TILE_MODE_ZFLIPZ_2X2 => Self::Zflipz2x2,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            ffi::GST_VIDEO_TILE_MODE_LINEAR => Self::Linear,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for VideoTileMode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_video_tile_mode_get_type()) }
    }
}

impl glib::value::ValueType for VideoTileMode {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for VideoTileMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for VideoTileMode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstVideoTransferFunction")]
pub enum VideoTransferFunction {
    #[doc(alias = "GST_VIDEO_TRANSFER_UNKNOWN")]
    Unknown,
    #[doc(alias = "GST_VIDEO_TRANSFER_GAMMA10")]
    Gamma10,
    #[doc(alias = "GST_VIDEO_TRANSFER_GAMMA18")]
    Gamma18,
    #[doc(alias = "GST_VIDEO_TRANSFER_GAMMA20")]
    Gamma20,
    #[doc(alias = "GST_VIDEO_TRANSFER_GAMMA22")]
    Gamma22,
    #[doc(alias = "GST_VIDEO_TRANSFER_BT709")]
    Bt709,
    #[doc(alias = "GST_VIDEO_TRANSFER_SMPTE240M")]
    Smpte240m,
    #[doc(alias = "GST_VIDEO_TRANSFER_SRGB")]
    Srgb,
    #[doc(alias = "GST_VIDEO_TRANSFER_GAMMA28")]
    Gamma28,
    #[doc(alias = "GST_VIDEO_TRANSFER_LOG100")]
    Log100,
    #[doc(alias = "GST_VIDEO_TRANSFER_LOG316")]
    Log316,
    #[doc(alias = "GST_VIDEO_TRANSFER_BT2020_12")]
    Bt202012,
    #[doc(alias = "GST_VIDEO_TRANSFER_ADOBERGB")]
    Adobergb,
    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    #[doc(alias = "GST_VIDEO_TRANSFER_BT2020_10")]
    Bt202010,
    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    #[doc(alias = "GST_VIDEO_TRANSFER_SMPTE2084")]
    Smpte2084,
    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    #[doc(alias = "GST_VIDEO_TRANSFER_ARIB_STD_B67")]
    AribStdB67,
    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    #[doc(alias = "GST_VIDEO_TRANSFER_BT601")]
    Bt601,
    #[doc(hidden)]
    __Unknown(i32),
}

impl VideoTransferFunction {
    #[cfg(any(feature = "v1_20", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_20")))]
    #[doc(alias = "gst_video_transfer_function_decode")]
    pub fn decode(self, val: f64) -> f64 {
        assert_initialized_main_thread!();
        unsafe { ffi::gst_video_transfer_function_decode(self.into_glib(), val) }
    }

    #[cfg(any(feature = "v1_20", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_20")))]
    #[doc(alias = "gst_video_transfer_function_encode")]
    pub fn encode(self, val: f64) -> f64 {
        assert_initialized_main_thread!();
        unsafe { ffi::gst_video_transfer_function_encode(self.into_glib(), val) }
    }

    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    #[doc(alias = "gst_video_transfer_function_from_iso")]
    pub fn from_iso(value: u32) -> VideoTransferFunction {
        assert_initialized_main_thread!();
        unsafe { from_glib(ffi::gst_video_transfer_function_from_iso(value)) }
    }

    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    #[doc(alias = "gst_video_transfer_function_is_equivalent")]
    pub fn is_equivalent(self, from_bpp: u32, to_func: VideoTransferFunction, to_bpp: u32) -> bool {
        assert_initialized_main_thread!();
        unsafe {
            from_glib(ffi::gst_video_transfer_function_is_equivalent(
                self.into_glib(),
                from_bpp,
                to_func.into_glib(),
                to_bpp,
            ))
        }
    }

    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    #[doc(alias = "gst_video_transfer_function_to_iso")]
    pub fn to_iso(self) -> u32 {
        assert_initialized_main_thread!();
        unsafe { ffi::gst_video_transfer_function_to_iso(self.into_glib()) }
    }
}

#[doc(hidden)]
impl IntoGlib for VideoTransferFunction {
    type GlibType = ffi::GstVideoTransferFunction;

    fn into_glib(self) -> ffi::GstVideoTransferFunction {
        match self {
            Self::Unknown => ffi::GST_VIDEO_TRANSFER_UNKNOWN,
            Self::Gamma10 => ffi::GST_VIDEO_TRANSFER_GAMMA10,
            Self::Gamma18 => ffi::GST_VIDEO_TRANSFER_GAMMA18,
            Self::Gamma20 => ffi::GST_VIDEO_TRANSFER_GAMMA20,
            Self::Gamma22 => ffi::GST_VIDEO_TRANSFER_GAMMA22,
            Self::Bt709 => ffi::GST_VIDEO_TRANSFER_BT709,
            Self::Smpte240m => ffi::GST_VIDEO_TRANSFER_SMPTE240M,
            Self::Srgb => ffi::GST_VIDEO_TRANSFER_SRGB,
            Self::Gamma28 => ffi::GST_VIDEO_TRANSFER_GAMMA28,
            Self::Log100 => ffi::GST_VIDEO_TRANSFER_LOG100,
            Self::Log316 => ffi::GST_VIDEO_TRANSFER_LOG316,
            Self::Bt202012 => ffi::GST_VIDEO_TRANSFER_BT2020_12,
            Self::Adobergb => ffi::GST_VIDEO_TRANSFER_ADOBERGB,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            Self::Bt202010 => ffi::GST_VIDEO_TRANSFER_BT2020_10,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            Self::Smpte2084 => ffi::GST_VIDEO_TRANSFER_SMPTE2084,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            Self::AribStdB67 => ffi::GST_VIDEO_TRANSFER_ARIB_STD_B67,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            Self::Bt601 => ffi::GST_VIDEO_TRANSFER_BT601,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstVideoTransferFunction> for VideoTransferFunction {
    unsafe fn from_glib(value: ffi::GstVideoTransferFunction) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_VIDEO_TRANSFER_UNKNOWN => Self::Unknown,
            ffi::GST_VIDEO_TRANSFER_GAMMA10 => Self::Gamma10,
            ffi::GST_VIDEO_TRANSFER_GAMMA18 => Self::Gamma18,
            ffi::GST_VIDEO_TRANSFER_GAMMA20 => Self::Gamma20,
            ffi::GST_VIDEO_TRANSFER_GAMMA22 => Self::Gamma22,
            ffi::GST_VIDEO_TRANSFER_BT709 => Self::Bt709,
            ffi::GST_VIDEO_TRANSFER_SMPTE240M => Self::Smpte240m,
            ffi::GST_VIDEO_TRANSFER_SRGB => Self::Srgb,
            ffi::GST_VIDEO_TRANSFER_GAMMA28 => Self::Gamma28,
            ffi::GST_VIDEO_TRANSFER_LOG100 => Self::Log100,
            ffi::GST_VIDEO_TRANSFER_LOG316 => Self::Log316,
            ffi::GST_VIDEO_TRANSFER_BT2020_12 => Self::Bt202012,
            ffi::GST_VIDEO_TRANSFER_ADOBERGB => Self::Adobergb,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            ffi::GST_VIDEO_TRANSFER_BT2020_10 => Self::Bt202010,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            ffi::GST_VIDEO_TRANSFER_SMPTE2084 => Self::Smpte2084,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            ffi::GST_VIDEO_TRANSFER_ARIB_STD_B67 => Self::AribStdB67,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            ffi::GST_VIDEO_TRANSFER_BT601 => Self::Bt601,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for VideoTransferFunction {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_video_transfer_function_get_type()) }
    }
}

impl glib::value::ValueType for VideoTransferFunction {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for VideoTransferFunction {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for VideoTransferFunction {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}
