// Take a look at the license at the top of the repository in the LICENSE file.

use crate::PtpClock;

use glib::prelude::*;
use glib::translate::*;

impl PtpClock {
    #[doc(alias = "gst_ptp_clock_new")]
    pub fn new(name: Option<&str>, domain: u32) -> PtpClock {
        assert_initialized_main_thread!();
        let name = name.to_glib_none();
        let (major, minor, _, _) = gst::version();
        if (major, minor) > (1, 12) {
            unsafe {
                gst::Clock::from_glib_full(ffi::gst_ptp_clock_new(name.0, domain)).unsafe_cast()
            }
        } else {
            // Workaround for bad floating reference handling in 1.12. This issue was fixed for 1.13
            unsafe {
                gst::Clock::from_glib_none(ffi::gst_ptp_clock_new(name.0, domain)).unsafe_cast()
            }
        }
    }
}
