// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

use crate::GLBaseFilter;
use crate::GLMemory;
use crate::GLShader;
use glib::object::IsA;
use glib::translate::*;

glib::wrapper! {
    #[doc(alias = "GstGLFilter")]
    pub struct GLFilter(Object<ffi::GstGLFilter, ffi::GstGLFilterClass>) @extends GLBaseFilter, gst_base::BaseTransform, gst::Element, gst::Object;

    match fn {
        type_ => || ffi::gst_gl_filter_get_type(),
    }
}

unsafe impl Send for GLFilter {}
unsafe impl Sync for GLFilter {}

pub const NONE_GL_FILTER: Option<&GLFilter> = None;

pub trait GLFilterExt: 'static {
    #[doc(alias = "gst_gl_filter_draw_fullscreen_quad")]
    fn draw_fullscreen_quad(&self);

    #[doc(alias = "gst_gl_filter_filter_texture")]
    fn filter_texture(
        &self,
        input: &gst::Buffer,
        output: &gst::Buffer,
    ) -> Result<(), glib::error::BoolError>;

    #[doc(alias = "gst_gl_filter_render_to_target")]
    fn render_to_target<P: FnMut(&GLFilter, &GLMemory) -> bool>(
        &self,
        input: &GLMemory,
        output: &GLMemory,
        func: P,
    ) -> Result<(), glib::error::BoolError>;

    #[doc(alias = "gst_gl_filter_render_to_target_with_shader")]
    fn render_to_target_with_shader(&self, input: &GLMemory, output: &GLMemory, shader: &GLShader);
}

impl<O: IsA<GLFilter>> GLFilterExt for O {
    fn draw_fullscreen_quad(&self) {
        unsafe {
            ffi::gst_gl_filter_draw_fullscreen_quad(self.as_ref().to_glib_none().0);
        }
    }

    fn filter_texture(
        &self,
        input: &gst::Buffer,
        output: &gst::Buffer,
    ) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_gl_filter_filter_texture(
                    self.as_ref().to_glib_none().0,
                    input.to_glib_none().0,
                    output.to_glib_none().0
                ),
                "Failed to transform texture"
            )
        }
    }

    fn render_to_target<P: FnMut(&GLFilter, &GLMemory) -> bool>(
        &self,
        input: &GLMemory,
        output: &GLMemory,
        func: P,
    ) -> Result<(), glib::error::BoolError> {
        let func_data: P = func;
        unsafe extern "C" fn func_func<P: FnMut(&GLFilter, &GLMemory) -> bool>(
            filter: *mut ffi::GstGLFilter,
            in_tex: *mut ffi::GstGLMemory,
            user_data: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let filter = from_glib_borrow(filter);
            let in_tex = from_glib_borrow(in_tex);
            let callback: *mut P = user_data as *const _ as usize as *mut P;
            let res = (*callback)(&filter, &in_tex);
            res.into_glib()
        }
        let func = Some(func_func::<P> as _);
        let super_callback0: &P = &func_data;
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_gl_filter_render_to_target(
                    self.as_ref().to_glib_none().0,
                    mut_override(input.to_glib_none().0),
                    mut_override(output.to_glib_none().0),
                    func,
                    super_callback0 as *const _ as usize as *mut _
                ),
                "`func` returned `false`"
            )
        }
    }

    fn render_to_target_with_shader(&self, input: &GLMemory, output: &GLMemory, shader: &GLShader) {
        unsafe {
            ffi::gst_gl_filter_render_to_target_with_shader(
                self.as_ref().to_glib_none().0,
                mut_override(input.to_glib_none().0),
                mut_override(output.to_glib_none().0),
                shader.to_glib_none().0,
            );
        }
    }
}
