// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

use crate::GLContext;
use crate::GLDisplayType;
use crate::GLWindow;
use crate::GLAPI;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use std::boxed::Box as Box_;
use std::mem::transmute;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "GstGLDisplay")]
    pub struct GLDisplay(Object<ffi::GstGLDisplay, ffi::GstGLDisplayClass>) @extends gst::Object;

    match fn {
        type_ => || ffi::gst_gl_display_get_type(),
    }
}

impl GLDisplay {
    #[doc(alias = "gst_gl_display_new")]
    pub fn new() -> GLDisplay {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gst_gl_display_new()) }
    }

    #[cfg(any(feature = "v1_20", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_20")))]
    #[doc(alias = "gst_gl_display_new_with_type")]
    #[doc(alias = "new_with_type")]
    pub fn with_type(type_: GLDisplayType) -> Option<GLDisplay> {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gst_gl_display_new_with_type(type_.into_glib())) }
    }
}

impl Default for GLDisplay {
    fn default() -> Self {
        Self::new()
    }
}

unsafe impl Send for GLDisplay {}
unsafe impl Sync for GLDisplay {}

pub const NONE_GL_DISPLAY: Option<&GLDisplay> = None;

pub trait GLDisplayExt: 'static {
    #[doc(alias = "gst_gl_display_add_context")]
    fn add_context<P: IsA<GLContext>>(&self, context: &P) -> Result<(), glib::error::BoolError>;

    #[doc(alias = "gst_gl_display_create_context")]
    fn create_context<P: IsA<GLContext>>(
        &self,
        other_context: &P,
    ) -> Result<GLContext, glib::Error>;

    #[doc(alias = "gst_gl_display_create_window")]
    fn create_window(&self) -> Result<GLWindow, glib::BoolError>;

    #[doc(alias = "gst_gl_display_filter_gl_api")]
    fn filter_gl_api(&self, gl_api: GLAPI);

    #[doc(alias = "gst_gl_display_get_gl_api")]
    #[doc(alias = "get_gl_api")]
    fn gl_api(&self) -> GLAPI;

    #[doc(alias = "gst_gl_display_get_gl_api_unlocked")]
    #[doc(alias = "get_gl_api_unlocked")]
    fn gl_api_unlocked(&self) -> GLAPI;

    #[doc(alias = "gst_gl_display_get_handle_type")]
    #[doc(alias = "get_handle_type")]
    fn handle_type(&self) -> GLDisplayType;

    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    #[doc(alias = "gst_gl_display_remove_context")]
    fn remove_context<P: IsA<GLContext>>(&self, context: &P);

    #[doc(alias = "gst_gl_display_remove_window")]
    fn remove_window<P: IsA<GLWindow>>(&self, window: &P) -> Result<(), glib::error::BoolError>;

    //#[cfg(any(feature = "v1_18", feature = "dox"))]
    //#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    //#[doc(alias = "gst_gl_display_retrieve_window")]
    //fn retrieve_window(&self, data: /*Unimplemented*/Option<Fundamental: Pointer>, compare_func: /*Unimplemented*/FnMut(/*Unimplemented*/Option<Fundamental: Pointer>, /*Unimplemented*/Option<Fundamental: Pointer>) -> i32) -> Option<GLWindow>;

    #[doc(alias = "create-context")]
    fn connect_create_context<F: Fn(&Self, &GLContext) -> GLContext + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;
}

impl<O: IsA<GLDisplay>> GLDisplayExt for O {
    fn add_context<P: IsA<GLContext>>(&self, context: &P) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_gl_display_add_context(
                    self.as_ref().to_glib_none().0,
                    context.as_ref().to_glib_none().0
                ),
                "Failed to add OpenGL context"
            )
        }
    }

    fn create_context<P: IsA<GLContext>>(
        &self,
        other_context: &P,
    ) -> Result<GLContext, glib::Error> {
        unsafe {
            let mut p_context = ptr::null_mut();
            let mut error = ptr::null_mut();
            let _ = ffi::gst_gl_display_create_context(
                self.as_ref().to_glib_none().0,
                other_context.as_ref().to_glib_none().0,
                &mut p_context,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(p_context))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn create_window(&self) -> Result<GLWindow, glib::BoolError> {
        unsafe {
            Option::<_>::from_glib_full(ffi::gst_gl_display_create_window(
                self.as_ref().to_glib_none().0,
            ))
            .ok_or_else(|| glib::bool_error!("Failed to create window"))
        }
    }

    fn filter_gl_api(&self, gl_api: GLAPI) {
        unsafe {
            ffi::gst_gl_display_filter_gl_api(self.as_ref().to_glib_none().0, gl_api.into_glib());
        }
    }

    fn gl_api(&self) -> GLAPI {
        unsafe {
            from_glib(ffi::gst_gl_display_get_gl_api(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn gl_api_unlocked(&self) -> GLAPI {
        unsafe {
            from_glib(ffi::gst_gl_display_get_gl_api_unlocked(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn handle_type(&self) -> GLDisplayType {
        unsafe {
            from_glib(ffi::gst_gl_display_get_handle_type(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    fn remove_context<P: IsA<GLContext>>(&self, context: &P) {
        unsafe {
            ffi::gst_gl_display_remove_context(
                self.as_ref().to_glib_none().0,
                context.as_ref().to_glib_none().0,
            );
        }
    }

    fn remove_window<P: IsA<GLWindow>>(&self, window: &P) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_gl_display_remove_window(
                    self.as_ref().to_glib_none().0,
                    window.as_ref().to_glib_none().0
                ),
                "Failed to remove window"
            )
        }
    }

    //#[cfg(any(feature = "v1_18", feature = "dox"))]
    //#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    //fn retrieve_window(&self, data: /*Unimplemented*/Option<Fundamental: Pointer>, compare_func: /*Unimplemented*/FnMut(/*Unimplemented*/Option<Fundamental: Pointer>, /*Unimplemented*/Option<Fundamental: Pointer>) -> i32) -> Option<GLWindow> {
    //    unsafe { TODO: call ffi:gst_gl_display_retrieve_window() }
    //}

    fn connect_create_context<F: Fn(&Self, &GLContext) -> GLContext + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn create_context_trampoline<
            P: IsA<GLDisplay>,
            F: Fn(&P, &GLContext) -> GLContext + Send + Sync + 'static,
        >(
            this: *mut ffi::GstGLDisplay,
            context: *mut ffi::GstGLContext,
            f: glib::ffi::gpointer,
        ) -> *mut ffi::GstGLContext {
            let f: &F = &*(f as *const F);
            f(
                GLDisplay::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(context),
            )
            .to_glib_full()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"create-context\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    create_context_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}
