// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

use crate::GLContext;
use crate::GLSLProfile;
use glib::error::ErrorDomain;
use glib::object::IsA;
use glib::translate::*;
use glib::value::FromValue;
use glib::value::ToValue;
use glib::Quark;
use glib::StaticType;
use glib::Type;
use std::mem;

#[cfg(any(feature = "v1_20", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_20")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstGLConfigCaveat")]
pub enum GLConfigCaveat {
    #[doc(alias = "GST_GL_CONFIG_CAVEAT_NONE")]
    None,
    #[doc(alias = "GST_GL_CONFIG_CAVEAT_SLOW")]
    Slow,
    #[doc(alias = "GST_GL_CONFIG_CAVEAT_NON_CONFORMANT")]
    NonConformant,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v1_20", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_20")))]
impl GLConfigCaveat {
    #[doc(alias = "gst_gl_config_caveat_to_string")]
    #[doc(alias = "to_string")]
    pub fn to_str(self) -> Option<glib::GString> {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::gst_gl_config_caveat_to_string(self.into_glib())) }
    }
}

#[cfg(any(feature = "v1_20", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_20")))]
#[doc(hidden)]
impl IntoGlib for GLConfigCaveat {
    type GlibType = ffi::GstGLConfigCaveat;

    fn into_glib(self) -> ffi::GstGLConfigCaveat {
        match self {
            Self::None => ffi::GST_GL_CONFIG_CAVEAT_NONE,
            Self::Slow => ffi::GST_GL_CONFIG_CAVEAT_SLOW,
            Self::NonConformant => ffi::GST_GL_CONFIG_CAVEAT_NON_CONFORMANT,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(any(feature = "v1_20", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_20")))]
#[doc(hidden)]
impl FromGlib<ffi::GstGLConfigCaveat> for GLConfigCaveat {
    unsafe fn from_glib(value: ffi::GstGLConfigCaveat) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_GL_CONFIG_CAVEAT_NONE => Self::None,
            ffi::GST_GL_CONFIG_CAVEAT_SLOW => Self::Slow,
            ffi::GST_GL_CONFIG_CAVEAT_NON_CONFORMANT => Self::NonConformant,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v1_20", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_20")))]
impl StaticType for GLConfigCaveat {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_gl_config_caveat_get_type()) }
    }
}

#[cfg(any(feature = "v1_20", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_20")))]
impl glib::value::ValueType for GLConfigCaveat {
    type Type = Self;
}

#[cfg(any(feature = "v1_20", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_20")))]
unsafe impl<'a> FromValue<'a> for GLConfigCaveat {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v1_20", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_20")))]
impl ToValue for GLConfigCaveat {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstGLContextError")]
pub enum GLContextError {
    #[doc(alias = "GST_GL_CONTEXT_ERROR_FAILED")]
    Failed,
    #[doc(alias = "GST_GL_CONTEXT_ERROR_WRONG_CONFIG")]
    WrongConfig,
    #[doc(alias = "GST_GL_CONTEXT_ERROR_WRONG_API")]
    WrongApi,
    #[doc(alias = "GST_GL_CONTEXT_ERROR_OLD_LIBS")]
    OldLibs,
    #[doc(alias = "GST_GL_CONTEXT_ERROR_CREATE_CONTEXT")]
    CreateContext,
    #[doc(alias = "GST_GL_CONTEXT_ERROR_RESOURCE_UNAVAILABLE")]
    ResourceUnavailable,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for GLContextError {
    type GlibType = ffi::GstGLContextError;

    fn into_glib(self) -> ffi::GstGLContextError {
        match self {
            Self::Failed => ffi::GST_GL_CONTEXT_ERROR_FAILED,
            Self::WrongConfig => ffi::GST_GL_CONTEXT_ERROR_WRONG_CONFIG,
            Self::WrongApi => ffi::GST_GL_CONTEXT_ERROR_WRONG_API,
            Self::OldLibs => ffi::GST_GL_CONTEXT_ERROR_OLD_LIBS,
            Self::CreateContext => ffi::GST_GL_CONTEXT_ERROR_CREATE_CONTEXT,
            Self::ResourceUnavailable => ffi::GST_GL_CONTEXT_ERROR_RESOURCE_UNAVAILABLE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstGLContextError> for GLContextError {
    unsafe fn from_glib(value: ffi::GstGLContextError) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_GL_CONTEXT_ERROR_FAILED => Self::Failed,
            ffi::GST_GL_CONTEXT_ERROR_WRONG_CONFIG => Self::WrongConfig,
            ffi::GST_GL_CONTEXT_ERROR_WRONG_API => Self::WrongApi,
            ffi::GST_GL_CONTEXT_ERROR_OLD_LIBS => Self::OldLibs,
            ffi::GST_GL_CONTEXT_ERROR_CREATE_CONTEXT => Self::CreateContext,
            ffi::GST_GL_CONTEXT_ERROR_RESOURCE_UNAVAILABLE => Self::ResourceUnavailable,
            value => Self::__Unknown(value),
        }
    }
}

impl ErrorDomain for GLContextError {
    fn domain() -> Quark {
        skip_assert_initialized!();

        unsafe { from_glib(ffi::gst_gl_context_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            ffi::GST_GL_CONTEXT_ERROR_FAILED => Some(Self::Failed),
            ffi::GST_GL_CONTEXT_ERROR_WRONG_CONFIG => Some(Self::WrongConfig),
            ffi::GST_GL_CONTEXT_ERROR_WRONG_API => Some(Self::WrongApi),
            ffi::GST_GL_CONTEXT_ERROR_OLD_LIBS => Some(Self::OldLibs),
            ffi::GST_GL_CONTEXT_ERROR_CREATE_CONTEXT => Some(Self::CreateContext),
            ffi::GST_GL_CONTEXT_ERROR_RESOURCE_UNAVAILABLE => Some(Self::ResourceUnavailable),
            _ => Some(Self::Failed),
        }
    }
}

impl StaticType for GLContextError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_gl_context_error_get_type()) }
    }
}

impl glib::value::ValueType for GLContextError {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for GLContextError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for GLContextError {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstGLFormat")]
pub enum GLFormat {
    #[doc(alias = "GST_GL_LUMINANCE")]
    Luminance,
    #[doc(alias = "GST_GL_ALPHA")]
    Alpha,
    #[doc(alias = "GST_GL_LUMINANCE_ALPHA")]
    LuminanceAlpha,
    #[doc(alias = "GST_GL_RED")]
    Red,
    #[doc(alias = "GST_GL_R8")]
    R8,
    #[doc(alias = "GST_GL_RG")]
    Rg,
    #[doc(alias = "GST_GL_RG8")]
    Rg8,
    #[doc(alias = "GST_GL_RGB")]
    Rgb,
    #[doc(alias = "GST_GL_RGB8")]
    Rgb8,
    #[doc(alias = "GST_GL_RGB565")]
    Rgb565,
    #[doc(alias = "GST_GL_RGB16")]
    Rgb16,
    #[doc(alias = "GST_GL_RGBA")]
    Rgba,
    #[doc(alias = "GST_GL_RGBA8")]
    Rgba8,
    #[doc(alias = "GST_GL_RGBA16")]
    Rgba16,
    #[doc(alias = "GST_GL_DEPTH_COMPONENT16")]
    DepthComponent16,
    #[doc(alias = "GST_GL_DEPTH24_STENCIL8")]
    Depth24Stencil8,
    #[doc(alias = "GST_GL_RGB10_A2")]
    Rgb10A2,
    #[doc(alias = "GST_GL_R16")]
    R16,
    #[doc(alias = "GST_GL_RG16")]
    Rg16,
    #[doc(hidden)]
    __Unknown(i32),
}

impl GLFormat {
    #[doc(alias = "gst_gl_format_from_video_info")]
    pub fn from_video_info<P: IsA<GLContext>>(
        context: &P,
        vinfo: &gst_video::VideoInfo,
        plane: u32,
    ) -> GLFormat {
        skip_assert_initialized!();
        unsafe {
            from_glib(ffi::gst_gl_format_from_video_info(
                context.as_ref().to_glib_none().0,
                vinfo.to_glib_none().0,
                plane,
            ))
        }
    }

    #[cfg(any(feature = "v1_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_16")))]
    #[doc(alias = "gst_gl_format_is_supported")]
    pub fn is_supported<P: IsA<GLContext>>(context: &P, format: GLFormat) -> bool {
        skip_assert_initialized!();
        unsafe {
            from_glib(ffi::gst_gl_format_is_supported(
                context.as_ref().to_glib_none().0,
                format.into_glib(),
            ))
        }
    }

    #[cfg(any(feature = "v1_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_16")))]
    #[doc(alias = "gst_gl_format_type_from_sized_gl_format")]
    pub fn type_from_sized_gl_format(self) -> (GLFormat, u32) {
        assert_initialized_main_thread!();
        unsafe {
            let mut unsized_format = mem::MaybeUninit::uninit();
            let mut gl_type = mem::MaybeUninit::uninit();
            ffi::gst_gl_format_type_from_sized_gl_format(
                self.into_glib(),
                unsized_format.as_mut_ptr(),
                gl_type.as_mut_ptr(),
            );
            let unsized_format = unsized_format.assume_init();
            let gl_type = gl_type.assume_init();
            (from_glib(unsized_format), gl_type)
        }
    }

    #[doc(alias = "gst_gl_format_type_n_bytes")]
    pub fn type_n_bytes(format: u32, type_: u32) -> u32 {
        assert_initialized_main_thread!();
        unsafe { ffi::gst_gl_format_type_n_bytes(format, type_) }
    }
}

#[doc(hidden)]
impl IntoGlib for GLFormat {
    type GlibType = ffi::GstGLFormat;

    fn into_glib(self) -> ffi::GstGLFormat {
        match self {
            Self::Luminance => ffi::GST_GL_LUMINANCE,
            Self::Alpha => ffi::GST_GL_ALPHA,
            Self::LuminanceAlpha => ffi::GST_GL_LUMINANCE_ALPHA,
            Self::Red => ffi::GST_GL_RED,
            Self::R8 => ffi::GST_GL_R8,
            Self::Rg => ffi::GST_GL_RG,
            Self::Rg8 => ffi::GST_GL_RG8,
            Self::Rgb => ffi::GST_GL_RGB,
            Self::Rgb8 => ffi::GST_GL_RGB8,
            Self::Rgb565 => ffi::GST_GL_RGB565,
            Self::Rgb16 => ffi::GST_GL_RGB16,
            Self::Rgba => ffi::GST_GL_RGBA,
            Self::Rgba8 => ffi::GST_GL_RGBA8,
            Self::Rgba16 => ffi::GST_GL_RGBA16,
            Self::DepthComponent16 => ffi::GST_GL_DEPTH_COMPONENT16,
            Self::Depth24Stencil8 => ffi::GST_GL_DEPTH24_STENCIL8,
            Self::Rgb10A2 => ffi::GST_GL_RGB10_A2,
            Self::R16 => ffi::GST_GL_R16,
            Self::Rg16 => ffi::GST_GL_RG16,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstGLFormat> for GLFormat {
    unsafe fn from_glib(value: ffi::GstGLFormat) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_GL_LUMINANCE => Self::Luminance,
            ffi::GST_GL_ALPHA => Self::Alpha,
            ffi::GST_GL_LUMINANCE_ALPHA => Self::LuminanceAlpha,
            ffi::GST_GL_RED => Self::Red,
            ffi::GST_GL_R8 => Self::R8,
            ffi::GST_GL_RG => Self::Rg,
            ffi::GST_GL_RG8 => Self::Rg8,
            ffi::GST_GL_RGB => Self::Rgb,
            ffi::GST_GL_RGB8 => Self::Rgb8,
            ffi::GST_GL_RGB565 => Self::Rgb565,
            ffi::GST_GL_RGB16 => Self::Rgb16,
            ffi::GST_GL_RGBA => Self::Rgba,
            ffi::GST_GL_RGBA8 => Self::Rgba8,
            ffi::GST_GL_RGBA16 => Self::Rgba16,
            ffi::GST_GL_DEPTH_COMPONENT16 => Self::DepthComponent16,
            ffi::GST_GL_DEPTH24_STENCIL8 => Self::Depth24Stencil8,
            ffi::GST_GL_RGB10_A2 => Self::Rgb10A2,
            ffi::GST_GL_R16 => Self::R16,
            ffi::GST_GL_RG16 => Self::Rg16,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for GLFormat {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_gl_format_get_type()) }
    }
}

impl glib::value::ValueType for GLFormat {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for GLFormat {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for GLFormat {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstGLQueryType")]
pub enum GLQueryType {
    #[doc(alias = "GST_GL_QUERY_NONE")]
    None,
    #[doc(alias = "GST_GL_QUERY_TIME_ELAPSED")]
    TimeElapsed,
    #[doc(alias = "GST_GL_QUERY_TIMESTAMP")]
    Timestamp,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for GLQueryType {
    type GlibType = ffi::GstGLQueryType;

    fn into_glib(self) -> ffi::GstGLQueryType {
        match self {
            Self::None => ffi::GST_GL_QUERY_NONE,
            Self::TimeElapsed => ffi::GST_GL_QUERY_TIME_ELAPSED,
            Self::Timestamp => ffi::GST_GL_QUERY_TIMESTAMP,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstGLQueryType> for GLQueryType {
    unsafe fn from_glib(value: ffi::GstGLQueryType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_GL_QUERY_NONE => Self::None,
            ffi::GST_GL_QUERY_TIME_ELAPSED => Self::TimeElapsed,
            ffi::GST_GL_QUERY_TIMESTAMP => Self::Timestamp,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for GLQueryType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_gl_query_type_get_type()) }
    }
}

impl glib::value::ValueType for GLQueryType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for GLQueryType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for GLQueryType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstGLSLError")]
pub enum GLSLError {
    #[doc(alias = "GST_GLSL_ERROR_COMPILE")]
    Compile,
    #[doc(alias = "GST_GLSL_ERROR_LINK")]
    Link,
    #[doc(alias = "GST_GLSL_ERROR_PROGRAM")]
    Program,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for GLSLError {
    type GlibType = ffi::GstGLSLError;

    fn into_glib(self) -> ffi::GstGLSLError {
        match self {
            Self::Compile => ffi::GST_GLSL_ERROR_COMPILE,
            Self::Link => ffi::GST_GLSL_ERROR_LINK,
            Self::Program => ffi::GST_GLSL_ERROR_PROGRAM,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstGLSLError> for GLSLError {
    unsafe fn from_glib(value: ffi::GstGLSLError) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_GLSL_ERROR_COMPILE => Self::Compile,
            ffi::GST_GLSL_ERROR_LINK => Self::Link,
            ffi::GST_GLSL_ERROR_PROGRAM => Self::Program,
            value => Self::__Unknown(value),
        }
    }
}

impl ErrorDomain for GLSLError {
    fn domain() -> Quark {
        skip_assert_initialized!();

        unsafe { from_glib(ffi::gst_glsl_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            ffi::GST_GLSL_ERROR_COMPILE => Some(Self::Compile),
            ffi::GST_GLSL_ERROR_LINK => Some(Self::Link),
            ffi::GST_GLSL_ERROR_PROGRAM => Some(Self::Program),
            value => Some(Self::__Unknown(value)),
        }
    }
}

impl StaticType for GLSLError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_glsl_error_get_type()) }
    }
}

impl glib::value::ValueType for GLSLError {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for GLSLError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for GLSLError {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstGLSLVersion")]
pub enum GLSLVersion {
    #[doc(alias = "GST_GLSL_VERSION_NONE")]
    None,
    #[doc(alias = "GST_GLSL_VERSION_100")]
    _100,
    #[doc(alias = "GST_GLSL_VERSION_110")]
    _110,
    #[doc(alias = "GST_GLSL_VERSION_120")]
    _120,
    #[doc(alias = "GST_GLSL_VERSION_130")]
    _130,
    #[doc(alias = "GST_GLSL_VERSION_140")]
    _140,
    #[doc(alias = "GST_GLSL_VERSION_150")]
    _150,
    #[doc(alias = "GST_GLSL_VERSION_300")]
    _300,
    #[doc(alias = "GST_GLSL_VERSION_310")]
    _310,
    #[doc(alias = "GST_GLSL_VERSION_320")]
    _320,
    #[doc(alias = "GST_GLSL_VERSION_330")]
    _330,
    #[doc(alias = "GST_GLSL_VERSION_400")]
    _400,
    #[doc(alias = "GST_GLSL_VERSION_410")]
    _410,
    #[doc(alias = "GST_GLSL_VERSION_420")]
    _420,
    #[doc(alias = "GST_GLSL_VERSION_430")]
    _430,
    #[doc(alias = "GST_GLSL_VERSION_440")]
    _440,
    #[doc(alias = "GST_GLSL_VERSION_450")]
    _450,
    #[doc(hidden)]
    __Unknown(i32),
}

impl GLSLVersion {
    #[doc(alias = "gst_glsl_version_from_string")]
    pub fn from_string(string: &str) -> GLSLVersion {
        assert_initialized_main_thread!();
        unsafe { from_glib(ffi::gst_glsl_version_from_string(string.to_glib_none().0)) }
    }

    #[doc(alias = "gst_glsl_version_profile_from_string")]
    pub fn profile_from_string(string: &str) -> Option<(GLSLVersion, GLSLProfile)> {
        assert_initialized_main_thread!();
        unsafe {
            let mut version_ret = mem::MaybeUninit::uninit();
            let mut profile_ret = mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gst_glsl_version_profile_from_string(
                string.to_glib_none().0,
                version_ret.as_mut_ptr(),
                profile_ret.as_mut_ptr(),
            ));
            let version_ret = version_ret.assume_init();
            let profile_ret = profile_ret.assume_init();
            if ret {
                Some((from_glib(version_ret), from_glib(profile_ret)))
            } else {
                None
            }
        }
    }

    #[doc(alias = "gst_glsl_version_profile_to_string")]
    pub fn profile_to_string(self, profile: GLSLProfile) -> Option<glib::GString> {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::gst_glsl_version_profile_to_string(
                self.into_glib(),
                profile.into_glib(),
            ))
        }
    }

    #[doc(alias = "gst_glsl_version_to_string")]
    #[doc(alias = "to_string")]
    pub fn to_str(self) -> Option<glib::GString> {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::gst_glsl_version_to_string(self.into_glib())) }
    }
}

#[doc(hidden)]
impl IntoGlib for GLSLVersion {
    type GlibType = ffi::GstGLSLVersion;

    fn into_glib(self) -> ffi::GstGLSLVersion {
        match self {
            Self::None => ffi::GST_GLSL_VERSION_NONE,
            Self::_100 => ffi::GST_GLSL_VERSION_100,
            Self::_110 => ffi::GST_GLSL_VERSION_110,
            Self::_120 => ffi::GST_GLSL_VERSION_120,
            Self::_130 => ffi::GST_GLSL_VERSION_130,
            Self::_140 => ffi::GST_GLSL_VERSION_140,
            Self::_150 => ffi::GST_GLSL_VERSION_150,
            Self::_300 => ffi::GST_GLSL_VERSION_300,
            Self::_310 => ffi::GST_GLSL_VERSION_310,
            Self::_320 => ffi::GST_GLSL_VERSION_320,
            Self::_330 => ffi::GST_GLSL_VERSION_330,
            Self::_400 => ffi::GST_GLSL_VERSION_400,
            Self::_410 => ffi::GST_GLSL_VERSION_410,
            Self::_420 => ffi::GST_GLSL_VERSION_420,
            Self::_430 => ffi::GST_GLSL_VERSION_430,
            Self::_440 => ffi::GST_GLSL_VERSION_440,
            Self::_450 => ffi::GST_GLSL_VERSION_450,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstGLSLVersion> for GLSLVersion {
    unsafe fn from_glib(value: ffi::GstGLSLVersion) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_GLSL_VERSION_NONE => Self::None,
            ffi::GST_GLSL_VERSION_100 => Self::_100,
            ffi::GST_GLSL_VERSION_110 => Self::_110,
            ffi::GST_GLSL_VERSION_120 => Self::_120,
            ffi::GST_GLSL_VERSION_130 => Self::_130,
            ffi::GST_GLSL_VERSION_140 => Self::_140,
            ffi::GST_GLSL_VERSION_150 => Self::_150,
            ffi::GST_GLSL_VERSION_300 => Self::_300,
            ffi::GST_GLSL_VERSION_310 => Self::_310,
            ffi::GST_GLSL_VERSION_320 => Self::_320,
            ffi::GST_GLSL_VERSION_330 => Self::_330,
            ffi::GST_GLSL_VERSION_400 => Self::_400,
            ffi::GST_GLSL_VERSION_410 => Self::_410,
            ffi::GST_GLSL_VERSION_420 => Self::_420,
            ffi::GST_GLSL_VERSION_430 => Self::_430,
            ffi::GST_GLSL_VERSION_440 => Self::_440,
            ffi::GST_GLSL_VERSION_450 => Self::_450,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for GLSLVersion {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_glsl_version_get_type()) }
    }
}

impl glib::value::ValueType for GLSLVersion {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for GLSLVersion {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for GLSLVersion {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstGLStereoDownmix")]
pub enum GLStereoDownmix {
    #[doc(alias = "GST_GL_STEREO_DOWNMIX_ANAGLYPH_GREEN_MAGENTA_DUBOIS")]
    GreenMagentaDubois,
    #[doc(alias = "GST_GL_STEREO_DOWNMIX_ANAGLYPH_RED_CYAN_DUBOIS")]
    RedCyanDubois,
    #[doc(alias = "GST_GL_STEREO_DOWNMIX_ANAGLYPH_AMBER_BLUE_DUBOIS")]
    AmberBlueDubois,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for GLStereoDownmix {
    type GlibType = ffi::GstGLStereoDownmix;

    fn into_glib(self) -> ffi::GstGLStereoDownmix {
        match self {
            Self::GreenMagentaDubois => ffi::GST_GL_STEREO_DOWNMIX_ANAGLYPH_GREEN_MAGENTA_DUBOIS,
            Self::RedCyanDubois => ffi::GST_GL_STEREO_DOWNMIX_ANAGLYPH_RED_CYAN_DUBOIS,
            Self::AmberBlueDubois => ffi::GST_GL_STEREO_DOWNMIX_ANAGLYPH_AMBER_BLUE_DUBOIS,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstGLStereoDownmix> for GLStereoDownmix {
    unsafe fn from_glib(value: ffi::GstGLStereoDownmix) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_GL_STEREO_DOWNMIX_ANAGLYPH_GREEN_MAGENTA_DUBOIS => Self::GreenMagentaDubois,
            ffi::GST_GL_STEREO_DOWNMIX_ANAGLYPH_RED_CYAN_DUBOIS => Self::RedCyanDubois,
            ffi::GST_GL_STEREO_DOWNMIX_ANAGLYPH_AMBER_BLUE_DUBOIS => Self::AmberBlueDubois,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for GLStereoDownmix {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_gl_stereo_downmix_get_type()) }
    }
}

impl glib::value::ValueType for GLStereoDownmix {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for GLStereoDownmix {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for GLStereoDownmix {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstGLTextureTarget")]
pub enum GLTextureTarget {
    #[doc(alias = "GST_GL_TEXTURE_TARGET_NONE")]
    None,
    #[doc(alias = "GST_GL_TEXTURE_TARGET_2D")]
    _2d,
    #[doc(alias = "GST_GL_TEXTURE_TARGET_RECTANGLE")]
    Rectangle,
    #[doc(alias = "GST_GL_TEXTURE_TARGET_EXTERNAL_OES")]
    ExternalOes,
    #[doc(hidden)]
    __Unknown(i32),
}

impl GLTextureTarget {
    #[doc(alias = "gst_gl_texture_target_from_gl")]
    pub fn from_gl(target: u32) -> GLTextureTarget {
        assert_initialized_main_thread!();
        unsafe { from_glib(ffi::gst_gl_texture_target_from_gl(target)) }
    }

    #[doc(alias = "gst_gl_texture_target_from_string")]
    pub fn from_string(str: &str) -> GLTextureTarget {
        assert_initialized_main_thread!();
        unsafe { from_glib(ffi::gst_gl_texture_target_from_string(str.to_glib_none().0)) }
    }

    #[doc(alias = "gst_gl_texture_target_to_buffer_pool_option")]
    pub fn to_buffer_pool_option(self) -> Option<glib::GString> {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_none(ffi::gst_gl_texture_target_to_buffer_pool_option(
                self.into_glib(),
            ))
        }
    }

    #[doc(alias = "gst_gl_texture_target_to_gl")]
    pub fn to_gl(self) -> u32 {
        assert_initialized_main_thread!();
        unsafe { ffi::gst_gl_texture_target_to_gl(self.into_glib()) }
    }

    #[doc(alias = "gst_gl_texture_target_to_string")]
    #[doc(alias = "to_string")]
    pub fn to_str(self) -> Option<glib::GString> {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::gst_gl_texture_target_to_string(self.into_glib())) }
    }
}

#[doc(hidden)]
impl IntoGlib for GLTextureTarget {
    type GlibType = ffi::GstGLTextureTarget;

    fn into_glib(self) -> ffi::GstGLTextureTarget {
        match self {
            Self::None => ffi::GST_GL_TEXTURE_TARGET_NONE,
            Self::_2d => ffi::GST_GL_TEXTURE_TARGET_2D,
            Self::Rectangle => ffi::GST_GL_TEXTURE_TARGET_RECTANGLE,
            Self::ExternalOes => ffi::GST_GL_TEXTURE_TARGET_EXTERNAL_OES,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstGLTextureTarget> for GLTextureTarget {
    unsafe fn from_glib(value: ffi::GstGLTextureTarget) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_GL_TEXTURE_TARGET_NONE => Self::None,
            ffi::GST_GL_TEXTURE_TARGET_2D => Self::_2d,
            ffi::GST_GL_TEXTURE_TARGET_RECTANGLE => Self::Rectangle,
            ffi::GST_GL_TEXTURE_TARGET_EXTERNAL_OES => Self::ExternalOes,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for GLTextureTarget {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_gl_texture_target_get_type()) }
    }
}

impl glib::value::ValueType for GLTextureTarget {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for GLTextureTarget {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for GLTextureTarget {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstGLUploadReturn")]
pub enum GLUploadReturn {
    #[doc(alias = "GST_GL_UPLOAD_DONE")]
    Done,
    #[doc(alias = "GST_GL_UPLOAD_ERROR")]
    Error,
    #[doc(alias = "GST_GL_UPLOAD_UNSUPPORTED")]
    Unsupported,
    #[doc(alias = "GST_GL_UPLOAD_RECONFIGURE")]
    Reconfigure,
    #[doc(alias = "GST_GL_UPLOAD_UNSHARED_GL_CONTEXT")]
    UnsharedGlContext,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for GLUploadReturn {
    type GlibType = ffi::GstGLUploadReturn;

    fn into_glib(self) -> ffi::GstGLUploadReturn {
        match self {
            Self::Done => ffi::GST_GL_UPLOAD_DONE,
            Self::Error => ffi::GST_GL_UPLOAD_ERROR,
            Self::Unsupported => ffi::GST_GL_UPLOAD_UNSUPPORTED,
            Self::Reconfigure => ffi::GST_GL_UPLOAD_RECONFIGURE,
            Self::UnsharedGlContext => ffi::GST_GL_UPLOAD_UNSHARED_GL_CONTEXT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstGLUploadReturn> for GLUploadReturn {
    unsafe fn from_glib(value: ffi::GstGLUploadReturn) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_GL_UPLOAD_DONE => Self::Done,
            ffi::GST_GL_UPLOAD_ERROR => Self::Error,
            ffi::GST_GL_UPLOAD_UNSUPPORTED => Self::Unsupported,
            ffi::GST_GL_UPLOAD_RECONFIGURE => Self::Reconfigure,
            ffi::GST_GL_UPLOAD_UNSHARED_GL_CONTEXT => Self::UnsharedGlContext,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for GLUploadReturn {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_gl_upload_return_get_type()) }
    }
}

impl glib::value::ValueType for GLUploadReturn {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for GLUploadReturn {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for GLUploadReturn {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstGLWindowError")]
pub enum GLWindowError {
    #[doc(alias = "GST_GL_WINDOW_ERROR_FAILED")]
    Failed,
    #[doc(alias = "GST_GL_WINDOW_ERROR_OLD_LIBS")]
    OldLibs,
    #[doc(alias = "GST_GL_WINDOW_ERROR_RESOURCE_UNAVAILABLE")]
    ResourceUnavailable,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for GLWindowError {
    type GlibType = ffi::GstGLWindowError;

    fn into_glib(self) -> ffi::GstGLWindowError {
        match self {
            Self::Failed => ffi::GST_GL_WINDOW_ERROR_FAILED,
            Self::OldLibs => ffi::GST_GL_WINDOW_ERROR_OLD_LIBS,
            Self::ResourceUnavailable => ffi::GST_GL_WINDOW_ERROR_RESOURCE_UNAVAILABLE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstGLWindowError> for GLWindowError {
    unsafe fn from_glib(value: ffi::GstGLWindowError) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_GL_WINDOW_ERROR_FAILED => Self::Failed,
            ffi::GST_GL_WINDOW_ERROR_OLD_LIBS => Self::OldLibs,
            ffi::GST_GL_WINDOW_ERROR_RESOURCE_UNAVAILABLE => Self::ResourceUnavailable,
            value => Self::__Unknown(value),
        }
    }
}

impl ErrorDomain for GLWindowError {
    fn domain() -> Quark {
        skip_assert_initialized!();

        unsafe { from_glib(ffi::gst_gl_window_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            ffi::GST_GL_WINDOW_ERROR_FAILED => Some(Self::Failed),
            ffi::GST_GL_WINDOW_ERROR_OLD_LIBS => Some(Self::OldLibs),
            ffi::GST_GL_WINDOW_ERROR_RESOURCE_UNAVAILABLE => Some(Self::ResourceUnavailable),
            _ => Some(Self::Failed),
        }
    }
}

impl StaticType for GLWindowError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_gl_window_error_get_type()) }
    }
}

impl glib::value::ValueType for GLWindowError {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for GLWindowError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for GLWindowError {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}
