// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

use crate::Extractable;
use crate::MetaContainer;
use crate::Operation;
use crate::TimelineElement;
use crate::TrackElement;
use crate::Transition;
use crate::VideoStandardTransitionType;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "GESVideoTransition")]
    pub struct VideoTransition(Object<ffi::GESVideoTransition, ffi::GESVideoTransitionClass>) @extends Transition, Operation, TrackElement, TimelineElement, @implements Extractable, MetaContainer;

    match fn {
        type_ => || ffi::ges_video_transition_get_type(),
    }
}

impl VideoTransition {
    pub const NONE: Option<&'static VideoTransition> = None;

    #[doc(alias = "ges_video_transition_new")]
    pub fn new() -> VideoTransition {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::ges_video_transition_new()) }
    }
}

impl Default for VideoTransition {
    fn default() -> Self {
        Self::new()
    }
}

pub trait VideoTransitionExt: 'static {
    #[cfg_attr(feature = "v1_20", deprecated = "Since 1.20")]
    #[doc(alias = "ges_video_transition_get_border")]
    #[doc(alias = "get_border")]
    fn border(&self) -> i32;

    #[doc(alias = "ges_video_transition_get_transition_type")]
    #[doc(alias = "get_transition_type")]
    fn transition_type(&self) -> VideoStandardTransitionType;

    #[cfg_attr(feature = "v1_20", deprecated = "Since 1.20")]
    #[doc(alias = "ges_video_transition_is_inverted")]
    fn is_inverted(&self) -> bool;

    #[cfg_attr(feature = "v1_20", deprecated = "Since 1.20")]
    #[doc(alias = "ges_video_transition_set_border")]
    fn set_border(&self, value: u32);

    #[cfg_attr(feature = "v1_20", deprecated = "Since 1.20")]
    #[doc(alias = "ges_video_transition_set_inverted")]
    fn set_inverted(&self, inverted: bool);

    #[doc(alias = "ges_video_transition_set_transition_type")]
    fn set_transition_type(&self, type_: VideoStandardTransitionType) -> bool;

    #[cfg_attr(feature = "v1_20", deprecated = "Since 1.20")]
    fn inverts(&self) -> bool;

    #[cfg_attr(feature = "v1_20", deprecated = "Since 1.20")]
    fn set_invert(&self, invert: bool);

    #[doc(alias = "border")]
    fn connect_border_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg_attr(feature = "v1_20", deprecated = "Since 1.20")]
    #[doc(alias = "invert")]
    fn connect_invert_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "transition-type")]
    fn connect_transition_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<VideoTransition>> VideoTransitionExt for O {
    fn border(&self) -> i32 {
        unsafe { ffi::ges_video_transition_get_border(self.as_ref().to_glib_none().0) }
    }

    fn transition_type(&self) -> VideoStandardTransitionType {
        unsafe {
            from_glib(ffi::ges_video_transition_get_transition_type(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_inverted(&self) -> bool {
        unsafe {
            from_glib(ffi::ges_video_transition_is_inverted(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn set_border(&self, value: u32) {
        unsafe {
            ffi::ges_video_transition_set_border(self.as_ref().to_glib_none().0, value);
        }
    }

    fn set_inverted(&self, inverted: bool) {
        unsafe {
            ffi::ges_video_transition_set_inverted(
                self.as_ref().to_glib_none().0,
                inverted.into_glib(),
            );
        }
    }

    fn set_transition_type(&self, type_: VideoStandardTransitionType) -> bool {
        unsafe {
            from_glib(ffi::ges_video_transition_set_transition_type(
                self.as_ref().to_glib_none().0,
                type_.into_glib(),
            ))
        }
    }

    fn inverts(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "invert")
    }

    fn set_invert(&self, invert: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "invert", &invert)
    }

    fn connect_border_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_border_trampoline<
            P: IsA<VideoTransition>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GESVideoTransition,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(VideoTransition::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::border\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_border_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_invert_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_invert_trampoline<
            P: IsA<VideoTransition>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GESVideoTransition,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(VideoTransition::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::invert\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_invert_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_transition_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_transition_type_trampoline<
            P: IsA<VideoTransition>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GESVideoTransition,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(VideoTransition::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::transition-type\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_transition_type_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}
