// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

use glib::translate::*;
use glib::value::FromValue;
use glib::value::ToValue;
use glib::StaticType;
use glib::Type;
#[cfg(any(feature = "v1_16", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_16")))]
use std::ffi::CStr;
#[cfg(any(feature = "v1_16", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_16")))]
use std::fmt;

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GESEdge")]
pub enum Edge {
    #[doc(alias = "GES_EDGE_START")]
    Start,
    #[doc(alias = "GES_EDGE_END")]
    End,
    #[doc(alias = "GES_EDGE_NONE")]
    None,
    #[doc(hidden)]
    __Unknown(i32),
}

impl Edge {
    #[cfg(any(feature = "v1_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_16")))]
    pub fn name<'a>(self) -> &'a str {
        unsafe {
            CStr::from_ptr(
                ffi::ges_edge_name(self.into_glib())
                    .as_ref()
                    .expect("ges_edge_name returned NULL"),
            )
            .to_str()
            .expect("ges_edge_name returned an invalid string")
        }
    }
}

#[cfg(any(feature = "v1_16", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_16")))]
impl fmt::Display for Edge {
    #[inline]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str(&self.name())
    }
}

#[doc(hidden)]
impl IntoGlib for Edge {
    type GlibType = ffi::GESEdge;

    fn into_glib(self) -> ffi::GESEdge {
        match self {
            Self::Start => ffi::GES_EDGE_START,
            Self::End => ffi::GES_EDGE_END,
            Self::None => ffi::GES_EDGE_NONE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GESEdge> for Edge {
    unsafe fn from_glib(value: ffi::GESEdge) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GES_EDGE_START => Self::Start,
            ffi::GES_EDGE_END => Self::End,
            ffi::GES_EDGE_NONE => Self::None,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for Edge {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::ges_edge_get_type()) }
    }
}

impl glib::value::ValueType for Edge {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for Edge {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for Edge {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GESEditMode")]
pub enum EditMode {
    #[doc(alias = "GES_EDIT_MODE_NORMAL")]
    Normal,
    #[doc(alias = "GES_EDIT_MODE_RIPPLE")]
    Ripple,
    #[doc(alias = "GES_EDIT_MODE_ROLL")]
    Roll,
    #[doc(alias = "GES_EDIT_MODE_TRIM")]
    Trim,
    #[doc(alias = "GES_EDIT_MODE_SLIDE")]
    Slide,
    #[doc(hidden)]
    __Unknown(i32),
}

impl EditMode {
    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    pub fn name<'a>(self) -> &'a str {
        unsafe {
            CStr::from_ptr(
                ffi::ges_edit_mode_name(self.into_glib())
                    .as_ref()
                    .expect("ges_edit_mode_name returned NULL"),
            )
            .to_str()
            .expect("ges_edit_mode_name returned an invalid string")
        }
    }
}

#[cfg(any(feature = "v1_18", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
impl fmt::Display for EditMode {
    #[inline]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str(&self.name())
    }
}

#[doc(hidden)]
impl IntoGlib for EditMode {
    type GlibType = ffi::GESEditMode;

    fn into_glib(self) -> ffi::GESEditMode {
        match self {
            Self::Normal => ffi::GES_EDIT_MODE_NORMAL,
            Self::Ripple => ffi::GES_EDIT_MODE_RIPPLE,
            Self::Roll => ffi::GES_EDIT_MODE_ROLL,
            Self::Trim => ffi::GES_EDIT_MODE_TRIM,
            Self::Slide => ffi::GES_EDIT_MODE_SLIDE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GESEditMode> for EditMode {
    unsafe fn from_glib(value: ffi::GESEditMode) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GES_EDIT_MODE_NORMAL => Self::Normal,
            ffi::GES_EDIT_MODE_RIPPLE => Self::Ripple,
            ffi::GES_EDIT_MODE_ROLL => Self::Roll,
            ffi::GES_EDIT_MODE_TRIM => Self::Trim,
            ffi::GES_EDIT_MODE_SLIDE => Self::Slide,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for EditMode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::ges_edit_mode_get_type()) }
    }
}

impl glib::value::ValueType for EditMode {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for EditMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for EditMode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GESVideoStandardTransitionType")]
pub enum VideoStandardTransitionType {
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_NONE")]
    None,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BAR_WIPE_LR")]
    BarWipeLr,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BAR_WIPE_TB")]
    BarWipeTb,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_TL")]
    BoxWipeTl,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_TR")]
    BoxWipeTr,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_BR")]
    BoxWipeBr,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_BL")]
    BoxWipeBl,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_FOUR_BOX_WIPE_CI")]
    FourBoxWipeCi,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_FOUR_BOX_WIPE_CO")]
    FourBoxWipeCo,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNDOOR_V")]
    BarndoorV,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNDOOR_H")]
    BarndoorH,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_TC")]
    BoxWipeTc,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_RC")]
    BoxWipeRc,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_BC")]
    BoxWipeBc,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_LC")]
    BoxWipeLc,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_DIAGONAL_TL")]
    DiagonalTl,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_DIAGONAL_TR")]
    DiagonalTr,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BOWTIE_V")]
    BowtieV,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BOWTIE_H")]
    BowtieH,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNDOOR_DBL")]
    BarndoorDbl,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNDOOR_DTL")]
    BarndoorDtl,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_MISC_DIAGONAL_DBD")]
    MiscDiagonalDbd,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_MISC_DIAGONAL_DD")]
    MiscDiagonalDd,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_VEE_D")]
    VeeD,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_VEE_L")]
    VeeL,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_VEE_U")]
    VeeU,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_VEE_R")]
    VeeR,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNVEE_D")]
    BarnveeD,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNVEE_L")]
    BarnveeL,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNVEE_U")]
    BarnveeU,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNVEE_R")]
    BarnveeR,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_IRIS_RECT")]
    IrisRect,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_CLOCK_CW12")]
    ClockCw12,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_CLOCK_CW3")]
    ClockCw3,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_CLOCK_CW6")]
    ClockCw6,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_CLOCK_CW9")]
    ClockCw9,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_PINWHEEL_TBV")]
    PinwheelTbv,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_PINWHEEL_TBH")]
    PinwheelTbh,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_PINWHEEL_FB")]
    PinwheelFb,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_CT")]
    FanCt,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_CR")]
    FanCr,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLEFAN_FOV")]
    DoublefanFov,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLEFAN_FOH")]
    DoublefanFoh,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWT")]
    SinglesweepCwt,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWR")]
    SinglesweepCwr,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWB")]
    SinglesweepCwb,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWL")]
    SinglesweepCwl,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_PV")]
    DoublesweepPv,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_PD")]
    DoublesweepPd,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_OV")]
    DoublesweepOv,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_OH")]
    DoublesweepOh,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_T")]
    FanT,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_R")]
    FanR,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_B")]
    FanB,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_L")]
    FanL,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLEFAN_FIV")]
    DoublefanFiv,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLEFAN_FIH")]
    DoublefanFih,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWTL")]
    SinglesweepCwtl,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWBL")]
    SinglesweepCwbl,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWBR")]
    SinglesweepCwbr,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWTR")]
    SinglesweepCwtr,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_PDTL")]
    DoublesweepPdtl,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_PDBL")]
    DoublesweepPdbl,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_SALOONDOOR_T")]
    SaloondoorT,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_SALOONDOOR_L")]
    SaloondoorL,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_SALOONDOOR_B")]
    SaloondoorB,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_SALOONDOOR_R")]
    SaloondoorR,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_WINDSHIELD_R")]
    WindshieldR,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_WINDSHIELD_U")]
    WindshieldU,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_WINDSHIELD_V")]
    WindshieldV,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_WINDSHIELD_H")]
    WindshieldH,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_CROSSFADE")]
    Crossfade,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for VideoStandardTransitionType {
    type GlibType = ffi::GESVideoStandardTransitionType;

    fn into_glib(self) -> ffi::GESVideoStandardTransitionType {
        match self {
            Self::None => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_NONE,
            Self::BarWipeLr => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BAR_WIPE_LR,
            Self::BarWipeTb => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BAR_WIPE_TB,
            Self::BoxWipeTl => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_TL,
            Self::BoxWipeTr => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_TR,
            Self::BoxWipeBr => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_BR,
            Self::BoxWipeBl => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_BL,
            Self::FourBoxWipeCi => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FOUR_BOX_WIPE_CI,
            Self::FourBoxWipeCo => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FOUR_BOX_WIPE_CO,
            Self::BarndoorV => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNDOOR_V,
            Self::BarndoorH => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNDOOR_H,
            Self::BoxWipeTc => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_TC,
            Self::BoxWipeRc => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_RC,
            Self::BoxWipeBc => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_BC,
            Self::BoxWipeLc => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_LC,
            Self::DiagonalTl => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DIAGONAL_TL,
            Self::DiagonalTr => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DIAGONAL_TR,
            Self::BowtieV => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOWTIE_V,
            Self::BowtieH => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOWTIE_H,
            Self::BarndoorDbl => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNDOOR_DBL,
            Self::BarndoorDtl => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNDOOR_DTL,
            Self::MiscDiagonalDbd => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_MISC_DIAGONAL_DBD,
            Self::MiscDiagonalDd => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_MISC_DIAGONAL_DD,
            Self::VeeD => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_VEE_D,
            Self::VeeL => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_VEE_L,
            Self::VeeU => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_VEE_U,
            Self::VeeR => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_VEE_R,
            Self::BarnveeD => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNVEE_D,
            Self::BarnveeL => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNVEE_L,
            Self::BarnveeU => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNVEE_U,
            Self::BarnveeR => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNVEE_R,
            Self::IrisRect => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_IRIS_RECT,
            Self::ClockCw12 => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_CLOCK_CW12,
            Self::ClockCw3 => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_CLOCK_CW3,
            Self::ClockCw6 => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_CLOCK_CW6,
            Self::ClockCw9 => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_CLOCK_CW9,
            Self::PinwheelTbv => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_PINWHEEL_TBV,
            Self::PinwheelTbh => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_PINWHEEL_TBH,
            Self::PinwheelFb => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_PINWHEEL_FB,
            Self::FanCt => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_CT,
            Self::FanCr => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_CR,
            Self::DoublefanFov => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLEFAN_FOV,
            Self::DoublefanFoh => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLEFAN_FOH,
            Self::SinglesweepCwt => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWT,
            Self::SinglesweepCwr => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWR,
            Self::SinglesweepCwb => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWB,
            Self::SinglesweepCwl => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWL,
            Self::DoublesweepPv => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_PV,
            Self::DoublesweepPd => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_PD,
            Self::DoublesweepOv => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_OV,
            Self::DoublesweepOh => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_OH,
            Self::FanT => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_T,
            Self::FanR => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_R,
            Self::FanB => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_B,
            Self::FanL => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_L,
            Self::DoublefanFiv => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLEFAN_FIV,
            Self::DoublefanFih => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLEFAN_FIH,
            Self::SinglesweepCwtl => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWTL,
            Self::SinglesweepCwbl => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWBL,
            Self::SinglesweepCwbr => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWBR,
            Self::SinglesweepCwtr => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWTR,
            Self::DoublesweepPdtl => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_PDTL,
            Self::DoublesweepPdbl => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_PDBL,
            Self::SaloondoorT => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SALOONDOOR_T,
            Self::SaloondoorL => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SALOONDOOR_L,
            Self::SaloondoorB => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SALOONDOOR_B,
            Self::SaloondoorR => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SALOONDOOR_R,
            Self::WindshieldR => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_WINDSHIELD_R,
            Self::WindshieldU => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_WINDSHIELD_U,
            Self::WindshieldV => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_WINDSHIELD_V,
            Self::WindshieldH => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_WINDSHIELD_H,
            Self::Crossfade => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_CROSSFADE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GESVideoStandardTransitionType> for VideoStandardTransitionType {
    unsafe fn from_glib(value: ffi::GESVideoStandardTransitionType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_NONE => Self::None,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BAR_WIPE_LR => Self::BarWipeLr,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BAR_WIPE_TB => Self::BarWipeTb,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_TL => Self::BoxWipeTl,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_TR => Self::BoxWipeTr,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_BR => Self::BoxWipeBr,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_BL => Self::BoxWipeBl,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FOUR_BOX_WIPE_CI => Self::FourBoxWipeCi,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FOUR_BOX_WIPE_CO => Self::FourBoxWipeCo,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNDOOR_V => Self::BarndoorV,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNDOOR_H => Self::BarndoorH,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_TC => Self::BoxWipeTc,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_RC => Self::BoxWipeRc,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_BC => Self::BoxWipeBc,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_LC => Self::BoxWipeLc,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DIAGONAL_TL => Self::DiagonalTl,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DIAGONAL_TR => Self::DiagonalTr,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOWTIE_V => Self::BowtieV,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOWTIE_H => Self::BowtieH,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNDOOR_DBL => Self::BarndoorDbl,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNDOOR_DTL => Self::BarndoorDtl,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_MISC_DIAGONAL_DBD => Self::MiscDiagonalDbd,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_MISC_DIAGONAL_DD => Self::MiscDiagonalDd,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_VEE_D => Self::VeeD,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_VEE_L => Self::VeeL,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_VEE_U => Self::VeeU,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_VEE_R => Self::VeeR,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNVEE_D => Self::BarnveeD,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNVEE_L => Self::BarnveeL,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNVEE_U => Self::BarnveeU,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNVEE_R => Self::BarnveeR,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_IRIS_RECT => Self::IrisRect,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_CLOCK_CW12 => Self::ClockCw12,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_CLOCK_CW3 => Self::ClockCw3,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_CLOCK_CW6 => Self::ClockCw6,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_CLOCK_CW9 => Self::ClockCw9,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_PINWHEEL_TBV => Self::PinwheelTbv,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_PINWHEEL_TBH => Self::PinwheelTbh,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_PINWHEEL_FB => Self::PinwheelFb,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_CT => Self::FanCt,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_CR => Self::FanCr,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLEFAN_FOV => Self::DoublefanFov,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLEFAN_FOH => Self::DoublefanFoh,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWT => Self::SinglesweepCwt,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWR => Self::SinglesweepCwr,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWB => Self::SinglesweepCwb,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWL => Self::SinglesweepCwl,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_PV => Self::DoublesweepPv,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_PD => Self::DoublesweepPd,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_OV => Self::DoublesweepOv,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_OH => Self::DoublesweepOh,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_T => Self::FanT,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_R => Self::FanR,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_B => Self::FanB,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_L => Self::FanL,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLEFAN_FIV => Self::DoublefanFiv,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLEFAN_FIH => Self::DoublefanFih,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWTL => Self::SinglesweepCwtl,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWBL => Self::SinglesweepCwbl,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWBR => Self::SinglesweepCwbr,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWTR => Self::SinglesweepCwtr,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_PDTL => Self::DoublesweepPdtl,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_PDBL => Self::DoublesweepPdbl,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SALOONDOOR_T => Self::SaloondoorT,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SALOONDOOR_L => Self::SaloondoorL,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SALOONDOOR_B => Self::SaloondoorB,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SALOONDOOR_R => Self::SaloondoorR,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_WINDSHIELD_R => Self::WindshieldR,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_WINDSHIELD_U => Self::WindshieldU,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_WINDSHIELD_V => Self::WindshieldV,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_WINDSHIELD_H => Self::WindshieldH,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_CROSSFADE => Self::Crossfade,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for VideoStandardTransitionType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::ges_video_standard_transition_type_get_type()) }
    }
}

impl glib::value::ValueType for VideoStandardTransitionType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for VideoStandardTransitionType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for VideoStandardTransitionType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}
