#[cfg(feature = "libadwaita")]
use libadwaita as adw;

/// Sending Actions from GTK widgets via dispatch() performs some checks for
/// prohibiting internal update loops.
#[cfg(feature = "gtk")]
pub trait DispatchWidget: glib::IsA<gtk::Widget> {
    fn dispatch(&self, action: &str, argument: Option<&dyn glib::ToVariant>) {
        crate::check_internal!(self);
        if let Err(e) = gtk::prelude::WidgetExt::activate_action(
            self,
            &format!("app.{}", action),
            argument.map(|a| a.to_variant()).as_ref(),
        ) {
            error!("Dispatch action '{}': {}", action, e.to_string());
        }
    }
}

#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::AppChooser {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::AppChooserButton {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::ApplicationWindow {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::Box {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::Button {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::Calendar {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::CenterBox {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::ColorButton {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::ComboBox {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::Dialog {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::DragIcon {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::DrawingArea {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::DropDown {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::Editable {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::EmojiChooser {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::Entry {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::Expander {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::Fixed {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::FlowBox {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::FontButton {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::Frame {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::Grid {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::GridView {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::HeaderBar {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::IconView {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::Image {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::InfoBar {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::Label {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::LevelBar {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::LinkButton {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::ListBox {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::ListBoxRow {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::LockButton {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::MenuButton {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::MessageDialog {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::Notebook {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::PasswordEntry {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::Popover {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::PopoverMenu {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::Revealer {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::ScrolledWindow {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::SearchBar {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::SearchEntry {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::SpinButton {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::Spinner {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::Stack {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::StackSidebar {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::StackSwitcher {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::Statusbar {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::Switch {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::Text {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::ToggleButton {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::Widget {}
#[cfg(feature = "gtk")]
impl DispatchWidget for gtk::Window {}

#[cfg(feature = "libadwaita")]
impl DispatchWidget for adw::ActionRow {}
#[cfg(feature = "libadwaita")]
impl DispatchWidget for adw::Carousel {}
#[cfg(feature = "libadwaita")]
impl DispatchWidget for adw::Clamp {}
#[cfg(feature = "libadwaita")]
impl DispatchWidget for adw::ComboRow {}
#[cfg(feature = "libadwaita")]
impl DispatchWidget for adw::ExpanderRow {}
#[cfg(feature = "libadwaita")]
impl DispatchWidget for adw::Flap {}
#[cfg(feature = "libadwaita")]
impl DispatchWidget for adw::HeaderBar {}
#[cfg(feature = "libadwaita")]
impl DispatchWidget for adw::Leaflet {}
#[cfg(feature = "libadwaita")]
impl DispatchWidget for adw::PreferencesGroup {}
#[cfg(feature = "libadwaita")]
impl DispatchWidget for adw::PreferencesRow {}
#[cfg(feature = "libadwaita")]
impl DispatchWidget for adw::SplitButton {}
#[cfg(feature = "libadwaita")]
impl DispatchWidget for adw::Squeezer {}
#[cfg(feature = "libadwaita")]
impl DispatchWidget for adw::Swipeable {}
#[cfg(feature = "libadwaita")]
impl DispatchWidget for adw::TabBar {}
#[cfg(feature = "libadwaita")]
impl DispatchWidget for adw::ViewStack {}
#[cfg(feature = "libadwaita")]
impl DispatchWidget for adw::ViewSwitcher {}
#[cfg(feature = "libadwaita")]
impl DispatchWidget for adw::ViewSwitcherBar {}
