use glib::ObjectExt;
use libadwaita as adw;

/// Sending Actions from GTK widgets via dispatch() performs some checks for
/// prohibiting internal update loops.
pub trait DispatchWidget: glib::IsA<gtk::Widget> {
    fn dispatch(&self, action: &str, argument: Option<&dyn glib::ToVariant>) {
        crate::check_internal!(self);
        gtk::prelude::WidgetExt::activate_action(
            self,
            &format!("app.{}", action),
            argument.map(|a| a.to_variant()).as_ref(),
        );
    }
}

impl DispatchWidget for gtk::AppChooser {}
impl DispatchWidget for gtk::AppChooserButton {}
impl DispatchWidget for gtk::ApplicationWindow {}
impl DispatchWidget for gtk::Box {}
impl DispatchWidget for gtk::Button {}
impl DispatchWidget for gtk::Calendar {}
impl DispatchWidget for gtk::CenterBox {}
impl DispatchWidget for gtk::ColorButton {}
impl DispatchWidget for gtk::ComboBox {}
impl DispatchWidget for gtk::Dialog {}
impl DispatchWidget for gtk::DragIcon {}
impl DispatchWidget for gtk::DrawingArea {}
impl DispatchWidget for gtk::DropDown {}
impl DispatchWidget for gtk::Editable {}
impl DispatchWidget for gtk::EmojiChooser {}
impl DispatchWidget for gtk::Entry {}
impl DispatchWidget for gtk::Expander {}
impl DispatchWidget for gtk::Fixed {}
impl DispatchWidget for gtk::FlowBox {}
impl DispatchWidget for gtk::FontButton {}
impl DispatchWidget for gtk::Frame {}
impl DispatchWidget for gtk::Grid {}
impl DispatchWidget for gtk::GridView {}
impl DispatchWidget for gtk::HeaderBar {}
impl DispatchWidget for gtk::IconView {}
impl DispatchWidget for gtk::Image {}
impl DispatchWidget for gtk::InfoBar {}
impl DispatchWidget for gtk::Label {}
impl DispatchWidget for gtk::LevelBar {}
impl DispatchWidget for gtk::LinkButton {}
impl DispatchWidget for gtk::ListBox {}
impl DispatchWidget for gtk::ListBoxRow {}
impl DispatchWidget for gtk::LockButton {}
impl DispatchWidget for gtk::MenuButton {}
impl DispatchWidget for gtk::MessageDialog {}
impl DispatchWidget for gtk::Notebook {}
impl DispatchWidget for gtk::PasswordEntry {}
impl DispatchWidget for gtk::Popover {}
impl DispatchWidget for gtk::PopoverMenu {}
impl DispatchWidget for gtk::Revealer {}
impl DispatchWidget for gtk::ScrolledWindow {}
impl DispatchWidget for gtk::SearchBar {}
impl DispatchWidget for gtk::SearchEntry {}
impl DispatchWidget for gtk::SpinButton {}
impl DispatchWidget for gtk::Spinner {}
impl DispatchWidget for gtk::Stack {}
impl DispatchWidget for gtk::StackSidebar {}
impl DispatchWidget for gtk::StackSwitcher {}
impl DispatchWidget for gtk::Statusbar {}
impl DispatchWidget for gtk::Switch {}
impl DispatchWidget for gtk::Text {}
impl DispatchWidget for gtk::ToggleButton {}
impl DispatchWidget for gtk::Widget {}
impl DispatchWidget for gtk::Window {}

impl DispatchWidget for adw::ActionRow {}
impl DispatchWidget for adw::Carousel {}
impl DispatchWidget for adw::Clamp {}
impl DispatchWidget for adw::ComboRow {}
impl DispatchWidget for adw::ExpanderRow {}
impl DispatchWidget for adw::Flap {}
impl DispatchWidget for adw::HeaderBar {}
impl DispatchWidget for adw::Leaflet {}
impl DispatchWidget for adw::PreferencesGroup {}
impl DispatchWidget for adw::PreferencesRow {}
impl DispatchWidget for adw::SplitButton {}
impl DispatchWidget for adw::Squeezer {}
impl DispatchWidget for adw::Swipeable {}
impl DispatchWidget for adw::TabBar {}
impl DispatchWidget for adw::ViewStack {}
impl DispatchWidget for adw::ViewSwitcher {}
impl DispatchWidget for adw::ViewSwitcherBar {}
