// SPDX-License-Identifier: GPL-3.0-or-later

pub(crate) const PERF_ENV_VAR: &str = "GSTORE_PERF";

#[macro_export]
macro_rules! print_perf {
    (
        $expr:expr;
        $message:expr
    ) => {
        if let Ok(_s) = std::env::var(crate::utils::PERF_ENV_VAR) {
            let t0 = std::time::Instant::now();
            $expr;
            let d = std::time::Instant::now().duration_since(t0);
            println!("[gstore] [{:06} μs]: {}", d.as_micros(), $message);
        } else {
            $expr;
        }
    };
}
