/// This code is unsafe! GTK allows to store data on widgets. This is useful sometimes but since GTK is written
/// in C, setting data to widgets is not safe. This widgets needs more work to address this is or should be
/// implemented differently.
#[macro_export]
macro_rules! state {
    (
        $(
            $widget:ident[$field:expr]: $t:ty = $init:expr;
        )*
    ) => {
        $(

        let widget_name = stringify!($widget);

        let widget = &$widget;
        unsafe {widget.set_data::<$t>($field, $init);}
        let (sender, receiver) = glib::MainContext::channel::<$t>(glib::PRIORITY_DEFAULT);

        unsafe {
            widget.set_data::<glib::Sender<$t>>(&format!("{}.sender", $field), sender);
            widget.set_data::<Vec<glib::Sender<$t>>>(&format!("{}.delegators", $field), Vec::new());
        }

        receiver.attach(None, glib::clone!(@weak widget => @default-return glib::Continue(true), move |value| {
            if let Some(delegators) = unsafe {widget
                .data::<Vec<glib::Sender<$t>>>(&format!("{}.delegators", $field))
                .map(|p| p.as_ptr() as *const Vec<glib::Sender<$t>>)
                .map(|p| p.as_ref())
                .flatten()}
            {
                for sender in delegators {
                    sender.send(value.clone())
                        .expect(&format!("Could not send local state update of state {}[\"{}.delegators\"].", widget_name, $field));
                }
            } else {
                error!("Could not read {}[\"{}.delegators\"]", widget_name, $field);
            }
            glib::Continue(true)
        }));

        )*
    }
}

/// This code is unsafe! GTK allows to store data on widgets. This is useful sometimes but since GTK is written
/// in C, setting data to widgets is not safe. This widgets needs more work to address this is or should be
/// implemented differently.
#[macro_export]
macro_rules! update_state {
    (
        $view:ident[$field:expr] => $variable:ident: $t:ty => $handler:expr
    ) => {
        unsafe {
            if let (Some($variable), Some(_sender)) = (
                $view
                    .data::<$t>($field)
                    .map(|p| p.as_ptr() as *mut $t)
                    .map(|p| p.as_mut())
                    .flatten(),
                $view
                    .data::<glib::Sender<$t>>(&format!("{}.sender", $field))
                    .map(|p| p.as_ptr() as *const glib::Sender<$t>)
                    .map(|p| p.as_ref())
                    .flatten(),
            ) {
                $handler;
                _sender
                    .send($variable.clone())
                    .expect("Could not send update of local state.");
            }
        }
    };
}

/// This code is unsafe! GTK allows to store data on widgets. This is useful sometimes but since GTK is written
/// in C, setting data to widgets is not safe. This widgets needs more work to address this is or should be
/// implemented differently.
#[macro_export]
macro_rules! get_state {
    (
        $view:ident[$field:expr]: $t:ty
    ) => {
        unsafe {
            if let Some(v) = $view
                .data($field)
                .map(|p| p.as_ptr() as *const $t)
                .map(|p| p.as_ref())
                .flatten()
            {
                Some(v)
            } else {
                None
            }
        }
    };
}

/// This code is unsafe! GTK allows to store data on widgets. This is useful sometimes but since GTK is written
/// in C, setting data to widgets is not safe. This widgets needs more work to address this is or should be
/// implemented differently.
#[macro_export]
macro_rules! on_state_update {
    (
        $view:ident[$field:expr]: $t:ty => $callback:expr
    ) => {
        unsafe {
            let (sender, receiver) = glib::MainContext::channel::<$t>(glib::PRIORITY_DEFAULT);
            if let Some(delegators) = $view
                .data::<Vec<glib::Sender<$t>>>(&format!("{}.delegators", $field))
                .map(|p| p.as_ptr() as *mut Vec<glib::Sender<$t>>)
                .map(|p| p.as_mut())
                .flatten()
            {
                delegators.push(sender);
                receiver.attach(None, $callback);
            } else {
                error!(
                    "Could not attach on_state_update for {0}[\"{1}\"]. No delegators on widget {0}.",
                    stringify!($view),
                    $field
                );
            }
        }
    };
}
