/// Abstract GTK widget basis macro.
///
/// All widget macros utilize this macro to generate required code.
/// The widget macro defines how widgets are defined:
/// ```text
/// widget! {
///     class <a css class string literal>
///     properties <optional the 'keyword' stateful to listen to a locally defined state (see use_state)> {
///         <gtk widget property>: <property value expression>
///         ...
///     }
///     connections {
///         <(store) if the store may be used in the following closure> <connector name>: <closure to call for the signal of the connector>
///         ...
///     }
///     children [
///         <any child expression like another widget macro or a component function>
///     ]
/// }
/// ```
#[macro_export]
macro_rules! widget {
    (
        $widget:ident: $wt:path {
            $(class $class:literal)?
            $(properties $($stateful:ident)? {
                $( $prop:ident: $value:expr )*
            })?
            $(connections {
                $(
                    $( ($store:ident) )? $connector:ident: $connection:expr
                )*
            })?
            $(children [
                $($child:expr)*
            ])?
        }
    ) => {{
        // add children
        $($(
            $widget.add(&$child);
        )*)?

        // set properties
        $(
        {
            let render = |w: $wt| {
                $(
                match w.set_property(stringify!($prop), &$value) {
                    Err(e) => panic!("Could not set widget property {:?}", e),
                    _ => {},
                }
                )*
            };
            render($widget.clone());
            $(
            let w = $widget.clone();
            $stateful(move || {
                render(w.clone())
            });
            )?
        }
        )?

        // css class
        $($widget.get_style_context().add_class($class);)?

        // connections
        $($(
            {
                $(let $store = $store.clone();)?
                $widget.$connector($connection);
            }
        )*)?
    }}
}
