/// gstore macro for the GTK HeaderBar.
///
/// ## See Also
/// - [widget Macro](macro.widget.html)
/// - [HeaderBarBuilder in gtk-rs](https://gtk-rs.org/docs/gtk/struct.HeaderBarBuilder.html)
/// - [HeaderBar in gtk-rs](https://gtk-rs.org/docs/gtk/struct.HeaderBar.html)
///
/// ## Examples
/// ```rust,no_run
/// # #[macro_use]
/// # extern crate gstore;
/// # use gstore::prelude::*;
/// # use gtk::prelude::*;
/// #
/// # fn main() {
/// header_bar! {
///     properties {
///         title: "Test Application"
///     }
///     children [
///         button! {
///             children [
///                 image!("format-justify-fill-symbolic", gtk::IconSize::Button)
///             ]
///         }
///     ]
/// };
/// # }
/// ```
#[macro_export]
macro_rules! header_bar {
    (
        titled $title:expr
    ) => {{
        let header_bar = gtk::HeaderBarBuilder::new()
            .visible(true)
            .title($title)
            .show_close_button(true)
            .build();
        header_bar
    }};
    (
        $($text:tt)*
    ) => {{
        let bar = gtk::HeaderBarBuilder::new().visible(true).build();

        widget!(bar: gtk::HeaderBar { $($text)* });

        bar
    }}
}
