/// Creates a GTK button.
///
/// # See Also
/// - [widget Macro](macro.widget.html)
/// - [ButtonBuilder in gtk-rs](https://gtk-rs.org/docs/gtk/struct.ButtonBuilder.html)
/// - [Button in gtk-rs](https://gtk-rs.org/docs/gtk/struct.Button.html)
///
/// # Examples
///
/// Long example:
/// ```rust,no_run
/// # #[macro_use]
/// # extern crate gstore;
/// # use gstore::prelude::*;
/// # use gtk::prelude::*;
/// # slice! { CountState { count: i64 = 0 } CountAction { Clicked } }
/// # fn reduce_count(action: CountAction, state: CountState) -> CountState { state }
/// # store! { count: Count = crate::{CountState, CountAction, reduce_count} }
/// # fn main() {
/// #    let store = Store::new(|a,s| s, vec![]);
/// button! {
///     properties {
///         label: "Click Me!"
///         halign: gtk::Align::Center
///         valign: gtk::Align::Center
///     }
///     connections {
///        (store) connect_clicked: move |_| store.dispatch(Action::Count(CountAction::Clicked))
///     }
///     children [
///         image!("list-add-symbolic", gtk::IconSize::Button)
///     ]
/// };
/// # }
/// ```
#[macro_export]
macro_rules! button {
    (
        $($text:tt)*
    ) => {{
        let widget = gtk::ButtonBuilder::new().visible(true).build();
        widget!(widget: gtk::Button { $($text)* });
        widget
    }}
}
