/// gstore macro for the libhandy TitleBar
///
/// ## See Also
/// - [widget Macro](macro.widget.html)
/// - [TitleBarBuilder in libhandy-rs](https://world.pages.gitlab.gnome.org/Rust/libhandy-rs/libhandy/struct.TitleBarBuilder.html)
/// - [TitleBar in libhandy-rs](https://world.pages.gitlab.gnome.org/Rust/libhandy-rs/libhandy/struct.TitleBar.html)
///
/// ## Examples
/// TODO: compile this as soon as docs.rs can handle libhandy
/// ```text
/// # #[macro_use]
/// # extern crate gstore;
/// # use gstore::prelude::*;
/// # use gtk::prelude::*;
/// #
/// # fn main() {
/// title_bar! {
///     children [
///         header_bar! {
///             properties {
///                 title: "Test Application"
///             }
///             children [
///                 button! {
///                     children [
///                         image!("format-justify-fill-symbolic", gtk::IconSize::Button)
///                     ]
///                 }
///             ]
///         }
///     ]
/// };
/// # }
/// ```
#[macro_export]
macro_rules! title_bar {
    (
        $($text:tt)*
    ) => {{
        let widget = libhandy::TitleBarBuilder::new().visible(true).build();
        widget!(widget: libhandy::TitleBar { $($text)* });
        widget
    }}
}
