/// gstore macro for the GTK Switch
///
/// ## See Also
/// - [widget Macro](macro.widget.html)
/// - [SwitchBuilder in gtk-rs](https://gtk-rs.org/docs/gtk/struct.SwitchBuilder.html)
/// - [Switch in gtk-rs](https://gtk-rs.org/docs/gtk/struct.Switch.html)
///
/// ## Examples
/// ```rust,no_run
/// # #[macro_use]
/// # extern crate gstore;
/// # use gstore::prelude::*;
/// # use gtk::prelude::*;
/// #
/// # fn main() {
/// switch! {
///     properties {
///         active: true
///     }
/// };
/// # }
/// ```
#[macro_export]
macro_rules! switch {
    (
        $($text:tt)*
    ) => {{
        let widget = gtk::SwitchBuilder::new().visible(true).build();
        widget!(widget: gtk::Switch { $($text)* });
        widget
    }}
}
