/// gstore macro for the GTK ListBox.
///
///
/// ## See Also
/// - [widget Macro](macro.widget.html)
/// - [ListBoxBuilder in gtk-rs](https://gtk-rs.org/docs/gtk/struct.ListBoxBuilder.html)
/// - [ListBox in gtk-rs](https://gtk-rs.org/docs/gtk/struct.ListBox.html)
///
/// ## Examples
/// ```rust,no_run
/// # #[macro_use]
/// # extern crate gstore;
/// # use gstore::prelude::*;
/// # use gtk::prelude::*;
/// #
/// # fn main() {
/// list_box! {
///     properties {
///         title: "Test Application"
///     }
///     children [
///         button! {
///             children [
///                 image!("format-justify-fill-symbolic", gtk::IconSize::Button)
///             ]
///         }
///     ]
/// };
/// # }

#[macro_export]
macro_rules! list_box {
    (
        $($text:tt)*
    ) => {{
        let list_box = gtk::ListBoxBuilder::new().visible(true).build();
        widget!(list_box: gtk::ListBox { $($text)* });
        list_box
    }}
}
