/// Creates a GTK box.
///
/// # See Also
/// - [widget Macro](macro.widget.html)
/// - [ComboBoxBuilder in gtk-rs](https://gtk-rs.org/docs/gtk/struct.BoxBuilder.html)
/// - [ComboBox in gtk-rs](https://gtk-rs.org/docs/gtk/struct.Box.html)
///
/// # Examples
///
/// ```rust,no_run
/// # #[macro_use]
/// # extern crate gstore;
/// # use gstore::prelude::*;
/// # use gtk::prelude::*;
/// #
/// # slice! { CountState { count: i64 = 0 } CountAction { Clicked } }
/// # fn reduce_count(action: CountAction, state: CountState) -> CountState { state }
/// # store! { count: Count = crate::{CountState, CountAction, reduce_count} }
/// #
/// # fn main() {
/// #     let store = Store::new(|a,s| s, vec![]);
///
/// combo_box! {
///     options [
///         "Option 1"
///         "Option 2"
///         "Option 3"
///     ]
/// };
/// # }
/// ```
#[macro_export]
macro_rules! combo_box {
    (
        $(class $class:literal)?
        $(properties {
            $($properties:tt)*
        })?
        $(connections {
            $($connections:tt)*
        })?
        $(options [
            $($option:expr)*
        ])?

    ) => {{
        let combo_box = gtk::ComboBoxBuilder::new()
            .visible(true)
            .id_column(0)
            .entry_text_column(1)
            .has_entry(true)
            .build();

        widget!(combo_box: gtk::ComboBox {
            $(class $class)?
            $(properties {
                $($properties)*
            })?
            $(connections {
                $($connections)*
            })?
        });

        let mut index = 0;
        $(
        let list = gtk::ListStore::new(&[glib::Type::I64, glib::Type::String]);
            $(
                let list_option = list.append();
                list.set(&list_option, &[0, 1], &[&index, &format!("{}", $option)]);
                index += 1;
            )*
        combo_box.set_model(Some(&list));
        )?

        combo_box
    }}
}
