// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

use super::super::ffi;

use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;

use gst::glib;
use gst::prelude::*;

use std::boxed::Box as Box_;
use std::mem::transmute;

glib::wrapper! {
    pub struct Aggregator(Object<ffi::GstAggregator, ffi::GstAggregatorClass>) @extends gst::Element, gst::Object;

    match fn {
        type_ => || ffi::gst_aggregator_get_type(),
    }
}

unsafe impl Send for Aggregator {}
unsafe impl Sync for Aggregator {}

pub const NONE_AGGREGATOR: Option<&Aggregator> = None;

pub trait AggregatorExt: 'static {
    //#[doc(alias = "gst_aggregator_get_allocator")]
    //#[doc(alias = "get_allocator")]
    //fn allocator(&self, allocator: /*Ignored*/Option<gst::Allocator>, params: /*Ignored*/gst::AllocationParams);

    #[doc(alias = "gst_aggregator_get_buffer_pool")]
    #[doc(alias = "get_buffer_pool")]
    fn buffer_pool(&self) -> Option<gst::BufferPool>;

    #[doc(alias = "gst_aggregator_get_latency")]
    #[doc(alias = "get_latency")]
    fn latency(&self) -> Option<gst::ClockTime>;

    #[doc(alias = "gst_aggregator_negotiate")]
    fn negotiate(&self) -> bool;

    #[doc(alias = "gst_aggregator_set_latency")]
    fn set_latency(
        &self,
        min_latency: gst::ClockTime,
        max_latency: impl Into<Option<gst::ClockTime>>,
    );

    #[doc(alias = "gst_aggregator_set_src_caps")]
    fn set_src_caps(&self, caps: &gst::Caps);

    #[doc(alias = "gst_aggregator_simple_get_next_time")]
    fn simple_get_next_time(&self) -> Option<gst::ClockTime>;

    #[doc(alias = "start-time")]
    fn start_time(&self) -> u64;

    #[doc(alias = "start-time")]
    fn set_start_time(&self, start_time: u64);

    #[doc(alias = "latency")]
    fn connect_latency_notify<F: Fn(&Self) + Send + Sync + 'static>(&self, f: F)
        -> SignalHandlerId;

    #[doc(alias = "start-time")]
    fn connect_start_time_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;
}

impl<O: IsA<Aggregator>> AggregatorExt for O {
    //fn allocator(&self, allocator: /*Ignored*/Option<gst::Allocator>, params: /*Ignored*/gst::AllocationParams) {
    //    unsafe { TODO: call ffi:gst_aggregator_get_allocator() }
    //}

    fn buffer_pool(&self) -> Option<gst::BufferPool> {
        unsafe {
            from_glib_full(ffi::gst_aggregator_get_buffer_pool(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn latency(&self) -> Option<gst::ClockTime> {
        unsafe {
            from_glib(ffi::gst_aggregator_get_latency(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn negotiate(&self) -> bool {
        unsafe {
            from_glib(ffi::gst_aggregator_negotiate(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn set_latency(
        &self,
        min_latency: gst::ClockTime,
        max_latency: impl Into<Option<gst::ClockTime>>,
    ) {
        unsafe {
            ffi::gst_aggregator_set_latency(
                self.as_ref().to_glib_none().0,
                min_latency.into_glib(),
                max_latency.into().into_glib(),
            );
        }
    }

    fn set_src_caps(&self, caps: &gst::Caps) {
        unsafe {
            ffi::gst_aggregator_set_src_caps(self.as_ref().to_glib_none().0, caps.to_glib_none().0);
        }
    }

    fn simple_get_next_time(&self) -> Option<gst::ClockTime> {
        unsafe {
            from_glib(ffi::gst_aggregator_simple_get_next_time(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn start_time(&self) -> u64 {
        unsafe {
            let mut value = glib::Value::from_type(<u64 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"start-time\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `start-time` getter")
        }
    }

    fn set_start_time(&self, start_time: u64) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"start-time\0".as_ptr() as *const _,
                start_time.to_value().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "latency")]
    fn connect_latency_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_latency_trampoline<
            P: IsA<Aggregator>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstAggregator,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&Aggregator::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::latency\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_latency_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "start-time")]
    fn connect_start_time_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_start_time_trampoline<
            P: IsA<Aggregator>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstAggregator,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&Aggregator::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::start-time\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_start_time_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}
