// Generated by gir (https://github.com/gtk-rs/gir @ ee37253c10af)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git @ 5264fd0c3183)
// DO NOT EDIT

use gspell_sys::*;
use std::env;
use std::error::Error;
use std::ffi::OsString;
use std::mem::{align_of, size_of};
use std::path::Path;
use std::process::Command;
use std::str;
use tempfile::Builder;

static PACKAGES: &[&str] = &["gspell-1"];

#[derive(Clone, Debug)]
struct Compiler {
    pub args: Vec<String>,
}

impl Compiler {
    pub fn new() -> Result<Self, Box<dyn Error>> {
        let mut args = get_var("CC", "cc")?;
        args.push("-Wno-deprecated-declarations".to_owned());
        // For _Generic
        args.push("-std=c11".to_owned());
        // For %z support in printf when using MinGW.
        args.push("-D__USE_MINGW_ANSI_STDIO".to_owned());
        args.extend(get_var("CFLAGS", "")?);
        args.extend(get_var("CPPFLAGS", "")?);
        args.extend(pkg_config_cflags(PACKAGES)?);
        Ok(Self { args })
    }

    pub fn compile(&self, src: &Path, out: &Path) -> Result<(), Box<dyn Error>> {
        let mut cmd = self.to_command();
        cmd.arg(src);
        cmd.arg("-o");
        cmd.arg(out);
        let status = cmd.spawn()?.wait()?;
        if !status.success() {
            return Err(format!("compilation command {:?} failed, {}", &cmd, status).into());
        }
        Ok(())
    }

    fn to_command(&self) -> Command {
        let mut cmd = Command::new(&self.args[0]);
        cmd.args(&self.args[1..]);
        cmd
    }
}

fn get_var(name: &str, default: &str) -> Result<Vec<String>, Box<dyn Error>> {
    match env::var(name) {
        Ok(value) => Ok(shell_words::split(&value)?),
        Err(env::VarError::NotPresent) => Ok(shell_words::split(default)?),
        Err(err) => Err(format!("{} {}", name, err).into()),
    }
}

fn pkg_config_cflags(packages: &[&str]) -> Result<Vec<String>, Box<dyn Error>> {
    if packages.is_empty() {
        return Ok(Vec::new());
    }
    let pkg_config = env::var_os("PKG_CONFIG").unwrap_or_else(|| OsString::from("pkg-config"));
    let mut cmd = Command::new(pkg_config);
    cmd.arg("--cflags");
    cmd.args(packages);
    let out = cmd.output()?;
    if !out.status.success() {
        return Err(format!("command {:?} returned {}", &cmd, out.status).into());
    }
    let stdout = str::from_utf8(&out.stdout)?;
    Ok(shell_words::split(stdout.trim())?)
}

#[derive(Copy, Clone, Debug, Eq, PartialEq)]
struct Layout {
    size: usize,
    alignment: usize,
}

#[derive(Copy, Clone, Debug, Default, Eq, PartialEq)]
struct Results {
    /// Number of successfully completed tests.
    passed: usize,
    /// Total number of failed tests (including those that failed to compile).
    failed: usize,
}

impl Results {
    fn record_passed(&mut self) {
        self.passed += 1;
    }
    fn record_failed(&mut self) {
        self.failed += 1;
    }
    fn summary(&self) -> String {
        format!("{} passed; {} failed", self.passed, self.failed)
    }
    fn expect_total_success(&self) {
        if self.failed == 0 {
            println!("OK: {}", self.summary());
        } else {
            panic!("FAILED: {}", self.summary());
        };
    }
}

#[test]
fn cross_validate_constants_with_c() {
    let mut c_constants: Vec<(String, String)> = Vec::new();

    for l in get_c_output("constant").unwrap().lines() {
        let mut words = l.trim().split(';');
        let name = words.next().expect("Failed to parse name").to_owned();
        let value = words
            .next()
            .and_then(|s| s.parse().ok())
            .expect("Failed to parse value");
        c_constants.push((name, value));
    }

    let mut results = Results::default();

    for ((rust_name, rust_value), (c_name, c_value)) in
        RUST_CONSTANTS.iter().zip(c_constants.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {:?}\nC:    {:?}", rust_name, c_name,);
            continue;
        }

        if rust_value != c_value {
            results.record_failed();
            eprintln!(
                "Constant value mismatch for {}\nRust: {:?}\nC:    {:?}",
                rust_name, rust_value, &c_value
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

#[test]
fn cross_validate_layout_with_c() {
    let mut c_layouts = Vec::new();

    for l in get_c_output("layout").unwrap().lines() {
        let mut words = l.trim().split(';');
        let name = words.next().expect("Failed to parse name").to_owned();
        let size = words
            .next()
            .and_then(|s| s.parse().ok())
            .expect("Failed to parse size");
        let alignment = words
            .next()
            .and_then(|s| s.parse().ok())
            .expect("Failed to parse alignment");
        c_layouts.push((name, Layout { size, alignment }));
    }

    let mut results = Results::default();

    for ((rust_name, rust_layout), (c_name, c_layout)) in RUST_LAYOUTS.iter().zip(c_layouts.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {:?}\nC:    {:?}", rust_name, c_name,);
            continue;
        }

        if rust_layout != c_layout {
            results.record_failed();
            eprintln!(
                "Layout mismatch for {}\nRust: {:?}\nC:    {:?}",
                rust_name, rust_layout, &c_layout
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

fn get_c_output(name: &str) -> Result<String, Box<dyn Error>> {
    let tmpdir = Builder::new().prefix("abi").tempdir()?;
    let exe = tmpdir.path().join(name);
    let c_file = Path::new("tests").join(name).with_extension("c");

    let cc = Compiler::new().expect("configured compiler");
    cc.compile(&c_file, &exe)?;

    let mut abi_cmd = Command::new(exe);
    let output = abi_cmd.output()?;
    if !output.status.success() {
        return Err(format!("command {:?} failed, {:?}", &abi_cmd, &output).into());
    }

    Ok(String::from_utf8(output.stdout)?)
}

const RUST_LAYOUTS: &[(&str, Layout)] = &[
    (
        "GspellChecker",
        Layout {
            size: size_of::<GspellChecker>(),
            alignment: align_of::<GspellChecker>(),
        },
    ),
    (
        "GspellCheckerClass",
        Layout {
            size: size_of::<GspellCheckerClass>(),
            alignment: align_of::<GspellCheckerClass>(),
        },
    ),
    (
        "GspellCheckerDialog",
        Layout {
            size: size_of::<GspellCheckerDialog>(),
            alignment: align_of::<GspellCheckerDialog>(),
        },
    ),
    (
        "GspellCheckerDialogClass",
        Layout {
            size: size_of::<GspellCheckerDialogClass>(),
            alignment: align_of::<GspellCheckerDialogClass>(),
        },
    ),
    (
        "GspellCheckerError",
        Layout {
            size: size_of::<GspellCheckerError>(),
            alignment: align_of::<GspellCheckerError>(),
        },
    ),
    (
        "GspellEntryBufferClass",
        Layout {
            size: size_of::<GspellEntryBufferClass>(),
            alignment: align_of::<GspellEntryBufferClass>(),
        },
    ),
    (
        "GspellEntryClass",
        Layout {
            size: size_of::<GspellEntryClass>(),
            alignment: align_of::<GspellEntryClass>(),
        },
    ),
    (
        "GspellLanguageChooserButton",
        Layout {
            size: size_of::<GspellLanguageChooserButton>(),
            alignment: align_of::<GspellLanguageChooserButton>(),
        },
    ),
    (
        "GspellLanguageChooserButtonClass",
        Layout {
            size: size_of::<GspellLanguageChooserButtonClass>(),
            alignment: align_of::<GspellLanguageChooserButtonClass>(),
        },
    ),
    (
        "GspellLanguageChooserDialog",
        Layout {
            size: size_of::<GspellLanguageChooserDialog>(),
            alignment: align_of::<GspellLanguageChooserDialog>(),
        },
    ),
    (
        "GspellLanguageChooserDialogClass",
        Layout {
            size: size_of::<GspellLanguageChooserDialogClass>(),
            alignment: align_of::<GspellLanguageChooserDialogClass>(),
        },
    ),
    (
        "GspellLanguageChooserInterface",
        Layout {
            size: size_of::<GspellLanguageChooserInterface>(),
            alignment: align_of::<GspellLanguageChooserInterface>(),
        },
    ),
    (
        "GspellNavigatorInterface",
        Layout {
            size: size_of::<GspellNavigatorInterface>(),
            alignment: align_of::<GspellNavigatorInterface>(),
        },
    ),
    (
        "GspellNavigatorTextView",
        Layout {
            size: size_of::<GspellNavigatorTextView>(),
            alignment: align_of::<GspellNavigatorTextView>(),
        },
    ),
    (
        "GspellNavigatorTextViewClass",
        Layout {
            size: size_of::<GspellNavigatorTextViewClass>(),
            alignment: align_of::<GspellNavigatorTextViewClass>(),
        },
    ),
    (
        "GspellTextBufferClass",
        Layout {
            size: size_of::<GspellTextBufferClass>(),
            alignment: align_of::<GspellTextBufferClass>(),
        },
    ),
    (
        "GspellTextView",
        Layout {
            size: size_of::<GspellTextView>(),
            alignment: align_of::<GspellTextView>(),
        },
    ),
    (
        "GspellTextViewClass",
        Layout {
            size: size_of::<GspellTextViewClass>(),
            alignment: align_of::<GspellTextViewClass>(),
        },
    ),
];

const RUST_CONSTANTS: &[(&str, &str)] = &[
    ("(gint) GSPELL_CHECKER_ERROR_DICTIONARY", "0"),
    ("(gint) GSPELL_CHECKER_ERROR_NO_LANGUAGE_SET", "1"),
];
