use gsof_protocol::protocol::tables::read_gsof_file_protocol;
use gsof_protocol::protocol::gsof::{GsofData};
use tokio::{io};

/*
Read a stream of bytes from stdout and convert to GsofData
 */
#[tokio::main]
async fn main(){
    let stdin = io::stdin();
    let mut reader = io::BufReader::new(stdin);
    let tables = read_gsof_file_protocol().unwrap();
    loop {
        let result = GsofData::read_from_stream(
            &mut reader, &tables).await.unwrap();
        println!("{}", result.json_dumps());
        let latency = (result.latency() as f64) / 1000.0;
        println!("Latency {} secs", latency);
    }
}
