use heck::ToPascalCase;

use super::{Context, KeyGenerator, SchemaKey};

pub fn key_generator(key: &SchemaKey) -> KeyGenerator<'_> {
    if let Some(ref choices) = key.choices {
        let choice_enum_name = key.name.to_pascal_case();
        let choice_enum_token_stream = super::new_variant_enum(
            &choice_enum_name,
            &choices
                .choices
                .iter()
                .map(|choice| choice.value.as_str())
                .collect::<Vec<_>>(),
        );
        KeyGenerator::new(
            key,
            Context::new_with_aux(&choice_enum_name, choice_enum_token_stream),
        )
    } else {
        KeyGenerator::new(key, Context::new_dissimilar("&str", "String"))
    }
}
