#![allow(unused)]

use clap::Parser;
use indicatif::{HumanDuration, ProgressBar, ProgressStyle};
use log::{info, warn};

/// Search for a pattern in a file and display the lines that contain it.
#[derive(Parser)]
struct Cli {
    /// The pattern to look for
    pattern: String,
    /// The path to the file to read
    #[clap(parse(from_os_str))]
    // #[clap(short = 'o', long = "output")]
    path: std::path::PathBuf,
}

fn main() -> Result<(), Box<dyn std::error::Error>> {
    env_logger::init();

    let args = Cli::parse();
    let content = std::fs::read_to_string(&args.path)
        .expect("could not read file");


    println!("args: {:?}, {:?}", args.pattern, args.path);
    // for line in content.lines() {
    //     if line.contains(&args.pattern) {
    //         info!("find patter");
    //         println!("{}", line);
    //     }
    // }

    grrs_cheng::find_matches(&content, &args.pattern, &mut std::io::stdout());

    // let content = std::fs::read_to_string("atest.txt").unwrap();
    // let content = match result {
    //     Ok(content) => { content },
    //     Err(err) => { panic!("Can't deal with {}, just exit here", err); }
    // };
    // println!("file content: {}", content);
    //
    foo1();

    // try2
    // foo()
    Ok(())
}

// fn find_matches(content: &str, pattern: &str, mut write: impl std::io::Write) {
//     for line in content.lines() {
//         if line.contains(&pattern) {
//             // println!("{}", line);
//             writeln!(write, "{}", line);
//         }
//     }
// }

#[test]
fn find_a_match() {
    let mut result = Vec::new();
    grrs_cheng::find_matches("lorem ipsum\ndolor sit amet", "lorem", &mut result);
    assert_eq!(result, b"lorem ipsum\n");
}

// fn main() -> Result<(), Box<dyn std::error::Error>> {
//     let content = std::fs::read_to_string("test1.txt")?;
//     println!("file content: {}", content);
//     // Ok(());
//     foo()
// }

fn foo() -> Result<(), Box<dyn std::error::Error>> {
    //  let result = std::fs::read_to_string("test.txt");
    // let content = match result {
    //     Ok(content) => { content },
    //     Err(error) => { return Err(error.into()); }
    // };
     let content = std::fs::read_to_string("test.txt")?;
    println!("file content: {}", content);
    Ok(())

}

fn foo1() {
    let pb = indicatif::ProgressBar::new(100);
    for i in 0..100 {
        // do_hard_work();
        // pb.println(format!("[+] finished #{}", i));
        pb.inc(1);
    }
    pb.finish_with_message("done");
}
