
# graphlang - graph languages defined by graph grammars

**NOTE: This crate is still highly exerimental and API changes should be expected! 
Performance is currently also not a concern. I highly discourage any use except for 
experiments.**

For the api documentation refer to `TODO`. This project contains a library that can be
used to define and use graph grammars as well as some helper function for generating 
random graphs given a graph grammar. It also has some predefined ones to aid
the creation of custom ones and to play around with. It comes with an extensive 
test suite[^1] and a good documented with many examples[^1].

The project also has an application that utilises the library to display generated graphs
and graphically create custom ones[^1].

The intermediate format to define and read graph grammars is a simple json file.

[^1]: Not yet implemented.

## TODO's

The following list contains all crucial things and the 
- [ ] Better documentation & examples
- [ ] Show serde support with an actual minimal example binary
- [ ] Create the whole application thing
- [ ] Eventually use the `graph_builder`-crate
- [ ] Write a usefull README.md

This list denotes 'good-to-have' things that improve the project, but are 
not necessary:
- [ ] Implement a better partial isomorphism algorithm - maybe VL2? Should be a major speedup
- [ ] Make it more generic s.t. it is actually usable 
- [ ] Reevaluate the public api
- [ ] Upload to crates.io s.t. it can be easily used/installed
- [ ] Improve performance to the point where it is usefull and not only a neat library to 
      try things.

## Basic introduction to graph grammars

TODO DPO-approach - This should be enough s.t. everybody could understand and work with the basic
building blocks.

## Basic usage

TODO - The documentation also has many examples ( that are actually there instead just more todos
).  

```rust
let grammar = graphlang::predefined::string_grammar();
let mut g = grammar.start_graph.clone();

for _ in 0..10 {
  grammar.productions["extend"].apply_inplace(&mut g)?;
}
grammar.productions["finalize"].apply_inplace(&mut g)?;

assert!(grammar.is_valid(&g));
```
