#[allow(unused_imports)]
use graphlang::{
    match_subgraph, Edge, Graph, GraphGrammar, Isomorphism, Node, Production, QuitCondition,
};

fn main() {
    pretty_env_logger::init_timed();

    let gg = graphlang::predefined::ladder_grammar(2);
    let mut g = gg.start_graph.clone();
    println!("----> {:?}", &g);
    for n in 0..5 {
        gg.productions["extend"].apply_inplace(&mut g).unwrap();
        println!("{n:4}: {:?}", &g.nodes);
        println!("      {:?}", &g.edges);
    }
    gg.productions["finalize"].apply_inplace(&mut g).unwrap();
    println!(" fin: {:?}", &g.nodes);
    println!("      {:?}", &g.edges);
}
