use super::*;
use image::EncodableLayout;
use serde::{Deserialize, Serialize};
use std::result::Result;

impl Serialize for Image {
    fn serialize<S>(&self, serializer: S) -> Result<S::Ok, S::Error>
    where
        S: Serializer,
    {
        serializer.serialize_bytes(self.shared.as_bytes())
    }
}

impl<'de> Deserialize<'de> for Image {
    fn deserialize<D>(_deserializer: D) -> Result<Self, D::Error>
    where
        D: Deserializer<'de>,
    {
        todo!()
    }
}
