// Copyright 2021 Chiral Ltd.
// Licensed under the Apache-2.0 license (https://opensource.org/licenses/Apache-2.0)
// This file may not be copied, modified, or distributed
// except according to those terms.


fn atomic_number_from_element(element: &purr::feature::Element) -> u8 {
    match &element {
        purr::feature::Element::H => 1,
        purr::feature::Element::He => 2, 
        purr::feature::Element::Li => 3, 
        purr::feature::Element::Be => 4, 
        purr::feature::Element::B => 5, 
        purr::feature::Element::C => 6,
        purr::feature::Element::N => 7,
        purr::feature::Element::O => 8, 
        purr::feature::Element::F => 9, 
        purr::feature::Element::Ne => 10,
        purr::feature::Element::Na => 11, 
        purr::feature::Element::Mg => 12, 
        purr::feature::Element::Al => 13, 
        purr::feature::Element::Si => 14, 
        purr::feature::Element::P => 15, 
        purr::feature::Element::S => 16, 
        purr::feature::Element::Cl => 17, 
        purr::feature::Element::Ar => 18, 
        purr::feature::Element::K => 19,
        purr::feature::Element::Ca => 20,
        purr::feature::Element::Sc => 21, 
        purr::feature::Element::Ti => 22, 
        purr::feature::Element::V => 23, 
        purr::feature::Element::Cr => 24, 
        purr::feature::Element::Mn => 25, 
        purr::feature::Element::Fe => 26, 
        purr::feature::Element::Co => 27, 
        purr::feature::Element::Ni => 28, 
        purr::feature::Element::Cu => 29, 
        purr::feature::Element::Zn => 30,
        purr::feature::Element::Ga => 31, 
        purr::feature::Element::Ge => 32, 
        purr::feature::Element::As => 33, 
        purr::feature::Element::Se => 34, 
        purr::feature::Element::Br => 35, 
        purr::feature::Element::Kr => 36,
        purr::feature::Element::Rb => 37, 
        purr::feature::Element::Sr => 38, 
        purr::feature::Element::Y => 39, 
        purr::feature::Element::Zr => 40,
        purr::feature::Element::Nb => 41, 
        purr::feature::Element::Mo => 42, 
        purr::feature::Element::Tc => 43, 
        purr::feature::Element::Ru => 44, 
        purr::feature::Element::Rh => 45, 
        purr::feature::Element::Pd => 46, 
        purr::feature::Element::Ag => 47, 
        purr::feature::Element::Cd => 48, 
        purr::feature::Element::In => 49,
        purr::feature::Element::Sn => 50,
        purr::feature::Element::Sb => 51, 
        purr::feature::Element::Te => 52, 
        purr::feature::Element::I => 53, 
        purr::feature::Element::Xe => 54, 
        purr::feature::Element::Cs => 55, 
        purr::feature::Element::Ba => 56, 
        purr::feature::Element::La => 57, 
        purr::feature::Element::Ce => 58, 
        purr::feature::Element::Pr => 59,
        purr::feature::Element::Nd => 60,
        purr::feature::Element::Pm => 61, 
        purr::feature::Element::Sm => 62, 
        purr::feature::Element::Eu => 63,
        purr::feature::Element::Gd => 64, 
        purr::feature::Element::Tb => 65,
        purr::feature::Element::Dy => 66, 
        purr::feature::Element::Ho => 67, 
        purr::feature::Element::Er => 68, 
        purr::feature::Element::Tm => 69, 
        purr::feature::Element::Yb => 70,
        purr::feature::Element::Lu => 71, 
        purr::feature::Element::Hf => 72, 
        purr::feature::Element::Ta => 73,
        purr::feature::Element::W => 74, 
        purr::feature::Element::Re => 75, 
        purr::feature::Element::Os => 76, 
        purr::feature::Element::Ir => 77, 
        purr::feature::Element::Pt => 78,
        purr::feature::Element::Au => 79, 
        purr::feature::Element::Hg => 80,
        purr::feature::Element::Tl => 81, 
        purr::feature::Element::Pb => 82, 
        purr::feature::Element::Bi => 83, 
        purr::feature::Element::Po => 84, 
        purr::feature::Element::At => 85, 
        purr::feature::Element::Rn => 86, 
        purr::feature::Element::Fr => 87, 
        purr::feature::Element::Ra => 88, 
        purr::feature::Element::Ac => 89, 
        purr::feature::Element::Th => 90,
        purr::feature::Element::Pa => 91, 
        purr::feature::Element::U => 92, 
        purr::feature::Element::Np => 93, 
        purr::feature::Element::Pu => 94, 
        purr::feature::Element::Am => 95, 
        purr::feature::Element::Cm => 96, 
        purr::feature::Element::Bk => 97, 
        purr::feature::Element::Cf => 98, 
        purr::feature::Element::Es => 99, 
        purr::feature::Element::Fm => 100,
        purr::feature::Element::Md => 101, 
        purr::feature::Element::No => 102, 
        purr::feature::Element::Lr => 103, 
        purr::feature::Element::Rf => 104, 
        purr::feature::Element::Db => 105, 
        purr::feature::Element::Sg => 106, 
        purr::feature::Element::Bh => 107, 
        purr::feature::Element::Hs => 108, 
        purr::feature::Element::Mt => 109, 
        purr::feature::Element::Ds => 110,
        purr::feature::Element::Rg => 111, 
        purr::feature::Element::Cn => 112, 
        purr::feature::Element::Nh => 113, 
        purr::feature::Element::Fl => 114, 
        purr::feature::Element::Mc => 115, 
        purr::feature::Element::Lv => 116,
        purr::feature::Element::Ts => 117,
        purr::feature::Element::Og => 118
    }
}

pub fn atomic_number(atom_kind: &purr::feature::AtomKind) -> u8 {
    let element_op: Option<&purr::feature::Element> = match &atom_kind {
        purr::feature::AtomKind::Star => None, 
        purr::feature::AtomKind::Aliphatic(aliphatic) => match &aliphatic {
            purr::feature::Aliphatic::B => Some(&purr::feature::Element::B), 
            purr::feature::Aliphatic::C => Some(&purr::feature::Element::C),
            purr::feature::Aliphatic::N => Some(&purr::feature::Element::N),
            purr::feature::Aliphatic::O => Some(&purr::feature::Element::O),
            purr::feature::Aliphatic::S => Some(&purr::feature::Element::S),
            purr::feature::Aliphatic::P => Some(&purr::feature::Element::P), 
            purr::feature::Aliphatic::F => Some(&purr::feature::Element::F), 
            purr::feature::Aliphatic::Cl => Some(&purr::feature::Element::Cl),
            purr::feature::Aliphatic::Br => Some(&purr::feature::Element::Br),
            purr::feature::Aliphatic::I => Some(&purr::feature::Element::I),
            purr::feature::Aliphatic::At => Some(&purr::feature::Element::At),
            purr::feature::Aliphatic::Ts => Some(&purr::feature::Element::Ts)
        },
        purr::feature::AtomKind::Aromatic(aromatic) => match &aromatic {
            purr::feature::Aromatic::B => Some(&purr::feature::Element::B),
            purr::feature::Aromatic::C => Some(&purr::feature::Element::C),
            purr::feature::Aromatic::N => Some(&purr::feature::Element::N),
            purr::feature::Aromatic::O => Some(&purr::feature::Element::O), 
            purr::feature::Aromatic::P => Some(&purr::feature::Element::P), 
            purr::feature::Aromatic::S => Some(&purr::feature::Element::S)
        },
        purr::feature::AtomKind::Bracket {
            isotope: _, symbol, configuration: _, hcount: _, charge: _, map: _
        } => match &symbol {
            purr::feature::BracketSymbol::Star => None,
            purr::feature::BracketSymbol::Element(ele) => Some(ele.clone()),
            purr::feature::BracketSymbol::Aromatic(bracket_aromatic) => match &bracket_aromatic {
                purr::feature::BracketAromatic::B => Some(&purr::feature::Element::B),
                purr::feature::BracketAromatic::C => Some(&purr::feature::Element::C),
                purr::feature::BracketAromatic::N => Some(&purr::feature::Element::N),
                purr::feature::BracketAromatic::O => Some(&purr::feature::Element::O),
                purr::feature::BracketAromatic::S => Some(&purr::feature::Element::S),
                purr::feature::BracketAromatic::P => Some(&purr::feature::Element::P),
                purr::feature::BracketAromatic::Se => Some(&purr::feature::Element::Se),
                purr::feature::BracketAromatic::As => Some(&purr::feature::Element::As)
            }
        } 
    };
    match element_op {
        Some(element) => atomic_number_from_element(element),
        None => 0
    }
}