# Grapes: Persistent Graph Data Structures

Persistent: Cheap to clone, so you can keep (and modify) older versions of the data structure easily.

Data Structures:
- Arena (for building arbitrary graph-like data structures)
- Tree (hierarchical, indexable collection with ordered children)
- MapTree (maintains a key-node mapping in addition to a tree)

## Alternatives

Unless you specifically need a *persistent* tree, I recommend using these crates instead (these are more mature, and probably faster):

- Arenas: [generational-arena](https://crates.io/crates/generational-arena)
- Trees: [id_tree](https://crates.io/crates/id_tree)
- Graphs: [petgraph](https://crates.io/crates/petgraph)

If you need simple persistent data structures (lists, maps), check out:

- [im](https://crates.io/crates/im) or [imbl](https://crates.io/crates/imbl)
- [rpds](https://crates.io/crates/rpds)

## Status

This library is in the early stages. It only supports what I need it to support for my very specific use case.

There are no benchmarks; performance is probably nowhere near other libraries, and this is fine for now – I'll optimize later if I run into performance issues.

## Use Cases

This library is only useful if you need graph structures that can be somewhat cheaply cloned and manipulated.

For example, if you're building an application that stores state in a graph structure, and needs efficient undo-redo
functionality, you might want to store past copies of the graph in memory. To do this efficiently, those copies should
share parts of the graph that didn't change.