use crate::tree::NodeId;

#[derive(Debug)]
/// An error that occurs when attempting to remove the root node from a tree
pub struct CannotRemoveRoot;

#[derive(Debug)]
/// An error that occurs when attempting to move a node to an invalid location
pub enum MoveError<Id> {
    /// The specified location referenced a node ID that doesn't exist
    NoSuchNode(Id),
    /// Attempted to move the node as a sibling of the root node; this is not allowed
    RootCannotHaveSiblings,
    /// Attempted to move a node under itself (either as a direct child or indirect descendant)
    ///
    /// This is not allowed, as it would result in an invalid Tree structure
    CannotMoveUnderSelf,
}

#[derive(Debug)]
pub(crate) enum InvalidLocation {
    NoSuchNode(NodeId),
    RootCannotHaveSiblings,
}

#[derive(Debug)]
pub(crate) enum RemoveByIdError {
    NoSuchNode(NodeId),
    CannotRemoveRoot,
}
