use gramme_build::parse_tl_file;
use gramme_build::tl::Definition;
use gramme_build::{generate_rust_code, Config};
use std::io;

const LAYER: i32 = 0;

fn get_definitions(contents: &str) -> Vec<Definition> {
    parse_tl_file(&contents)
        .into_iter()
        .map(|d| d.unwrap())
        .collect()
}

#[test]
fn generic_functions_use_generic_parameters() -> io::Result<()> {
    let definitions = get_definitions(
        "
        ---functions---
        invokeWithLayer#da9b0d0d {X:Type} layer:int query:!X = X;
    ",
    );
    let mut file = Vec::new();
    generate_rust_code(
        &mut file,
        &definitions,
        LAYER,
        &Config {
            gen_name_for_id: false,
            deserializable_functions: true,
            impl_debug: true,
            impl_from_enum: true,
            impl_from_type: true,
        },
    )?;
    let result = String::from_utf8(file).unwrap();
    eprintln!("{}", result);
    assert!(result.contains("InvokeWithLayer<X: gramme_types::RemoteCall>"));
    assert!(result.contains("pub query: X,"));
    assert!(result.contains(
        "impl<X: gramme_types::RemoteCall> gramme_types::Identifiable for InvokeWithLayer<X>"
    ));
    assert!(result.contains(
        "impl<X: gramme_types::RemoteCall> gramme_types::Serializable for InvokeWithLayer<X>"
    ));
    assert!(result.contains(
        "impl<X: gramme_types::RemoteCall> gramme_types::Deserializable for InvokeWithLayer<X>"
    ));
    assert!(result.contains(
        "impl<X: gramme_types::RemoteCall> gramme_types::RemoteCall for InvokeWithLayer<X>"
    ));
    assert!(result.contains("type Return = X::Return;"));
    Ok(())
}
