// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// WARNING! Do not edit this file manually, your changes will be overwritten.

#include "PropValueObject.h"

#include "graphqlservice/internal/Schema.h"

#include "graphqlservice/introspection/IntrospectionSchema.h"

using namespace std::literals;

namespace graphql::mapi {
namespace object {

PropValue::PropValue(std::unique_ptr<Concept>&& pimpl) noexcept
	: service::Object { pimpl->getTypeNames(), pimpl->getResolvers() }
	, _pimpl { std::move(pimpl) }
{
}

void PropValue::beginSelectionSet(const service::SelectionSetParams& params) const
{
	_pimpl->beginSelectionSet(params);
}

void PropValue::endSelectionSet(const service::SelectionSetParams& params) const
{
	_pimpl->endSelectionSet(params);
}

} // namespace object

void AddPropValueDetails(const std::shared_ptr<schema::UnionType>& typePropValue, const std::shared_ptr<schema::Schema>& schema)
{
	typePropValue->AddPossibleTypes({
		schema->LookupType(R"gql(IntValue)gql"sv),
		schema->LookupType(R"gql(BoolValue)gql"sv),
		schema->LookupType(R"gql(StringValue)gql"sv),
		schema->LookupType(R"gql(GuidValue)gql"sv),
		schema->LookupType(R"gql(DateTimeValue)gql"sv),
		schema->LookupType(R"gql(BinaryValue)gql"sv),
		schema->LookupType(R"gql(StreamValue)gql"sv)
	});
}

} // namespace graphql::mapi
