// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// WARNING! Do not edit this file manually, your changes will be overwritten.

#include "NamedIdObject.h"
#include "NamedPropIdObject.h"

#include "graphqlservice/internal/Schema.h"

#include "graphqlservice/introspection/IntrospectionSchema.h"

#include <algorithm>
#include <functional>
#include <sstream>
#include <stdexcept>
#include <unordered_map>

using namespace std::literals;

namespace graphql::mapi {
namespace object {

NamedId::NamedId(std::unique_ptr<Concept>&& pimpl) noexcept
	: service::Object{ getTypeNames(), getResolvers() }
	, _pimpl { std::move(pimpl) }
{
}

service::TypeNames NamedId::getTypeNames() const noexcept
{
	return {
		R"gql(PropId)gql"sv,
		R"gql(NamedId)gql"sv
	};
}

service::ResolverMap NamedId::getResolvers() const noexcept
{
	return {
		{ R"gql(id)gql"sv, [this](service::ResolverParams&& params) { return resolveId(std::move(params)); } },
		{ R"gql(propset)gql"sv, [this](service::ResolverParams&& params) { return resolvePropset(std::move(params)); } },
		{ R"gql(__typename)gql"sv, [this](service::ResolverParams&& params) { return resolve_typename(std::move(params)); } }
	};
}

void NamedId::beginSelectionSet(const service::SelectionSetParams& params) const
{
	_pimpl->beginSelectionSet(params);
}

void NamedId::endSelectionSet(const service::SelectionSetParams& params) const
{
	_pimpl->endSelectionSet(params);
}

service::AwaitableResolver NamedId::resolvePropset(service::ResolverParams&& params) const
{
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = _pimpl->getPropset(service::FieldParams(service::SelectionSetParams{ params }, std::move(directives)));
	resolverLock.unlock();

	return service::ModifiedResult<response::Value>::convert(std::move(result), std::move(params));
}

service::AwaitableResolver NamedId::resolveId(service::ResolverParams&& params) const
{
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = _pimpl->getId(service::FieldParams(service::SelectionSetParams{ params }, std::move(directives)));
	resolverLock.unlock();

	return service::ModifiedResult<NamedPropId>::convert(std::move(result), std::move(params));
}

service::AwaitableResolver NamedId::resolve_typename(service::ResolverParams&& params) const
{
	return service::ModifiedResult<std::string>::convert(std::string{ R"gql(NamedId)gql" }, std::move(params));
}

} // namespace object

void AddNamedIdDetails(const std::shared_ptr<schema::ObjectType>& typeNamedId, const std::shared_ptr<schema::Schema>& schema)
{
	typeNamedId->AddFields({
		schema::Field::Make(R"gql(propset)gql"sv, R"md(Property set Guid)md"sv, std::nullopt, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType(R"gql(Guid)gql"sv))),
		schema::Field::Make(R"gql(id)gql"sv, R"md(Named property integer ID or string name)md"sv, std::nullopt, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType(R"gql(NamedPropId)gql"sv)))
	});
}

} // namespace graphql::mapi
