// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// WARNING! Do not edit this file manually, your changes will be overwritten.

#include "FoldersReloadedObject.h"
#include "FolderObject.h"

#include "graphqlservice/internal/Schema.h"

#include "graphqlservice/introspection/IntrospectionSchema.h"

#include <algorithm>
#include <functional>
#include <sstream>
#include <stdexcept>
#include <unordered_map>

using namespace std::literals;

namespace graphql::mapi {
namespace object {

FoldersReloaded::FoldersReloaded(std::unique_ptr<Concept>&& pimpl) noexcept
	: service::Object{ getTypeNames(), getResolvers() }
	, _pimpl { std::move(pimpl) }
{
}

service::TypeNames FoldersReloaded::getTypeNames() const noexcept
{
	return {
		R"gql(FolderChange)gql"sv,
		R"gql(FoldersReloaded)gql"sv
	};
}

service::ResolverMap FoldersReloaded::getResolvers() const noexcept
{
	return {
		{ R"gql(reloaded)gql"sv, [this](service::ResolverParams&& params) { return resolveReloaded(std::move(params)); } },
		{ R"gql(__typename)gql"sv, [this](service::ResolverParams&& params) { return resolve_typename(std::move(params)); } }
	};
}

void FoldersReloaded::beginSelectionSet(const service::SelectionSetParams& params) const
{
	_pimpl->beginSelectionSet(params);
}

void FoldersReloaded::endSelectionSet(const service::SelectionSetParams& params) const
{
	_pimpl->endSelectionSet(params);
}

service::AwaitableResolver FoldersReloaded::resolveReloaded(service::ResolverParams&& params) const
{
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = _pimpl->getReloaded(service::FieldParams(service::SelectionSetParams{ params }, std::move(directives)));
	resolverLock.unlock();

	return service::ModifiedResult<Folder>::convert<service::TypeModifier::List>(std::move(result), std::move(params));
}

service::AwaitableResolver FoldersReloaded::resolve_typename(service::ResolverParams&& params) const
{
	return service::ModifiedResult<std::string>::convert(std::string{ R"gql(FoldersReloaded)gql" }, std::move(params));
}

} // namespace object

void AddFoldersReloadedDetails(const std::shared_ptr<schema::ObjectType>& typeFoldersReloaded, const std::shared_ptr<schema::Schema>& schema)
{
	typeFoldersReloaded->AddFields({
		schema::Field::Make(R"gql(reloaded)gql"sv, R"md(`Folders` that were reloaded)md"sv, std::nullopt, schema->WrapType(introspection::TypeKind::NON_NULL, schema->WrapType(introspection::TypeKind::LIST, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType(R"gql(Folder)gql"sv)))))
	});
}

} // namespace graphql::mapi
