// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// WARNING! Do not edit this file manually, your changes will be overwritten.

#include "FolderRemovedObject.h"

#include "graphqlservice/internal/Schema.h"

#include "graphqlservice/introspection/IntrospectionSchema.h"

#include <algorithm>
#include <functional>
#include <sstream>
#include <stdexcept>
#include <unordered_map>

using namespace std::literals;

namespace graphql::mapi {
namespace object {

FolderRemoved::FolderRemoved(std::unique_ptr<Concept>&& pimpl) noexcept
	: service::Object{ getTypeNames(), getResolvers() }
	, _pimpl { std::move(pimpl) }
{
}

service::TypeNames FolderRemoved::getTypeNames() const noexcept
{
	return {
		R"gql(FolderChange)gql"sv,
		R"gql(FolderRemoved)gql"sv
	};
}

service::ResolverMap FolderRemoved::getResolvers() const noexcept
{
	return {
		{ R"gql(index)gql"sv, [this](service::ResolverParams&& params) { return resolveIndex(std::move(params)); } },
		{ R"gql(removed)gql"sv, [this](service::ResolverParams&& params) { return resolveRemoved(std::move(params)); } },
		{ R"gql(__typename)gql"sv, [this](service::ResolverParams&& params) { return resolve_typename(std::move(params)); } }
	};
}

void FolderRemoved::beginSelectionSet(const service::SelectionSetParams& params) const
{
	_pimpl->beginSelectionSet(params);
}

void FolderRemoved::endSelectionSet(const service::SelectionSetParams& params) const
{
	_pimpl->endSelectionSet(params);
}

service::AwaitableResolver FolderRemoved::resolveIndex(service::ResolverParams&& params) const
{
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = _pimpl->getIndex(service::FieldParams(service::SelectionSetParams{ params }, std::move(directives)));
	resolverLock.unlock();

	return service::ModifiedResult<int>::convert(std::move(result), std::move(params));
}

service::AwaitableResolver FolderRemoved::resolveRemoved(service::ResolverParams&& params) const
{
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = _pimpl->getRemoved(service::FieldParams(service::SelectionSetParams{ params }, std::move(directives)));
	resolverLock.unlock();

	return service::ModifiedResult<response::IdType>::convert(std::move(result), std::move(params));
}

service::AwaitableResolver FolderRemoved::resolve_typename(service::ResolverParams&& params) const
{
	return service::ModifiedResult<std::string>::convert(std::string{ R"gql(FolderRemoved)gql" }, std::move(params));
}

} // namespace object

void AddFolderRemovedDetails(const std::shared_ptr<schema::ObjectType>& typeFolderRemoved, const std::shared_ptr<schema::Schema>& schema)
{
	typeFolderRemoved->AddFields({
		schema::Field::Make(R"gql(index)gql"sv, R"md(Index in the subscribed window)md"sv, std::nullopt, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType(R"gql(Int)gql"sv))),
		schema::Field::Make(R"gql(removed)gql"sv, R"md(ID of the `Folder` that was removed)md"sv, std::nullopt, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType(R"gql(ID)gql"sv)))
	});
}

} // namespace graphql::mapi
