// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// WARNING! Do not edit this file manually, your changes will be overwritten.

#pragma once

#ifndef STREAMVALUEOBJECT_H
#define STREAMVALUEOBJECT_H

#include "MAPISchema.h"

namespace graphql::mapi::object {
namespace implements {

template <class I>
concept StreamValueIs = std::is_same_v<I, PropValue>;

} // namespace implements

namespace methods::StreamValueHas {

template <class TImpl>
concept getValueWithParams = requires (TImpl impl, service::FieldParams params) 
{
	{ service::AwaitableScalar<response::Value> { impl.getValue(std::move(params)) } };
};

template <class TImpl>
concept getValue = requires (TImpl impl) 
{
	{ service::AwaitableScalar<response::Value> { impl.getValue() } };
};

template <class TImpl>
concept beginSelectionSet = requires (TImpl impl, const service::SelectionSetParams params) 
{
	{ impl.beginSelectionSet(params) };
};

template <class TImpl>
concept endSelectionSet = requires (TImpl impl, const service::SelectionSetParams params) 
{
	{ impl.endSelectionSet(params) };
};

} // namespace methods::StreamValueHas

class StreamValue
	: public service::Object
{
private:
	service::AwaitableResolver resolveValue(service::ResolverParams&& params) const;

	service::AwaitableResolver resolve_typename(service::ResolverParams&& params) const;

	struct Concept
	{
		virtual ~Concept() = default;

		virtual void beginSelectionSet(const service::SelectionSetParams& params) const = 0;
		virtual void endSelectionSet(const service::SelectionSetParams& params) const = 0;

		virtual service::AwaitableScalar<response::Value> getValue(service::FieldParams&& params) const = 0;
	};

	template <class T>
	struct Model
		: Concept
	{
		Model(std::shared_ptr<T>&& pimpl) noexcept
			: _pimpl { std::move(pimpl) }
		{
		}

		service::AwaitableScalar<response::Value> getValue(service::FieldParams&& params) const final
		{
			if constexpr (methods::StreamValueHas::getValueWithParams<T>)
			{
				return { _pimpl->getValue(std::move(params)) };
			}
			else if constexpr (methods::StreamValueHas::getValue<T>)
			{
				return { _pimpl->getValue() };
			}
			else
			{
				throw std::runtime_error(R"ex(StreamValue::getValue is not implemented)ex");
			}
		}

		void beginSelectionSet(const service::SelectionSetParams& params) const final
		{
			if constexpr (methods::StreamValueHas::beginSelectionSet<T>)
			{
				_pimpl->beginSelectionSet(params);
			}
		}

		void endSelectionSet(const service::SelectionSetParams& params) const final
		{
			if constexpr (methods::StreamValueHas::endSelectionSet<T>)
			{
				_pimpl->endSelectionSet(params);
			}
		}

	private:
		const std::shared_ptr<T> _pimpl;
	};

	StreamValue(std::unique_ptr<Concept>&& pimpl) noexcept;

	// Unions which include this type
	friend PropValue;

	template <class I>
	static constexpr bool implements() noexcept
	{
		return implements::StreamValueIs<I>;
	}

	service::TypeNames getTypeNames() const noexcept;
	service::ResolverMap getResolvers() const noexcept;

	void beginSelectionSet(const service::SelectionSetParams& params) const final;
	void endSelectionSet(const service::SelectionSetParams& params) const final;

	const std::unique_ptr<Concept> _pimpl;

public:
	template <class T>
	StreamValue(std::shared_ptr<T> pimpl) noexcept
		: StreamValue { std::unique_ptr<Concept> { std::make_unique<Model<T>>(std::move(pimpl)) } }
	{
	}
};

} // namespace graphql::mapi::object

#endif // STREAMVALUEOBJECT_H
