// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// WARNING! Do not edit this file manually, your changes will be overwritten.

#include "NamedPropIdObject.h"

#include "graphqlservice/internal/Schema.h"

#include "graphqlservice/introspection/IntrospectionSchema.h"

using namespace std::literals;

namespace graphql::mapi {
namespace object {

NamedPropId::NamedPropId(std::unique_ptr<Concept>&& pimpl) noexcept
	: service::Object { pimpl->getTypeNames(), pimpl->getResolvers() }
	, _pimpl { std::move(pimpl) }
{
}

void NamedPropId::beginSelectionSet(const service::SelectionSetParams& params) const
{
	_pimpl->beginSelectionSet(params);
}

void NamedPropId::endSelectionSet(const service::SelectionSetParams& params) const
{
	_pimpl->endSelectionSet(params);
}

} // namespace object

void AddNamedPropIdDetails(const std::shared_ptr<schema::UnionType>& typeNamedPropId, const std::shared_ptr<schema::Schema>& schema)
{
	typeNamedPropId->AddPossibleTypes({
		schema->LookupType(R"gql(IntId)gql"sv),
		schema->LookupType(R"gql(StringId)gql"sv)
	});
}

} // namespace graphql::mapi
