// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// WARNING! Do not edit this file manually, your changes will be overwritten.

#pragma once

#ifndef NAMEDIDOBJECT_H
#define NAMEDIDOBJECT_H

#include "MAPISchema.h"

namespace graphql::mapi::object {
namespace implements {

template <class I>
concept NamedIdIs = std::is_same_v<I, PropId>;

} // namespace implements

namespace methods::NamedIdHas {

template <class TImpl>
concept getPropsetWithParams = requires (TImpl impl, service::FieldParams params) 
{
	{ service::AwaitableScalar<response::Value> { impl.getPropset(std::move(params)) } };
};

template <class TImpl>
concept getPropset = requires (TImpl impl) 
{
	{ service::AwaitableScalar<response::Value> { impl.getPropset() } };
};

template <class TImpl>
concept getIdWithParams = requires (TImpl impl, service::FieldParams params) 
{
	{ service::AwaitableObject<std::shared_ptr<NamedPropId>> { impl.getId(std::move(params)) } };
};

template <class TImpl>
concept getId = requires (TImpl impl) 
{
	{ service::AwaitableObject<std::shared_ptr<NamedPropId>> { impl.getId() } };
};

template <class TImpl>
concept beginSelectionSet = requires (TImpl impl, const service::SelectionSetParams params) 
{
	{ impl.beginSelectionSet(params) };
};

template <class TImpl>
concept endSelectionSet = requires (TImpl impl, const service::SelectionSetParams params) 
{
	{ impl.endSelectionSet(params) };
};

} // namespace methods::NamedIdHas

class NamedId
	: public service::Object
{
private:
	service::AwaitableResolver resolvePropset(service::ResolverParams&& params) const;
	service::AwaitableResolver resolveId(service::ResolverParams&& params) const;

	service::AwaitableResolver resolve_typename(service::ResolverParams&& params) const;

	struct Concept
	{
		virtual ~Concept() = default;

		virtual void beginSelectionSet(const service::SelectionSetParams& params) const = 0;
		virtual void endSelectionSet(const service::SelectionSetParams& params) const = 0;

		virtual service::AwaitableScalar<response::Value> getPropset(service::FieldParams&& params) const = 0;
		virtual service::AwaitableObject<std::shared_ptr<NamedPropId>> getId(service::FieldParams&& params) const = 0;
	};

	template <class T>
	struct Model
		: Concept
	{
		Model(std::shared_ptr<T>&& pimpl) noexcept
			: _pimpl { std::move(pimpl) }
		{
		}

		service::AwaitableScalar<response::Value> getPropset(service::FieldParams&& params) const final
		{
			if constexpr (methods::NamedIdHas::getPropsetWithParams<T>)
			{
				return { _pimpl->getPropset(std::move(params)) };
			}
			else if constexpr (methods::NamedIdHas::getPropset<T>)
			{
				return { _pimpl->getPropset() };
			}
			else
			{
				throw std::runtime_error(R"ex(NamedId::getPropset is not implemented)ex");
			}
		}

		service::AwaitableObject<std::shared_ptr<NamedPropId>> getId(service::FieldParams&& params) const final
		{
			if constexpr (methods::NamedIdHas::getIdWithParams<T>)
			{
				return { _pimpl->getId(std::move(params)) };
			}
			else if constexpr (methods::NamedIdHas::getId<T>)
			{
				return { _pimpl->getId() };
			}
			else
			{
				throw std::runtime_error(R"ex(NamedId::getId is not implemented)ex");
			}
		}

		void beginSelectionSet(const service::SelectionSetParams& params) const final
		{
			if constexpr (methods::NamedIdHas::beginSelectionSet<T>)
			{
				_pimpl->beginSelectionSet(params);
			}
		}

		void endSelectionSet(const service::SelectionSetParams& params) const final
		{
			if constexpr (methods::NamedIdHas::endSelectionSet<T>)
			{
				_pimpl->endSelectionSet(params);
			}
		}

	private:
		const std::shared_ptr<T> _pimpl;
	};

	NamedId(std::unique_ptr<Concept>&& pimpl) noexcept;

	// Unions which include this type
	friend PropId;

	template <class I>
	static constexpr bool implements() noexcept
	{
		return implements::NamedIdIs<I>;
	}

	service::TypeNames getTypeNames() const noexcept;
	service::ResolverMap getResolvers() const noexcept;

	void beginSelectionSet(const service::SelectionSetParams& params) const final;
	void endSelectionSet(const service::SelectionSetParams& params) const final;

	const std::unique_ptr<Concept> _pimpl;

public:
	template <class T>
	NamedId(std::shared_ptr<T> pimpl) noexcept
		: NamedId { std::unique_ptr<Concept> { std::make_unique<Model<T>>(std::move(pimpl)) } }
	{
	}
};

} // namespace graphql::mapi::object

#endif // NAMEDIDOBJECT_H
