// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// WARNING! Do not edit this file manually, your changes will be overwritten.

#include "MutationObject.h"
#include "ItemObject.h"
#include "FolderObject.h"

#include "graphqlservice/internal/Schema.h"

#include "graphqlservice/introspection/IntrospectionSchema.h"

#include <algorithm>
#include <functional>
#include <sstream>
#include <stdexcept>
#include <unordered_map>

using namespace std::literals;

namespace graphql::mapi {
namespace object {

Mutation::Mutation(std::unique_ptr<Concept>&& pimpl) noexcept
	: service::Object{ getTypeNames(), getResolvers() }
	, _pimpl { std::move(pimpl) }
{
}

service::TypeNames Mutation::getTypeNames() const noexcept
{
	return {
		R"gql(Mutation)gql"sv
	};
}

service::ResolverMap Mutation::getResolvers() const noexcept
{
	return {
		{ R"gql(copyItems)gql"sv, [this](service::ResolverParams&& params) { return resolveCopyItems(std::move(params)); } },
		{ R"gql(moveItems)gql"sv, [this](service::ResolverParams&& params) { return resolveMoveItems(std::move(params)); } },
		{ R"gql(__typename)gql"sv, [this](service::ResolverParams&& params) { return resolve_typename(std::move(params)); } },
		{ R"gql(createItem)gql"sv, [this](service::ResolverParams&& params) { return resolveCreateItem(std::move(params)); } },
		{ R"gql(markAsRead)gql"sv, [this](service::ResolverParams&& params) { return resolveMarkAsRead(std::move(params)); } },
		{ R"gql(modifyItem)gql"sv, [this](service::ResolverParams&& params) { return resolveModifyItem(std::move(params)); } },
		{ R"gql(deleteItems)gql"sv, [this](service::ResolverParams&& params) { return resolveDeleteItems(std::move(params)); } },
		{ R"gql(modifyFolder)gql"sv, [this](service::ResolverParams&& params) { return resolveModifyFolder(std::move(params)); } },
		{ R"gql(removeFolder)gql"sv, [this](service::ResolverParams&& params) { return resolveRemoveFolder(std::move(params)); } },
		{ R"gql(createSubFolder)gql"sv, [this](service::ResolverParams&& params) { return resolveCreateSubFolder(std::move(params)); } }
	};
}

void Mutation::beginSelectionSet(const service::SelectionSetParams& params) const
{
	_pimpl->beginSelectionSet(params);
}

void Mutation::endSelectionSet(const service::SelectionSetParams& params) const
{
	_pimpl->endSelectionSet(params);
}

service::AwaitableResolver Mutation::resolveCreateItem(service::ResolverParams&& params) const
{
	auto argInput = service::ModifiedArgument<mapi::CreateItemInput>::require("input", params.arguments);
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = _pimpl->applyCreateItem(service::FieldParams(service::SelectionSetParams{ params }, std::move(directives)), std::move(argInput));
	resolverLock.unlock();

	return service::ModifiedResult<Item>::convert(std::move(result), std::move(params));
}

service::AwaitableResolver Mutation::resolveCreateSubFolder(service::ResolverParams&& params) const
{
	auto argInput = service::ModifiedArgument<mapi::CreateSubFolderInput>::require("input", params.arguments);
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = _pimpl->applyCreateSubFolder(service::FieldParams(service::SelectionSetParams{ params }, std::move(directives)), std::move(argInput));
	resolverLock.unlock();

	return service::ModifiedResult<Folder>::convert(std::move(result), std::move(params));
}

service::AwaitableResolver Mutation::resolveModifyItem(service::ResolverParams&& params) const
{
	auto argInput = service::ModifiedArgument<mapi::ModifyItemInput>::require("input", params.arguments);
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = _pimpl->applyModifyItem(service::FieldParams(service::SelectionSetParams{ params }, std::move(directives)), std::move(argInput));
	resolverLock.unlock();

	return service::ModifiedResult<Item>::convert(std::move(result), std::move(params));
}

service::AwaitableResolver Mutation::resolveModifyFolder(service::ResolverParams&& params) const
{
	auto argInput = service::ModifiedArgument<mapi::ModifyFolderInput>::require("input", params.arguments);
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = _pimpl->applyModifyFolder(service::FieldParams(service::SelectionSetParams{ params }, std::move(directives)), std::move(argInput));
	resolverLock.unlock();

	return service::ModifiedResult<Folder>::convert(std::move(result), std::move(params));
}

service::AwaitableResolver Mutation::resolveRemoveFolder(service::ResolverParams&& params) const
{
	static const auto defaultArguments = []()
	{
		response::Value values(response::Type::Map);
		response::Value entry;

		entry = response::Value(false);
		values.emplace_back("hardDelete", std::move(entry));

		return values;
	}();

	auto argInput = service::ModifiedArgument<ObjectId>::require("input", params.arguments);
	auto pairHardDelete = service::ModifiedArgument<bool>::find("hardDelete", params.arguments);
	auto argHardDelete = (pairHardDelete.second
		? std::move(pairHardDelete.first)
		: service::ModifiedArgument<bool>::require("hardDelete", defaultArguments));
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = _pimpl->applyRemoveFolder(service::FieldParams(service::SelectionSetParams{ params }, std::move(directives)), std::move(argInput), std::move(argHardDelete));
	resolverLock.unlock();

	return service::ModifiedResult<bool>::convert(std::move(result), std::move(params));
}

service::AwaitableResolver Mutation::resolveMarkAsRead(service::ResolverParams&& params) const
{
	static const auto defaultArguments = []()
	{
		response::Value values(response::Type::Map);
		response::Value entry;

		entry = response::Value(true);
		values.emplace_back("read", std::move(entry));

		return values;
	}();

	auto argInput = service::ModifiedArgument<MultipleItemsInput>::require("input", params.arguments);
	auto pairRead = service::ModifiedArgument<bool>::find("read", params.arguments);
	auto argRead = (pairRead.second
		? std::move(pairRead.first)
		: service::ModifiedArgument<bool>::require("read", defaultArguments));
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = _pimpl->applyMarkAsRead(service::FieldParams(service::SelectionSetParams{ params }, std::move(directives)), std::move(argInput), std::move(argRead));
	resolverLock.unlock();

	return service::ModifiedResult<bool>::convert(std::move(result), std::move(params));
}

service::AwaitableResolver Mutation::resolveCopyItems(service::ResolverParams&& params) const
{
	auto argInput = service::ModifiedArgument<MultipleItemsInput>::require("input", params.arguments);
	auto argDestination = service::ModifiedArgument<ObjectId>::require("destination", params.arguments);
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = _pimpl->applyCopyItems(service::FieldParams(service::SelectionSetParams{ params }, std::move(directives)), std::move(argInput), std::move(argDestination));
	resolverLock.unlock();

	return service::ModifiedResult<bool>::convert(std::move(result), std::move(params));
}

service::AwaitableResolver Mutation::resolveMoveItems(service::ResolverParams&& params) const
{
	auto argInput = service::ModifiedArgument<MultipleItemsInput>::require("input", params.arguments);
	auto argDestination = service::ModifiedArgument<ObjectId>::require("destination", params.arguments);
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = _pimpl->applyMoveItems(service::FieldParams(service::SelectionSetParams{ params }, std::move(directives)), std::move(argInput), std::move(argDestination));
	resolverLock.unlock();

	return service::ModifiedResult<bool>::convert(std::move(result), std::move(params));
}

service::AwaitableResolver Mutation::resolveDeleteItems(service::ResolverParams&& params) const
{
	static const auto defaultArguments = []()
	{
		response::Value values(response::Type::Map);
		response::Value entry;

		entry = response::Value(false);
		values.emplace_back("hardDelete", std::move(entry));

		return values;
	}();

	auto argInput = service::ModifiedArgument<MultipleItemsInput>::require("input", params.arguments);
	auto pairHardDelete = service::ModifiedArgument<bool>::find("hardDelete", params.arguments);
	auto argHardDelete = (pairHardDelete.second
		? std::move(pairHardDelete.first)
		: service::ModifiedArgument<bool>::require("hardDelete", defaultArguments));
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = _pimpl->applyDeleteItems(service::FieldParams(service::SelectionSetParams{ params }, std::move(directives)), std::move(argInput), std::move(argHardDelete));
	resolverLock.unlock();

	return service::ModifiedResult<bool>::convert(std::move(result), std::move(params));
}

service::AwaitableResolver Mutation::resolve_typename(service::ResolverParams&& params) const
{
	return service::ModifiedResult<std::string>::convert(std::string{ R"gql(Mutation)gql" }, std::move(params));
}

} // namespace object

void AddMutationDetails(const std::shared_ptr<schema::ObjectType>& typeMutation, const std::shared_ptr<schema::Schema>& schema)
{
	typeMutation->AddFields({
		schema::Field::Make(R"gql(createItem)gql"sv, R"md(Create a new item in the target folder)md"sv, std::nullopt, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType(R"gql(Item)gql"sv)), {
			schema::InputValue::Make(R"gql(input)gql"sv, R"md()md"sv, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType(R"gql(CreateItemInput)gql"sv)), R"gql()gql"sv)
		}),
		schema::Field::Make(R"gql(createSubFolder)gql"sv, R"md(Create a new sub-folder in the target folder)md"sv, std::nullopt, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType(R"gql(Folder)gql"sv)), {
			schema::InputValue::Make(R"gql(input)gql"sv, R"md()md"sv, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType(R"gql(CreateSubFolderInput)gql"sv)), R"gql()gql"sv)
		}),
		schema::Field::Make(R"gql(modifyItem)gql"sv, R"md(Modify properties on an existing item)md"sv, std::nullopt, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType(R"gql(Item)gql"sv)), {
			schema::InputValue::Make(R"gql(input)gql"sv, R"md()md"sv, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType(R"gql(ModifyItemInput)gql"sv)), R"gql()gql"sv)
		}),
		schema::Field::Make(R"gql(modifyFolder)gql"sv, R"md(Modify properties on an existing folder)md"sv, std::nullopt, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType(R"gql(Folder)gql"sv)), {
			schema::InputValue::Make(R"gql(input)gql"sv, R"md()md"sv, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType(R"gql(ModifyFolderInput)gql"sv)), R"gql()gql"sv)
		}),
		schema::Field::Make(R"gql(removeFolder)gql"sv, R"md(Remove an entire sub-folder)md"sv, std::nullopt, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType(R"gql(Boolean)gql"sv)), {
			schema::InputValue::Make(R"gql(input)gql"sv, R"md()md"sv, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType(R"gql(ObjectId)gql"sv)), R"gql()gql"sv),
			schema::InputValue::Make(R"gql(hardDelete)gql"sv, R"md(false means move to `Deleted Items`)md"sv, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType(R"gql(Boolean)gql"sv)), R"gql(false)gql"sv)
		}),
		schema::Field::Make(R"gql(markAsRead)gql"sv, R"md(Bulk mark items as read/unread)md"sv, std::nullopt, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType(R"gql(Boolean)gql"sv)), {
			schema::InputValue::Make(R"gql(input)gql"sv, R"md()md"sv, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType(R"gql(MultipleItemsInput)gql"sv)), R"gql()gql"sv),
			schema::InputValue::Make(R"gql(read)gql"sv, R"md()md"sv, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType(R"gql(Boolean)gql"sv)), R"gql(true)gql"sv)
		}),
		schema::Field::Make(R"gql(copyItems)gql"sv, R"md(Bulk copy items from a single source folder to a single destination folder)md"sv, std::nullopt, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType(R"gql(Boolean)gql"sv)), {
			schema::InputValue::Make(R"gql(input)gql"sv, R"md()md"sv, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType(R"gql(MultipleItemsInput)gql"sv)), R"gql()gql"sv),
			schema::InputValue::Make(R"gql(destination)gql"sv, R"md()md"sv, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType(R"gql(ObjectId)gql"sv)), R"gql()gql"sv)
		}),
		schema::Field::Make(R"gql(moveItems)gql"sv, R"md(Bulk move items from a single source folder to a single destination folder)md"sv, std::nullopt, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType(R"gql(Boolean)gql"sv)), {
			schema::InputValue::Make(R"gql(input)gql"sv, R"md()md"sv, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType(R"gql(MultipleItemsInput)gql"sv)), R"gql()gql"sv),
			schema::InputValue::Make(R"gql(destination)gql"sv, R"md()md"sv, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType(R"gql(ObjectId)gql"sv)), R"gql()gql"sv)
		}),
		schema::Field::Make(R"gql(deleteItems)gql"sv, R"md(Bulk delete items from a single source folder)md"sv, std::nullopt, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType(R"gql(Boolean)gql"sv)), {
			schema::InputValue::Make(R"gql(input)gql"sv, R"md()md"sv, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType(R"gql(MultipleItemsInput)gql"sv)), R"gql()gql"sv),
			schema::InputValue::Make(R"gql(hardDelete)gql"sv, R"md(false means move to `Deleted Items`)md"sv, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType(R"gql(Boolean)gql"sv)), R"gql(false)gql"sv)
		})
	});
}

} // namespace graphql::mapi
