// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// WARNING! Do not edit this file manually, your changes will be overwritten.

#pragma once

#ifndef ITEMSRELOADEDOBJECT_H
#define ITEMSRELOADEDOBJECT_H

#include "MAPISchema.h"

namespace graphql::mapi::object {
namespace implements {

template <class I>
concept ItemsReloadedIs = std::is_same_v<I, ItemChange>;

} // namespace implements

namespace methods::ItemsReloadedHas {

template <class TImpl>
concept getReloadedWithParams = requires (TImpl impl, service::FieldParams params) 
{
	{ service::AwaitableObject<std::vector<std::shared_ptr<Item>>> { impl.getReloaded(std::move(params)) } };
};

template <class TImpl>
concept getReloaded = requires (TImpl impl) 
{
	{ service::AwaitableObject<std::vector<std::shared_ptr<Item>>> { impl.getReloaded() } };
};

template <class TImpl>
concept beginSelectionSet = requires (TImpl impl, const service::SelectionSetParams params) 
{
	{ impl.beginSelectionSet(params) };
};

template <class TImpl>
concept endSelectionSet = requires (TImpl impl, const service::SelectionSetParams params) 
{
	{ impl.endSelectionSet(params) };
};

} // namespace methods::ItemsReloadedHas

class ItemsReloaded
	: public service::Object
{
private:
	service::AwaitableResolver resolveReloaded(service::ResolverParams&& params) const;

	service::AwaitableResolver resolve_typename(service::ResolverParams&& params) const;

	struct Concept
	{
		virtual ~Concept() = default;

		virtual void beginSelectionSet(const service::SelectionSetParams& params) const = 0;
		virtual void endSelectionSet(const service::SelectionSetParams& params) const = 0;

		virtual service::AwaitableObject<std::vector<std::shared_ptr<Item>>> getReloaded(service::FieldParams&& params) const = 0;
	};

	template <class T>
	struct Model
		: Concept
	{
		Model(std::shared_ptr<T>&& pimpl) noexcept
			: _pimpl { std::move(pimpl) }
		{
		}

		service::AwaitableObject<std::vector<std::shared_ptr<Item>>> getReloaded(service::FieldParams&& params) const final
		{
			if constexpr (methods::ItemsReloadedHas::getReloadedWithParams<T>)
			{
				return { _pimpl->getReloaded(std::move(params)) };
			}
			else if constexpr (methods::ItemsReloadedHas::getReloaded<T>)
			{
				return { _pimpl->getReloaded() };
			}
			else
			{
				throw std::runtime_error(R"ex(ItemsReloaded::getReloaded is not implemented)ex");
			}
		}

		void beginSelectionSet(const service::SelectionSetParams& params) const final
		{
			if constexpr (methods::ItemsReloadedHas::beginSelectionSet<T>)
			{
				_pimpl->beginSelectionSet(params);
			}
		}

		void endSelectionSet(const service::SelectionSetParams& params) const final
		{
			if constexpr (methods::ItemsReloadedHas::endSelectionSet<T>)
			{
				_pimpl->endSelectionSet(params);
			}
		}

	private:
		const std::shared_ptr<T> _pimpl;
	};

	ItemsReloaded(std::unique_ptr<Concept>&& pimpl) noexcept;

	// Unions which include this type
	friend ItemChange;

	template <class I>
	static constexpr bool implements() noexcept
	{
		return implements::ItemsReloadedIs<I>;
	}

	service::TypeNames getTypeNames() const noexcept;
	service::ResolverMap getResolvers() const noexcept;

	void beginSelectionSet(const service::SelectionSetParams& params) const final;
	void endSelectionSet(const service::SelectionSetParams& params) const final;

	const std::unique_ptr<Concept> _pimpl;

public:
	template <class T>
	ItemsReloaded(std::shared_ptr<T> pimpl) noexcept
		: ItemsReloaded { std::unique_ptr<Concept> { std::make_unique<Model<T>>(std::move(pimpl)) } }
	{
	}
};

} // namespace graphql::mapi::object

#endif // ITEMSRELOADEDOBJECT_H
