// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// WARNING! Do not edit this file manually, your changes will be overwritten.

#include "ItemsReloadedObject.h"
#include "ItemObject.h"

#include "graphqlservice/internal/Schema.h"

#include "graphqlservice/introspection/IntrospectionSchema.h"

#include <algorithm>
#include <functional>
#include <sstream>
#include <stdexcept>
#include <unordered_map>

using namespace std::literals;

namespace graphql::mapi {
namespace object {

ItemsReloaded::ItemsReloaded(std::unique_ptr<Concept>&& pimpl) noexcept
	: service::Object{ getTypeNames(), getResolvers() }
	, _pimpl { std::move(pimpl) }
{
}

service::TypeNames ItemsReloaded::getTypeNames() const noexcept
{
	return {
		R"gql(ItemChange)gql"sv,
		R"gql(ItemsReloaded)gql"sv
	};
}

service::ResolverMap ItemsReloaded::getResolvers() const noexcept
{
	return {
		{ R"gql(reloaded)gql"sv, [this](service::ResolverParams&& params) { return resolveReloaded(std::move(params)); } },
		{ R"gql(__typename)gql"sv, [this](service::ResolverParams&& params) { return resolve_typename(std::move(params)); } }
	};
}

void ItemsReloaded::beginSelectionSet(const service::SelectionSetParams& params) const
{
	_pimpl->beginSelectionSet(params);
}

void ItemsReloaded::endSelectionSet(const service::SelectionSetParams& params) const
{
	_pimpl->endSelectionSet(params);
}

service::AwaitableResolver ItemsReloaded::resolveReloaded(service::ResolverParams&& params) const
{
	std::unique_lock resolverLock(_resolverMutex);
	auto directives = std::move(params.fieldDirectives);
	auto result = _pimpl->getReloaded(service::FieldParams(service::SelectionSetParams{ params }, std::move(directives)));
	resolverLock.unlock();

	return service::ModifiedResult<Item>::convert<service::TypeModifier::List>(std::move(result), std::move(params));
}

service::AwaitableResolver ItemsReloaded::resolve_typename(service::ResolverParams&& params) const
{
	return service::ModifiedResult<std::string>::convert(std::string{ R"gql(ItemsReloaded)gql" }, std::move(params));
}

} // namespace object

void AddItemsReloadedDetails(const std::shared_ptr<schema::ObjectType>& typeItemsReloaded, const std::shared_ptr<schema::Schema>& schema)
{
	typeItemsReloaded->AddFields({
		schema::Field::Make(R"gql(reloaded)gql"sv, R"md(`Items` that were reloaded)md"sv, std::nullopt, schema->WrapType(introspection::TypeKind::NON_NULL, schema->WrapType(introspection::TypeKind::LIST, schema->WrapType(introspection::TypeKind::NON_NULL, schema->LookupType(R"gql(Item)gql"sv)))))
	});
}

} // namespace graphql::mapi
